/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.schema.tools;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.tools.javac.Main;

public class Conventions {
    private static Hashtable postfixTable = Conventions.init();
    private static boolean verbose = true;

    private static Hashtable init() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(11);
        hashtable.put("simpleType", "");
        hashtable.put("complexType", "");
        hashtable.put("group", "_Group");
        hashtable.put("attributeGroup", "_AttrGp");
        hashtable.put("element", "");
        hashtable.put("attribute", "_Attr");
        return hashtable;
    }

    public static String namespaceURI2JavaPath(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Argument to 'namespaceURI2JavaPath' cannot be null.");
        }
        if (string.startsWith("http://")) {
            string = string.substring(7);
        }
        if (string.compareTo("") == 0) {
            return string;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.lastIndexOf("/"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken() + "." + string2;
        }
        stringTokenizer = new StringTokenizer(string2, ".", false);
        string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken() + "." + string2;
        }
        string2 = string2.replace(':', '_');
        string2 = string2.replace('-', '_');
        return string2;
    }

    public static String schema2JavaName(String string, String string2, boolean bl) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
        }
        if (string.compareTo("any") == 0) {
            return "any";
        }
        if (string.compareTo("simpleType") == 0) {
            if (string2 == null) {
                throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
            }
            string2 = string2.replace('-', '_');
            return string2;
        }
        if (string.compareTo("attribute") == 0) {
            if (string2 == null) {
                throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
            }
            string2 = string2.replace('-', '_');
            return string2 + postfixTable.get("attribute");
        }
        if (string.compareTo("anyAttribute") == 0) {
            return "anyAttribute";
        }
        if (string.compareTo("all") == 0) {
            string2 = "all";
        } else if (string.compareTo("choice") == 0) {
            string2 = "choice";
        } else if (string.compareTo("sequence") == 0) {
            string2 = "sequence";
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
        }
        string2 = string2.replace('-', '_');
        String string3 = (String)postfixTable.get(string);
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string2;
        if (bl) {
            string4 = Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
        }
        return string4 + string3;
    }

    public static String schema2JavaName(Node node, String string) {
        if (node == null || string == null) {
            throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
        }
        String string2 = Conventions.namespaceURI2JavaPath(string) + ".";
        String string3 = DOMUtils.getAttribute((Element)((Element)node), (String)"name");
        String string4 = node.getLocalName();
        if (string3 == null || string4 == null) {
            return null;
        }
        string3 = Conventions.schema2JavaName(string4, string3, true);
        return string2 + string3;
    }

    public static String schema2JavaName(NodeList nodeList, NodeList nodeList2) {
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No type name found for serializer class.");
        }
        Node node = nodeList.item(0);
        if (nodeList2.getLength() == 0) {
            throw new IllegalArgumentException("No type name found for serializer class.");
        }
        Node node2 = nodeList2.item(0);
        String string = node2.getNodeValue();
        return Conventions.schema2JavaName(node, string);
    }

    public static String schema2NonQualifiedJavaName(NodeList nodeList, NodeList nodeList2) {
        String string = Conventions.schema2JavaName(nodeList, nodeList2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static String getJavaPathName(String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            string = string + File.separatorChar + string2.replace('.', File.separatorChar);
        }
        return string;
    }

    public static String getJavaFileName(NodeList nodeList, NodeList nodeList2, String string) {
        String string2 = Conventions.schema2NonQualifiedJavaName(nodeList, nodeList2) + string + ".java";
        return string2;
    }

    public static boolean JDKcompile(String string, String string2) throws IllegalArgumentException {
        String string3 = System.getProperty("java.class.path");
        if (string2 != null && !string2.equals("")) {
            string3 = string3 + System.getProperty("path.separator") + string2;
        }
        String[] stringArray = new String[]{"-classpath", string3, string};
        try {
            return new Main((OutputStream)System.err, "javac").compile(stringArray);
        }
        catch (Throwable throwable) {
            System.err.println("Unable to load JDK compiler.");
            return false;
        }
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static boolean getVerbose() {
        return verbose;
    }
}

