/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.schema.tools;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.wsif.compiler.schema.SchemaException;
import org.apache.wsif.compiler.schema.tools.ClassField;
import org.apache.wsif.compiler.schema.tools.ClassFile;
import org.apache.wsif.compiler.schema.tools.Conventions;
import org.apache.wsif.compiler.schema.tools.SchemaAny;
import org.apache.wsif.compiler.schema.tools.SchemaAnyAttribute;
import org.apache.wsif.compiler.schema.tools.SchemaAttribute;
import org.apache.wsif.compiler.schema.tools.SchemaAttributeGroup;
import org.apache.wsif.compiler.schema.tools.SchemaComplexType;
import org.apache.wsif.compiler.schema.tools.SchemaElement;
import org.apache.wsif.compiler.schema.tools.SchemaGroup;
import org.apache.wsif.compiler.schema.tools.SchemaMGS;
import org.apache.wsif.compiler.schema.tools.SchemaSimpleType;
import org.apache.wsif.compiler.schema.tools.SchemaType;
import org.apache.wsif.compiler.util.StreamFactory;
import org.apache.wsif.compiler.util.TypeMapping;
import org.apache.wsif.logging.Trc;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Schema2Java {
    private HashMap registry = new HashMap();
    private String workingDirectory;
    private HashMap namespaceRegistry = new HashMap();
    private HashMap undefinedRegistry = new HashMap();
    private Vector schemaElementList = new Vector();
    private String packageName = "";
    private boolean verbose = true;
    private boolean overwrite = false;
    private boolean javac = true;

    public Schema2Java(String string) {
        this.registry.put(new QName(string, "string"), "java.lang.String");
        this.registry.put(new QName(string, "integer"), "java.math.BigInteger");
        this.registry.put(new QName(string, "boolean"), "boolean");
        this.registry.put(new QName(string, "float"), "float");
        this.registry.put(new QName(string, "double"), "double");
        this.registry.put(new QName(string, "binary"), "[B");
        this.registry.put(new QName(string, "base64Binary"), "[B");
        this.registry.put(new QName(string, "hexBinary"), "[B");
        this.registry.put(new QName(string, "long"), "long");
        this.registry.put(new QName(string, "int"), "int");
        this.registry.put(new QName(string, "short"), "short");
        this.registry.put(new QName(string, "decimal"), "java.math.BigDecimal");
        this.registry.put(new QName(string, "QName"), "javax.xml.namespace.QName");
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            this.registry.put(new QName(string, "dateTime"), "java.util.Calendar");
        } else {
            this.registry.put(new QName(string, "timeInstant"), "java.util.Calendar");
        }
        this.registry.put(new QName(string, "byte"), "byte");
        this.registry.put(new QName(string, "void"), "void");
        this.registry.put(new QName(string, "ur-type"), "java.lang.Object");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "string"), "java.lang.String");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean"), "java.lang.Boolean");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "float"), "java.lang.Float");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "double"), "java.lang.Double");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "decimal"), "java.math.BigDecimal");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "int"), "java.lang.Integer");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "short"), "java.lang.Short");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte"), "java.lang.Byte");
        this.registry.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "base64"), "[B");
    }

    private ClassFile any2Field(SchemaAny schemaAny, ClassFile classFile) {
        if (schemaAny == null || classFile == null) {
            throw new IllegalArgumentException("Argument to 'any2Field' cannot be null.");
        }
        classFile.addField(new ClassField("byte[]", Conventions.schema2JavaName("any", null, false), schemaAny.isArray()));
        return classFile;
    }

    private ClassFile anyAttribute2Field(SchemaAnyAttribute schemaAnyAttribute, ClassFile classFile) {
        if (schemaAnyAttribute == null || classFile == null) {
            throw new IllegalArgumentException("Argument to 'anyAttribute2Field' cannot be null.");
        }
        classFile.addField(new ClassField("byte[]", Conventions.schema2JavaName("anyAttribute", null, false), false));
        return classFile;
    }

    private ClassFile attribute2Field(SchemaAttribute schemaAttribute, ClassFile classFile) throws SchemaException {
        if (schemaAttribute == null || classFile == null) {
            throw new IllegalArgumentException("Argument to 'attribute2Field' cannot be null.");
        }
        QName qName = schemaAttribute.getType();
        QName qName2 = schemaAttribute.getRef();
        SchemaSimpleType schemaSimpleType = schemaAttribute.getChild();
        String string = schemaAttribute.getTargetURI();
        if (qName2 != null) {
            ClassField classField = new ClassField(this.getJavaType(qName2, string, "attribute"), Conventions.schema2JavaName("attribute", qName2.getLocalPart(), false), false);
            classFile.addField(classField);
        } else if (qName != null) {
            ClassField classField = new ClassField(this.getJavaType(qName, string, "simpleType"), Conventions.schema2JavaName("attribute", schemaAttribute.getName(), false), false);
            classFile.addField(classField);
        } else if (schemaSimpleType != null) {
            String string2 = Conventions.schema2JavaName("attribute", schemaAttribute.getName(), false);
            classFile = this.simpleType2Field(string2, false, schemaSimpleType, classFile);
        }
        return classFile;
    }

    private ClassFile attributeGroup2Class(SchemaAttributeGroup schemaAttributeGroup) throws SchemaException {
        if (schemaAttributeGroup == null) {
            throw new IllegalArgumentException("Argument to 'attributeGroup2Class' cannot be null.");
        }
        String string = Conventions.schema2JavaName("attributeGroup", schemaAttributeGroup.getName(), true);
        ClassFile classFile = new ClassFile(string);
        Vector vector = schemaAttributeGroup.getChildren();
        block4: for (int i = 0; i < vector.size(); ++i) {
            SchemaType schemaType = (SchemaType)vector.elementAt(i);
            switch (schemaType.getElementType()) {
                case 4: {
                    classFile = this.attributeGroup2Field((SchemaAttributeGroup)schemaType, classFile);
                    continue block4;
                }
                case 3: {
                    classFile = this.attribute2Field((SchemaAttribute)schemaType, classFile);
                    continue block4;
                }
            }
        }
        return classFile;
    }

    private ClassFile attributeGroup2Field(SchemaAttributeGroup schemaAttributeGroup, ClassFile classFile) throws SchemaException {
        if (schemaAttributeGroup == null || classFile == null) {
            throw new IllegalArgumentException("Argument to 'attributeGroup2Field' cannot be null.");
        }
        QName qName = schemaAttributeGroup.getRef();
        if (qName == null) {
            throw new SchemaException("Attribute group can only be defined at the top level.");
        }
        ClassField classField = new ClassField(this.getJavaType(qName, schemaAttributeGroup.getTargetURI(), "attributeGroup"), Conventions.schema2JavaName("attributeGroup", qName.getLocalPart(), false), false);
        classFile.addField(classField);
        return classFile;
    }

    private ClassFile complexType2Class(String string, SchemaComplexType schemaComplexType) throws SchemaException {
        if (string == null || schemaComplexType == null) {
            throw new IllegalArgumentException("Argument to 'complexType2Class' cannot be null.");
        }
        QName qName = schemaComplexType.getBase();
        ClassFile classFile = new ClassFile(string);
        if (qName != null) {
            classFile.superClassName = this.getJavaType(qName, schemaComplexType.getTargetURI(), "complexType");
        }
        Vector vector = schemaComplexType.getChildren();
        block9: for (int i = 0; i < vector.size(); ++i) {
            SchemaType schemaType = (SchemaType)vector.elementAt(i);
            String string2 = schemaType.getName();
            switch (schemaType.getElementType()) {
                case 2: {
                    classFile = this.element2Field((SchemaElement)schemaType, classFile);
                    continue block9;
                }
                case 5: {
                    classFile = this.group2Field((SchemaGroup)schemaType, classFile);
                    continue block9;
                }
                case 3: {
                    classFile = this.attribute2Field((SchemaAttribute)schemaType, classFile);
                    continue block9;
                }
                case 4: {
                    classFile = this.attributeGroup2Field((SchemaAttributeGroup)schemaType, classFile);
                    continue block9;
                }
                case 6: {
                    classFile = this.any2Field((SchemaAny)schemaType, classFile);
                    continue block9;
                }
                case 7: {
                    classFile = this.anyAttribute2Field((SchemaAnyAttribute)schemaType, classFile);
                    continue block9;
                }
                case 8: 
                case 9: 
                case 10: {
                    classFile = this.mgs2Field((SchemaMGS)schemaType, classFile);
                }
            }
        }
        return classFile;
    }

    public Map createJavaMapping(Element element, Map map) throws SchemaException {
        if (element == null || map == null) {
            throw new IllegalArgumentException("Argument to 'createJavaMapping' cannot be null.");
        }
        String string = element.getAttribute("targetNamespace");
        Vector vector = this.parseSchemaRoot(element, string);
        for (int i = 0; i < vector.size(); ++i) {
            this.schemaElementList.addElement(vector.elementAt(i));
        }
        this.updateRegistry(this.schemaElementList);
        return this.getRegistry(map);
    }

    private ClassFile element2Field(SchemaElement schemaElement, ClassFile classFile) throws SchemaException {
        if (schemaElement == null || classFile == null) {
            throw new IllegalArgumentException("Argument to 'element2Field' cannot be null.");
        }
        String string = schemaElement.getName();
        QName qName = schemaElement.getRef();
        QName qName2 = schemaElement.getType();
        SchemaType schemaType = schemaElement.getChild();
        String string2 = schemaElement.getTargetURI();
        if (string != null) {
            string = Conventions.schema2JavaName("element", string, false);
        }
        if (qName != null) {
            String string3 = this.getJavaType(qName, string2, "element");
            classFile.addField(new ClassField(string3, Conventions.schema2JavaName("element", qName.getLocalPart(), false), schemaElement.isArray()));
        } else if (qName2 != null) {
            String string4 = this.getJavaType(qName2, string2, "complexType");
            classFile.addField(new ClassField(string4, string, schemaElement.isArray()));
        } else {
            if (schemaType == null) {
                throw new SchemaException("The type of this element is unknown: '" + string + "'.");
            }
            if (schemaType.getElementType() == 1) {
                classFile = this.simpleType2Field(string, schemaElement.isArray(), (SchemaSimpleType)schemaType, classFile);
            } else if (schemaType.getElementType() == 0) {
                throw new SchemaException("Inner complex-types are not supported: '" + string + "'.");
            }
        }
        return classFile;
    }

    private QName getAttributeQName(Element element, String string) {
        if (element == null || string == null) {
            throw new IllegalArgumentException("Argument to 'getAttrQName' cannot be null.");
        }
        String string2 = DOMUtils.getAttribute((Element)element, (String)string);
        if (string2 == null) {
            return null;
        }
        int n = string2.lastIndexOf(":");
        String string3 = null;
        if (n != -1) {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        String string4 = DOMUtils.getNamespaceURIFromPrefix((Node)element, string3);
        return new QName(string4, string2);
    }

    private String getGenericJavaName(QName qName, String string) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument to 'getGenericJavaName' cannot be null.");
        }
        String string2 = (String)this.undefinedRegistry.get(qName);
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getNamespaceURIMapping(qName.getNamespaceURI());
        String string4 = qName.getLocalPart();
        string4 = Conventions.schema2JavaName(string, string4, true);
        string2 = string3.compareTo("") != 0 ? string3 + "." + string4 : string4;
        this.undefinedRegistry.put(qName, string2);
        Trc.event(this, "Schema name ", qName, " is undefined, and so generic Java name ", string2, " is used instead.");
        return string2;
    }

    private String getJavaType(QName qName, String string, String string2) throws SchemaException {
        if (qName == null) {
            throw new IllegalArgumentException("Argument to 'getJavaType' cannot be null.");
        }
        String string3 = (String)this.registry.get(qName);
        if (string3 == null) {
            throw new SchemaException("Basic type '" + qName + "' not supported.");
        }
        String string4 = this.getNamespaceURIMapping(string);
        if (string3.startsWith(string4)) {
            string3 = string3.substring(string3.lastIndexOf(".") + 1);
        }
        return string3;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getNamespaceURIMapping(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument to 'getNamespaceURIMapping' cannot be null.");
        }
        if (string.compareTo("") == 0) {
            return "";
        }
        if (this.packageName != null && !this.packageName.equals("")) {
            return this.packageName;
        }
        String string2 = (String)this.namespaceRegistry.get(string);
        if (string2 == null) {
            string2 = Conventions.namespaceURI2JavaPath(string);
            this.namespaceRegistry.put(string, string2);
        }
        return string2;
    }

    public Map getRegistry(Map map) {
        for (QName qName : this.registry.keySet()) {
            map.put(qName, new TypeMapping(qName, (String)this.registry.get(qName)));
        }
        return map;
    }

    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("user.dir");
                }
            });
        }
        return this.workingDirectory;
    }

    private ClassFile group2Class(SchemaGroup schemaGroup) throws SchemaException {
        if (schemaGroup == null) {
            throw new IllegalArgumentException("Argument to 'group2Class' cannot be null.");
        }
        SchemaMGS schemaMGS = schemaGroup.getChild();
        String string = Conventions.schema2JavaName("group", schemaGroup.getName(), true);
        ClassFile classFile = new ClassFile(string);
        classFile = this.mgs2Field(schemaMGS, classFile);
        return classFile;
    }

    private ClassFile group2Field(SchemaGroup schemaGroup, ClassFile classFile) throws SchemaException {
        if (schemaGroup == null || classFile == null) {
            throw new IllegalArgumentException("Argument to 'group2Field' cannot be null.");
        }
        QName qName = schemaGroup.getRef();
        if (qName != null) {
            String string = this.getJavaType(qName, schemaGroup.getTargetURI(), "group");
            classFile.addField(new ClassField(string, Conventions.schema2JavaName("group", qName.getLocalPart(), false), schemaGroup.isArray()));
        }
        return classFile;
    }

    private ClassFile mgs2Class(String string, SchemaMGS schemaMGS) throws SchemaException {
        if (string == null || schemaMGS == null) {
            throw new IllegalArgumentException("Argument to 'mgs2Class' cannot be null.");
        }
        ClassFile classFile = new ClassFile(string);
        Vector vector = schemaMGS.getChildren();
        block5: for (int i = 0; i < vector.size(); ++i) {
            SchemaType schemaType = (SchemaType)vector.elementAt(i);
            switch (schemaType.getElementType()) {
                case 2: {
                    this.element2Field((SchemaElement)schemaType, classFile);
                    continue block5;
                }
                case 5: {
                    this.group2Field((SchemaGroup)schemaType, classFile);
                    continue block5;
                }
                case 6: 
                case 9: 
                case 10: {
                    this.mgs2Field((SchemaMGS)schemaType, classFile);
                }
            }
        }
        return classFile;
    }

    private ClassFile mgs2Field(SchemaMGS schemaMGS, ClassFile classFile) throws SchemaException {
        String string;
        if (schemaMGS == null || classFile == null) {
            throw new IllegalArgumentException("Argument to 'mgs2Field' cannot be null.");
        }
        switch (schemaMGS.getElementType()) {
            case 8: {
                string = "all";
                break;
            }
            case 9: {
                string = "choice";
                break;
            }
            case 10: {
                string = "sequence";
                break;
            }
            default: {
                return classFile;
            }
        }
        String string2 = Conventions.schema2JavaName(string, null, true);
        String string3 = Conventions.schema2JavaName(string, null, false);
        classFile.addField(new ClassField(string2, string3, schemaMGS.isArray()));
        classFile.addInnerClass(this.mgs2Class(string2, schemaMGS));
        return classFile;
    }

    public void outputJavaMapping() throws SchemaException, IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray;
        int n2;
        Vector<Object> vector = new Vector<Object>();
        for (n2 = 0; n2 < this.schemaElementList.size(); ++n2) {
            stringArray = (String[])this.schemaElementList.elementAt(n2);
            object4 = null;
            switch (stringArray.getElementType()) {
                case 0: {
                    SchemaComplexType schemaComplexType = (SchemaComplexType)stringArray;
                    object3 = Conventions.schema2JavaName("complexType", schemaComplexType.getName(), true);
                    object4 = this.complexType2Class((String)object3, schemaComplexType);
                    break;
                }
                case 5: {
                    object4 = this.group2Class((SchemaGroup)stringArray);
                    break;
                }
                case 4: {
                    object4 = this.attributeGroup2Class((SchemaAttributeGroup)stringArray);
                    break;
                }
                case 2: {
                    object2 = (SchemaElement)stringArray;
                    object = ((SchemaElement)object2).getChild();
                    if (object == null || object.getElementType() != 0) break;
                    object3 = Conventions.schema2JavaName("element", ((SchemaElement)object2).getName(), true);
                    object4 = this.complexType2Class((String)object3, (SchemaComplexType)((SchemaElement)object2).getChild());
                }
            }
            if (object4 == null) continue;
            ((ClassFile)object4).packageName = this.getNamespaceURIMapping(stringArray.getTargetURI());
            vector.addElement(object4);
        }
        n2 = vector.size();
        stringArray = new String[n2];
        object4 = new StreamFactory();
        for (n = 0; n < n2; ++n) {
            object3 = (ClassFile)vector.elementAt(n);
            object2 = Conventions.getJavaPathName(this.getWorkingDirectory(), ((ClassFile)object3).packageName);
            object = ((ClassFile)object3).className + ".java";
            OutputStream outputStream = ((StreamFactory)object4).getOutputStream((String)object2, (String)object, this.overwrite);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write("/*\n *This class is automatically generated by schema to Java program.\n");
            outputStreamWriter.write(" *Only a subset of schema is handled and some of the schema information\n");
            outputStreamWriter.write(" *may be lost during translation\n */\n\n");
            if (((ClassFile)object3).packageName != null) {
                outputStreamWriter.write("package " + ((ClassFile)object3).packageName + ";\n\n");
            }
            this.printJavaFile(outputStreamWriter, (ClassFile)object3, null);
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            stringArray[n] = new File((String)object2, (String)object).getAbsolutePath();
        }
        if (this.javac) {
            for (n = 0; n < n2; ++n) {
                if (!Conventions.JDKcompile(stringArray[n], this.getWorkingDirectory()) || !this.verbose) continue;
                System.out.println("Compiled file '" + stringArray[n] + "'.");
            }
        }
    }

    private Vector parseSchemaRoot(Element element, String string) throws SchemaException {
        if (element == null) {
            throw new IllegalArgumentException("Argument to 'parseSchemaRoot' cannot be null.");
        }
        Vector<SchemaType> vector = new Vector<SchemaType>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl;
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string2 = element2.getLocalName();
            if (string2 == null) {
                return null;
            }
            String string3 = DOMUtils.getAttribute((Element)element2, (String)"name");
            QName qName = this.getAttributeQName(element2, "type");
            boolean bl2 = false;
            if (string2.equals("complexType")) {
                boolean bl3 = false;
                bl = false;
                QName qName2 = null;
                Vector vector2 = this.parseSchemaRoot(element2, string);
                vector.addElement(new SchemaComplexType(string3, qName2, bl, bl3, vector2, string));
                continue;
            }
            if (string2.equals("simpleType")) {
                QName qName3 = null;
                bl = false;
                vector.addElement(new SchemaSimpleType(string3, qName3, bl, string));
                continue;
            }
            if (!string2.equals("element")) continue;
            QName qName4 = null;
            vector.addElement(new SchemaElement(string3, qName4, qName, bl2, null, string));
        }
        return vector;
    }

    private void printJavaFile(Writer writer, ClassFile classFile, String string) throws IOException {
        Object object;
        ClassField classField;
        int n;
        String string2 = classFile.className;
        String string3 = classFile.superClassName;
        if (string == null) {
            string = "";
            writer.write("public ");
        } else {
            writer.write(string);
        }
        if (classFile.isAbstract) {
            writer.write("abstract ");
        } else if (classFile.isFinal) {
            writer.write("final");
        }
        if (string3 != null) {
            writer.write("class " + string2 + " extends " + string3 + "{\n");
        } else {
            writer.write("class " + string2 + "{\n");
        }
        writer.write("\n" + string + "\t//instance variables\n");
        int n2 = classFile.getFieldCount();
        for (n = 0; n < n2; ++n) {
            classField = classFile.getField(n);
            writer.write(string + "\tprivate " + classField.fieldType);
            if (classField.isArray) {
                writer.write("[]");
            }
            writer.write("\t" + classField.fieldName + ";\n");
        }
        writer.write("\n" + string + "\t//constructors\n");
        if (n2 > 0) {
            writer.write(string + "\tpublic " + string2 + " () { }\n");
        }
        writer.write("\n" + string + "\tpublic " + string2 + " (");
        for (n = 0; n < n2; ++n) {
            classField = classFile.getField(n);
            writer.write(classField.fieldType);
            if (classField.isArray) {
                writer.write("[]");
            }
            writer.write(" " + classField.fieldName);
            if (n >= n2 - 1) continue;
            writer.write(", ");
        }
        writer.write(") {\n");
        for (n = 0; n < n2; ++n) {
            classField = classFile.getField(n);
            writer.write(string + "\t\tthis." + classField.fieldName + "\t= " + classField.fieldName + ";\n");
        }
        writer.write(string + "\t}\n");
        for (n = 0; n < n2; ++n) {
            classField = classFile.getField(n);
            object = Character.toUpperCase(classField.fieldName.charAt(0)) + classField.fieldName.substring(1);
            writer.write("\n" + string + "\tpublic ");
            if (classField.isArray) {
                writer.write("[]");
            }
            writer.write(classField.fieldType + " get" + (String)object + "() {\n");
            writer.write(string + "\t\treturn " + classField.fieldName + ";\n");
            writer.write(string + "\t}\n");
            writer.write("\n" + string + "\tpublic ");
            writer.write(" void set" + (String)object + "(" + classField.fieldType);
            if (classField.isArray) {
                writer.write("[]");
            }
            writer.write(" " + classField.fieldName + ") {\n");
            writer.write(string + "\t\tthis." + classField.fieldName + "\t= " + classField.fieldName + ";\n");
            writer.write(string + "\t}\n");
        }
        writer.write("\n\tpublic String toString() {\n");
        writer.write("\t\treturn ");
        for (n = 0; n < n2; ++n) {
            classField = classFile.getField(n);
            if (n > 0) {
                writer.write(" + \"\\n\" + \n\t\t\t");
            }
            writer.write("\"" + classField.fieldName + "=\" + " + classField.fieldName);
        }
        writer.write(";\n\t}\n");
        n = classFile.getInnerClassCount();
        if (n > 0) {
            writer.write("\n" + string + "\t//Inner classes\n");
            for (int i = 0; i < n; ++i) {
                object = classFile.getInnerClass(i);
                this.printJavaFile(writer, (ClassFile)object, string + "\t");
            }
        }
        writer.write("\n" + string + "}");
    }

    public void setNamespaceURIMapping(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Argument to 'setNamespaceURIMapping' cannot be null.");
        }
        this.namespaceRegistry.put(string, string2);
    }

    public void setWorkingDirectory(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Argument to 'setWorkingDirectory' cannot be null.");
        }
        this.workingDirectory = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setJavac(boolean bl) {
        this.javac = bl;
    }

    private ClassFile simpleType2Field(String string, boolean bl, SchemaSimpleType schemaSimpleType, ClassFile classFile) throws SchemaException {
        if (string == null || schemaSimpleType == null || classFile == null) {
            throw new IllegalArgumentException("Argument to 'simpleType2Field' cannot be null.");
        }
        QName qName = schemaSimpleType.getBase();
        String string2 = this.getJavaType(qName, schemaSimpleType.getTargetURI(), "simpleType");
        if (schemaSimpleType.isList()) {
            string2 = string2 + "[]";
        }
        classFile.addField(new ClassField(string2, string, bl));
        return classFile;
    }

    private void updateRegistry(Vector vector) throws SchemaException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        int n2;
        if (vector == null) {
            throw new IllegalArgumentException("Argument to 'updateRegistry' cannot be null.");
        }
        HashMap hashMap = new HashMap();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object5 = (SchemaType)vector.elementAt(n2);
            object42 = object5.getName();
            if (object42 == null) {
                object42 = "";
            }
            object3 = new QName(object5.getTargetURI(), (String)object42);
            if (object5.getElementType() != 1) continue;
            hashMap.put(object3, object5);
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            for (Object object42 : hashMap.keySet()) {
                object3 = (SchemaSimpleType)hashMap.get(object42);
                object2 = ((SchemaSimpleType)object3).getBase();
                boolean bl = ((SchemaSimpleType)object3).isList();
                if (object2 != null) {
                    object = (String)this.registry.get(object2);
                    if (object == null) {
                        if (hashMap.containsKey(object2)) continue;
                        object = this.getGenericJavaName((QName)object2, "simpleType");
                    }
                    if (bl) {
                        object = (String)object + "[]";
                    }
                    this.registry.put(object42, object);
                    n2 = 1;
                    hashMap.remove(object42);
                    continue;
                }
                object = this.getGenericJavaName((QName)object42, "simpleType");
                this.registry.put(object42, object);
            }
        }
        object5 = hashMap.keySet().iterator();
        while (object5.hasNext()) {
            if (this.registry.containsKey((QName)object5.next())) continue;
            throw new SchemaException("'simpleType' definitions have cyclic dependency.");
        }
        block13: for (n = 0; n < vector.size(); ++n) {
            String string;
            object42 = (SchemaType)vector.elementAt(n);
            object3 = object42.getTargetURI();
            object2 = this.getNamespaceURIMapping((String)object3);
            if (((String)object2).compareTo("") != 0) {
                object2 = (String)object2 + ".";
            }
            if ((string = object42.getName()) == null) {
                string = "";
            }
            object = new QName((String)object3, string);
            switch (object42.getElementType()) {
                case 0: {
                    this.registry.put(object, (String)object2 + Conventions.schema2JavaName("complexType", string, true));
                    continue block13;
                }
                case 5: {
                    this.registry.put(object, (String)object2 + Conventions.schema2JavaName("group", string, true));
                    continue block13;
                }
                case 4: {
                    this.registry.put(object, (String)object2 + Conventions.schema2JavaName("attributeGroup", string, true));
                }
            }
        }
        block14: for (n = 0; n < vector.size(); ++n) {
            object42 = (SchemaType)vector.elementAt(n);
            object3 = object42.getName();
            object2 = object42.getTargetURI();
            String string = this.getNamespaceURIMapping((String)object2);
            if (string.compareTo("") != 0) {
                string = string + ".";
            }
            if (object3 == null) {
                object3 = "";
            }
            object = new QName((String)object2, (String)object3);
            switch (object42.getElementType()) {
                case 2: {
                    Object object6;
                    Object object7;
                    SchemaElement schemaElement = (SchemaElement)object42;
                    QName qName = schemaElement.getType();
                    SchemaType schemaType = schemaElement.getChild();
                    if (qName != null) {
                        object7 = (String)this.registry.get(qName);
                        if (object7 == null) continue block14;
                        this.registry.put(object, object7);
                        continue block14;
                    }
                    if (schemaType == null) continue block14;
                    if (schemaType.getElementType() == 1) {
                        object7 = ((SchemaSimpleType)schemaType).getBase();
                        object6 = (String)this.registry.get(object7);
                        if (object6 == null) continue block14;
                        if (((SchemaSimpleType)schemaType).isList()) {
                            object6 = (String)object6 + "[]";
                        }
                        this.registry.put(object, object6);
                        continue block14;
                    }
                    if (schemaType.getElementType() != 0) continue block14;
                    this.registry.put(object, string + Conventions.schema2JavaName("complexType", (String)object3, true));
                    continue block14;
                }
                case 3: {
                    String string2;
                    Object object8;
                    Object object7 = (SchemaAttribute)object42;
                    QName qName = ((SchemaAttribute)object7).getType();
                    Object object6 = ((SchemaAttribute)object7).getChild();
                    if (qName != null) {
                        object8 = (String)this.registry.get(qName);
                        if (object8 == null) continue block14;
                        this.registry.put(object, object8);
                        continue block14;
                    }
                    if (object6 == null || (string2 = (String)this.registry.get(object8 = ((SchemaSimpleType)object6).getBase())) == null) continue block14;
                    if (((SchemaSimpleType)object6).isList()) {
                        string2 = string2 + "[]";
                    }
                    this.registry.put(object, string2);
                }
            }
        }
    }
}

