/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.wsif.WSIFException;
import org.apache.wsif.compiler.schema.tools.Conventions;

public class StreamFactory {
    public OutputStream getOutputStream(String string, String string2, boolean bl) throws WSIFException {
        File file;
        boolean bl2 = Conventions.getVerbose();
        if (string != null && !(file = new File(string)).exists()) {
            if (!file.mkdirs()) {
                throw new WSIFException("Failed to create directory '" + string + "'.");
            }
            if (bl2) {
                System.out.println("Created directory '" + file.getAbsolutePath() + "'.");
            }
        }
        file = new File(string, string2);
        String string3 = file.getAbsolutePath();
        if (file.exists()) {
            if (!bl) {
                throw new WSIFException("File '" + string3 + "' already exists. Please remove it or " + "enable the overwrite option.");
            }
            file.delete();
            if (bl2) {
                System.out.println("Deleted file '" + string3 + "'.");
            }
        }
        if (bl2) {
            System.out.println("Created file '" + string3 + "'.");
        }
        try {
            return new FileOutputStream(string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WSIFException("Problem getting output stream.", fileNotFoundException);
        }
    }

    public InputStream getInputStream(String string, String string2) throws IOException {
        String string3 = string != null ? string + File.separatorChar + string2 : string2;
        URL uRL = null;
        Object object = null;
        try {
            uRL = StreamFactory.getURL(null, string3, 1);
            object = uRL.getContent();
        }
        catch (SecurityException securityException) {
            throw new IOException("Your JVM's security manager has disallowed access to '" + string3 + "'.");
        }
        catch (IOException iOException) {
            throw new IOException("The resource at '" + string3 + "' was not found.");
        }
        if (object == null) {
            throw new IllegalArgumentException("No content at '" + string3 + "'.");
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        throw new IOException("The content of '" + string3 + "' is not a stream.");
    }

    private static URL getURL(URL uRL, String string, int n) throws MalformedURLException {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                throw new MalformedURLException("This file was not found: " + uRL2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = new URL("file", "", string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                String string2;
                String string3;
                if (uRL != null && (string3 = new File(string2 = uRL.getFile()).getParent()) != null && n < 3) {
                    return StreamFactory.getURL(new URL("file", "", string3 + '/'), string, n + 1);
                }
                throw new MalformedURLException("This file was not found: " + uRL2);
            }
        }
        return uRL2;
    }
}

