/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.util;

import com.ibm.wsdl.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.compiler.util.TypeMapping;

public class Utils {
    public static void addAllTypesElements(Definition definition, List list) {
        Object object;
        Types types = definition.getTypes();
        if (types != null) {
            object = types.getExtensibilityElements().iterator();
            while (object.hasNext()) {
                UnknownExtensibilityElement unknownExtensibilityElement = (UnknownExtensibilityElement)object.next();
                list.add(unknownExtensibilityElement);
            }
        }
        if ((object = definition.getImports()) != null) {
            for (List list2 : object.values()) {
                if (list2 == null) continue;
                for (Import import_ : list2) {
                    Definition definition2;
                    if (import_ == null || (definition2 = import_.getDefinition()) == null) continue;
                    Utils.addAllTypesElements(definition2, list);
                }
            }
        }
    }

    public static List getAllTypesElements(Definition definition) {
        Vector vector = new Vector();
        Utils.addAllTypesElements(definition, vector);
        return vector;
    }

    public static String getPackageName(String string) {
        int n;
        String string2 = "";
        if (string != null && (n = string.lastIndexOf(46)) != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getClassName(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String queryJavaTypeName(QName qName, String string, Hashtable hashtable) throws IllegalArgumentException {
        TypeMapping typeMapping = (TypeMapping)hashtable.get(qName);
        if (typeMapping != null) {
            return typeMapping.javaType;
        }
        if (string != null && string.equals("http://xml.apache.org/xml-soap/literalxml")) {
            return "org.w3c.dom.Element";
        }
        throw new IllegalArgumentException("No mapping was found for '" + qName + "'.");
    }

    public static String getQuotedString(Reader reader, int n) throws WSIFException {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        String string = new String(cArray);
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringWriter stringWriter = new StringWriter();
            int n2 = 0;
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringWriter.write((n2 > 0 ? " + \"" + StringUtils.lineSeparatorStr + "\" +" + StringUtils.lineSeparator : "") + string + '\"' + StringUtils.cleanString((String)string2) + '\"');
                ++n2;
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new WSIFException("Problem writing strings.", iOException);
        }
    }

    public static String convertToObject(String string, String string2) throws WSIFException {
        return Utils.convertClass(string, string2, "java.lang.Object");
    }

    public static String convertFromObject(String string, String string2) throws WSIFException {
        return Utils.convertClass("java.lang.Object", string, string2);
    }

    private static String convertClass(String string, String string2, String string3) throws WSIFException {
        if (string == null || string3 == null) {
            throw new WSIFException("I was unable to convert an object from " + string + " to " + string3 + ".");
        }
        String string4 = Utils.getShortName(string3);
        if (string.equals("java.lang.Object")) {
            if (Utils.isPrimitive(string3)) {
                return "((" + Utils.getWrapperClassName(string3) + ")" + string2 + ")." + string4 + "Value()";
            }
            return "(" + string3 + ")" + string2;
        }
        if (Utils.isPrimitive(string) && string3.equals("java.lang.Object")) {
            return "new " + Utils.getWrapperClassName(string) + "(" + string2 + ")";
        }
        return string2;
    }

    private static String getShortName(String string) {
        if (string.startsWith("java.lang.")) {
            return string.substring(10);
        }
        return string;
    }

    private static String getWrapperClassName(String string) {
        if (string.equals("int")) {
            return "Integer";
        }
        if (string.equals("char")) {
            return "Character";
        }
        return Utils.getCapitalized(string);
    }

    private static String getCapitalized(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private static boolean isPrimitive(String string) {
        String[] stringArray = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double", "void"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

