/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wsif.logging.Trc;

public class MessageLogger {
    private static Log log = LogFactory.getLog((String)"wsif");
    private static ResourceBundle messages = null;

    private MessageLogger() {
        Trc.entry(this);
        Trc.exit();
    }

    public static boolean isInfoEnabled() {
        return log.isInfoEnabled();
    }

    public static boolean isWarnEnabled() {
        return log.isWarnEnabled();
    }

    public static boolean isErrorEnabled() {
        return log.isErrorEnabled();
    }

    public static boolean isFatalEnabled() {
        return log.isFatalEnabled();
    }

    public static void log(String string) {
        Trc.entry(null, string);
        try {
            MessageLogger.logIt(string.charAt(string.length() - 1), MessageLogger.getMessage(string));
        }
        catch (MissingResourceException missingResourceException) {
            Trc.exception(missingResourceException);
            MessageLogger.handleMissingResourceException(missingResourceException, string, null);
        }
        Trc.exit();
    }

    public static void log(String string, Object object) {
        Trc.entry(null, string, object);
        Object[] objectArray = new String[]{object == null ? "<null>" : object.toString()};
        try {
            MessageLogger.logIt(string.charAt(string.length() - 1), MessageFormat.format(MessageLogger.getMessage(string), objectArray));
        }
        catch (MissingResourceException missingResourceException) {
            Trc.exception(missingResourceException);
            MessageLogger.handleMissingResourceException(missingResourceException, string, (String[])objectArray);
        }
        Trc.exit();
    }

    public static void log(String string, Object object, Object object2) {
        Trc.entry(null, string, object, object2);
        Object[] objectArray = new String[]{object == null ? "<null>" : object.toString(), object2 == null ? "<null>" : object2.toString()};
        try {
            MessageLogger.logIt(string.charAt(string.length() - 1), MessageFormat.format(MessageLogger.getMessage(string), objectArray));
        }
        catch (MissingResourceException missingResourceException) {
            Trc.exception(missingResourceException);
            MessageLogger.handleMissingResourceException(missingResourceException, string, (String[])objectArray);
        }
        Trc.exit();
    }

    public static void log(String string, Object[] objectArray) {
        Object[] objectArray2;
        Trc.entry(null, string, objectArray);
        if (objectArray == null) {
            objectArray2 = new String[]{"<null>"};
        } else {
            objectArray2 = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] == null ? "<null>" : objectArray[i].toString();
            }
        }
        try {
            MessageLogger.logIt(string.charAt(string.length() - 1), MessageFormat.format(MessageLogger.getMessage(string), objectArray2));
        }
        catch (MissingResourceException missingResourceException) {
            Trc.exception(missingResourceException);
            MessageLogger.handleMissingResourceException(missingResourceException, string, (String[])objectArray2);
        }
        Trc.exit();
    }

    private static String getMessage(String string) {
        if (messages == null) {
            messages = ResourceBundle.getBundle("org.apache.wsif.catalog.Messages");
        }
        return messages.getString(string);
    }

    private static void logIt(char c, String string) {
        if (c == 'I') {
            if (MessageLogger.isInfoEnabled()) {
                log.info((Object)string);
            }
        } else if (c == 'W') {
            if (MessageLogger.isWarnEnabled()) {
                log.warn((Object)string);
            }
        } else if (c == 'F') {
            if (MessageLogger.isFatalEnabled()) {
                log.fatal((Object)string);
            }
        } else if (MessageLogger.isErrorEnabled()) {
            log.error((Object)string);
        }
    }

    private static void handleMissingResourceException(MissingResourceException missingResourceException, String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("WSIF: Unable to display message ");
        stringBuffer.append(string);
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append(" with arguments ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        stringBuffer.append(" because WSIF MessageLogger caught ");
        stringBuffer.append(missingResourceException.toString());
        log.error((Object)stringBuffer.toString());
    }
}

