/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Trc {
    public static final int LOG_LEVEL_TRACE = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_INFO = 2;
    public static final int LOG_LEVEL_WARN = 3;
    public static final int LOG_LEVEL_ERROR = 4;
    public static final int LOG_LEVEL_FATAL = 5;
    private static final String wsifPackageName = "org.apache.wsif";
    private static Log log = LogFactory.getLog((String)"org.apache.wsif.*");
    public static boolean ON = log.isDebugEnabled();
    private static int currentLogLevel = log.isTraceEnabled() ? 0 : (log.isDebugEnabled() ? 1 : (log.isInfoEnabled() ? 2 : (log.isWarnEnabled() ? 3 : (log.isErrorEnabled() ? 4 : 5))));
    private static Log traceLog = LogFactory.getLog((String)"org.apache.wsif.logging.*");
    private static boolean traceTrace = false;
    private static final String ENTRY = "ENTRY";
    private static final String EXIT = "EXIT ";
    private static final String EXCEPTION = "EXCEPTION";
    private static final String EVENT = "EVENT";

    private Trc() {
    }

    public static boolean isTraceEnabled() {
        return log.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    public static void entry(Object object) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, null);
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10, object11});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13, object14});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13, object14, object15});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13, object14, object15, object16});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entryExpandWsdl(Object object, Object[] objectArray) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, ENTRY, true, objectArray);
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void entry(Object object, boolean bl) {
        if (ON) {
            Trc.entry(object, new Boolean(bl));
        }
    }

    public static void entry(Object object, int n) {
        if (ON) {
            Trc.entry(object, new Integer(n));
        }
    }

    public static void exit() {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(null, EXIT, false, null);
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void exit(Object object) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(null, EXIT, false, new Object[]{object});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void exit(boolean bl) {
        if (ON) {
            Trc.exit(new Boolean(bl));
        }
    }

    public static void exit(int n) {
        if (ON) {
            Trc.exit(new Integer(n));
        }
    }

    public static void exitExpandWsdl(Object object) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(null, EXIT, true, new Object[]{object});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void exception(Throwable throwable) {
        try {
            if (!ON) {
                return;
            }
            log.debug((Object)EXCEPTION, throwable);
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void ignoredException(Throwable throwable) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(null, EVENT, false, new Object[]{"Caught and handled throwable: " + throwable.toString()});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void exceptionInTrace(Exception exception) {
        try {
            log.debug((Object)"****** Exception in WSIF trace statement ******", (Throwable)exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public static void event(Object object, Object object2) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3, Object object4) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3, object4});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3, Object object4, Object object5) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3, object4, object5});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3, object4, object5, object6});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3, object4, object5, object6, object7});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3, object4, object5, object6, object7, object8});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static void event(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(object, EVENT, false, new Object[]{object2, object3, object4, object5, object6, object7, object8, object9, object10, object11});
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
    }

    public static String brief(Definition definition) {
        return !ON ? "" : Trc.brief(1, definition);
    }

    public static String brief(int n, Definition definition) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (definition == null) {
                return "null";
            }
            if (definition.getQName() == null) {
                return "UNNAMED," + Integer.toHexString(definition.hashCode());
            }
            return definition.getQName() + "," + Integer.toHexString(definition.hashCode());
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    public static String brief(PortType portType) {
        return !ON ? "" : Trc.brief(1, portType);
    }

    public static String brief(int n, PortType portType) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (portType == null) {
                return "null";
            }
            if (portType.getQName() == null) {
                return "UNNAMED," + Integer.toHexString(portType.hashCode());
            }
            return portType.getQName() + "," + Integer.toHexString(portType.hashCode());
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    public static String brief(Service service) {
        return !ON ? "" : Trc.brief(1, service);
    }

    public static String brief(int n, Service service) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (service == null) {
                return "null";
            }
            if (service.getQName() == null) {
                return "UNNAMED," + Integer.toHexString(service.hashCode());
            }
            return service.getQName() + "," + Integer.toHexString(service.hashCode());
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    public static String brief(Port port) {
        return !ON ? "" : Trc.brief(1, port);
    }

    public static String brief(int n, Port port) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (port == null) {
                return "null";
            }
            if (port.getName() == null) {
                return "UNNAMED," + Integer.toHexString(port.hashCode());
            }
            return port.getName() + "," + Integer.toHexString(port.hashCode());
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    public static String brief(BindingOperation bindingOperation) {
        return !ON ? "" : Trc.brief(1, bindingOperation);
    }

    public static String brief(int n, BindingOperation bindingOperation) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (bindingOperation == null) {
                return "null";
            }
            if (bindingOperation.getName() == null) {
                return "UNNAMED," + Integer.toHexString(bindingOperation.hashCode());
            }
            return bindingOperation.getName() + "," + Integer.toHexString(bindingOperation.hashCode());
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    public static String brief(Operation operation) {
        return !ON ? "" : Trc.brief(1, operation);
    }

    public static String brief(int n, Operation operation) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (operation == null) {
                return "null";
            }
            if (operation.getName() == null) {
                return "UNNAMED," + Integer.toHexString(operation.hashCode());
            }
            return operation.getName() + "," + Integer.toHexString(operation.hashCode());
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    public static String brief(String string, Collection collection) {
        return !ON ? "" : Trc.brief(1, string, collection);
    }

    public static String brief(int n, String string, Collection collection) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (collection == null) {
                return string + ":null";
            }
            if (collection.size() == 0) {
                return string + ":size(0)";
            }
            return Trc.brief(n, string, collection.toArray());
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    public static String brief(String string, Object[] objectArray) {
        return !ON ? "" : Trc.brief(1, string, objectArray);
    }

    public static String brief(int n, String string, Object[] objectArray) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (objectArray == null) {
                return string + ":null";
            }
            if (objectArray.length == 0) {
                return string + ":size(0)";
            }
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = objectArray[i] == null ? "null" : objectArray[i].toString();
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append("[");
                stringBuffer.append(i);
                stringBuffer.append("]:");
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    public static String brief(Map map) {
        return !ON ? "" : Trc.brief(1, map);
    }

    public static String brief(int n, Map map) {
        try {
            if (currentLogLevel > n) {
                return "";
            }
            if (map == null) {
                return "<null>";
            }
            if (map.isEmpty()) {
                return "size(0)";
            }
            StringBuffer stringBuffer = new StringBuffer("{");
            boolean bl = true;
            for (String string : map.keySet()) {
                Object object = map.get(string);
                if (object == null) {
                    object = "<null>";
                }
                Object object2 = Trc.checkWsdl(object);
                if (!bl) {
                    stringBuffer.append(", ");
                }
                bl = false;
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(object2.toString());
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
            return "";
        }
    }

    private static void checkWsdl(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = Trc.checkWsdl(objectArray[i]);
        }
    }

    private static Object checkWsdl(Object object) {
        String string = null;
        boolean bl = false;
        if (object instanceof Definition) {
            bl = true;
            Definition definition = (Definition)object;
            string = definition == null ? "definition(NULL)" : (definition.getQName() == null ? "definition(UNNAMED" : "definition(" + definition.getQName());
        } else if (object instanceof Service) {
            bl = true;
            Service service = (Service)object;
            string = service == null ? "service(NULL)" : (service.getQName() == null ? "service(UNNAMED" : "service(" + service.getQName());
        } else if (object instanceof Port) {
            bl = true;
            Port port = (Port)object;
            string = port == null ? "port(NULL)" : (port.getName() == null ? "port(UNNAMED" : "port(" + port.getName());
        } else if (object instanceof PortType) {
            bl = true;
            PortType portType = (PortType)object;
            string = portType == null ? "portType(NULL)" : (portType.getQName() == null ? "portType(UNNAMED" : "portType(" + portType.getQName());
        } else if (object instanceof Operation) {
            bl = true;
            Operation operation = (Operation)object;
            string = operation == null ? "operation(NULL)" : (operation.getName() == null ? "operation(UNNAMED" : "operation(" + operation.getName());
        } else if (object instanceof Binding) {
            bl = true;
            Binding binding = (Binding)object;
            string = binding == null ? "binding(NULL)" : (binding.getQName() == null ? "binding(UNNAMED" : "binding(" + binding.getQName());
        } else if (object instanceof BindingOperation) {
            bl = true;
            BindingOperation bindingOperation = (BindingOperation)object;
            string = bindingOperation == null ? "bindingOperation(NULL)" : (bindingOperation.getName() == null ? "bindingOperation(UNNAMED" : "bindingOperation(" + bindingOperation.getName());
        } else if (object instanceof BindingInput) {
            bl = true;
            BindingInput bindingInput = (BindingInput)object;
            string = bindingInput == null ? "bindingInput(NULL)" : (bindingInput.getName() == null ? "bindingInput(UNNAMED" : "bindingInput(" + bindingInput.getName());
        } else if (object instanceof BindingOutput) {
            bl = true;
            BindingOutput bindingOutput = (BindingOutput)object;
            string = bindingOutput == null ? "bindingOutput(NULL)" : (bindingOutput.getName() == null ? "bindingOutput(UNNAMED" : "bindingOutput(" + bindingOutput.getName());
        } else if (object instanceof Map) {
            Map map = (Map)object;
            HashMap hashMap = null;
            for (Object k : map.keySet()) {
                Object object2;
                Object v;
                if (k == null || (v = map.get(k)) == null || v.equals(object2 = Trc.checkWsdl(v))) continue;
                if (hashMap == null) {
                    hashMap = new HashMap(map);
                }
                hashMap.put(k, object2);
            }
            if (hashMap != null) {
                return hashMap;
            }
            return map;
        }
        if (!bl) {
            return object;
        }
        if (object != null) {
            string = string + "," + Integer.toHexString(object.hashCode()) + ")";
        }
        return string;
    }

    private static void appendMethodName(StringBuffer stringBuffer) {
        Exception exception = new Exception();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        String string = stringWriter.getBuffer().toString();
        if (traceTrace) {
            traceLog.debug((Object)("TRACE stack=" + string));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator", "\n"));
        boolean bl = false;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.indexOf("org.apache.wsif.logging") != -1) {
                bl = true;
                continue;
            }
            if (!bl) continue;
        }
        if (traceTrace) {
            traceLog.debug((Object)("TRACE token=" + string2));
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
        String string3 = null;
        while (stringTokenizer2.hasMoreTokens() && (string3 = stringTokenizer2.nextToken()).indexOf("(") == -1) {
        }
        if (string3.indexOf("(") == -1) {
            string3 = string2;
        }
        stringBuffer.append(" ");
        while (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.nextToken().indexOf(wsifPackageName) == -1) continue;
            stringBuffer.append(" ");
        }
        int n = string3.indexOf("(");
        if (n != -1) {
            string3 = string3.substring(0, n);
        }
        if (traceTrace) {
            traceLog.debug((Object)("TRACE token=" + string3));
        }
        String string4 = null;
        if (string3.startsWith(wsifPackageName)) {
            StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ".");
            String string5 = null;
            while (stringTokenizer3.hasMoreTokens()) {
                string5 = string4;
                string4 = stringTokenizer3.nextToken();
            }
            if (string5 != null) {
                string4 = string5 + "." + string4;
            }
        } else {
            string4 = string3;
        }
        if (traceTrace) {
            traceLog.debug((Object)("TRACE appending result=" + string4));
        }
        stringBuffer.append(string4);
    }

    private static void traceIt(Object object, String string, boolean bl, Object[] objectArray) {
        boolean bl2 = false;
        if (EVENT.equals(string)) {
            bl2 = true;
        }
        if (!bl) {
            Trc.checkWsdl(objectArray);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl2) {
            stringBuffer.append(" ");
        }
        Trc.appendMethodName(stringBuffer);
        if (object != null) {
            stringBuffer.append("<");
            stringBuffer.append(Integer.toHexString(object.hashCode()));
            stringBuffer.append(">");
        }
        if (bl2) {
            stringBuffer.append(" ");
        } else {
            stringBuffer.append("(");
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0 && !bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(objectArray[i] == null ? "<null>" : objectArray[i].toString());
            }
        }
        if (!bl2) {
            stringBuffer.append(")");
        }
        log.debug((Object)stringBuffer);
    }
}

