/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.mapping;

import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.WSIFMapper;
import org.apache.wsif.util.WSIFProperties;

public class WSIFMapperFactory {
    private static final String DEFAULT_MAPPER_CLASS = "org.apache.wsif.mapping.WSIFDefaultMapper";
    private static StringBuffer mapperClassNameBuffer = new StringBuffer();

    public static WSIFMapper newMapper() throws WSIFException {
        return WSIFMapperFactory.newMapper(false);
    }

    public static WSIFMapper newMapper(boolean bl) throws WSIFException {
        StringBuffer stringBuffer = mapperClassNameBuffer;
        synchronized (stringBuffer) {
            Object object;
            if (mapperClassNameBuffer.length() == 0 || bl) {
                object = null;
                try {
                    object = System.getProperty("org.apache.wsif.mapper");
                }
                catch (SecurityException securityException) {
                    Trc.ignoredException(securityException);
                }
                if (object == null) {
                    object = WSIFProperties.getProperty("org.apache.wsif.mapper");
                }
                if (object == null) {
                    object = DEFAULT_MAPPER_CLASS;
                }
                if (bl) {
                    mapperClassNameBuffer.delete(0, mapperClassNameBuffer.length());
                }
                mapperClassNameBuffer.insert(0, (String)object);
            }
            try {
                object = Class.forName(mapperClassNameBuffer.toString(), true, Thread.currentThread().getContextClassLoader());
                return (WSIFMapper)((Class)object).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WSIFException("Unable to create new mapper", classNotFoundException);
            }
            catch (Exception exception) {
                throw new WSIFException("Unable to create new mapper", exception);
            }
        }
    }

    public static WSIFMapper newMapper(String string) throws WSIFException {
        try {
            Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            return (WSIFMapper)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WSIFException("Unable to create new mapper", classNotFoundException);
        }
        catch (Exception exception) {
            throw new WSIFException("Unable to create new mapper", exception);
        }
    }
}

