/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.mapping;

import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.WSIFMappingConvention;
import org.apache.wsif.util.WSIFProperties;

public class WSIFMappingConventionFactory {
    private static final String DEFAULT_MAPPINGCONVENTION_CLASS = "org.apache.wsif.mapping.WSIFDefaultMappingConvention";
    private static StringBuffer mappingConvClassNameBuffer = new StringBuffer();

    public static WSIFMappingConvention newMappingConvention() throws WSIFException {
        return WSIFMappingConventionFactory.newMappingConvention(false);
    }

    public static WSIFMappingConvention newMappingConvention(boolean bl) throws WSIFException {
        StringBuffer stringBuffer = mappingConvClassNameBuffer;
        synchronized (stringBuffer) {
            Object object;
            if (mappingConvClassNameBuffer.length() == 0 || bl) {
                object = null;
                try {
                    object = System.getProperty("org.apache.wsif.mappingconvention");
                }
                catch (SecurityException securityException) {
                    Trc.ignoredException(securityException);
                }
                if (object == null) {
                    object = WSIFProperties.getProperty("org.apache.wsif.mappingconvention");
                }
                if (object == null) {
                    object = DEFAULT_MAPPINGCONVENTION_CLASS;
                }
                if (bl) {
                    mappingConvClassNameBuffer.delete(0, mappingConvClassNameBuffer.length());
                }
                mappingConvClassNameBuffer.insert(0, (String)object);
            }
            try {
                object = Class.forName(mappingConvClassNameBuffer.toString(), true, Thread.currentThread().getContextClassLoader());
                return (WSIFMappingConvention)((Class)object).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WSIFException("Unable to create new mapping convention", classNotFoundException);
            }
            catch (Exception exception) {
                throw new WSIFException("Unable to create new mapping convention", exception);
            }
        }
    }

    public static WSIFMappingConvention newMappingConvention(String string) throws WSIFException {
        try {
            Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            return (WSIFMappingConvention)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WSIFException("Unable to create new mapping convention", classNotFoundException);
        }
        catch (Exception exception) {
            throw new WSIFException("Unable to create new mapping convention", exception);
        }
    }
}

