/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.InvocationHelper;
import org.apache.wsif.providers.ModelWSIFPort;
import org.apache.wsif.providers.Part;
import org.apache.wsif.providers.ProviderUtils;

public abstract class ModelWSIFOperation
implements WSIFOperation {
    protected ModelWSIFPort wsifPort;
    protected BindingOperation bindingOperation;
    protected Operation portTypeOperation;
    protected List inputParts;
    protected List outputParts;
    protected WSIFResponseHandler asyncResponseHandler;
    protected WSIFMessage context;
    protected boolean used;

    public ModelWSIFOperation(ModelWSIFPort modelWSIFPort, BindingOperation bindingOperation) throws WSIFException {
        this.wsifPort = modelWSIFPort;
        this.bindingOperation = bindingOperation;
    }

    public void executeInputOnlyOperation(WSIFMessage wSIFMessage) throws WSIFException {
        Trc.entry((Object)this, wSIFMessage);
        this.markAsUsed();
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("input message is null");
        }
        this.invokeInputOnlyOperation(wSIFMessage);
        Trc.exit();
    }

    public boolean executeRequestResponseOperation(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Trc.entry(this, wSIFMessage, wSIFMessage2, wSIFMessage3);
        this.markAsUsed();
        if (!this.wsifPort.supportsSync()) {
            throw new WSIFException("synchronus operations not supported");
        }
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("input message is null");
        }
        if (wSIFMessage2 == null) {
            throw new IllegalArgumentException("output message is null");
        }
        if (wSIFMessage3 == null) {
            throw new IllegalArgumentException("fault message is null");
        }
        boolean bl = this.invokeRequestResponseOperation(wSIFMessage, wSIFMessage2, wSIFMessage3);
        Trc.exit(bl);
        return bl;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage) throws WSIFException {
        Trc.entry((Object)this, wSIFMessage);
        this.markAsUsed();
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not supportted");
        }
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("input message is null");
        }
        WSIFCorrelationId wSIFCorrelationId = this.invokeRequestResponseAsync(wSIFMessage, null);
        Trc.exit(wSIFCorrelationId);
        return wSIFCorrelationId;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage, WSIFResponseHandler wSIFResponseHandler) throws WSIFException {
        Trc.entry(this, wSIFMessage, wSIFResponseHandler);
        this.markAsUsed();
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not supportted");
        }
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("input message is null");
        }
        if (wSIFResponseHandler == null) {
            throw new IllegalArgumentException("WSIFResponseHandler is null");
        }
        WSIFCorrelationId wSIFCorrelationId = this.invokeRequestResponseAsync(wSIFMessage, wSIFResponseHandler);
        Trc.exit(wSIFCorrelationId);
        return wSIFCorrelationId;
    }

    public void fireAsyncResponse(Object object) throws WSIFException {
        Trc.entry((Object)this, object);
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not supportted");
        }
        if (this.asyncResponseHandler == null) {
            throw new WSIFException("asyncResponseHandler is null!");
        }
        Map map = this.doDeserialiseResponse(object);
        WSIFMessage wSIFMessage = this.createOutputMessage();
        WSIFMessage wSIFMessage2 = this.createFaultMessage();
        this.buildResponseMessages(map, wSIFMessage, wSIFMessage2);
        this.asyncResponseHandler.executeAsyncResponse(wSIFMessage, wSIFMessage2);
        Trc.exit();
    }

    public boolean processAsyncResponse(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        Trc.entry(this, object, wSIFMessage, wSIFMessage2);
        Trc.exit();
        throw new WSIFException("not implemented yet");
    }

    protected boolean invokeRequestResponseOperation(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        boolean bl = false;
        this.setPartValues(this.inputParts, wSIFMessage);
        List list = this.getInputArguments();
        ArrayList arrayList = new ArrayList();
        this.setInvocationContext();
        bl = this.doInvokeRequestResponse(list, arrayList);
        if (bl) {
            if (wSIFMessage2 != null) {
                this.setPartValues(this.outputParts, arrayList);
                this.setMessagePartValues(wSIFMessage2, this.outputParts);
            }
        } else if (wSIFMessage3 != null) {
            this.setFaultObjects(wSIFMessage3, arrayList);
        }
        return bl;
    }

    protected boolean doInvokeRequestResponse(List list, List list2) throws WSIFException {
        throw new WSIFException("doInvoke must be implemented by subclass!");
    }

    protected void invokeInputOnlyOperation(WSIFMessage wSIFMessage) throws WSIFException {
        this.invokeRequestResponseOperation(wSIFMessage, null, null);
        boolean bl = false;
        this.setPartValues(this.inputParts, wSIFMessage);
        List list = this.getInputArguments();
        ArrayList arrayList = new ArrayList();
        this.setInvocationContext();
        this.doInvokeInputOnly(list);
    }

    protected void doInvokeInputOnly(List list) throws WSIFException {
        this.doInvokeRequestResponse(list, new ArrayList());
    }

    protected WSIFCorrelationId invokeRequestResponseAsync(WSIFMessage wSIFMessage, WSIFResponseHandler wSIFResponseHandler) throws WSIFException {
        this.setPartValues(this.inputParts, wSIFMessage);
        List list = this.getInputArguments();
        this.setInvocationContext();
        WSIFCorrelationId wSIFCorrelationId = this.doInvokeRequestResponseAsync(list);
        return wSIFCorrelationId;
    }

    protected WSIFCorrelationId doInvokeRequestResponseAsync(List list) throws WSIFException {
        throw new WSIFException("doInvokeAsync must be implemented by subclass!");
    }

    protected Map doDeserialiseResponse(Object object) throws WSIFException {
        throw new WSIFException("doDeserialiseResponse must be implemented by subclass!");
    }

    protected void buildResponseMessages(Map map, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        throw new WSIFException("buildResponseMessages must be implemented by subclass!");
    }

    protected void setPartValues(List list, WSIFMessage wSIFMessage) throws WSIFException {
        for (Part part : list) {
            Object object;
            try {
                object = wSIFMessage.getObjectPart(part.getName());
                this.validatePartValue(part, object);
            }
            catch (WSIFException wSIFException) {
                object = this.doMissingPart(wSIFMessage, part);
            }
            part.setValue(object);
        }
    }

    protected void setPartValues(List list, List list2) throws WSIFException {
        Iterator iterator = list2.iterator();
        for (Part part : list) {
            Object object;
            if (iterator.hasNext()) {
                object = iterator.next();
                this.validatePartValue(part, object);
            } else {
                object = this.doMissingOutputValue(part);
            }
            part.setValue(object);
        }
    }

    protected void setMessagePartValues(WSIFMessage wSIFMessage, List list) throws WSIFException {
        for (Part part : list) {
            wSIFMessage.setObjectPart(part.getName(), part.getValue());
        }
    }

    protected void setFaultObjects(WSIFMessage wSIFMessage, List list) throws WSIFException {
        int n = 0;
        for (Object e : list) {
            String string = "fault" + n++;
            wSIFMessage.setObjectPart(string, e);
        }
    }

    protected List getInputArguments() throws WSIFException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Part part : this.inputParts) {
            Object object = part.getValue();
            arrayList.add(object);
        }
        return arrayList;
    }

    protected Object doMissingPart(WSIFMessage wSIFMessage, Part part) {
        Trc.event(this, "message " + wSIFMessage.getName() + "has missing input part '" + part.getName() + "', defaulting to null");
        return null;
    }

    protected Object doMissingOutputValue(Part part) {
        Trc.event(this, "response value missing for part: " + part.getName());
        return null;
    }

    protected void validatePartValue(Part part, Object object) throws WSIFException {
        if (object != null) {
            Class<?> clazz = object.getClass();
            if (!(part.getJavaClass().isAssignableFrom(clazz) || object instanceof WSIFAttachmentPart || "javax.activation.DataHandler".equals(clazz))) {
                throw new WSIFException("WSIFMessage part '" + part.getName() + "' has invalid type, expecting " + part.getJavaClass() + " found " + object.getClass());
            }
        }
    }

    protected void initialise() throws WSIFException {
        this.used = false;
        if (this.inputParts == null) {
            this.prepare();
        }
        this.doInitialise();
    }

    protected void doInitialise() {
    }

    protected void prepare() throws WSIFException {
        Message message;
        this.inputParts = new ArrayList();
        this.outputParts = new ArrayList();
        Operation operation = this.getPortTypeOperation();
        boolean bl = ProviderUtils.isUnwrapable(operation);
        if (bl) {
            boolean bl2 = bl = !this.isWrappedInContext();
        }
        if (operation.getInput() != null) {
            message = operation.getInput().getMessage();
            this.initialiseParts(message, bl, this.inputParts);
        }
        if (operation.getOutput() != null) {
            message = operation.getOutput().getMessage();
            this.initialiseParts(message, bl, this.outputParts);
        }
        this.initializeOperationExtensibilityElement();
        this.doPrepare();
    }

    protected void initializeOperationExtensibilityElement() throws WSIFException {
        Class clazz = this.getOperationExtensibilityClass();
        if (clazz != null) {
            if (!ExtensibilityElement.class.isAssignableFrom(clazz)) {
                throw new WSIFException("getOperationExtensabilityClass must return a subclass of ExtensibilityElement");
            }
            ExtensibilityElement extensibilityElement = null;
            List list = this.bindingOperation.getExtensibilityElements();
            Iterator iterator = list.iterator();
            while (extensibilityElement == null && iterator.hasNext()) {
                Object e = iterator.next();
                if (!clazz.isAssignableFrom(e.getClass())) continue;
                extensibilityElement = (ExtensibilityElement)e;
            }
            if (extensibilityElement != null) {
                this.validateOperationExtensibilityElement(extensibilityElement);
            }
        }
    }

    protected Class getOperationExtensibilityClass() {
        return null;
    }

    protected void validateOperationExtensibilityElement(ExtensibilityElement extensibilityElement) throws WSIFException {
    }

    protected void doPrepare() {
    }

    protected void initialiseParts(Message message, boolean bl, List list) throws WSIFException {
        List list2 = message.getOrderedParts(null);
        if (list2 != null && !list2.isEmpty()) {
            if (bl) {
                Part part = (Part)list2.get(0);
                Object object = ProviderUtils.unWrapPart(part.getWsdlPart(), this.wsifPort.getDefinition(), this.getContext());
                list2.remove(part);
                list2.add(0, object);
            }
            for (Object object : list2) {
                Part part = new Part((javax.wsdl.Part)object);
                part.setJavaClass(this.wsifPort.getClassForPart((javax.wsdl.Part)object));
                list.add(part);
            }
        }
    }

    protected boolean isWrappedInContext() {
        boolean bl = false;
        String string = null;
        try {
            WSIFMessage wSIFMessage = this.getContext();
            string = (String)wSIFMessage.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        if ("wrapped".equals(string)) {
            bl = true;
        }
        return bl;
    }

    protected boolean isUnwrappedInContext() {
        boolean bl = false;
        String string = null;
        try {
            WSIFMessage wSIFMessage = this.getContext();
            string = (String)wSIFMessage.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        if ("unwrapped".equals(string)) {
            bl = true;
        }
        return bl;
    }

    protected Operation getOperation() throws WSIFException {
        Trc.entry(this);
        this.getPortTypeOperation();
        Trc.exit(this.portTypeOperation);
        return this.portTypeOperation;
    }

    public Operation getPortTypeOperation() {
        Trc.entry(this);
        if (this.portTypeOperation == null) {
            String string = null;
            if (this.bindingOperation.getBindingInput() != null) {
                string = this.bindingOperation.getBindingInput().getName();
            }
            String string2 = null;
            if (this.bindingOperation.getBindingOutput() != null) {
                string2 = this.bindingOperation.getBindingOutput().getName();
            }
            this.portTypeOperation = this.wsifPort.getPort().getBinding().getPortType().getOperation(this.bindingOperation.getName(), string, string2);
            if (this.portTypeOperation == null) {
                throw new RuntimeException("no WSDL portType operation found for binding opertion: " + this.bindingOperation.getName() + ":" + string + ":" + string2);
            }
        }
        Trc.exit(this.portTypeOperation);
        return this.portTypeOperation;
    }

    public WSIFMessage createInputMessage() {
        Trc.entry(this);
        WSIFMessage wSIFMessage = this.createInputMessage(null);
        Trc.exit(wSIFMessage);
        return wSIFMessage;
    }

    public WSIFMessage createInputMessage(String string) {
        Trc.entry((Object)this, string);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        wSIFDefaultMessage.setName(string);
        Input input = this.getPortTypeOperation().getInput();
        if (input != null) {
            wSIFDefaultMessage.setMessageDefinition(input.getMessage());
        }
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    public WSIFMessage createOutputMessage() {
        Trc.entry(this);
        WSIFMessage wSIFMessage = this.createOutputMessage(null);
        Trc.exit(wSIFMessage);
        return wSIFMessage;
    }

    public WSIFMessage createOutputMessage(String string) {
        Trc.entry((Object)this, string);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        wSIFDefaultMessage.setName(string);
        Output output = this.getPortTypeOperation().getOutput();
        if (output != null) {
            wSIFDefaultMessage.setMessageDefinition(output.getMessage());
        }
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    public WSIFMessage createFaultMessage() {
        Trc.entry(this);
        WSIFMessage wSIFMessage = this.createFaultMessage(null);
        Trc.exit(wSIFMessage);
        return wSIFMessage;
    }

    public WSIFMessage createFaultMessage(String string) {
        Trc.entry((Object)this, string);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        wSIFDefaultMessage.setName(string);
        Fault fault = this.getPortTypeOperation().getFault(string);
        if (fault != null) {
            wSIFDefaultMessage.setMessageDefinition(fault.getMessage());
        }
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    protected List getInputParts() {
        return this.inputParts;
    }

    protected void setInputParts(List list) throws WSIFException {
        this.inputParts = list;
    }

    protected void setInputPartOrder(List list) throws WSIFException {
        this.inputParts = this.setPartOrder(list, this.inputParts);
    }

    protected Part getReturnPart() {
        Part part = this.outputParts.size() > 0 ? (Part)this.outputParts.get(0) : null;
        return part;
    }

    protected void SetReturnPart(String string) throws WSIFException {
        Part part = this.getNamedPart(string, this.outputParts);
        if (part == null) {
            throw new WSIFException("part does not exist: " + string);
        }
        this.SetReturnPart(part);
    }

    protected void SetReturnPart(Part part) throws WSIFException {
        if (!this.outputParts.contains(part)) {
            throw new WSIFException("part does not exist: " + part);
        }
        this.outputParts.remove(part);
        this.outputParts.add(0, part);
    }

    protected List getOutputParts() {
        return this.outputParts;
    }

    protected void setOutputPartOrder(List list) throws WSIFException {
        this.outputParts = this.setPartOrder(list, this.outputParts);
    }

    protected List setPartOrder(List list, List arrayList) throws WSIFException {
        ArrayList<Part> arrayList2 = arrayList;
        if (list != null) {
            ArrayList<Part> arrayList3 = new ArrayList<Part>();
            for (String string : list) {
                Part part = this.getNamedPart(string, arrayList);
                if (part != null) {
                    arrayList3.add(part);
                    arrayList2.remove(part);
                    continue;
                }
                throw new WSIFException("part does not exists: " + string);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                arrayList3.add((Part)iterator.next());
            }
            arrayList = arrayList3;
        }
        return arrayList;
    }

    protected Part getNamedPart(String string, List list) {
        Part part = null;
        Iterator iterator = list.iterator();
        while (part == null && iterator.hasNext()) {
            Part part2 = (Part)iterator.next();
            if (!part2.getName().equals(string)) continue;
            part = part2;
        }
        return part;
    }

    protected Part getNamedPart(String string, Map map) {
        Part part = null;
        Iterator iterator = map.keySet().iterator();
        while (part == null && iterator.hasNext()) {
            Part part2 = (Part)iterator.next();
            if (!part2.getName().equals(string)) continue;
            part = part2;
        }
        return part;
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage wSIFMessage;
        Trc.entry(this);
        try {
            if (this.context == null) {
                this.context = (WSIFMessage)this.wsifPort.getContext().clone();
            }
            wSIFMessage = (WSIFMessage)this.context.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new WSIFException("CloneNotSupportedException cloning context", cloneNotSupportedException);
        }
        Trc.exit(wSIFMessage);
        return wSIFMessage;
    }

    public void setContext(WSIFMessage wSIFMessage) {
        Trc.entry((Object)this, wSIFMessage);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = wSIFMessage;
        Trc.exit();
    }

    protected void setInvocationContext() throws WSIFException {
        WSIFMessage wSIFMessage = this.getContext();
        if (this.context == null) {
            this.getContext();
        }
        InvocationHelper.setMessageContext(this.context);
    }

    protected void markAsUsed() throws WSIFException {
        if (this.used) {
            throw new WSIFException("WSIFOperations has already been executed");
        }
        this.used = true;
    }

    public String deep() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(":\n");
        stringBuffer.append("portTypeOperation:" + Trc.brief(this.portTypeOperation));
        stringBuffer.append(", bindingOperation:" + Trc.brief(this.bindingOperation));
        stringBuffer.append(", wsifPort:" + this.wsifPort);
        stringBuffer.append(", used:" + this.used);
        stringBuffer.append(", inputParts:" + this.inputParts);
        stringBuffer.append(", outputParts:" + this.outputParts);
        stringBuffer.append(", asyncResponseHandler:" + this.asyncResponseHandler);
        stringBuffer.append(", context:" + this.context);
        return stringBuffer.toString();
    }
}

