/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.ModelWSIFOperation;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.format.TypeMap;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;

public abstract class ModelWSIFPort
implements WSIFPort {
    protected Definition def;
    protected Service service;
    protected Port port;
    protected transient WSIFMessage context;
    protected WSIFDynamicTypeMap typeMap;
    protected ExtensibilityElement binding;
    protected boolean cacheOperations;
    protected transient HashMap cachedOperations;
    protected boolean autoTypeMappingSupported;
    protected boolean formatBindingSupported;
    protected HashMap formatBindingTypes;

    public ModelWSIFPort(Definition definition, Port port, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        this(definition, null, port, wSIFDynamicTypeMap, null);
    }

    public ModelWSIFPort(Definition definition, Service service, Port port, WSIFDynamicTypeMap wSIFDynamicTypeMap, ExtensibilityElement extensibilityElement) throws WSIFException {
        Trc.entry(this, definition, service, port, wSIFDynamicTypeMap, extensibilityElement);
        this.def = definition;
        this.service = service;
        this.port = port;
        this.binding = extensibilityElement;
        this.typeMap = wSIFDynamicTypeMap;
        this.autoTypeMappingSupported = true;
        this.cacheOperations = true;
        if (this.cacheOperations) {
            this.cachedOperations = new HashMap();
        }
        this.formatBindingSupported = false;
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation createOperation(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        WSIFOperation wSIFOperation = this.createOperation(string, null, null);
        Trc.exit(wSIFOperation);
        return wSIFOperation;
    }

    public WSIFOperation createOperation(String string, String string2, String string3) throws WSIFException {
        BindingOperation bindingOperation;
        Trc.entry(this, string, string2, string3);
        ModelWSIFOperation modelWSIFOperation = null;
        String string4 = null;
        if (this.cacheOperations) {
            string4 = new StringBuffer(string).append(":").append(string2).append(":").append(string3).toString();
            modelWSIFOperation = (ModelWSIFOperation)this.cachedOperations.get(string4);
        }
        if (modelWSIFOperation == null && (bindingOperation = WSIFUtils.getBindingOperation(this.port.getBinding(), string, string2, string3)) != null) {
            modelWSIFOperation = this.makeWSIFOperation(this, bindingOperation);
        }
        if (modelWSIFOperation == null) {
            throw new WSIFException("Could not create operation: " + string + ":" + string2 + ":" + string3);
        }
        if (this.cacheOperations) {
            this.cachedOperations.put(string4, modelWSIFOperation);
        }
        modelWSIFOperation.initialise();
        Trc.exit(modelWSIFOperation);
        return modelWSIFOperation;
    }

    protected boolean isAutoTypeMappingSupported() {
        return this.autoTypeMappingSupported;
    }

    protected void setAutoTypeMappingSupported(boolean bl) {
        this.autoTypeMappingSupported = bl;
    }

    public boolean isCacheOperations() {
        return this.cacheOperations;
    }

    protected void setCacheOperations(boolean bl) {
        this.cacheOperations = bl;
    }

    public ExtensibilityElement getBinding() {
        return this.binding;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public Port getPort() {
        return this.port;
    }

    public Service getService() {
        return this.service;
    }

    public WSIFDynamicTypeMap getTypeMap() {
        return this.typeMap;
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage wSIFMessage;
        Trc.entry(this);
        if (this.context == null) {
            this.context = new WSIFDefaultMessage();
        }
        try {
            wSIFMessage = (WSIFMessage)this.context.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new WSIFException("CloneNotSupportedException cloning context: ", cloneNotSupportedException);
        }
        Trc.exit(wSIFMessage);
        return wSIFMessage;
    }

    public void setContext(WSIFMessage wSIFMessage) {
        Trc.entry((Object)this, wSIFMessage);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = wSIFMessage;
        Trc.exit(null);
    }

    public boolean supportsSync() {
        Trc.entry(this);
        Trc.exit(true);
        return true;
    }

    public boolean supportsAsync() {
        Trc.entry(this);
        Trc.exit(false);
        return false;
    }

    public boolean isFormatBindingSupported() {
        return this.formatBindingSupported;
    }

    protected void setFormatBindingSupported(boolean bl) {
        this.formatBindingSupported = bl;
    }

    public void finalize() throws Throwable {
        Trc.entry(this);
        try {
            this.close();
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        super.finalize();
        Trc.exit();
    }

    protected Class getClassForPart(Part part) throws WSIFException {
        QName qName = ProviderUtils.getPartType(part);
        Class clazz = null;
        if (clazz == null && this.isFormatBindingSupported()) {
            clazz = this.getFormatBindingType(qName);
        }
        if (!this.isFormatBindingSupported() || this.isAutoTypeMappingSupported()) {
            clazz = this.getDynamicTypeClass(qName);
            if (clazz == null) {
                clazz = this.getStandardType(qName);
            }
            if (clazz == null) {
                // empty if block
            }
        }
        if (clazz == null) {
            clazz = this.doNoClassForPart(qName, part);
        }
        return clazz;
    }

    protected Class doNoClassForPart(QName qName, Part part) throws WSIFException {
        throw new WSIFException("cannot determine class for type: " + qName);
    }

    protected Class getDynamicTypeClass(QName qName) {
        Class clazz = null;
        Iterator iterator = this.typeMap.iterator();
        while (clazz == null && iterator.hasNext()) {
            WSIFDynamicTypeMapping wSIFDynamicTypeMapping = (WSIFDynamicTypeMapping)iterator.next();
            if (!qName.equals(wSIFDynamicTypeMapping.getXmlType())) continue;
            clazz = wSIFDynamicTypeMapping.javaType;
        }
        return clazz;
    }

    protected Class getFormatBindingType(QName qName) throws WSIFException {
        Class clazz = null;
        if (this.formatBindingTypes == null && this.isFormatBindingSupported()) {
            this.initializeFormatBindingTypes();
        }
        if (this.formatBindingTypes != null) {
            Iterator iterator = this.formatBindingTypes.keySet().iterator();
            while (clazz == null && iterator.hasNext()) {
                QName qName2 = (QName)iterator.next();
                if (!qName2.equals(qName)) continue;
                clazz = (Class)this.formatBindingTypes.get(qName);
            }
        }
        return clazz;
    }

    protected Class getStandardType(QName qName) throws WSIFException {
        Class clazz = null;
        Map map = WSIFUtils.getSimpleTypesMap();
        String string = (String)map.get(qName);
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            clazz = string.indexOf(46) < 0 && Character.isLowerCase(c) ? this.getPrimitiveClass(string) : ('[' == c ? this.getArrayClass(string) : this.getClassForType(string));
        }
        return clazz;
    }

    protected Class getPrimitiveClass(String string) {
        Class clazz = null;
        if (string.equals("int")) {
            clazz = Integer.class;
        } else if (string.equals("float")) {
            clazz = Float.class;
        } else if (string.equals("double")) {
            clazz = Double.class;
        } else if (string.equals("boolean")) {
            clazz = Boolean.class;
        } else if (string.equals("long")) {
            clazz = Long.class;
        } else if (string.equals("short")) {
            clazz = Short.class;
        } else if (string.equals("byte")) {
            clazz = Byte.class;
        } else if (string.equals("void")) {
            clazz = Void.class;
        }
        return clazz;
    }

    protected Class getArrayClass(String string) {
        Class clazz = null;
        return clazz;
    }

    protected Class getClassForType(String string) throws WSIFException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(string, true, classLoader);
        }
        catch (Throwable throwable) {
            throw new WSIFException("exception getting class for simple type '" + clazz + "': " + throwable);
        }
        return clazz;
    }

    protected void initializeFormatBindingTypes() throws WSIFException {
        Trc.entry(this);
        TypeMapping typeMapping = this.getFormatTypeMapping();
        if (typeMapping == null) {
            this.doMissingFormatTypeMapping();
        }
        this.formatBindingTypes = new HashMap();
        if (typeMapping != null) {
            List list = typeMapping.getMaps();
            for (TypeMap typeMap : list) {
                QName qName = typeMap.getTypeName();
                if (qName == null) {
                    qName = typeMap.getElementName();
                }
                String string = typeMap.getFormatType();
                Class clazz = this.getNamedClass(string);
                if (qName != null && clazz != null) {
                    this.formatBindingTypes.put(qName, clazz);
                    continue;
                }
                throw new WSIFException("Error in binding TypeMap. Key or Value is null");
            }
        }
        Trc.exit();
    }

    protected TypeMapping getFormatTypeMapping() {
        TypeMapping typeMapping = null;
        for (Object e : this.port.getBinding().getExtensibilityElements()) {
            if (!(e instanceof TypeMapping)) continue;
            typeMapping = (TypeMapping)e;
            if ("Java".equals(typeMapping.getEncoding()) && "Java".equals(typeMapping.getStyle())) break;
            typeMapping = null;
        }
        return typeMapping;
    }

    protected void doMissingFormatTypeMapping() throws WSIFException {
    }

    protected Class getNamedClass(String string) throws WSIFException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(string, true, classLoader);
        }
        catch (Throwable throwable) {
            Trc.exception(throwable);
            this.doUnknownClassName(string);
        }
        return clazz;
    }

    protected void doUnknownClassName(String string) throws WSIFException {
        throw new WSIFException("can not find Java class for formatType: " + string);
    }

    protected void doInitialize() throws WSIFException {
    }

    protected abstract ModelWSIFOperation makeWSIFOperation(ModelWSIFPort var1, BindingOperation var2) throws WSIFException;

    protected abstract Class getImplementedAddressClass();

    protected abstract void validateAddress(ExtensibilityElement var1) throws WSIFException;

    public abstract void close() throws WSIFException;

    public String deep() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + ":\n");
        stringBuffer.append("definition:");
        stringBuffer.append(Trc.brief(this.def));
        stringBuffer.append(" service:");
        stringBuffer.append(Trc.brief(this.service));
        stringBuffer.append(" portModel:");
        stringBuffer.append(Trc.brief(this.port));
        stringBuffer.append(" context:");
        stringBuffer.append(this.context);
        stringBuffer.append(" typeMap:");
        stringBuffer.append(this.typeMap);
        stringBuffer.append(" binding:");
        stringBuffer.append(this.binding);
        stringBuffer.append(" autoTypeMappingSupported:");
        stringBuffer.append(this.autoTypeMappingSupported);
        stringBuffer.append(" cacheOperations:");
        stringBuffer.append(this.cacheOperations);
        stringBuffer.append(" cachedOperations:");
        stringBuffer.append(this.cachedOperations);
        stringBuffer.append(" formatBindingSupported:");
        stringBuffer.append(this.formatBindingSupported);
        stringBuffer.append(" formatBindingTypes:");
        stringBuffer.append(this.formatBindingTypes);
        return stringBuffer.toString();
    }
}

