/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.ModelWSIFPort;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.tools.wsdl.BindingGenerator;

public abstract class ModelWSIFProvider
implements WSIFProvider {
    protected String[] supportedBindings;
    protected String[] supportedAddresses;

    protected ModelWSIFProvider() throws WSIFException {
        Trc.entry(this);
        if (this.isActive()) {
            this.enableProvider();
        } else {
            this.disableProvider();
        }
        Trc.exit();
    }

    public String[] getBindingNamespaceURIs() {
        Trc.entry(this);
        String[] stringArray = this.supportedBindings;
        Trc.exit(stringArray);
        return stringArray;
    }

    public String[] getAddressNamespaceURIs() {
        Trc.entry(this);
        String[] stringArray = this.supportedAddresses;
        Trc.exit(stringArray);
        return stringArray;
    }

    public WSIFPort createDynamicWSIFPort(Definition definition, Service service, Port port, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        Trc.entry(this, definition, service, port, wSIFDynamicTypeMap);
        Class clazz = this.getImplementedBindingClass();
        if (!ExtensibilityElement.class.isAssignableFrom(clazz)) {
            throw new WSIFException("getImplementedBindingClass must return a subclass of ExtensibilityElement");
        }
        ModelWSIFPort modelWSIFPort = null;
        Binding binding = port.getBinding();
        List list = binding.getExtensibilityElements();
        Iterator iterator = list.iterator();
        while (modelWSIFPort == null && iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)e;
            modelWSIFPort = this.makeWSIFPort(definition, service, port, wSIFDynamicTypeMap, extensibilityElement);
        }
        if (modelWSIFPort != null) {
            this.initializeWSIFPort(port, modelWSIFPort);
        }
        Trc.exit(modelWSIFPort);
        return modelWSIFPort;
    }

    protected void initializeWSIFPort(Port port, ModelWSIFPort modelWSIFPort) throws WSIFException {
        Class clazz = modelWSIFPort.getImplementedAddressClass();
        ExtensibilityElement extensibilityElement = null;
        List list = port.getExtensibilityElements();
        Iterator iterator = list.iterator();
        while (extensibilityElement == null && iterator.hasNext()) {
            ExtensibilityElement extensibilityElement2 = (ExtensibilityElement)iterator.next();
            if (!clazz.isAssignableFrom(extensibilityElement2.getClass())) continue;
            extensibilityElement = extensibilityElement2;
        }
        if (extensibilityElement == null) {
            throw new WSIFException("port '" + port + "' missing address ExtensibilityElement: " + clazz.getName());
        }
        modelWSIFPort.validateAddress(extensibilityElement);
        modelWSIFPort.doInitialize();
    }

    protected ModelWSIFPort makeWSIFPort(Definition definition, Service service, Port port, WSIFDynamicTypeMap wSIFDynamicTypeMap, ExtensibilityElement extensibilityElement) throws WSIFException {
        return this.makeWSIFPort(definition, port, wSIFDynamicTypeMap);
    }

    protected boolean isActive() {
        String[] stringArray = this.getRequiredClasses();
        return ModelWSIFProvider.isRequiredClassesAvailable(stringArray);
    }

    protected void enableProvider() throws WSIFException {
        ExtensionRegistry[] extensionRegistryArray = this.getExtensionRegistries();
        for (int i = 0; i < extensionRegistryArray.length; ++i) {
            WSIFServiceImpl.addExtensionRegistry(extensionRegistryArray[i]);
        }
        this.supportedBindings = this.getSupportedBindingNamespaces();
        this.supportedAddresses = this.getSupportedAddressNamespaces();
        Trc.event(null, "provider " + this.getProviderName() + " enabled");
    }

    protected void disableProvider() {
        String[] stringArray = new String[]{};
        this.supportedBindings = stringArray;
        this.supportedAddresses = stringArray;
        Trc.event(null, "provider " + this.getProviderName() + " disabled");
    }

    protected String[] getSupportedBindingNamespaces() throws WSIFException {
        ExtensibilityElement extensibilityElement;
        try {
            extensibilityElement = (ExtensibilityElement)this.getImplementedBindingClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new WSIFException("InstantiationException creating binding: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WSIFException("IllegalAccessException creating binding: " + illegalAccessException);
        }
        return new String[]{extensibilityElement.getElementType().getNamespaceURI()};
    }

    protected String[] getSupportedAddressNamespaces() throws WSIFException {
        return this.getSupportedBindingNamespaces();
    }

    protected static boolean isRequiredClassesAvailable(String[] stringArray) {
        boolean bl = true;
        if (stringArray != null) {
            for (int i = 0; bl && i < stringArray.length; ++i) {
                final String string = stringArray[i];
                Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                        }
                        catch (Throwable throwable) {
                            Trc.ignoredException(throwable);
                            return null;
                        }
                    }
                });
                if (clazz != null) continue;
                bl = false;
            }
        }
        Trc.event(null, "required classes available=" + bl);
        return bl;
    }

    protected abstract String getProviderName();

    protected abstract String[] getRequiredClasses();

    protected abstract ExtensionRegistry[] getExtensionRegistries();

    protected abstract Class getImplementedBindingClass();

    public abstract BindingGenerator[] getBindingGenerators();

    protected abstract ModelWSIFPort makeWSIFPort(Definition var1, Port var2, WSIFDynamicTypeMap var3) throws WSIFException;
}

