/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.util.WSIFUtils;

public class WSIFDynamicTypeMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Vector typeMapList = new Vector();
    protected Vector xmlTypes = new Vector();
    protected ArrayList allTypes;

    public WSIFDynamicTypeMap() {
        Trc.entry(this);
        this.allTypes = new ArrayList();
        Trc.exit();
    }

    public WSIFDynamicTypeMap(ArrayList arrayList) {
        Trc.entry((Object)this, arrayList);
        this.allTypes = arrayList;
        Trc.exit();
    }

    public void mapType(QName qName, Class clazz) {
        Trc.entry(this, qName, clazz);
        this.mapType(qName, clazz, true);
        Trc.exit();
    }

    public void mapType(QName qName, Class clazz, boolean bl) {
        Trc.entry(this, qName, clazz);
        int n = this.xmlTypes.indexOf(qName);
        if (n < 0) {
            this.typeMapList.add(new WSIFDynamicTypeMapping(qName, clazz));
            this.xmlTypes.add(qName);
        } else if (bl) {
            this.typeMapList.setElementAt(new WSIFDynamicTypeMapping(qName, clazz), n);
        }
        Trc.exit();
    }

    public void mapPackage(String string, String string2) {
        Trc.entry(this, string, string2);
        for (QName qName : this.allTypes) {
            String string3 = qName.getNamespaceURI();
            if (string3 == null || !string3.equals(string)) continue;
            this.resolveMapping(qName, string2);
        }
        Trc.exit();
    }

    protected void resolveMapping(QName qName, String string) {
        Trc.entry(this, qName, string);
        try {
            String string2 = qName.getLocalPart();
            if (string2 != null) {
                String string3 = WSIFUtils.getJavaClassNameFromXMLName(string2);
                String string4 = string + "." + string3;
                Class<?> clazz = Class.forName(string4, true, Thread.currentThread().getContextClassLoader());
                this.mapType(qName, clazz);
            }
        }
        catch (Exception exception) {
            Trc.ignoredException(exception);
        }
        Trc.exit();
    }

    public void setAllTypes(ArrayList arrayList) {
        Trc.entry((Object)this, arrayList);
        this.allTypes = arrayList;
        Trc.exit();
    }

    public Iterator iterator() {
        Trc.entry(this);
        Trc.exit();
        return this.typeMapList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSIFDynamicTypeMap copy() {
        Vector vector = this.typeMapList;
        synchronized (vector) {
            WSIFDynamicTypeMap wSIFDynamicTypeMap = new WSIFDynamicTypeMap();
            ArrayList arrayList = this.allTypes;
            synchronized (arrayList) {
                wSIFDynamicTypeMap.setAllTypes((ArrayList)this.allTypes.clone());
            }
            for (WSIFDynamicTypeMapping wSIFDynamicTypeMapping : this.typeMapList) {
                wSIFDynamicTypeMap.mapType(wSIFDynamicTypeMapping.getXmlType(), wSIFDynamicTypeMapping.getJavaType());
            }
            return wSIFDynamicTypeMap;
        }
    }
}

