/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;

public class WSIFDynamicTypeMapping
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected QName xmlType;
    protected Class javaType;

    public WSIFDynamicTypeMapping() {
        this.xmlType = null;
        this.javaType = null;
    }

    public WSIFDynamicTypeMapping(QName qName, Class clazz) {
        Trc.entry(this, qName, clazz);
        this.xmlType = qName;
        this.javaType = clazz;
        Trc.exit();
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public String toString() {
        return "QName:" + this.xmlType + " Class:" + this.javaType;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.xmlType);
        if (this.javaType.isPrimitive()) {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(this.javaType.getName());
        } else {
            objectOutput.writeBoolean(false);
            objectOutput.writeObject(this.javaType);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.xmlType = (QName)objectInput.readObject();
        boolean bl = objectInput.readBoolean();
        if (bl) {
            String string = (String)objectInput.readObject();
            if (string.equals("int")) {
                this.javaType = Integer.TYPE;
            } else if (string.equals("float")) {
                this.javaType = Float.TYPE;
            } else if (string.equals("double")) {
                this.javaType = Double.TYPE;
            } else if (string.equals("boolean")) {
                this.javaType = Boolean.TYPE;
            } else if (string.equals("long")) {
                this.javaType = Long.TYPE;
            } else if (string.equals("short")) {
                this.javaType = Short.TYPE;
            } else if (string.equals("byte")) {
                this.javaType = Byte.TYPE;
            } else if (string.equals("void")) {
                this.javaType = Void.TYPE;
            }
        } else {
            this.javaType = (Class)objectInput.readObject();
        }
    }
}

