/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.base.WSIFDefaultPort;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.java.WSIFOperation_Java;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.format.TypeMap;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;
import org.apache.wsif.wsdl.extensions.java.JavaAddress;

public class WSIFPort_Java
extends WSIFDefaultPort
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Definition fieldDefinition;
    private Port fieldPortModel;
    private transient Class serviceObjectClass;
    private transient Method[] serviceObjectMethods;
    private transient Constructor[] serviceObjectConstructors;
    private transient Object fieldObjectReference;
    private final boolean separatedObjectRef;
    private Map fieldTypeMaps;
    protected transient Map operationInstances;

    public WSIFPort_Java(Definition definition, Port port, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        Trc.entry(this, definition, port, wSIFDynamicTypeMap);
        this.separatedObjectRef = true;
        this.fieldDefinition = definition;
        this.fieldPortModel = port;
        this.operationInstances = new HashMap();
        this.buildTypeMap();
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation createOperation(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        WSIFOperation wSIFOperation = this.createOperation(string, null, null);
        Trc.exit(wSIFOperation);
        return wSIFOperation;
    }

    public WSIFOperation createOperation(String string, String string2, String string3) throws WSIFException {
        Trc.entry(this, string, string2, string3);
        WSIFOperation_Java wSIFOperation_Java = this.getDynamicWSIFOperation(string, string2, string3);
        if (wSIFOperation_Java == null) {
            throw new WSIFException("Could not create operation: " + string + ":" + string2 + ":" + string3);
        }
        WSIFOperation_Java wSIFOperation_Java2 = wSIFOperation_Java.copy();
        Trc.exit(wSIFOperation_Java2);
        return wSIFOperation_Java2;
    }

    protected WSIFOperation_Java getDynamicWSIFOperation(String string, String string2, String string3) throws WSIFException {
        BindingOperation bindingOperation;
        Trc.entry(this, string, string2, string3);
        WSIFOperation_Java wSIFOperation_Java = (WSIFOperation_Java)this.operationInstances.get(this.getKey(string, string2, string3));
        if (wSIFOperation_Java == null && (bindingOperation = WSIFUtils.getBindingOperation(this.fieldPortModel.getBinding(), string, string2, string3)) != null) {
            wSIFOperation_Java = new WSIFOperation_Java(this.fieldPortModel, bindingOperation, this, this.fieldTypeMaps);
            this.setDynamicWSIFOperation(string, string2, string3, wSIFOperation_Java);
        }
        Trc.exit(wSIFOperation_Java);
        return wSIFOperation_Java;
    }

    protected void setDynamicWSIFOperation(String string, String string2, String string3, WSIFOperation_Java wSIFOperation_Java) {
        Trc.entry(this, string, string2, string3, wSIFOperation_Java);
        this.operationInstances.put(this.getKey(string, string2, string3), wSIFOperation_Java);
        Trc.exit();
    }

    Class getServiceObjectClass() throws WSIFException {
        Trc.entry(this);
        if (this.serviceObjectClass == null) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)this.fieldPortModel.getExtensibilityElements().get(0);
            if (extensibilityElement == null) {
                throw new WSIFException("missing port extension");
            }
            JavaAddress javaAddress = (JavaAddress)extensibilityElement;
            try {
                this.serviceObjectClass = Class.forName(javaAddress.getClassName(), true, Thread.currentThread().getContextClassLoader());
            }
            catch (Throwable throwable) {
                Trc.exception(throwable);
                throw new WSIFException("Exception getting target object class '" + javaAddress.getClassName() + "'", throwable);
            }
        }
        Trc.exit(this.serviceObjectClass);
        return this.serviceObjectClass;
    }

    Constructor[] getServiceObjectConstructors() throws WSIFException {
        Trc.entry(this);
        if (this.serviceObjectConstructors == null) {
            Class clazz = this.getServiceObjectClass();
            this.serviceObjectConstructors = clazz.getConstructors();
        }
        Trc.exit(this.serviceObjectConstructors);
        return this.serviceObjectConstructors;
    }

    Method[] getServiceObjectMethods() throws WSIFException {
        Trc.entry(this);
        if (this.serviceObjectMethods == null) {
            Class clazz = this.getServiceObjectClass();
            this.serviceObjectMethods = clazz.getMethods();
        }
        Trc.exit(this.serviceObjectMethods);
        return this.serviceObjectMethods;
    }

    public Object getObjectReference() throws WSIFException {
        Trc.entry(this);
        if (this.fieldObjectReference == null) {
            Class clazz = this.getServiceObjectClass();
            try {
                this.fieldObjectReference = clazz.newInstance();
            }
            catch (Exception exception) {
                Trc.exception(exception);
                throw new WSIFException("Could not instantiate target object of class '" + clazz.getName() + "'", exception);
            }
        }
        Trc.exit(this.fieldObjectReference);
        return this.fieldObjectReference;
    }

    void setObjectReference(Object object) {
        Trc.entry((Object)this, object);
        this.fieldObjectReference = object;
        Trc.exit();
    }

    private void buildTypeMap() throws WSIFException {
        Trc.entry(this);
        TypeMapping typeMapping = null;
        for (Object object : this.fieldPortModel.getBinding().getExtensibilityElements()) {
            if (!(object instanceof TypeMapping)) continue;
            typeMapping = (TypeMapping)object;
            if ("Java".equals(typeMapping.getEncoding()) && "Java".equals(typeMapping.getStyle())) break;
            typeMapping = null;
        }
        if (typeMapping == null) {
            Object object;
            object = this.fieldPortModel.getBinding().getQName();
            throw new WSIFException("Binding " + (object == null ? "<null>" : ((QName)object).toString()) + " does not contain a typeMap with encoding=Java and style=Java");
        }
        this.fieldTypeMaps = new HashMap();
        for (Object object : typeMapping.getMaps()) {
            QName qName = ((TypeMap)object).getTypeName();
            if (qName == null) {
                qName = ((TypeMap)object).getElementName();
            }
            String string = ((TypeMap)object).getFormatType();
            if (qName != null && string != null) {
                if (this.fieldTypeMaps.containsKey(qName)) {
                    Vector<Object> vector = null;
                    Object v = this.fieldTypeMaps.get(qName);
                    if (v instanceof Vector) {
                        vector = (Vector<Object>)v;
                    } else {
                        vector = new Vector<Object>();
                        vector.addElement(v);
                    }
                    vector.addElement(string);
                    this.fieldTypeMaps.put(qName, vector);
                    continue;
                }
                this.fieldTypeMaps.put(qName, string);
                continue;
            }
            throw new WSIFException("Error in binding TypeMap. Key or Value is null");
        }
        Trc.exit();
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.fieldDefinition);
        return this.fieldDefinition;
    }

    public Port getPortModel() {
        Trc.entry(this);
        Trc.exit(this.fieldPortModel);
        return this.fieldPortModel;
    }

    public String deep() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(":\n");
        stringBuffer.append("definition:");
        if (this.fieldDefinition == null) {
            stringBuffer.append("null");
        } else if (this.fieldDefinition.getQName() == null) {
            stringBuffer.append("unknown");
        } else {
            stringBuffer.append(this.fieldDefinition.getQName().toString());
        }
        stringBuffer.append(" portModel:");
        if (this.fieldPortModel == null) {
            stringBuffer.append("null");
        } else if (this.fieldPortModel.getName() == null) {
            stringBuffer.append("unknown");
        } else {
            stringBuffer.append(this.fieldPortModel.getName().toString());
        }
        stringBuffer.append(" serviceObjectReference:").append(this.fieldObjectReference);
        stringBuffer.append(" serviceObjectClass: ").append(this.serviceObjectClass);
        stringBuffer.append(" serviceObjectConstructors: ");
        if (this.serviceObjectConstructors == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.serviceObjectConstructors);
            stringBuffer.append(" size:").append(this.serviceObjectConstructors.length);
        }
        stringBuffer.append(" serviceObjectMethods: ");
        if (this.serviceObjectMethods == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.serviceObjectMethods);
            stringBuffer.append(" size:").append(this.serviceObjectMethods.length);
        }
        stringBuffer.append(" formatTypeMaps: ");
        if (this.fieldTypeMaps == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(" size:").append(this.fieldTypeMaps.size());
            n = 0;
            for (Object object2 : this.fieldTypeMaps.keySet()) {
                object = this.fieldTypeMaps.get(object2);
                stringBuffer.append("\nformatTypeMaps[").append(n++).append("]:");
                stringBuffer.append(object2).append(", ").append(object);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(" operationInstances:");
        if (this.operationInstances == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(" size:").append(this.operationInstances.size());
            n = 0;
            for (Object object2 : this.operationInstances.keySet()) {
                object = (WSIFOperation_Java)this.operationInstances.get(object2);
                stringBuffer.append("\noperationInstances[").append(n++).append("]:");
                stringBuffer.append((String)object2).append(" ").append(object).append(" ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.fieldObjectReference != null && !(this.fieldObjectReference instanceof Serializable)) {
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeObject(this.fieldObjectReference);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.separatedObjectRef) {
            Object object;
            this.fieldObjectReference = object = objectInputStream.readObject();
        }
        this.operationInstances = new HashMap();
    }
}

