/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFRequest;
import org.apache.wsif.WSIFResponse;
import org.apache.wsif.format.WSIFFormatter;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.jms.JMSMessage;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.jms.JMSFault;
import org.apache.wsif.wsdl.extensions.jms.JMSFaultIndicator;
import org.apache.wsif.wsdl.extensions.jms.JMSFaultProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSInput;
import org.apache.wsif.wsdl.extensions.jms.JMSOutput;

public class JMSFormatter
implements WSIFFormatter,
Serializable {
    private static final long serialVersionUID = 1L;
    private Definition fieldDefinition;
    private Port fieldPort;
    private String reqOpName;
    private String reqInputName;
    private String reqOutputName;
    private BindingFault lastBindingFault = null;

    public JMSFormatter(Definition definition, Port port) {
        Trc.entry(this, definition, port);
        this.fieldDefinition = definition;
        this.fieldPort = port;
        Trc.exit();
    }

    public void formatRequest(WSIFRequest wSIFRequest, OutputStream outputStream) {
        Trc.entry((Object)this, wSIFRequest);
        Trc.exit();
    }

    public WSIFRequest unformatRequest(InputStream inputStream) {
        Trc.entry(this);
        Trc.exit();
        return null;
    }

    public void formatResponse(WSIFResponse wSIFResponse, OutputStream outputStream) {
        Trc.entry((Object)this, wSIFResponse);
        Trc.exit();
    }

    public WSIFResponse unformatResponse(InputStream inputStream) {
        Trc.entry(this);
        Trc.exit();
        return null;
    }

    public void formatRequest(WSIFRequest wSIFRequest, javax.jms.Message message) throws WSIFException {
        Trc.entry(this, wSIFRequest, message);
        Binding binding = this.fieldPort.getBinding();
        BindingOperation bindingOperation = binding.getBindingOperation(wSIFRequest.getOperationName(), wSIFRequest.getInputName(), wSIFRequest.getOutputName());
        Message message2 = bindingOperation.getOperation().getInput().getMessage();
        JMSMessage jMSMessage = new JMSMessage(this.fieldDefinition, binding, message2, this.getInputParts(bindingOperation));
        this.copyTo(wSIFRequest.getIncomingMessage(), jMSMessage);
        jMSMessage.write(message);
        this.setOperationName(wSIFRequest.getOperationName());
        this.setInputName(wSIFRequest.getInputName());
        this.setOutputName(wSIFRequest.getOutputName());
        Trc.exit();
    }

    public WSIFRequest unformatRequest(javax.jms.Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        WSIFRequest wSIFRequest = this.createRequest(message);
        Binding binding = this.fieldPort.getBinding();
        BindingOperation bindingOperation = binding.getBindingOperation(wSIFRequest.getOperationName(), wSIFRequest.getInputName(), wSIFRequest.getOutputName());
        Message message2 = bindingOperation.getOperation().getInput().getMessage();
        JMSMessage jMSMessage = new JMSMessage(this.fieldDefinition, binding, message2, this.getInputParts(bindingOperation));
        jMSMessage.read(message);
        wSIFRequest.setIncomingMessage(jMSMessage);
        Trc.exit(wSIFRequest);
        return wSIFRequest;
    }

    protected WSIFRequest createRequest(javax.jms.Message message) throws WSIFException {
        Port port;
        Object object;
        PortType portType;
        Trc.entry((Object)this, message);
        QName qName = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Binding binding = this.fieldPort.getBinding();
        if (binding == null) {
            throw new WSIFException("Unable to locate Binding");
        }
        Map map = WSIFUtils.getAllItems(this.fieldDefinition, "Service");
        Iterator iterator = map.values().iterator();
        block2: while (iterator.hasNext() && qName == null) {
            portType = (Service)iterator.next();
            object = portType.getPorts().values().iterator();
            while (object.hasNext()) {
                port = (Port)object.next();
                if (port.getBinding() == null || !port.getBinding().getQName().equals(binding.getQName())) continue;
                qName = portType.getQName();
                continue block2;
            }
        }
        if (qName == null) {
            throw new WSIFException("Unable to locate Service");
        }
        portType = binding.getPortType();
        if (portType != null && (object = portType.getOperations()) != null && object.size() == 1) {
            port = (Operation)object.get(0);
            string = port.getName();
            if (port.getInput() != null) {
                string2 = port.getInput().getName();
            }
            if (port.getOutput() != null) {
                string3 = port.getOutput().getName();
            }
        }
        if (string == null) {
            try {
                string = message.getStringProperty("WSDLOperation");
                string2 = message.getStringProperty("WSDLInput");
                string3 = message.getStringProperty("WSDLOutput");
            }
            catch (JMSException jMSException) {
                Trc.exception(jMSException);
            }
        }
        if (string == null) {
            throw new WSIFException("Unable to determine Operation");
        }
        object = new WSIFRequest(qName);
        ((WSIFRequest)object).setPortName(this.fieldPort.getName());
        ((WSIFRequest)object).setOperationName(string);
        ((WSIFRequest)object).setInputName(string2);
        ((WSIFRequest)object).setOutputName(string3);
        Trc.exit(object);
        return object;
    }

    protected WSIFResponse createResponse(javax.jms.Message message) throws WSIFException {
        Port port;
        Object object;
        Object object2;
        Trc.entry((Object)this, message);
        QName qName = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Binding binding = this.fieldPort.getBinding();
        if (binding == null) {
            throw new WSIFException("Unable to locate Binding");
        }
        Map map = WSIFUtils.getAllItems(this.fieldDefinition, "Service");
        Iterator iterator = map.values().iterator();
        block0: while (iterator.hasNext() && qName == null) {
            object2 = (Service)iterator.next();
            object = object2.getPorts().values().iterator();
            while (object.hasNext()) {
                port = (Port)object.next();
                if (port.getBinding() == null || !port.getBinding().getQName().equals(binding.getQName())) continue;
                qName = object2.getQName();
                continue block0;
            }
        }
        if (qName == null) {
            throw new WSIFException("Unable to locate Service");
        }
        string = this.getOperationName();
        string2 = this.getInputName();
        string3 = this.getOutputName();
        if ((string == null || string.equals("")) && (object2 = binding.getPortType()) != null && (object = object2.getOperations()) != null) {
            if (object.size() == 1) {
                port = (Operation)object.get(0);
                string = port.getName();
                if (port.getInput() != null) {
                    string2 = port.getInput().getName();
                }
                if (port.getOutput() != null) {
                    string3 = port.getOutput().getName();
                }
            } else {
                throw new WSIFException("Port Type definition contains multiple operations.");
            }
        }
        if (string == null) {
            throw new WSIFException("Unable to locate Operation");
        }
        object2 = new WSIFResponse(qName);
        ((WSIFResponse)object2).setPortName(this.fieldPort.getName());
        ((WSIFResponse)object2).setOperationName(string);
        ((WSIFResponse)object2).setInputName(string2);
        ((WSIFResponse)object2).setOutputName(string3);
        Trc.exit(object2);
        return object2;
    }

    public void formatResponse(WSIFResponse wSIFResponse, javax.jms.Message message) throws WSIFException {
        Trc.entry(this, wSIFResponse, message);
        Binding binding = this.fieldPort.getBinding();
        BindingOperation bindingOperation = binding.getBindingOperation(wSIFResponse.getOperationName(), wSIFResponse.getInputName(), wSIFResponse.getOutputName());
        Message message2 = bindingOperation.getOperation().getOutput().getMessage();
        JMSMessage jMSMessage = new JMSMessage(this.fieldDefinition, binding, message2, this.getOutputParts(bindingOperation));
        this.copyTo(wSIFResponse.getOutgoingMessage(), jMSMessage);
        jMSMessage.write(message);
        this.setOperationName(wSIFResponse.getOperationName());
        this.setInputName(wSIFResponse.getInputName());
        this.setOutputName(wSIFResponse.getOutputName());
        Trc.exit();
    }

    public WSIFResponse unformatResponse(javax.jms.Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        WSIFResponse wSIFResponse = this.createResponse(message);
        Binding binding = this.fieldPort.getBinding();
        BindingOperation bindingOperation = binding.getBindingOperation(wSIFResponse.getOperationName(), wSIFResponse.getInputName(), wSIFResponse.getOutputName());
        if (this.unformatResponseFault(wSIFResponse, message, binding, bindingOperation)) {
            Trc.exit(wSIFResponse);
            return wSIFResponse;
        }
        Operation operation = bindingOperation.getOperation();
        Output output = operation.getOutput();
        if (output != null) {
            Message message2 = output.getMessage();
            JMSMessage jMSMessage = new JMSMessage(this.fieldDefinition, binding, message2, this.getOutputParts(bindingOperation));
            jMSMessage.read(message);
            wSIFResponse.setOutgoingMessage(jMSMessage);
        }
        Trc.exit(wSIFResponse);
        return wSIFResponse;
    }

    private boolean unformatResponseFault(WSIFResponse wSIFResponse, javax.jms.Message message, Binding binding, BindingOperation bindingOperation) throws WSIFException {
        Trc.entry(this, wSIFResponse, message, binding, bindingOperation);
        Map map = bindingOperation.getBindingFaults();
        if (map != null && !map.isEmpty()) {
            for (String string : map.keySet()) {
                BindingFault bindingFault = (BindingFault)map.get(string);
                List list = bindingFault.getExtensibilityElements();
                if (list == null || list.isEmpty()) continue;
                for (Object e : list) {
                    JMSFaultIndicator jMSFaultIndicator;
                    if (!(e instanceof JMSFaultIndicator) || !this.matchesFaultIndicator(jMSFaultIndicator = (JMSFaultIndicator)e, message)) continue;
                    WSIFMessage wSIFMessage = this.unformatFaultMessage(message, binding, bindingOperation, string, bindingFault);
                    wSIFResponse.setOutgoingMessage(wSIFMessage);
                    wSIFResponse.setIsFault(true);
                    this.lastBindingFault = bindingFault;
                    Trc.exit(true);
                    return true;
                }
            }
        }
        Trc.exit(false);
        return false;
    }

    private boolean matchesFaultIndicator(JMSFaultIndicator jMSFaultIndicator, javax.jms.Message message) {
        Trc.entry(this, jMSFaultIndicator, message);
        String string = jMSFaultIndicator.getType();
        if (string == null || !"property".equals(string)) {
            Trc.exit(false);
            return false;
        }
        List list = jMSFaultIndicator.getJMSFaultProperties();
        if (list == null || list.isEmpty()) {
            Trc.exit(false);
            return false;
        }
        for (JMSFaultProperty jMSFaultProperty : list) {
            String string2 = jMSFaultProperty.getName();
            if (string2 == null || jMSFaultProperty.getType() == null || jMSFaultProperty.getValue() == null) continue;
            Object object = null;
            try {
                if (!message.propertyExists(string2)) continue;
                object = message.getObjectProperty(string2);
            }
            catch (JMSException jMSException) {
                Trc.ignoredException(jMSException);
                continue;
            }
            if (object == null || !jMSFaultProperty.getValue().equals(object.toString())) continue;
            Trc.exit(true);
            return true;
        }
        Trc.exit(false);
        return false;
    }

    private WSIFMessage unformatFaultMessage(javax.jms.Message message, Binding binding, BindingOperation bindingOperation, String string, BindingFault bindingFault) throws WSIFException {
        Trc.entry(this, message, binding, bindingOperation, string, bindingFault);
        Operation operation = bindingOperation.getOperation();
        Fault fault = operation.getFault(string);
        if (fault == null) {
            throw new WSIFException("No fault " + string + " found in operation " + operation.getName());
        }
        JMSMessage jMSMessage = new JMSMessage(this.fieldDefinition, binding, fault.getMessage(), this.getFaultParts(bindingFault));
        jMSMessage.read(message);
        Trc.exit(jMSMessage);
        return jMSMessage;
    }

    void copyTo(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        if (wSIFMessage == null || wSIFMessage2 == null) {
            return;
        }
        Iterator iterator = wSIFMessage.getPartNames();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            wSIFMessage2.setObjectPart(string, wSIFMessage.getObjectPart(string));
        }
    }

    private List getInputParts(BindingOperation bindingOperation) {
        if (bindingOperation.getBindingInput() != null) {
            for (ExtensibilityElement extensibilityElement : bindingOperation.getBindingInput().getExtensibilityElements()) {
                if (!(extensibilityElement instanceof JMSInput)) continue;
                return ((JMSInput)extensibilityElement).getParts();
            }
        }
        return null;
    }

    private List getOutputParts(BindingOperation bindingOperation) {
        if (bindingOperation.getBindingOutput() != null) {
            for (ExtensibilityElement extensibilityElement : bindingOperation.getBindingOutput().getExtensibilityElements()) {
                if (!(extensibilityElement instanceof JMSOutput)) continue;
                return ((JMSOutput)extensibilityElement).getParts();
            }
        }
        return null;
    }

    private List getFaultParts(BindingFault bindingFault) {
        Trc.entry((Object)this, bindingFault);
        List list = null;
        if (bindingFault != null) {
            for (Object e : bindingFault.getExtensibilityElements()) {
                if (!(e instanceof JMSFault)) continue;
                list = ((JMSFault)e).getParts();
                break;
            }
        }
        Trc.exit(list);
        return list;
    }

    public String getOperationName() {
        return this.reqOpName;
    }

    private void setOperationName(String string) {
        this.reqOpName = string;
    }

    public String getInputName() {
        return this.reqInputName;
    }

    private void setInputName(String string) {
        this.reqInputName = string;
    }

    public String getOutputName() {
        return this.reqOutputName;
    }

    private void setOutputName(String string) {
        this.reqOutputName = string;
    }

    public BindingFault getLastBindingFault() {
        Trc.entry(this);
        Trc.exit(this.lastBindingFault);
        return this.lastBindingFault;
    }

    public Definition getDefinition() {
        return this.fieldDefinition;
    }

    public Port getPort() {
        return this.fieldPort;
    }
}

