/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.format.jms.JMSFormatHandler;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.jms.PrimitiveTypeFormatHandler;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;
import org.apache.wsif.wsdl.extensions.jms.JMSBinding;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.TextSerializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JMSMessage
extends WSIFDefaultMessage {
    private static final long serialVersionUID = 1L;
    private static String XML_ENCODING = "XML";
    private static String JAVA_ENCODING = "Java";
    static String XML_SCHEMA_1999 = "http://www.w3.org/1999/XMLSchema";
    static String XML_SCHEMA_2000_10 = "http://www.w3.org/2000/10/XMLSchema";
    static String XML_SCHEMA_2001 = "http://www.w3.org/2001/XMLSchema";
    static final HashMap PRIMITIVE_JAVA_MAPPING = new HashMap();
    private Definition fieldDefinitionModel;
    private Binding fieldBindingModel;
    private javax.wsdl.Message fieldMessageModel;
    private List fieldMessageParts;

    public JMSMessage(Definition definition, Binding binding, javax.wsdl.Message message, List list) {
        Trc.entry(this, definition, binding, message, list);
        this.fieldDefinitionModel = definition;
        this.fieldBindingModel = binding;
        this.fieldMessageModel = message;
        this.fieldMessageParts = list;
        Trc.exit();
    }

    public void write(Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!this.isCorrectMessageType(message)) {
            throw new WSIFException("Incorrect message type");
        }
        if (message instanceof TextMessage) {
            this.write((TextMessage)message);
        } else if (message instanceof ObjectMessage) {
            this.write((ObjectMessage)message);
        } else {
            throw new WSIFException("Unsupported Message Type: " + message.getClass().getName());
        }
        Trc.exit();
    }

    private void write(TextMessage textMessage) throws WSIFException {
        Trc.entry((Object)this, textMessage);
        if (!XML_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non XML encodings in a JMS Text Message");
        }
        try {
            ArrayList arrayList = new ArrayList();
            String[] stringArray = this.getPartNames();
            while (stringArray.hasNext()) {
                arrayList.add(stringArray.next());
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            if (stringArray.length == 1) {
                String string = stringArray[0];
                Part part = this.fieldMessageModel.getPart(string);
                QName qName = part.getElementName() != null ? part.getElementName() : part.getTypeName();
                JMSFormatHandler jMSFormatHandler = this.getFormatHandler(string);
                if (jMSFormatHandler != null) {
                    jMSFormatHandler.setPartQName(qName);
                    jMSFormatHandler.setObjectPart(this.parts.get(string));
                    jMSFormatHandler.write((Message)textMessage);
                } else {
                    Object v = this.parts.get(string);
                    textMessage.setText(v.toString());
                }
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
                OutputFormat outputFormat = new OutputFormat();
                XMLSerializer xMLSerializer = new XMLSerializer((Writer)outputStreamWriter, outputFormat);
                String string = "";
                xMLSerializer.startDocument();
                xMLSerializer.startElement(string, this.fieldMessageModel.getQName().getLocalPart(), "", (Attributes)new AttributesImpl());
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    String string2 = stringArray[i];
                    xMLSerializer.startElement(string, string2, "", (Attributes)new AttributesImpl());
                    Part part = this.fieldMessageModel.getPart(string2);
                    QName qName = part.getElementName() != null ? part.getElementName() : part.getTypeName();
                    JMSFormatHandler jMSFormatHandler = this.getFormatHandler(string2);
                    if (jMSFormatHandler != null) {
                        jMSFormatHandler.setPartQName(qName);
                        jMSFormatHandler.setObjectPart(this.parts.get(string2));
                        textMessage.setText("");
                        jMSFormatHandler.write((Message)textMessage);
                        object = textMessage.getText().toCharArray();
                        xMLSerializer.characters(object, 0, ((V)object).length);
                    } else {
                        object = this.parts.get(string2);
                        char[] cArray = object.toString().toCharArray();
                        xMLSerializer.characters(cArray, 0, cArray.length);
                    }
                    xMLSerializer.endElement(string2);
                }
                xMLSerializer.endElement(this.fieldMessageModel.getQName().getLocalPart());
                xMLSerializer.endDocument();
                outputStreamWriter.flush();
                String string3 = byteArrayOutputStream.toString();
                textMessage.setText(string3);
            }
            Trc.event(this, textMessage.getText());
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw new WSIFException("Error in write.", jMSException);
        }
        catch (IOException iOException) {
            Trc.exception(iOException);
            throw new WSIFException("Error in write.", iOException);
        }
        catch (SAXException sAXException) {
            Trc.exception(sAXException);
            throw new WSIFException("Error in write.", sAXException);
        }
        Trc.exit();
    }

    private void write(ObjectMessage objectMessage) throws WSIFException {
        Trc.entry((Object)this, objectMessage);
        if (!JAVA_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non Java encodings in a JMS Object Message");
        }
        try {
            ArrayList arrayList = new ArrayList();
            String[] stringArray = this.getPartNames();
            while (stringArray.hasNext()) {
                arrayList.add(stringArray.next());
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            if (stringArray.length == 1) {
                String string = stringArray[0];
                Part part = this.fieldMessageModel.getPart(string);
                QName qName = part.getElementName() != null ? part.getElementName() : part.getTypeName();
                JMSFormatHandler jMSFormatHandler = this.getFormatHandler(string);
                if (jMSFormatHandler != null) {
                    jMSFormatHandler.setPartQName(qName);
                    jMSFormatHandler.setObjectPart(this.parts.get(string));
                    jMSFormatHandler.write((Message)objectMessage);
                } else {
                    Object v = this.parts.get(string);
                    try {
                        objectMessage.setObject((Serializable)v);
                    }
                    catch (ClassCastException classCastException) {
                        Trc.exception(classCastException);
                        throw new WSIFException("Unable to serialize a part");
                    }
                }
            } else {
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    Part part = this.fieldMessageModel.getPart(string);
                    QName qName = part.getElementName() != null ? part.getElementName() : part.getTypeName();
                    JMSFormatHandler jMSFormatHandler = this.getFormatHandler(string);
                    if (jMSFormatHandler != null) {
                        jMSFormatHandler.setPartQName(qName);
                        jMSFormatHandler.setObjectPart(this.parts.get(string));
                        jMSFormatHandler.write((Message)objectMessage);
                        hashMap.put(string, objectMessage.getObject());
                        continue;
                    }
                    Object v = this.parts.get(string);
                    try {
                        hashMap.put(string, (Serializable)v);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        Trc.exception(classCastException);
                        throw new WSIFException("Unable to serialize a part");
                    }
                }
                objectMessage.setObject(hashMap);
            }
            Trc.event(this, objectMessage.getObject());
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw new WSIFException("Error in write.", jMSException);
        }
        Trc.exit();
    }

    public void read(Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (!this.isCorrectMessageType(message)) {
            throw new WSIFException("Incorrect message type");
        }
        if (message instanceof TextMessage) {
            this.read((TextMessage)message);
        } else if (message instanceof ObjectMessage) {
            this.read((ObjectMessage)message);
        } else {
            throw new WSIFException("Unsupported Message Type: " + message.getClass().getName());
        }
        Trc.exit();
    }

    private void read(TextMessage textMessage) throws WSIFException {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object[] objectArray;
        Trc.entry((Object)this, textMessage);
        if (!XML_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non XML encodings in a JMS Text Message");
        }
        boolean bl = false;
        try {
            Trc.event(this, textMessage.getText());
            objectArray = DocumentBuilderFactory.newInstance();
            objectArray.setNamespaceAware(true);
            objectArray.setValidating(false);
            object3 = objectArray.newDocumentBuilder();
            ((DocumentBuilder)object3).setErrorHandler(null);
            string = textMessage.getText();
            object2 = new ByteArrayInputStream(string.getBytes());
            object = ((DocumentBuilder)object3).parse((InputStream)object2);
            if (this.fieldMessageModel.getQName().getLocalPart().equals(object.getDocumentElement().getLocalName())) {
                bl = true;
                textMessage.clearBody();
                for (Node node = object.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                    QName qName;
                    if (node.getNodeType() != 1) continue;
                    String string2 = node.getLocalName();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    OutputFormat outputFormat = new OutputFormat();
                    TextSerializer textSerializer = new TextSerializer();
                    textSerializer.setOutputFormat(outputFormat);
                    textSerializer.setOutputByteStream((OutputStream)byteArrayOutputStream);
                    outputFormat.setOmitXMLDeclaration(true);
                    textSerializer.serialize((Element)node);
                    byteArrayOutputStream.flush();
                    String string3 = byteArrayOutputStream.toString();
                    Part part = this.fieldMessageModel.getPart(string2);
                    JMSFormatHandler jMSFormatHandler = this.getFormatHandler(string2);
                    QName qName2 = qName = part.getElementName() != null ? part.getElementName() : part.getTypeName();
                    if (jMSFormatHandler != null) {
                        jMSFormatHandler.setPartQName(qName);
                        textMessage.setText(string3);
                        jMSFormatHandler.read((Message)textMessage);
                        this.setObjectPart(string2, jMSFormatHandler.getObjectPart());
                        continue;
                    }
                    this.setObjectPart(string2, string3);
                }
                textMessage.setText(string);
            }
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw new WSIFException("Error in read.", jMSException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Trc.exception(parserConfigurationException);
            throw new WSIFException("Error in read.", parserConfigurationException);
        }
        catch (Exception exception) {
            Trc.exception(exception);
        }
        try {
            if (!bl) {
                Object[] objectArray2 = objectArray = this.fieldMessageParts != null ? this.fieldMessageParts.toArray() : this.fieldMessageModel.getParts().keySet().toArray();
                if (objectArray.length != 1) {
                    throw new WSIFException("There should only be one part defined in " + this.fieldMessageModel.getQName().getLocalPart());
                }
                object3 = objectArray[0].toString();
                string = this.fieldMessageModel.getPart((String)object3);
                object2 = this.getFormatHandler((String)object3);
                Object object4 = object = string.getElementName() != null ? string.getElementName() : string.getTypeName();
                if (object2 != null) {
                    object2.setPartQName((QName)object);
                    object2.read((Message)textMessage);
                    this.setObjectPart((String)object3, object2.getObjectPart());
                } else {
                    this.setObjectPart((String)object3, textMessage.getText());
                }
            }
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw new WSIFException("Error in read.", jMSException);
        }
        Trc.exit();
    }

    private void read(ObjectMessage objectMessage) throws WSIFException {
        Trc.entry((Object)this, objectMessage);
        if (!JAVA_ENCODING.equals(JMSMessage.getFormatEncoding(this.fieldBindingModel))) {
            throw new WSIFException("Unable to support non Java encodings in a JMS Object Message");
        }
        try {
            Object[] objectArray;
            Trc.event(this, objectMessage.getObject());
            Serializable serializable = objectMessage.getObject();
            Object[] objectArray2 = objectArray = this.fieldMessageParts != null ? this.fieldMessageParts.toArray() : this.fieldMessageModel.getParts().keySet().toArray();
            if (objectArray.length == 0) {
                return;
            }
            if (serializable instanceof Map) {
                objectMessage.clearBody();
                Map map = (Map)((Object)serializable);
                for (int i = 0; i < objectArray.length; ++i) {
                    QName qName;
                    String string = objectArray[i].toString();
                    if (!map.containsKey(string)) continue;
                    Part part = this.fieldMessageModel.getPart(string);
                    JMSFormatHandler jMSFormatHandler = this.getFormatHandler(string);
                    QName qName2 = qName = part.getElementName() != null ? part.getElementName() : part.getTypeName();
                    if (jMSFormatHandler != null) {
                        jMSFormatHandler.setPartQName(qName);
                        objectMessage.setObject((Serializable)map.get(string));
                        jMSFormatHandler.read((Message)objectMessage);
                        this.setObjectPart(string, jMSFormatHandler.getObjectPart());
                        continue;
                    }
                    this.setObjectPart(string, map.get(string));
                }
                objectMessage.setObject(serializable);
            } else {
                QName qName;
                if (objectArray.length != 1) {
                    throw new WSIFException("There should only be one part defined in " + this.fieldMessageModel.getQName().getLocalPart() + " or the JMS ObjectMessage should be a Map of " + "all the parts in the message");
                }
                String string = objectArray[0].toString();
                Part part = this.fieldMessageModel.getPart(string);
                JMSFormatHandler jMSFormatHandler = this.getFormatHandler(string);
                QName qName3 = qName = part.getElementName() != null ? part.getElementName() : part.getTypeName();
                if (jMSFormatHandler != null) {
                    jMSFormatHandler.setPartQName(qName);
                    jMSFormatHandler.read((Message)objectMessage);
                    this.setObjectPart(string, jMSFormatHandler.getObjectPart());
                } else {
                    this.setObjectPart(string, objectMessage.getObject());
                }
            }
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw new WSIFException("Error in read.", jMSException);
        }
        Trc.exit();
    }

    private static String getFormatEncoding(Binding binding) {
        Trc.entry(null, binding);
        for (ExtensibilityElement extensibilityElement : binding.getExtensibilityElements()) {
            if (!(extensibilityElement instanceof TypeMapping)) continue;
            TypeMapping typeMapping = (TypeMapping)extensibilityElement;
            String string = typeMapping.getEncoding();
            Trc.exit(string);
            return string;
        }
        Trc.exit(null);
        return null;
    }

    private JMSFormatHandler getFormatHandler(String string) {
        Trc.entry((Object)this, string);
        Part part = this.fieldMessageModel.getPart(string);
        JMSFormatHandler jMSFormatHandler = null;
        QName qName = part.getTypeName();
        if (qName == null) {
            qName = part.getElementName();
        }
        try {
            jMSFormatHandler = JMSMessage.isSchemaNamespace(qName.getNamespaceURI()) && JMSMessage.isXSDPrimitiveType(qName.getLocalPart()) ? new PrimitiveTypeFormatHandler((Class)PRIMITIVE_JAVA_MAPPING.get(qName.getLocalPart().toLowerCase())) : (JMSFormatHandler)WSIFUtils.getFormatHandler(part, this.fieldDefinitionModel, this.fieldBindingModel);
        }
        catch (Exception exception) {
            Trc.exception(exception);
        }
        Trc.exit(jMSFormatHandler);
        return jMSFormatHandler;
    }

    static boolean isSchemaNamespace(String string) {
        return XML_SCHEMA_1999.equals(string) || XML_SCHEMA_2000_10.equals(string) || XML_SCHEMA_2001.equals(string);
    }

    static boolean isXSDPrimitiveType(String string) {
        Trc.entry(null, string);
        Object[] objectArray = PRIMITIVE_JAVA_MAPPING.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].toString().equalsIgnoreCase(string)) continue;
            Trc.exit(true);
            return true;
        }
        Trc.exit(false);
        return false;
    }

    private int getMessageType() {
        Trc.entry(this);
        for (ExtensibilityElement extensibilityElement : this.fieldBindingModel.getExtensibilityElements()) {
            if (!(extensibilityElement instanceof JMSBinding)) continue;
            JMSBinding jMSBinding = (JMSBinding)extensibilityElement;
            int n = jMSBinding.getJmsMessageType();
            Trc.exit(n);
            return n;
        }
        int n = 0;
        Trc.exit(n);
        return n;
    }

    private boolean isCorrectMessageType(Message message) {
        Trc.entry((Object)this, message);
        int n = this.getMessageType();
        boolean bl = message instanceof TextMessage && n == 50 || message instanceof ObjectMessage && n == 30 || message instanceof StreamMessage && n == 40 || message instanceof BytesMessage && n == 10 || message instanceof MapMessage && n == 20;
        Trc.exit(bl);
        return bl;
    }

    static {
        PRIMITIVE_JAVA_MAPPING.put("anySimpleType", String.class);
        PRIMITIVE_JAVA_MAPPING.put("anyURI", String.class);
        PRIMITIVE_JAVA_MAPPING.put("base64Binary", byte[].class);
        PRIMITIVE_JAVA_MAPPING.put("boolean", Boolean.class);
        PRIMITIVE_JAVA_MAPPING.put("byte", Byte.class);
        PRIMITIVE_JAVA_MAPPING.put("date", GregorianCalendar.class);
        PRIMITIVE_JAVA_MAPPING.put("dateTime", Date.class);
        PRIMITIVE_JAVA_MAPPING.put("decimal", BigDecimal.class);
        PRIMITIVE_JAVA_MAPPING.put("double", Double.class);
        PRIMITIVE_JAVA_MAPPING.put("duration", String.class);
        PRIMITIVE_JAVA_MAPPING.put("ENTITIES", String.class);
        PRIMITIVE_JAVA_MAPPING.put("ENTITY", String.class);
        PRIMITIVE_JAVA_MAPPING.put("float", Float.class);
        PRIMITIVE_JAVA_MAPPING.put("gDay", String.class);
        PRIMITIVE_JAVA_MAPPING.put("gMonth", String.class);
        PRIMITIVE_JAVA_MAPPING.put("gMonthDay", String.class);
        PRIMITIVE_JAVA_MAPPING.put("gYear", String.class);
        PRIMITIVE_JAVA_MAPPING.put("gYearMonth", String.class);
        PRIMITIVE_JAVA_MAPPING.put("hexBinary", byte[].class);
        PRIMITIVE_JAVA_MAPPING.put("ID", String.class);
        PRIMITIVE_JAVA_MAPPING.put("IDREF", String.class);
        PRIMITIVE_JAVA_MAPPING.put("IDREFS", String.class);
        PRIMITIVE_JAVA_MAPPING.put("int", Integer.class);
        PRIMITIVE_JAVA_MAPPING.put("integer", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("language", String.class);
        PRIMITIVE_JAVA_MAPPING.put("long", Long.class);
        PRIMITIVE_JAVA_MAPPING.put("Name", String.class);
        PRIMITIVE_JAVA_MAPPING.put("NCName", String.class);
        PRIMITIVE_JAVA_MAPPING.put("negativeInteger", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("NMTOKEN", String.class);
        PRIMITIVE_JAVA_MAPPING.put("NMTOKENS", String.class);
        PRIMITIVE_JAVA_MAPPING.put("nonNegativeInteger", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("nonPositiveInteger", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("normalizedString", String.class);
        PRIMITIVE_JAVA_MAPPING.put("NOTATION", String.class);
        PRIMITIVE_JAVA_MAPPING.put("positiveInteger", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("QName", QName.class);
        PRIMITIVE_JAVA_MAPPING.put("short", Short.class);
        PRIMITIVE_JAVA_MAPPING.put("string", String.class);
        PRIMITIVE_JAVA_MAPPING.put("time", String.class);
        PRIMITIVE_JAVA_MAPPING.put("token", String.class);
        PRIMITIVE_JAVA_MAPPING.put("unsignedByte", Short.class);
        PRIMITIVE_JAVA_MAPPING.put("unsignedInt", Long.class);
        PRIMITIVE_JAVA_MAPPING.put("unsignedLong", BigInteger.class);
        PRIMITIVE_JAVA_MAPPING.put("unsignedShort", Integer.class);
    }
}

