/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.xml.namespace.QName;
import org.apache.wsif.format.jms.JMSFormatHandler;
import org.apache.wsif.logging.Trc;

public class PrimitiveTypeFormatHandler
implements JMSFormatHandler {
    private static final long serialVersionUID = 1L;
    protected static DateFormat GREGORIAN_CALENDAR_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    protected static DateFormat STANDARD_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected static DateFormat PRECISE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    QName name;
    Object primitiveType;
    Class type;

    public PrimitiveTypeFormatHandler(Class clazz) {
        this.type = clazz;
    }

    public Object getElement(String string) {
        return null;
    }

    public void setElement(String string, Object object) {
    }

    public Object getElement(String string, int n) {
        return null;
    }

    public void setElement(String string, int n, Object object) {
    }

    public Object getObjectPart() {
        return this.primitiveType;
    }

    public Object getObjectPart(Class clazz) {
        return null;
    }

    public char getCharPart() {
        return '\u0000';
    }

    public byte getBytePart() {
        return 0;
    }

    public short getShortPart() {
        return 0;
    }

    public int getIntPart() {
        return 0;
    }

    public long getLongPart() {
        return 0L;
    }

    public float getFloatPart() {
        return 0.0f;
    }

    public double getDoublePart() {
        return 0.0;
    }

    public QName getPartQName() {
        return this.name;
    }

    public void setObjectPart(Object object) {
        this.primitiveType = object;
    }

    public void setCharPart(char c) {
    }

    public void setBytePart(byte by) {
    }

    public void setShortPart(short s) {
    }

    public void setIntPart(int n) {
    }

    public void setLongPart(long l) {
    }

    public void setFloatPart(float f) {
    }

    public void setDoublePart(double d) {
    }

    public void setPartQName(QName qName) {
        this.name = qName;
    }

    public void write(Message message) {
        Trc.entry((Object)this, message);
        try {
            if (message instanceof TextMessage) {
                this.write((TextMessage)message);
            } else if (message instanceof ObjectMessage) {
                this.write((ObjectMessage)message);
            }
        }
        catch (Exception exception) {
            Trc.exception(exception);
        }
        Trc.exit();
    }

    public void read(Message message) {
        Trc.entry((Object)this, message);
        try {
            if (message instanceof TextMessage) {
                this.read((TextMessage)message);
            } else if (message instanceof ObjectMessage) {
                this.read((ObjectMessage)message);
            }
        }
        catch (Exception exception) {
            Trc.exception(exception);
        }
        Trc.exit();
    }

    private void write(TextMessage textMessage) throws JMSException {
        String string = null;
        string = this.primitiveType == null ? "" : (this.primitiveType instanceof GregorianCalendar ? GREGORIAN_CALENDAR_DATE_FORMAT.format(((GregorianCalendar)this.primitiveType).getTime()) : (this.primitiveType instanceof Date ? STANDARD_DATE_FORMAT.format((Date)this.primitiveType) : (this.primitiveType instanceof byte[] ? new String((byte[])this.primitiveType) : this.primitiveType.toString())));
        if (string != null) {
            textMessage.setText(string);
        }
    }

    private void write(ObjectMessage objectMessage) throws JMSException {
        if (this.primitiveType != null && this.primitiveType instanceof Serializable) {
            objectMessage.setObject((Serializable)this.primitiveType);
        }
    }

    private void read(TextMessage textMessage) throws JMSException {
        block8: {
            String string = textMessage.getText();
            Class clazz = this.type;
            try {
                if (clazz == String.class) {
                    this.primitiveType = string;
                    break block8;
                }
                if (clazz == byte[].class) {
                    this.primitiveType = string.getBytes();
                    break block8;
                }
                if (GregorianCalendar.class.isAssignableFrom(clazz)) {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(GREGORIAN_CALENDAR_DATE_FORMAT.parse(string));
                    this.primitiveType = gregorianCalendar;
                    break block8;
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    Date date = new Date();
                    try {
                        date = STANDARD_DATE_FORMAT.parse(string);
                    }
                    catch (ParseException parseException) {
                        Trc.exception(parseException);
                        date = PRECISE_DATE_FORMAT.parse(string);
                    }
                    this.primitiveType = date;
                    break block8;
                }
                Constructor constructor = clazz.getConstructor(String.class);
                this.primitiveType = constructor.newInstance(string);
            }
            catch (Exception exception) {
                Trc.exception(exception);
                throw new JMSException("Unable to parse message");
            }
        }
    }

    private void read(ObjectMessage objectMessage) throws JMSException {
        this.primitiveType = objectMessage.getObject();
        if (!this.primitiveType.getClass().isAssignableFrom(this.type)) {
            throw new JMSException("Unable to parse message");
        }
    }
}

