/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Message;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFRequest;
import org.apache.wsif.WSIFResponse;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.base.WSIFDefaultOperation;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFTransactionControl;
import org.apache.wsif.providers.jms.JMSFormatter;
import org.apache.wsif.providers.jms.JMSMessage;
import org.apache.wsif.providers.jms.WSIFPort_Jms;
import org.apache.wsif.util.WSIFCorrelationServiceLocator;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSCorrelationId;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSProperties;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;
import org.apache.wsif.wsdl.extensions.jms.JMSBinding;
import org.apache.wsif.wsdl.extensions.jms.JMSConstants;
import org.apache.wsif.wsdl.extensions.jms.JMSFaultIndicator;
import org.apache.wsif.wsdl.extensions.jms.JMSFaultProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSInput;
import org.apache.wsif.wsdl.extensions.jms.JMSOutput;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;

public class WSIFOperation_Jms
extends WSIFDefaultOperation
implements WSIFOperation {
    private static final long serialVersionUID = 1L;
    protected Port fieldBasePort;
    protected BindingOperation fieldBindingOperation;
    protected WSIFPort_Jms fieldJmsPort;
    protected Operation fieldOperation;
    private boolean inputOnlyOp = false;
    protected String fieldInputMessageName;
    protected HashMap fieldInputJmsPropertyValues;
    protected HashMap fieldInputJmsProperties;
    protected JMSInput fieldInput;
    protected String fieldOutputMessageName;
    protected HashMap fieldOutputProperties;
    protected JMSOutput fieldOutput;
    private WSIFResponseHandler handler;
    private boolean asyncOperation;
    private JMSFormatter formatter;
    private long syncTimeout;
    private long asyncTimeout;
    private transient WSIFTransactionControl transControl;

    public WSIFOperation_Jms(Port port, BindingOperation bindingOperation, WSIFPort_Jms wSIFPort_Jms) throws WSIFException {
        Trc.entry(this, port, bindingOperation, wSIFPort_Jms);
        this.fieldBasePort = port;
        this.fieldBindingOperation = bindingOperation;
        this.fieldJmsPort = wSIFPort_Jms;
        this.syncTimeout = WSIFProperties.getSyncTimeout();
        this.asyncTimeout = WSIFProperties.getAsyncTimeout();
        final String string = WSIFProperties.getProperty("wsif.transactioncontrol.impl");
        if (string != null) {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (Throwable throwable) {
                        Trc.ignoredException(throwable);
                        return null;
                    }
                }
            });
            if (clazz != null) {
                try {
                    this.transControl = (WSIFTransactionControl)clazz.newInstance();
                }
                catch (Exception exception) {
                    Trc.ignoredException(exception);
                    this.transControl = null;
                }
            } else {
                this.transControl = null;
            }
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation_Jms copy() throws WSIFException {
        Trc.entry(this);
        WSIFOperation_Jms wSIFOperation_Jms = new WSIFOperation_Jms(this.fieldBasePort, this.fieldBindingOperation, this.fieldJmsPort);
        if (Trc.ON) {
            Trc.exit(wSIFOperation_Jms.deep());
        }
        return wSIFOperation_Jms;
    }

    public boolean executeRequestResponseOperation(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Trc.entry(this, wSIFMessage, wSIFMessage2, wSIFMessage3);
        this.close();
        if (!this.fieldJmsPort.supportsSync()) {
            throw new WSIFException("synchronous operations not available");
        }
        this.setAsyncOperation(false);
        boolean bl = true;
        boolean bl2 = false;
        try {
            this.getOperation();
            if (this.transControl != null) {
                this.transControl.suspend();
                bl2 = true;
            }
            String string = this.sendJmsMessage(wSIFMessage);
            WSIFJMSDestination wSIFJMSDestination = this.fieldJmsPort.getJmsDestination();
            Message message = wSIFJMSDestination.receive(string, this.syncTimeout);
            bl = this.receiveJmsMessage(message, wSIFMessage2, wSIFMessage3);
        }
        catch (Exception exception) {
            Trc.exception(exception);
            MessageLogger.log("WSIF.0005E", "Jms", this.fieldBindingOperation.getName());
            throw new WSIFException(this + " : Could not invoke '" + this.fieldBindingOperation.getName() + "'", exception);
        }
        finally {
            if (bl2) {
                this.transControl.resume();
            }
        }
        Trc.exit(bl);
        return bl;
    }

    public void executeInputOnlyOperation(WSIFMessage wSIFMessage) throws WSIFException {
        Trc.entry((Object)this, wSIFMessage);
        this.inputOnlyOp = true;
        this.executeRequestResponseAsync(wSIFMessage, null);
        Trc.exit();
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage) throws WSIFException {
        return this.executeRequestResponseAsync(wSIFMessage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage, WSIFResponseHandler wSIFResponseHandler) throws WSIFException {
        WSIFJMSCorrelationId wSIFJMSCorrelationId;
        block8: {
            Trc.entry(this, wSIFMessage, wSIFResponseHandler);
            this.close();
            if (!this.fieldJmsPort.supportsAsync()) {
                throw new WSIFException("asynchronous operations not available");
            }
            this.setAsyncOperation(true);
            wSIFJMSCorrelationId = null;
            try {
                WSIFCorrelationService wSIFCorrelationService;
                this.getOperation();
                this.handler = wSIFResponseHandler;
                if (this.inputOnlyOp) {
                    this.sendJmsMessage(wSIFMessage);
                    break block8;
                }
                if (wSIFResponseHandler == null) {
                    wSIFJMSCorrelationId = new WSIFJMSCorrelationId(this.sendJmsMessage(wSIFMessage));
                    break block8;
                }
                WSIFCorrelationService wSIFCorrelationService2 = wSIFCorrelationService = WSIFCorrelationServiceLocator.getCorrelationService();
                synchronized (wSIFCorrelationService2) {
                    wSIFJMSCorrelationId = new WSIFJMSCorrelationId(this.sendJmsMessage(wSIFMessage));
                    wSIFCorrelationService.put(wSIFJMSCorrelationId, this, this.asyncTimeout);
                }
            }
            catch (Exception exception) {
                Trc.exception(exception);
                MessageLogger.log("WSIF.0005E", "Jms", this.fieldBindingOperation.getName());
                throw new WSIFException(this + " : Could not invoke '" + this.fieldBindingOperation.getName() + "'", exception);
            }
        }
        Trc.exit(wSIFJMSCorrelationId);
        return wSIFJMSCorrelationId;
    }

    public boolean processAsyncResponse(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        Trc.entry(this, object, wSIFMessage, wSIFMessage2);
        boolean bl = false;
        try {
            this.getOperation();
            wSIFMessage.setName(this.fieldBindingOperation.getBindingOutput().getName());
            bl = this.receiveJmsMessage(object, wSIFMessage, wSIFMessage2);
        }
        catch (Exception exception) {
            Trc.exception(exception);
            MessageLogger.log("WSIF.0005E", "Jms", this.fieldBindingOperation.getName());
            throw new WSIFException(this + " : Could not invoke '" + this.fieldBindingOperation.getName() + "'", exception);
        }
        Trc.exit(bl);
        return bl;
    }

    public void fireAsyncResponse(Object object) throws WSIFException {
        Trc.entry((Object)this, object);
        WSIFMessage wSIFMessage = this.createOutputMessage();
        WSIFMessage wSIFMessage2 = this.createFaultMessage();
        this.receiveJmsMessage(object, wSIFMessage, wSIFMessage2);
        this.handler.executeAsyncResponse(wSIFMessage, wSIFMessage2);
        Trc.exit();
    }

    private String sendJmsMessage(WSIFMessage wSIFMessage) throws WSIFException {
        Service service3;
        Object object;
        String string;
        String string2 = null;
        WSIFJMSDestination wSIFJMSDestination = this.fieldJmsPort.getJmsDestination();
        this.setPropertyValues();
        ArrayList arrayList = this.getWSDLInputPartNames();
        HashMap hashMap = this.getPropertyParts();
        WSIFMessage wSIFMessage2 = this.createInputMessage();
        Service service2 = wSIFMessage.getPartNames();
        while (service2.hasNext()) {
            String string3 = (String)service2.next();
            if (hashMap.containsKey(string3)) {
                string = (String)hashMap.get(string3);
                if (this.timeoutProperty(string, object = wSIFMessage.getObjectPart(string3))) continue;
                wSIFJMSDestination.setProperty(string, object);
                continue;
            }
            if (!arrayList.contains(string3)) continue;
            arrayList.remove(string3);
            if (this.fieldInput == null) {
                wSIFMessage2.setObjectPart(string3, wSIFMessage.getObjectPart(string3));
                continue;
            }
            if (!this.fieldInput.getParts().contains(string3)) continue;
            wSIFMessage2.setObjectPart(string3, wSIFMessage.getObjectPart(string3));
        }
        service2 = arrayList.iterator();
        while (service2.hasNext()) {
            wSIFMessage2.setObjectPart((String)service2.next(), null);
        }
        this.setDestinationContext();
        service2 = null;
        string = this.fieldJmsPort.getDefinition();
        object = WSIFUtils.getAllItems((Definition)string, "Service");
        Port port = this.fieldJmsPort.getPortModel();
        for (Service service3 : object.values()) {
            if (!service3.getPorts().values().contains(port)) continue;
            service2 = service3;
            break;
        }
        if (service2 == null) {
            throw new WSIFException("cannot find service for port: " + port);
        }
        this.formatter = (JMSFormatter)this.fieldJmsPort.getFormatter();
        WSIFRequest wSIFRequest = new WSIFRequest(service2.getQName());
        wSIFRequest.setIncomingMessage(wSIFMessage2);
        wSIFRequest.setOperationName(this.fieldOperation.getName());
        wSIFRequest.setPortName(this.fieldJmsPort.getPortModel().getName());
        wSIFRequest.setInputName(this.fieldBindingOperation.getBindingInput().getName());
        service3 = wSIFJMSDestination.createMessage(this.getJMSMessageType());
        this.formatter.formatRequest(wSIFRequest, (Message)service3);
        if (this.isAsyncOperation() && this.handler != null) {
            wSIFJMSDestination.setAsyncMode(true);
        }
        string2 = wSIFJMSDestination.send((Message)service3, null, !this.inputOnlyOp);
        return string2;
    }

    private boolean receiveJmsMessage(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        Object object2;
        Trc.entry(this, object, wSIFMessage, wSIFMessage2);
        if (!(object instanceof Message)) {
            throw new WSIFException("Object is not of type javax.jms.Message");
        }
        this.fieldJmsPort.getJmsDestination().setLastMessage((Message)object);
        WSIFResponse wSIFResponse = this.formatter.unformatResponse((Message)object);
        if (wSIFResponse.getIsFault()) {
            this.formatter.copyTo(wSIFResponse.getOutgoingMessage(), wSIFMessage2);
            this.setFaultProperties(wSIFMessage2, this.formatter.getLastBindingFault());
            Trc.exit(false);
            return false;
        }
        ArrayList arrayList = this.getWSDLOutputPartNames();
        WSIFMessage wSIFMessage3 = wSIFResponse.getOutgoingMessage();
        if (wSIFMessage3 != null) {
            Iterator iterator = wSIFMessage3.getPartNames();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                wSIFMessage.setObjectPart((String)object2, wSIFMessage3.getObjectPart((String)object2));
                arrayList.remove(object2);
            }
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            wSIFMessage.setObjectPart((String)object2.next(), null);
        }
        this.setOutProperties(wSIFMessage);
        Trc.exit(true);
        return true;
    }

    private HashMap getPropertyParts() {
        HashMap hashMap = new HashMap();
        if (this.fieldInputJmsProperties != null) {
            for (String string : this.fieldInputJmsProperties.keySet()) {
                hashMap.put(string, this.fieldInputJmsProperties.get(string));
            }
        }
        return hashMap;
    }

    private void setPropertyValues() throws WSIFException {
        Object object;
        String string;
        WSIFJMSDestination wSIFJMSDestination = this.fieldJmsPort.getJmsDestination();
        try {
            string = this.fieldOperation.getName();
            if (string != null && string.length() > 0) {
                wSIFJMSDestination.setProperty("WSDLOperation", string);
            }
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        try {
            object = this.fieldBindingOperation.getBindingInput();
            String string2 = string = object == null ? null : object.getName();
            if (string != null && string.length() > 0) {
                wSIFJMSDestination.setProperty("WSDLInput", string);
            }
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        try {
            object = this.fieldBindingOperation.getBindingOutput();
            String string3 = string = object == null ? null : object.getName();
            if (string != null && string.length() > 0) {
                wSIFJMSDestination.setProperty("WSDLOutput", string);
            }
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        try {
            object = this.fieldJmsPort.getObjectReference();
            if (object != null) {
                this.setJMSPropertyValues(((JMSAddress)object).getJMSPropertyValues());
            }
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        if (this.fieldInputJmsPropertyValues != null) {
            try {
                this.setJmsPropertyValues(this.fieldInputJmsPropertyValues);
            }
            catch (WSIFException wSIFException) {
                Trc.ignoredException(wSIFException);
            }
        }
    }

    private void setOutProperties(WSIFMessage wSIFMessage) throws WSIFException {
        if (wSIFMessage != null && this.fieldOutputProperties != null) {
            WSIFJMSDestination wSIFJMSDestination = this.fieldJmsPort.getJmsDestination();
            for (String string : this.fieldOutputProperties.keySet()) {
                String string2 = (String)this.fieldOutputProperties.get(string);
                try {
                    Object object = wSIFJMSDestination.getProperty(string2);
                    wSIFMessage.setObjectPart(string, object);
                }
                catch (WSIFException wSIFException) {
                    Trc.ignoredException(wSIFException);
                }
            }
        }
    }

    private void setFaultProperties(WSIFMessage wSIFMessage, BindingFault bindingFault) throws WSIFException {
        Trc.entry(this, wSIFMessage, bindingFault);
        WSIFJMSDestination wSIFJMSDestination = this.fieldJmsPort.getJmsDestination();
        for (Object e : bindingFault.getExtensibilityElements()) {
            Object object;
            Object object2;
            Object object3;
            ExtensibilityElement extensibilityElement;
            if (e instanceof JMSFaultIndicator) {
                extensibilityElement = (JMSFaultIndicator)e;
                object3 = extensibilityElement.getJMSFaultProperties();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!(object instanceof JMSFaultProperty)) continue;
                    JMSFaultProperty jMSFaultProperty = (JMSFaultProperty)object;
                    String string = jMSFaultProperty.getPart();
                    String string2 = jMSFaultProperty.getName();
                    if (string == null || string.length() <= 0) continue;
                    try {
                        Object object4 = wSIFJMSDestination.getProperty(string2);
                        wSIFMessage.setObjectPart(string, object4);
                    }
                    catch (WSIFException wSIFException) {
                        Trc.ignoredException(wSIFException);
                    }
                }
                continue;
            }
            if (!(e instanceof JMSProperty)) continue;
            extensibilityElement = (JMSProperty)e;
            object3 = extensibilityElement.getPart();
            object2 = extensibilityElement.getName();
            try {
                object = wSIFJMSDestination.getProperty((String)object2);
                wSIFMessage.setObjectPart((String)object3, object);
            }
            catch (WSIFException wSIFException) {
                Trc.ignoredException(wSIFException);
            }
        }
        Trc.exit();
    }

    private void setJMSPropertyValues(List list) throws WSIFException {
        if (list != null) {
            WSIFJMSDestination wSIFJMSDestination = this.fieldJmsPort.getJmsDestination();
            for (JMSPropertyValue jMSPropertyValue : list) {
                if (jMSPropertyValue == null) continue;
                Object object = this.getObjectValue(jMSPropertyValue.getType(), jMSPropertyValue.getValue());
                if (this.timeoutProperty(jMSPropertyValue.getName(), object)) continue;
                wSIFJMSDestination.setProperty(jMSPropertyValue.getName(), object);
            }
        }
    }

    private void setJmsPropertyValues(HashMap hashMap) throws WSIFException {
        for (String string : hashMap.keySet()) {
            Object object;
            JMSPropertyValue jMSPropertyValue = (JMSPropertyValue)hashMap.get(string);
            if (jMSPropertyValue == null || this.timeoutProperty(string, object = this.getObjectValue(jMSPropertyValue.getType(), jMSPropertyValue.getValue()))) continue;
            WSIFJMSDestination wSIFJMSDestination = this.fieldJmsPort.getJmsDestination();
            wSIFJMSDestination.setProperty(string, object);
        }
    }

    private boolean timeoutProperty(String string, Object object) {
        boolean bl = false;
        if ("wsif.syncrequest.timeout".equals(string)) {
            bl = true;
            try {
                this.syncTimeout = Long.parseLong(object.toString());
                Trc.event(this, "overridding syncTimeout to " + this.syncTimeout);
            }
            catch (NumberFormatException numberFormatException) {
                Trc.ignoredException(numberFormatException);
            }
        } else if ("wsif.asyncrequest.timeout".equals(string)) {
            bl = true;
            try {
                this.asyncTimeout = Long.parseLong(object.toString());
                Trc.event(this, "overridding asyncTimeout to " + this.syncTimeout);
            }
            catch (NumberFormatException numberFormatException) {
                Trc.ignoredException(numberFormatException);
            }
        }
        return bl;
    }

    protected Operation getOperation() throws Exception {
        if (this.fieldOperation == null) {
            ExtensibilityElement extensibilityElement;
            Iterator iterator;
            if (this.fieldBindingOperation.getBindingInput() != null) {
                this.fieldInputMessageName = this.fieldBindingOperation.getBindingInput().getName();
            }
            if (this.fieldBindingOperation.getBindingOutput() != null) {
                this.fieldOutputMessageName = this.fieldBindingOperation.getBindingOutput().getName();
            }
            this.fieldOperation = this.fieldBasePort.getBinding().getPortType().getOperation(this.fieldBindingOperation.getName(), this.fieldInputMessageName, this.fieldOutputMessageName);
            if (this.fieldBindingOperation.getBindingInput() != null) {
                iterator = this.fieldBindingOperation.getBindingInput().getExtensibilityElements().iterator();
                this.fieldInputJmsProperties = new HashMap();
                this.fieldInputJmsPropertyValues = new HashMap();
                while (iterator.hasNext()) {
                    extensibilityElement = (ExtensibilityElement)iterator.next();
                    if (extensibilityElement instanceof JMSInput) {
                        this.fieldInput = (JMSInput)extensibilityElement;
                        continue;
                    }
                    if (extensibilityElement instanceof JMSProperty) {
                        this.fieldInputJmsProperties.put(((JMSProperty)extensibilityElement).getPart(), ((JMSProperty)extensibilityElement).getName());
                        continue;
                    }
                    if (!(extensibilityElement instanceof JMSPropertyValue)) continue;
                    this.fieldInputJmsPropertyValues.put(((JMSPropertyValue)extensibilityElement).getName(), extensibilityElement);
                }
            }
            if (this.fieldBindingOperation.getBindingOutput() != null) {
                iterator = this.fieldBindingOperation.getBindingOutput().getExtensibilityElements().iterator();
                this.fieldOutputProperties = new HashMap();
                while (iterator.hasNext()) {
                    extensibilityElement = (ExtensibilityElement)iterator.next();
                    if (extensibilityElement instanceof JMSOutput) {
                        this.fieldOutput = (JMSOutput)extensibilityElement;
                        continue;
                    }
                    if (!(extensibilityElement instanceof JMSProperty)) continue;
                    this.fieldOutputProperties.put(((JMSProperty)extensibilityElement).getPart(), ((JMSProperty)extensibilityElement).getName());
                }
            }
        }
        if (this.fieldOperation == null) {
            throw new WSIFException("Unable to resolve Jms binding for operation '" + this.fieldBindingOperation.getName() + ":" + this.fieldInputMessageName + ":" + this.fieldOutputMessageName + "'");
        }
        return this.fieldOperation;
    }

    private Object getObjectValue(QName qName, String string) throws WSIFException {
        Object object = null;
        if (JMSMessage.isSchemaNamespace(qName.getNamespaceURI()) && JMSMessage.isXSDPrimitiveType(qName.getLocalPart())) {
            Class clazz = (Class)JMSMessage.PRIMITIVE_JAVA_MAPPING.get(qName.getLocalPart().toLowerCase());
            if (clazz == String.class) {
                object = string;
            } else if (clazz == byte[].class) {
                object = string.getBytes();
            } else if (!GregorianCalendar.class.isAssignableFrom(clazz) && !Date.class.isAssignableFrom(clazz)) {
                try {
                    Constructor constructor = clazz.getConstructor(String.class);
                    object = constructor.newInstance(string);
                }
                catch (Exception exception) {
                    Trc.ignoredException(exception);
                }
            }
        }
        if (object != null) {
            return object;
        }
        throw new WSIFException("Unable to create the java object for XSD Type '" + qName.toString() + "' using value '" + string + "'");
    }

    public int getJMSMessageType() {
        Trc.entry(this);
        Iterator iterator = this.fieldBasePort.getBinding().getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            try {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                if (!JMSConstants.Q_ELEM_JMS_BINDING.equals(extensibilityElement.getElementType())) continue;
                int n = ((JMSBinding)extensibilityElement).getJmsMessageType();
                Trc.exit(n);
                return n;
            }
            catch (ClassCastException classCastException) {
                Trc.ignoredException(classCastException);
            }
        }
        Trc.exit(0);
        return 0;
    }

    private void setAsyncOperation(boolean bl) {
        this.asyncOperation = bl;
    }

    public boolean isAsyncOperation() {
        Trc.entry(this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    private void setDestinationContext() throws WSIFException {
        if (this.context == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = this.context.getPartNames();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                Object object2 = this.context.getObjectPart(string);
                if (this.timeoutProperty(string, object2) || !string.startsWith("JMSProperty.")) continue;
                hashMap.put(string.substring("JMSProperty.".length()), object2);
            }
            catch (WSIFException wSIFException) {
                Trc.ignoredException(wSIFException);
            }
        }
        if (hashMap.size() > 0) {
            object = this.fieldJmsPort.getJmsDestination();
            ((WSIFJMSDestination)object).setProperties(hashMap);
        }
    }

    private ArrayList getWSDLInputPartNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Input input = this.fieldOperation.getInput();
        if (input != null) {
            javax.wsdl.Message message = input.getMessage();
            for (String string : message.getParts().keySet()) {
                if (this.fieldInputJmsProperties != null && this.fieldInputJmsProperties.containsKey(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private ArrayList getWSDLOutputPartNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Output output = this.fieldOperation.getOutput();
        if (output != null) {
            javax.wsdl.Message message = output.getMessage();
            for (String string : message.getParts().keySet()) {
                if (this.fieldOutputProperties != null && this.fieldOutputProperties.containsKey(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public WSIFPort getWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.fieldJmsPort);
        return this.fieldJmsPort;
    }

    public static void setJMSMessageOutputHeaderProperties(Message message, WSIFMessage wSIFMessage, JMSFormatter jMSFormatter) throws WSIFException {
        Trc.entry(null, message, wSIFMessage, jMSFormatter);
        if (message == null) {
            throw new IllegalArgumentException("targetMsg is null");
        }
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("srcMsg is null");
        }
        if (jMSFormatter == null) {
            throw new IllegalArgumentException("formatter is null");
        }
        WSIFJMSProperties wSIFJMSProperties = new WSIFJMSProperties("out");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map map = WSIFOperation_Jms.getJMSOutputProperties(jMSFormatter);
        Iterator iterator = wSIFMessage.getPartNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = null;
            try {
                object = wSIFMessage.getObjectPart(string);
            }
            catch (WSIFException wSIFException) {
                Trc.ignoredException(wSIFException);
            }
            if (map.containsKey(string)) {
                String string2 = (String)map.get(string);
                wSIFJMSProperties.put(string2, object);
                continue;
            }
            hashMap.put(string, object);
        }
        wSIFJMSProperties.set(null, message);
        wSIFMessage.setParts(hashMap);
        Trc.exit();
    }

    protected static Map getJMSOutputProperties(JMSFormatter jMSFormatter) throws WSIFException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BindingOperation bindingOperation = WSIFOperation_Jms.getFormatterOperation(jMSFormatter);
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput != null) {
            List list = bindingOutput.getExtensibilityElements();
            for (ExtensibilityElement extensibilityElement : list) {
                if (!(extensibilityElement instanceof JMSProperty)) continue;
                hashMap.put(((JMSProperty)extensibilityElement).getPart(), ((JMSProperty)extensibilityElement).getName());
            }
        }
        return hashMap;
    }

    protected static BindingOperation getFormatterOperation(JMSFormatter jMSFormatter) throws WSIFException {
        Port port = jMSFormatter.getPort();
        if (port == null) {
            throw new WSIFException("formatter contains a null Port");
        }
        BindingOperation bindingOperation = WSIFUtils.getBindingOperation(port.getBinding(), jMSFormatter.getOperationName(), jMSFormatter.getInputName(), jMSFormatter.getOutputName());
        if (bindingOperation == null) {
            throw new WSIFException("cannot find binding operation for formatter");
        }
        return bindingOperation;
    }

    public String deep() {
        String string = "";
        try {
            string = new String(super.toString() + ":\n");
            string = string + "basePort:" + Trc.brief(this.fieldBasePort);
            string = string + " bindingOperation:" + Trc.brief(this.fieldBindingOperation);
            string = string + " wsifPort_Jms:" + this.fieldJmsPort;
            string = string + " Operation:" + Trc.brief(this.fieldOperation);
            string = string + " InputOnlyOperation:" + this.inputOnlyOp;
            string = string + " JmsMessageType:" + this.getJMSMessageType();
            string = string + " inputMessageName:" + this.fieldInputMessageName;
            string = string + " InputJmsPropertyValues:" + this.fieldInputJmsPropertyValues;
            string = string + " InputProperty:" + this.fieldInputJmsProperties;
            string = string + " Input:" + this.fieldInput;
            string = string + " outputMessageName:" + this.fieldOutputMessageName;
            string = string + " OutputProperties:" + this.fieldOutputProperties;
            string = string + " Output:" + this.fieldOutput;
            string = string + " Formater:" + this.formatter;
            string = string + " handler:" + this.handler;
            string = string + " asyncOperation:" + this.asyncOperation;
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }
}

