/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.base.WSIFDefaultPort;
import org.apache.wsif.format.WSIFFormatter;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.jms.JMSFormatter;
import org.apache.wsif.providers.jms.WSIFOperation_Jms;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;

public class WSIFPort_Jms
extends WSIFDefaultPort
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Definition fieldDefinition = null;
    private Port fieldPortModel = null;
    private JMSAddress fieldObjectReference = null;
    protected Map operationInstances = new HashMap();
    private transient WSIFJMSDestination jmsDest;

    public WSIFPort_Jms(Definition definition, Port port, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        Trc.entry(this, definition, port, wSIFDynamicTypeMap);
        this.fieldDefinition = definition;
        this.fieldPortModel = port;
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation createOperation(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        WSIFOperation wSIFOperation = this.createOperation(string, null, null);
        Trc.exit(wSIFOperation);
        return wSIFOperation;
    }

    public WSIFOperation createOperation(String string, String string2, String string3) throws WSIFException {
        Trc.entry(this, string, string2, string3);
        WSIFOperation_Jms wSIFOperation_Jms = this.getDynamicWSIFOperation(string, string2, string3);
        if (wSIFOperation_Jms == null) {
            throw new WSIFException("Could not create operation: " + string + ":" + string2 + ":" + string3);
        }
        WSIFOperation_Jms wSIFOperation_Jms2 = wSIFOperation_Jms.copy();
        Trc.exit(wSIFOperation_Jms2);
        return wSIFOperation_Jms2;
    }

    public WSIFOperation_Jms getDynamicWSIFOperation(String string, String string2, String string3) throws WSIFException {
        BindingOperation bindingOperation;
        Trc.entry(this, string, string2, string3);
        WSIFOperation_Jms wSIFOperation_Jms = (WSIFOperation_Jms)this.operationInstances.get(this.getKey(string, string2, string3));
        WSIFOperation_Jms wSIFOperation_Jms2 = null;
        if (wSIFOperation_Jms != null) {
            wSIFOperation_Jms2 = wSIFOperation_Jms.copy();
        }
        if (wSIFOperation_Jms2 == null && (bindingOperation = WSIFUtils.getBindingOperation(this.fieldPortModel.getBinding(), string, string2, string3)) != null) {
            wSIFOperation_Jms2 = new WSIFOperation_Jms(this.fieldPortModel, bindingOperation, this);
            this.setDynamicWSIFOperation(string, string2, string3, wSIFOperation_Jms2);
        }
        Trc.exit(wSIFOperation_Jms2);
        return wSIFOperation_Jms2;
    }

    public void setDynamicWSIFOperation(String string, String string2, String string3, WSIFOperation_Jms wSIFOperation_Jms) {
        Trc.entry(this, string, string2, string3);
        this.operationInstances.put(this.getKey(string, string2, string3), wSIFOperation_Jms);
        Trc.exit();
    }

    public boolean supportsSync() {
        Trc.entry(this);
        Trc.exit(true);
        return true;
    }

    public boolean supportsAsync() {
        Trc.entry(this);
        Trc.exit(true);
        return true;
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.fieldDefinition);
        return this.fieldDefinition;
    }

    public void setDefinition(Definition definition) {
        Trc.entry((Object)this, definition);
        this.fieldDefinition = definition;
        Trc.exit();
    }

    public Port getPortModel() {
        Trc.entry(this);
        Trc.exit(this.fieldPortModel);
        return this.fieldPortModel;
    }

    public void setPortModel(Port port) {
        Trc.entry((Object)this, port);
        this.fieldPortModel = port;
        Trc.exit();
    }

    public JMSAddress getObjectReference() throws WSIFException {
        Trc.entry(this);
        if (this.fieldObjectReference == null) {
            try {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)this.fieldPortModel.getExtensibilityElements().get(0);
                if (extensibilityElement == null) {
                    throw new WSIFException("Jms missing port extension");
                }
                this.fieldObjectReference = (JMSAddress)extensibilityElement;
            }
            catch (Exception exception) {
                Trc.exception(exception);
                throw new WSIFException("Could not create object of class '???todo??? '", exception);
            }
        }
        Trc.exit(this.fieldObjectReference);
        return this.fieldObjectReference;
    }

    public void setObjectReference(JMSAddress jMSAddress) {
        Trc.entry((Object)this, jMSAddress);
        this.fieldObjectReference = jMSAddress;
        Trc.exit();
    }

    public WSIFFormatter getFormatter() {
        Trc.entry(this);
        JMSFormatter jMSFormatter = new JMSFormatter(this.fieldDefinition, this.fieldPortModel);
        Trc.exit(jMSFormatter);
        return jMSFormatter;
    }

    public WSIFJMSDestination getJmsDestination() throws WSIFException {
        if (this.jmsDest == null) {
            this.jmsDest = new WSIFJMSDestination(WSIFJMSFinder.newFinder(this.getObjectReference(), this.fieldPortModel.getName()), this.getObjectReference().getJmsProvDestName(), WSIFProperties.getSyncTimeout());
        }
        return this.jmsDest;
    }

    public void close() throws WSIFException {
        Trc.entry(this);
        if (this.jmsDest != null) {
            this.jmsDest.close();
        }
        Trc.exit();
    }

    public String deep() {
        String string = "";
        try {
            string = new String(super.toString() + ":\n");
            string = string + "definition:" + Trc.brief(this.fieldDefinition);
            string = string + " portModel:" + Trc.brief(this.fieldPortModel);
            string = string + " objectReference:" + this.fieldObjectReference;
            string = string + " operationInstances: ";
            if (this.operationInstances == null) {
                string = string + "null";
            } else {
                string = string + "size:" + this.operationInstances.size();
                Iterator iterator = this.operationInstances.keySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    WSIFOperation_Jms wSIFOperation_Jms = (WSIFOperation_Jms)this.operationInstances.get(string2);
                    string = string + "\noperationInstances[" + n + "]:" + string2 + " " + wSIFOperation_Jms + " ";
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }
}

