/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apacheaxis;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory;
import org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.soap.apacheaxis.WSIFAXISUtils;

public class MIMEHelper {
    public static void registerAttachmentType(Call call, QName qName) {
        call.registerTypeMapping(DataHandler.class, qName, JAFDataHandlerSerializerFactory.class, JAFDataHandlerDeserializerFactory.class);
    }

    public static boolean addAttachementIfMIMEPart(Call call, Object object) {
        boolean bl;
        Trc.entry(null, call, object);
        if (object instanceof DataHandler) {
            call.addAttachmentPart((Object)new AttachmentPart((DataHandler)object));
            bl = true;
        } else {
            bl = false;
        }
        Trc.exit(new Boolean(bl));
        return bl;
    }

    public static AttachmentPart getAttachementPart(Object object) throws WSIFException {
        Trc.entry(null, object);
        AttachmentPart attachmentPart = null;
        if (object instanceof WSIFAttachmentPart) {
            attachmentPart = WSIFAXISUtils.wsifToAxisAttachmentPart((WSIFAttachmentPart)object);
        } else if (object instanceof DataHandler) {
            attachmentPart = new AttachmentPart((DataHandler)object);
        } else if (object instanceof AttachmentPart) {
            attachmentPart = (AttachmentPart)object;
        } else {
            throw new WSIFException("Object is not a DataHandler: " + object);
        }
        Trc.exit(attachmentPart);
        return attachmentPart;
    }

    public static void setMIMEMessagePart(WSIFMessage wSIFMessage, String string, Object object, Class clazz) throws WSIFException {
        Trc.entry(null, wSIFMessage, string, object, clazz);
        Class<?> clazz2 = object == null ? null : object.getClass();
        try {
            if (clazz2 != null && DataHandler.class.equals((Object)clazz) && AttachmentPart.class.isAssignableFrom(clazz2)) {
                AttachmentPart attachmentPart = (AttachmentPart)object;
                DataHandler dataHandler = attachmentPart.getDataHandler();
                wSIFMessage.setObjectPart(string, dataHandler);
            } else if (clazz2 != null && (String.class.equals((Object)clazz) || Image.class.equals((Object)clazz) || StreamSource.class.equals((Object)clazz) || DOMSource.class.equals((Object)clazz) || SAXSource.class.equals((Object)clazz) || MimeMultipart.class.equals((Object)clazz)) && AttachmentPart.class.isAssignableFrom(clazz2)) {
                AttachmentPart attachmentPart = (AttachmentPart)object;
                InputStream inputStream = attachmentPart.getDataHandler().getInputStream();
                if (String.class.equals((Object)clazz)) {
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    wSIFMessage.setObjectPart(string, new String(byArray));
                } else if (Image.class.equals((Object)clazz)) {
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    wSIFMessage.setObjectPart(string, new ImageIcon(byArray).getImage());
                } else if (StreamSource.class.equals((Object)clazz)) {
                    wSIFMessage.setObjectPart(string, new StreamSource(inputStream));
                } else {
                    if (DOMSource.class.equals((Object)clazz)) {
                        throw new WSIFException("DOMSource is not supported");
                    }
                    if (SAXSource.class.equals((Object)clazz)) {
                        throw new WSIFException("SAXSource is not supported");
                    }
                    if (MimeMultipart.class.equals((Object)clazz)) {
                        wSIFMessage.setObjectPart(string, new MimeMultipart(attachmentPart.getDataHandler().getDataSource()));
                    }
                }
            } else {
                if (clazz2 != null && clazz != null && !clazz.isPrimitive() && !clazz.isAssignableFrom(clazz2)) {
                    throw new WSIFException("return value " + object + " has unexpected type " + clazz2 + " instead of " + clazz);
                }
                wSIFMessage.setObjectPart(string, object);
            }
        }
        catch (SOAPException sOAPException) {
            Trc.exception(sOAPException);
            throw new WSIFException("WSIFOperation_ApacheAxis.setMessagePart messageName=" + (wSIFMessage.getName() == null ? "null" : wSIFMessage.getName()) + " partName=" + string + "  caught " + (Object)((Object)sOAPException));
        }
        catch (IOException iOException) {
            Trc.exception(iOException);
            throw new WSIFException("WSIFOperation_ApacheAxis.setMessagePart messageName=" + (wSIFMessage.getName() == null ? "null" : wSIFMessage.getName()) + " partName=" + string + "  caught " + iOException);
        }
        catch (MessagingException messagingException) {
            Trc.exception(messagingException);
            throw new WSIFException("WSIFOperation_ApacheAxis.setMessagePart messageName=" + (wSIFMessage.getName() == null ? "null" : wSIFMessage.getName()) + " partName=" + string + "  caught " + (Object)((Object)messagingException));
        }
        Trc.exit();
    }
}

