/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apacheaxis;

import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.wsif.WSIFException;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.logging.Trc;

public class WSIFAXISUtils {
    public static AttachmentPart wsifToAxisAttachmentPart(WSIFAttachmentPart wSIFAttachmentPart) throws WSIFException {
        Trc.entry(null, wSIFAttachmentPart);
        AttachmentPart attachmentPart = new AttachmentPart(wSIFAttachmentPart.getDataHandler());
        Iterator iterator = wSIFAttachmentPart.getPropertyIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ("Content-Id".equals(string)) {
                attachmentPart.setContentId(wSIFAttachmentPart.getProperty(string));
                continue;
            }
            if ("Content-Location".equals(string)) {
                attachmentPart.setContentLocation(wSIFAttachmentPart.getProperty(string));
                continue;
            }
            if ("Content-Type".equals(string)) {
                attachmentPart.setContentType(wSIFAttachmentPart.getProperty(string));
                continue;
            }
            attachmentPart.addMimeHeader(string, wSIFAttachmentPart.getProperty(string));
        }
        Trc.exit(attachmentPart);
        return attachmentPart;
    }

    public static WSIFAttachmentPart axisToWsifAttachmentPart(AttachmentPart attachmentPart) throws WSIFException {
        Trc.entry(null, attachmentPart);
        WSIFAttachmentPart wSIFAttachmentPart = null;
        try {
            wSIFAttachmentPart = new WSIFAttachmentPart(attachmentPart.getDataHandler());
        }
        catch (SOAPException sOAPException) {
            Trc.exception(sOAPException);
            throw new WSIFException("Could not convert WSIFAttachmentPart to Axis AttachmentPart. " + (Object)((Object)sOAPException));
        }
        Iterator iterator = attachmentPart.getAllMimeHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            wSIFAttachmentPart.setProperty(mimeHeader.getName(), mimeHeader.getValue());
        }
        Trc.exit(wSIFAttachmentPart);
        return wSIFAttachmentPart;
    }
}

