/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apacheaxis;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.soap.apacheaxis.WSIFPort_ApacheAxis;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.wsdl.extensions.jms.JMSExtensionRegistry;

public class WSIFDynamicProvider_ApacheAxis
implements WSIFProvider {
    private static final boolean axisAvailable = WSIFDynamicProvider_ApacheAxis.isAXISAvailable();
    private static final boolean jmsAvailable = WSIFDynamicProvider_ApacheAxis.isJMSAvailable();
    private static final String[] bindings = WSIFDynamicProvider_ApacheAxis.setUpBindingNamespaceURIs();
    private static final String[] addresses = WSIFDynamicProvider_ApacheAxis.setUpAddressNamespaceURIs();

    public WSIFDynamicProvider_ApacheAxis() {
        Trc.entry(this);
        if (axisAvailable && jmsAvailable) {
            WSIFServiceImpl.addExtensionRegistry(new JMSExtensionRegistry());
        }
        Trc.exit();
    }

    public WSIFPort createDynamicWSIFPort(Definition definition, Service service, Port port, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        Trc.entry(this, definition, service, port, wSIFDynamicTypeMap);
        Binding binding = port.getBinding();
        List list = binding.getExtensibilityElements();
        WSIFPort_ApacheAxis wSIFPort_ApacheAxis = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && wSIFPort_ApacheAxis == null) {
            Object e = iterator.next();
            if (!(e instanceof SOAPBinding)) continue;
            wSIFPort_ApacheAxis = new WSIFPort_ApacheAxis(definition, port, (SOAPBinding)e, wSIFDynamicTypeMap);
        }
        Trc.exit(wSIFPort_ApacheAxis);
        return wSIFPort_ApacheAxis;
    }

    public String[] getBindingNamespaceURIs() {
        Trc.entry(this);
        Trc.exit(bindings);
        return bindings;
    }

    public String[] getAddressNamespaceURIs() {
        Trc.entry(this);
        Trc.exit(addresses);
        return addresses;
    }

    private static String[] setUpBindingNamespaceURIs() {
        String[] stringArray = axisAvailable ? new String[]{"http://schemas.xmlsoap.org/wsdl/soap/"} : new String[]{};
        Trc.event("available binding namespace URIs: ", stringArray);
        return stringArray;
    }

    private static String[] setUpAddressNamespaceURIs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (WSIFDynamicProvider_ApacheAxis.isAXISAvailable()) {
            arrayList.add("http://schemas.xmlsoap.org/wsdl/soap/");
        }
        if (jmsAvailable) {
            arrayList.add("http://schemas.xmlsoap.org/wsdl/jms/");
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        Trc.event("available address namespace URIs: ", stringArray);
        return stringArray;
    }

    private static boolean isAXISAvailable() {
        return WSIFDynamicProvider_ApacheAxis.isClassAvailable("org.apache.axis.AxisEngine");
    }

    private static boolean isJMSAvailable() {
        return WSIFDynamicProvider_ApacheAxis.isClassAvailable("javax.jms.Queue");
    }

    private static boolean isClassAvailable(final String string) {
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable throwable) {
                    Trc.ignoredException(throwable);
                    return null;
                }
            }
        });
        return clazz != null;
    }
}

