/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apacheaxis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.soap.apacheaxis.WSIFOperation_ApacheAxis;
import org.apache.wsif.util.WSIFCorrelationServiceLocator;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.jms.WSIFJMSCorrelationId;
import org.apache.wsif.util.jms.WSIFJMSDestination;

public class WSIFJmsSender
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static final long SYNC_TIMEOUT = WSIFProperties.getSyncTimeout();
    private static final long ASYNC_TIMEOUT = WSIFProperties.getAsyncTimeout();
    private static final String DUMMY_RESPONSE = "<?xml version='1.0' encoding='UTF-8'?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\">\n<SOAP-ENV:Body>\n<ns1:addEntryResponse xmlns:ns1=\"http://wsifservice.addressbook/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n</ns1:addEntryResponse>\n\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>";

    public void invoke(MessageContext messageContext) throws AxisFault {
        Trc.entry((Object)this, messageContext);
        try {
            boolean bl = messageContext.isPropertyTrue("asyncOperation");
            WSIFJMSDestination wSIFJMSDestination = (WSIFJMSDestination)messageContext.getProperty("destination");
            Long l = (Long)messageContext.getProperty("syncTimeout");
            long l2 = l == null ? SYNC_TIMEOUT : l;
            Message message = messageContext.getRequestMessage();
            SOAPConstants sOAPConstants = messageContext.getSOAPConstants();
            String string = message.getContentType(sOAPConstants);
            wSIFJMSDestination.setProperty("WSIFContentType", string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)byteArrayOutputStream);
            String string2 = byteArrayOutputStream.toString();
            if (bl) {
                this.performAsyncSend(messageContext, wSIFJMSDestination, string2);
            } else {
                String string3 = wSIFJMSDestination.send(string2, null);
                String string4 = wSIFJMSDestination.receiveString(string3, l2);
                string = (String)wSIFJMSDestination.getProperty("WSIFContentType");
                String string5 = (String)wSIFJMSDestination.getProperty("WSIFContentLocation");
                Message message2 = string != null || string5 != null ? new Message((Object)new ByteArrayInputStream(string4.getBytes()), false, string, string5) : new Message((Object)string4);
                messageContext.setResponseMessage(message2);
            }
        }
        catch (IOException iOException) {
            Trc.exception(iOException);
            throw new AxisFault(iOException.toString());
        }
        catch (SOAPException sOAPException) {
            Trc.exception(sOAPException);
            throw new AxisFault(sOAPException.toString());
        }
        Trc.exit();
    }

    public void undo(MessageContext messageContext) {
        Trc.entry((Object)this, messageContext);
        Trc.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAsyncSend(MessageContext messageContext, WSIFJMSDestination wSIFJMSDestination, String string) throws WSIFException {
        Long l;
        String string2;
        WSIFOperation_ApacheAxis wSIFOperation_ApacheAxis = (WSIFOperation_ApacheAxis)messageContext.getProperty("wsifOperation");
        if (wSIFOperation_ApacheAxis.getResponseHandler() == null) {
            string2 = wSIFJMSDestination.send(string);
            WSIFJMSCorrelationId wSIFJMSCorrelationId = new WSIFJMSCorrelationId(string2);
        } else {
            WSIFCorrelationService wSIFCorrelationService;
            l = (Long)messageContext.getProperty("asyncTimeout");
            long l2 = l == null ? ASYNC_TIMEOUT : l;
            WSIFCorrelationService wSIFCorrelationService2 = wSIFCorrelationService = WSIFCorrelationServiceLocator.getCorrelationService();
            synchronized (wSIFCorrelationService2) {
                string2 = wSIFJMSDestination.send(string);
                WSIFJMSCorrelationId wSIFJMSCorrelationId = new WSIFJMSCorrelationId(string2);
                if (wSIFCorrelationService != null) {
                    wSIFCorrelationService.put(wSIFJMSCorrelationId, wSIFOperation_ApacheAxis, l2);
                }
            }
        }
        wSIFOperation_ApacheAxis.setAsyncRequestID(new WSIFJMSCorrelationId(string2));
        l = new Message((Object)DUMMY_RESPONSE);
        messageContext.setResponseMessage((Message)l);
    }
}

