/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apacheaxis;

import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Transport;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSDestination;

public class WSIFJmsTransport
extends Transport {
    private WSIFJMSDestination destination = null;
    private String asyncOperation = "false";
    private WSIFOperation wsifOperation = null;
    private Long syncTimeout = null;
    private Long asyncTimeout = null;
    public static final String DESTINATION = "destination";
    public static final String ASYNCOPERATION = "asyncOperation";
    public static final String WSIFOPERATION = "wsifOperation";
    public static final String SYNC_TIMEOUT = "syncTimeout";
    public static final String ASYNC_TIMEOUT = "asyncTimeout";

    public WSIFJmsTransport(WSIFJMSDestination wSIFJMSDestination) throws WSIFException {
        if (wSIFJMSDestination == null) {
            throw new WSIFException("destination is null");
        }
        this.destination = wSIFJMSDestination;
    }

    public void setDestination(WSIFJMSDestination wSIFJMSDestination) {
        Trc.entry((Object)this, wSIFJMSDestination);
        this.destination = wSIFJMSDestination;
        Trc.exit();
    }

    public void setAsyncOperation(String string) {
        Trc.entry((Object)this, string);
        this.asyncOperation = string;
        Trc.exit();
    }

    public void setWsifOperation(WSIFOperation wSIFOperation) {
        Trc.entry((Object)this, wSIFOperation);
        this.wsifOperation = wSIFOperation;
        Trc.exit();
    }

    public void setSyncTimeout(Long l) {
        Trc.entry((Object)this, l);
        this.syncTimeout = l;
        Trc.exit();
    }

    public void setAsyncTimeout(Long l) {
        Trc.entry((Object)this, l);
        this.asyncTimeout = l;
        Trc.exit();
    }

    public WSIFJMSDestination getDestination() {
        Trc.entry((Object)this);
        Trc.exit(this.destination);
        return this.destination;
    }

    public String getAsyncOperation() {
        Trc.entry((Object)this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    public WSIFOperation getWsifOperation() {
        Trc.entry((Object)this);
        Trc.exit(this.wsifOperation);
        return this.wsifOperation;
    }

    public Long getSyncTimeout() {
        Trc.entry((Object)this);
        Trc.exit(this.syncTimeout);
        return this.syncTimeout;
    }

    public Long getAsyncTimeout() {
        Trc.entry((Object)this);
        Trc.exit(this.asyncTimeout);
        return this.asyncTimeout;
    }

    public void setupMessageContextImpl(MessageContext messageContext, Call call, AxisEngine axisEngine) throws AxisFault {
        Trc.entry((Object)this, messageContext, call, axisEngine);
        messageContext.setTransportName("jms");
        if (this.destination != null) {
            messageContext.setProperty(DESTINATION, (Object)this.destination);
        }
        messageContext.setProperty(ASYNCOPERATION, (Object)new Boolean(this.asyncOperation));
        if (this.wsifOperation != null) {
            messageContext.setProperty(WSIFOPERATION, (Object)this.wsifOperation);
        }
        if (this.syncTimeout != null) {
            messageContext.setProperty(SYNC_TIMEOUT, (Object)this.syncTimeout);
        }
        if (this.asyncTimeout != null) {
            messageContext.setProperty(ASYNC_TIMEOUT, (Object)this.asyncTimeout);
        }
        Trc.exit();
    }

    public WSIFJmsTransport copy() throws WSIFException {
        Trc.entry((Object)this);
        WSIFJmsTransport wSIFJmsTransport = new WSIFJmsTransport(this.destination);
        wSIFJmsTransport.setAsyncOperation(this.asyncOperation);
        wSIFJmsTransport.setWsifOperation(this.wsifOperation);
        wSIFJmsTransport.setSyncTimeout(this.syncTimeout);
        wSIFJmsTransport.setAsyncTimeout(this.asyncTimeout);
        if (Trc.ON) {
            Trc.exit(wSIFJmsTransport.deep());
        }
        return wSIFJmsTransport;
    }

    public void close() throws WSIFException {
        Trc.entry((Object)this);
        if (this.destination == null) {
            throw new WSIFException("already closed");
        }
        this.destination.close();
        this.destination = null;
        Trc.exit();
    }

    public String deep() {
        String string = "";
        try {
            string = new String(super.toString() + ":\n");
            string = string + "destination:" + this.destination;
            string = string + "asyncOperation:" + this.asyncOperation;
            string = string + "wsifOperation:" + this.wsifOperation;
            string = string + "syncTimeout:" + this.syncTimeout;
            string = string + "asyncTimeout:" + this.asyncTimeout;
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }
}

