/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apacheaxis;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.jms.TextMessage;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.ArrayDeserializerFactory;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.encoding.ser.SimpleDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleSerializerFactory;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFaultElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.base.WSIFDefaultOperation;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.providers.soap.apacheaxis.MIMEHelper;
import org.apache.wsif.providers.soap.apacheaxis.WSIFAXISConstants;
import org.apache.wsif.providers.soap.apacheaxis.WSIFAXISUtils;
import org.apache.wsif.providers.soap.apacheaxis.WSIFJmsTransport;
import org.apache.wsif.providers.soap.apacheaxis.WSIFPort_ApacheAxis;
import org.apache.wsif.util.TypeSerializerInfo;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSIFOperation_ApacheAxis
extends WSIFDefaultOperation {
    private static final long serialVersionUID = 2L;
    protected transient WSIFPort_ApacheAxis wsifPort;
    protected transient Operation portTypeOperation;
    protected transient BindingOperation bindingOperation;
    protected transient SOAPOperation soapOperation;
    protected transient List inputSOAPParts;
    protected transient List inputUnwrappedSOAPParts;
    protected transient List inputMIMEParts;
    protected transient Part inputSOAPHeader;
    protected transient Part inputSOAPHeaderFault;
    protected List outputSOAPParts;
    protected List outputUnwrappedSOAPParts;
    protected List outputMIMEParts;
    protected Part outputSOAPHeader;
    protected Part outputSOAPHeaderFault;
    protected transient String inputEncodingStyle;
    protected transient String inputNamespace;
    protected transient String inputUse;
    protected transient String soapActionURI;
    protected transient HashMap responseMessageParameters;
    protected transient boolean asyncOperation;
    protected transient WSIFCorrelationId asyncRequestID;
    protected WSIFResponseHandler responseHandler;
    protected String outputEncodingStyle;
    protected WSIFDynamicTypeMap typeMap;
    protected String operationStyle;

    public WSIFOperation_ApacheAxis(WSIFPort_ApacheAxis wSIFPort_ApacheAxis, Operation operation, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        Trc.entry(this, wSIFPort_ApacheAxis, operation, wSIFDynamicTypeMap);
        this.wsifPort = wSIFPort_ApacheAxis;
        this.portTypeOperation = operation;
        this.typeMap = wSIFDynamicTypeMap;
        this.bindingOperation = this.getBindingOperation(operation);
        this.inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.outputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation_ApacheAxis copy() throws WSIFException {
        Trc.entry(this);
        WSIFOperation_ApacheAxis wSIFOperation_ApacheAxis = new WSIFOperation_ApacheAxis(this.wsifPort, this.portTypeOperation, this.typeMap);
        wSIFOperation_ApacheAxis.inputSOAPParts = this.inputSOAPParts;
        wSIFOperation_ApacheAxis.inputUnwrappedSOAPParts = this.inputUnwrappedSOAPParts;
        wSIFOperation_ApacheAxis.inputMIMEParts = this.inputMIMEParts;
        wSIFOperation_ApacheAxis.inputSOAPHeader = this.inputSOAPHeader;
        wSIFOperation_ApacheAxis.inputSOAPHeaderFault = this.inputSOAPHeaderFault;
        wSIFOperation_ApacheAxis.outputSOAPParts = this.outputSOAPParts;
        wSIFOperation_ApacheAxis.outputUnwrappedSOAPParts = this.outputUnwrappedSOAPParts;
        wSIFOperation_ApacheAxis.outputMIMEParts = this.outputMIMEParts;
        wSIFOperation_ApacheAxis.outputSOAPHeader = this.outputSOAPHeader;
        wSIFOperation_ApacheAxis.outputSOAPHeaderFault = this.outputSOAPHeaderFault;
        wSIFOperation_ApacheAxis.soapOperation = this.soapOperation;
        wSIFOperation_ApacheAxis.setSoapActionURI(this.getSoapActionURI());
        wSIFOperation_ApacheAxis.setInputNamespace(this.getInputNamespace());
        wSIFOperation_ApacheAxis.setInputEncodingStyle(this.getInputEncodingStyle());
        wSIFOperation_ApacheAxis.setInputUse(this.getInputUse());
        wSIFOperation_ApacheAxis.setOutputEncodingStyle(this.getOutputEncodingStyle());
        wSIFOperation_ApacheAxis.setAsyncOperation(this.isAsyncOperation());
        wSIFOperation_ApacheAxis.setResponseHandler(this.getResponseHandler());
        wSIFOperation_ApacheAxis.setInputJmsProperties(this.getInputJmsProperties());
        wSIFOperation_ApacheAxis.setOutputJmsProperties(this.getOutputJmsProperties());
        wSIFOperation_ApacheAxis.setInputJmsPropertyValues(this.getInputJmsPropertyValues());
        wSIFOperation_ApacheAxis.setOperationStyle(this.getOperationStyle());
        if (Trc.ON) {
            Trc.exit(wSIFOperation_ApacheAxis.deep());
        }
        return wSIFOperation_ApacheAxis;
    }

    private void parseSoapOperation() throws WSIFException {
        this.soapOperation = this.wsifPort.getSOAPOperation(this.bindingOperation);
        this.soapActionURI = this.soapOperation.getSoapActionURI();
        this.operationStyle = this.soapOperation.getStyle();
        if (this.operationStyle == null || this.operationStyle.length() < 1) {
            this.operationStyle = this.wsifPort.getBindingStyle();
        } else if (!WSIFAXISConstants.VALID_STYLES.contains(this.operationStyle)) {
            throw new WSIFException("unsupported style " + this.operationStyle + " for operation " + this.portTypeOperation.getName());
        }
        if (this.operationStyle == null || this.operationStyle.length() < 1) {
            this.operationStyle = "document";
        }
    }

    private void parseBindingInput() throws WSIFException {
        List list;
        MIMEMimeXml mIMEMimeXml;
        List list2;
        BindingInput bindingInput = this.bindingOperation.getBindingInput();
        SOAPBody sOAPBody = (SOAPBody)this.wsifPort.getExtElem(bindingInput, SOAPBody.class, list2 = bindingInput.getExtensibilityElements());
        if (sOAPBody != null) {
            this.inputSOAPParts = this.parseSoapBody(sOAPBody, true);
        }
        MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)this.wsifPort.getExtElem(bindingInput, MIMEMultipartRelated.class, list2);
        if (sOAPBody != null && mIMEMultipartRelated != null) {
            throw new WSIFException("In a binding operation that contains a mime:multipartRelated, a soap:body was found that was not in a mime:part. OperationName=" + this.getName());
        }
        if (sOAPBody == null && mIMEMultipartRelated == null) {
            throw new WSIFException("binding operation input must contain either a soap:body or a mime:multipartRelated element. OperationName=" + this.getName());
        }
        if (mIMEMultipartRelated != null) {
            this.parseMimeMultipart(mIMEMultipartRelated, true);
        }
        if ((mIMEMimeXml = (MIMEMimeXml)this.wsifPort.getExtElem(bindingInput, MIMEMimeXml.class, list2)) != null) {
            throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
        }
        this.parseSOAPHeaderElement(bindingInput);
        List list3 = this.wsifPort.getExtElems(bindingInput, JMSProperty.class, bindingInput.getExtensibilityElements());
        if (list3 != null && list3.size() > 0) {
            if (this.wsifPort.isTransportJMS()) {
                this.setInputJmsProperties(list3);
            } else {
                throw new WSIFException("jms:property found in non-jms binding");
            }
        }
        if ((list = this.wsifPort.getExtElems(bindingInput, JMSPropertyValue.class, bindingInput.getExtensibilityElements())) != null && list.size() > 0) {
            if (this.wsifPort.isTransportJMS()) {
                this.addInputJmsPropertyValues(list);
            } else {
                throw new WSIFException("jms:propertyValue found in non-jms binding");
            }
        }
    }

    private void parseBindingOutput() throws WSIFException {
        BindingOutput bindingOutput = this.bindingOperation.getBindingOutput();
        if (bindingOutput != null) {
            MIMEMimeXml mIMEMimeXml;
            List list = bindingOutput.getExtensibilityElements();
            SOAPBody sOAPBody = (SOAPBody)this.wsifPort.getExtElem(bindingOutput, SOAPBody.class, list);
            if (sOAPBody != null) {
                this.outputSOAPParts = this.parseSoapBody(sOAPBody, false);
            }
            MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)this.wsifPort.getExtElem(bindingOutput, MIMEMultipartRelated.class, list);
            if (sOAPBody != null && mIMEMultipartRelated != null) {
                throw new WSIFException("In a binding operation that contains a mime:multipartRelated, a soap:body was found that was not in a mime:part. OperationName=" + this.getName());
            }
            if (sOAPBody == null && mIMEMultipartRelated == null) {
                throw new WSIFException("binding operation output must contain either a soap:body or a mime:multipartRelated element. OperationName=" + this.getName());
            }
            if (mIMEMultipartRelated != null) {
                this.parseMimeMultipart(mIMEMultipartRelated, false);
            }
            if ((mIMEMimeXml = (MIMEMimeXml)this.wsifPort.getExtElem(bindingOutput, MIMEMimeXml.class, list)) != null) {
                throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
            }
            this.parseSOAPHeaderElement(bindingOutput);
            for (BindingFault bindingFault : this.bindingOperation.getBindingFaults().values()) {
                SOAPFault sOAPFault = (SOAPFault)this.wsifPort.getExtElem(bindingFault, SOAPFault.class, bindingFault.getExtensibilityElements());
            }
            List list2 = this.wsifPort.getExtElems(bindingOutput, JMSProperty.class, list);
            if (list2 != null && list2.size() > 0) {
                if (this.wsifPort.isTransportJMS()) {
                    this.setOutputJmsProperties(list2);
                } else {
                    throw new WSIFException("jms:properties found in non-jms binding");
                }
            }
        }
    }

    private void parseSOAPHeaderElement(Object object) throws WSIFException {
        List list;
        if (object instanceof BindingInput) {
            list = ((BindingInput)object).getExtensibilityElements();
        } else if (object instanceof BindingOutput) {
            list = ((BindingOutput)object).getExtensibilityElements();
        } else {
            throw new WSIFException("internal error, unexpected object: " + object);
        }
        Part part = null;
        Part part2 = null;
        javax.wsdl.extensions.soap.SOAPHeader sOAPHeader = (javax.wsdl.extensions.soap.SOAPHeader)this.wsifPort.getExtElem(object, javax.wsdl.extensions.soap.SOAPHeader.class, list);
        if (sOAPHeader != null) {
            QName qName = sOAPHeader.getMessage();
            if (qName == null) {
                throw new WSIFException("no message attribute on soap:header: " + sOAPHeader);
            }
            String string = sOAPHeader.getPart();
            if (string == null) {
                throw new WSIFException("no part attribute on soap:header: " + sOAPHeader);
            }
            part = this.getPart(qName, string);
            if (part == null) {
                throw new WSIFException("non existent part specified on soap:header: " + sOAPHeader);
            }
            SOAPHeaderFault sOAPHeaderFault = (SOAPHeaderFault)this.wsifPort.getExtElem(sOAPHeader, SOAPHeaderFault.class, list);
            if (sOAPHeaderFault != null) {
                qName = sOAPHeader.getMessage();
                if (qName == null) {
                    throw new WSIFException("no message attribute on soap:header: " + sOAPHeader);
                }
                string = sOAPHeader.getPart();
                if (string == null) {
                    throw new WSIFException("no part attribute on soap:header: " + sOAPHeader);
                }
                part2 = this.getPart(qName, string);
                if (part2 == null) {
                    throw new WSIFException("non existent part specified on soap:header: " + sOAPHeader);
                }
            }
        }
        if (object instanceof BindingInput) {
            this.inputSOAPHeader = part;
            this.inputSOAPHeaderFault = part2;
        } else {
            this.outputSOAPHeader = part;
            this.outputSOAPHeaderFault = part2;
        }
    }

    private List parseSoapBody(SOAPBody sOAPBody, boolean bl) throws WSIFException {
        Object object;
        List list;
        String string;
        Trc.entry(this, sOAPBody, new Boolean(bl));
        if (bl && (string = sOAPBody.getNamespaceURI()) != null) {
            this.setInputNamespace(sOAPBody.getNamespaceURI());
        }
        if (!WSIFAXISConstants.VALID_USES.contains(string = sOAPBody.getUse())) {
            throw new WSIFException("unsupported use " + string + " in " + this.soapOperation);
        }
        if (bl) {
            this.setInputUse(string);
        }
        if (bl && (list = sOAPBody.getEncodingStyles()) != null && list.size() > 0) {
            this.setInputEncodingStyle((String)list.get(0));
        }
        list = null;
        if (bl) {
            object = this.portTypeOperation.getInput();
            if (object != null) {
                list = object.getMessage();
            }
        } else {
            object = this.portTypeOperation.getOutput();
            if (object != null) {
                list = object.getMessage();
            }
        }
        object = this.getParts((javax.wsdl.Message)list, sOAPBody.getParts());
        Trc.exit(object);
        return object;
    }

    private ArrayList getParts(javax.wsdl.Message message, List list) throws WSIFException {
        ArrayList<Part> arrayList = new ArrayList<Part>();
        List list2 = null;
        if (message != null) {
            list2 = message.getOrderedParts(null);
        }
        if ((list2 == null || list2.size() < 1) && list != null && list.size() > 0) {
            throw new WSIFException("part '" + list.get(0) + "' not defined in message " + message);
        }
        if (list == null) {
            if (list2 != null) {
                arrayList.addAll(list2);
            }
        } else {
            for (String string : list) {
                Part part = message.getPart(string);
                if (part == null) {
                    throw new WSIFException("Part '" + string + "' in soap:body parts not in message " + message);
                }
                if (arrayList.contains(part)) continue;
                arrayList.add(part);
            }
        }
        return arrayList;
    }

    private void parseMimeMultipart(MIMEMultipartRelated mIMEMultipartRelated, boolean bl) throws WSIFException {
        Object object;
        Object object22;
        Trc.entry((Object)this, mIMEMultipartRelated);
        ArrayList<String> arrayList = new ArrayList<String>();
        SOAPBody sOAPBody = null;
        Operation operation = this.bindingOperation.getOperation();
        Map map = operation.getInput().getMessage().getParts();
        Map map2 = operation.getOutput() == null ? new HashMap() : operation.getOutput().getMessage().getParts();
        List list = mIMEMultipartRelated.getMIMEParts();
        for (Object object22 : list) {
            if (!(object22 instanceof MIMEPart)) continue;
            object = (MIMEPart)object22;
            if (!"http://schemas.xmlsoap.org/wsdl/mime/".equals(object.getElementType().getNamespaceURI())) {
                throw new WSIFException("A MIME part in binding operation " + this.bindingOperation.getName() + " did not have the correct namespace URI of " + "http://schemas.xmlsoap.org/wsdl/mime/" + ".");
            }
            boolean bl2 = false;
            boolean bl3 = false;
            List list2 = object.getExtensibilityElements();
            for (Object e : list2) {
                if (e instanceof MIMEContent) {
                    MIMEContent mIMEContent = (MIMEContent)e;
                    if (!"http://schemas.xmlsoap.org/wsdl/mime/".equals(object.getElementType().getNamespaceURI())) {
                        throw new WSIFException("A MIME part in binding operation " + this.bindingOperation.getName() + " did not have the correct namespace URI of " + "http://schemas.xmlsoap.org/wsdl/mime/" + ".");
                    }
                    bl3 = true;
                    if (bl2) {
                        throw new WSIFException("A mime:part that contains a mime:content also contains a soap:body. Operation=" + this.getName());
                    }
                    String string = mIMEContent.getPart();
                    if (string == null || string.length() == 0) {
                        throw new WSIFException("No part name for a mime:content. Operation=" + this.getName());
                    }
                    if (bl && map.get(string) == null || !bl && map2.get(string) == null) {
                        throw new WSIFException("The part specified in a mime:content does not exist in the operation. Operation=" + this.getName() + " Part=" + string);
                    }
                    arrayList.add(string);
                    continue;
                }
                if (e instanceof SOAPBody) {
                    if (sOAPBody != null) {
                        throw new WSIFException("Multiple soap:body tags found in a mime:multipartRelated. Operation=" + this.getName());
                    }
                    sOAPBody = (SOAPBody)e;
                    bl2 = true;
                    if (!bl3) continue;
                    throw new WSIFException("A mime:part that contains a mime:content also contains a soap:body. Operation=" + this.getName());
                }
                if (e instanceof MIMEMultipartRelated) {
                    throw new WSIFException("WSIF does not support nesting mime:multipartRelated inside a mime:part. Operation=" + this.getName());
                }
                if (!(e instanceof MIMEMimeXml)) continue;
                throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
            }
        }
        object22 = new ArrayList();
        if (arrayList != null && !arrayList.isEmpty()) {
            Input input;
            object = null;
            if (bl) {
                input = this.portTypeOperation.getInput();
                if (input != null) {
                    object = input.getMessage();
                }
            } else {
                input = this.portTypeOperation.getOutput();
                if (input != null) {
                    object = input.getMessage();
                }
            }
            object22 = this.getParts((javax.wsdl.Message)object, arrayList);
        }
        object = null;
        object = bl ? map : map2;
        List list3 = null;
        if (sOAPBody != null) {
            list3 = this.parseSoapBody(sOAPBody, bl);
            if (bl) {
                this.inputSOAPParts = list3;
            } else {
                this.outputSOAPParts = list3;
            }
        }
        if (bl) {
            this.inputMIMEParts = object22;
        } else {
            this.outputMIMEParts = object22;
        }
        Trc.exit();
    }

    private void unwrapSOAPParts() throws WSIFException {
        if ("document".equals(this.operationStyle)) {
            Object object;
            QName qName;
            String string = this.getName();
            if (this.inputSOAPParts.size() == 1 && (qName = (object = (Part)this.inputSOAPParts.get(0)).getElementName()) != null && string.equals(qName.getLocalPart())) {
                this.inputUnwrappedSOAPParts = ProviderUtils.unWrapPart((Part)object, this.getDefinition(), this.context);
            }
            if (this.outputSOAPParts.size() == 1) {
                object = string + "Response";
                qName = (Part)this.outputSOAPParts.get(0);
                QName qName2 = qName.getElementName();
                if (qName2 != null && ((String)object).equals(qName2.getLocalPart())) {
                    this.outputUnwrappedSOAPParts = ProviderUtils.unWrapPart((Part)qName, this.getDefinition(), this.context);
                }
            }
        }
    }

    private BindingOperation getBindingOperation(Operation operation) throws WSIFException {
        Binding binding = this.wsifPort.getPort().getBinding();
        BindingOperation bindingOperation = WSIFUtils.getBindingOperation(binding, operation);
        if (bindingOperation == null) {
            throw new WSIFException("cannot find binding operation for port operation:" + operation.getName());
        }
        return bindingOperation;
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Definition definition = this.wsifPort.getDefinition();
        Trc.exit(definition);
        return definition;
    }

    public WSIFPort_ApacheAxis getDynamicWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.wsifPort);
        return this.wsifPort;
    }

    public String getInputEncodingStyle() {
        Trc.entry(this);
        Trc.exit(this.inputEncodingStyle);
        return this.inputEncodingStyle;
    }

    public String getInputNamespace() {
        Trc.entry(this);
        Trc.exit(this.inputNamespace);
        return this.inputNamespace;
    }

    public String getInputUse() {
        return this.inputUse;
    }

    protected void setInputUse(String string) {
        this.inputUse = string;
    }

    public String getName() {
        Trc.entry(this);
        String string = this.portTypeOperation.getName();
        Trc.exit(string);
        return string;
    }

    public Operation getOperation() {
        Trc.entry(this);
        Operation operation = this.getPortTypeOperation();
        Trc.exit(operation);
        return operation;
    }

    private Part getPart(QName qName, String string) {
        Part part = null;
        Definition definition = this.wsifPort.getDefinition();
        javax.wsdl.Message message = definition.getMessage(qName);
        if (message != null) {
            part = message.getPart(string);
        }
        return part;
    }

    public Operation getPortTypeOperation() {
        Trc.entry(this);
        Trc.exit(this.portTypeOperation);
        return this.portTypeOperation;
    }

    public String getOutputEncodingStyle() {
        Trc.entry(this);
        Trc.exit(this.outputEncodingStyle);
        return this.outputEncodingStyle;
    }

    public String getSoapActionURI() {
        Trc.entry(this);
        Trc.exit(this.soapActionURI);
        return this.soapActionURI;
    }

    public Transport getTransport() throws WSIFException {
        Trc.entry(this);
        Transport transport = this.wsifPort.getTransport();
        Trc.exit(transport);
        return transport;
    }

    public WSIFCorrelationId getAsyncRequestID() {
        Trc.entry(this);
        Trc.exit(this.asyncRequestID);
        return this.asyncRequestID;
    }

    private HashMap getResponseMessageParameters() {
        return this.responseMessageParameters;
    }

    public WSIFPort getWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.wsifPort);
        return this.wsifPort;
    }

    public boolean isAsyncOperation() {
        Trc.entry(this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    public void executeInputOnlyOperation(WSIFMessage wSIFMessage) throws WSIFException {
        Trc.entry((Object)this, wSIFMessage);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("input message is null");
        }
        this.setAsyncOperation(false);
        this.invokeRequestResponseOperation(wSIFMessage, null, null);
        Trc.exit();
    }

    public boolean executeRequestResponseOperation(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Trc.entry(this, wSIFMessage, wSIFMessage2, wSIFMessage3);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("input message is null");
        }
        if (wSIFMessage2 == null) {
            throw new IllegalArgumentException("output message is null");
        }
        if (wSIFMessage3 == null) {
            throw new IllegalArgumentException("fault message is null");
        }
        this.close();
        this.setAsyncOperation(false);
        boolean bl = this.invokeRequestResponseOperation(wSIFMessage, wSIFMessage2, wSIFMessage3);
        Trc.exit(bl);
        return bl;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage) throws WSIFException {
        Trc.entry((Object)this, wSIFMessage);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("input message is null");
        }
        WSIFCorrelationId wSIFCorrelationId = this.executeRequestResponseAsync(wSIFMessage, null);
        Trc.exit(wSIFCorrelationId);
        return wSIFCorrelationId;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage, WSIFResponseHandler wSIFResponseHandler) throws WSIFException {
        Trc.entry(this, wSIFMessage, wSIFResponseHandler);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("input message is null");
        }
        this.close();
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not available");
        }
        this.setAsyncOperation(true);
        this.setResponseHandler(wSIFResponseHandler);
        WSIFJmsTransport wSIFJmsTransport = (WSIFJmsTransport)this.getTransport();
        wSIFJmsTransport.setWsifOperation(this);
        wSIFJmsTransport.setAsyncOperation("true");
        this.invokeRequestResponseOperation(wSIFMessage, null, null);
        wSIFJmsTransport.setAsyncOperation("false");
        WSIFCorrelationId wSIFCorrelationId = this.getAsyncRequestID();
        Trc.exit(wSIFCorrelationId);
        return wSIFCorrelationId;
    }

    public void fireAsyncResponse(Object object) throws WSIFException {
        Trc.entry((Object)this, object);
        Object object2 = this.deserialiseResponseObject(object);
        WSIFMessage wSIFMessage = this.createOutputMessage();
        WSIFMessage wSIFMessage2 = this.createFaultMessage();
        this.buildResponseMessages(object2, wSIFMessage, wSIFMessage2);
        this.getResponseHandler().executeAsyncResponse(wSIFMessage, wSIFMessage2);
        Trc.exit(wSIFMessage);
    }

    public boolean processAsyncResponse(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        Trc.entry(this, object, wSIFMessage, wSIFMessage2);
        Object object2 = this.deserialiseResponseObject(object);
        boolean bl = this.buildResponseMessages(object2, wSIFMessage, wSIFMessage2);
        Trc.exit(bl);
        return bl;
    }

    private Object deserialiseResponseObject(Object object) throws WSIFException {
        if (object == null) {
            throw new WSIFException("null response to async send");
        }
        if (!(object instanceof TextMessage)) {
            throw new WSIFException("response not a javax.jms.TextMessage");
        }
        try {
            TextMessage textMessage = (TextMessage)object;
            Message message = new Message((Object)textMessage.getText());
            message.setMessageType("response");
            Service service = new Service();
            MessageContext messageContext = new MessageContext(service.getEngine());
            messageContext.setResponseMessage(message);
            TypeMappingRegistry typeMappingRegistry = messageContext.getTypeMappingRegistry();
            TypeMapping typeMapping = (TypeMapping)typeMappingRegistry.getTypeMapping(this.outputEncodingStyle);
            WSIFOperation_ApacheAxis.registerDefaultTypeMappings(typeMapping, this.getContext());
            WSIFOperation_ApacheAxis.registerDynamicTypes(typeMapping, this.typeMap, this.getContext());
            Message message2 = messageContext.getResponseMessage();
            SOAPEnvelope sOAPEnvelope = message2.getSOAPEnvelope();
            SOAPBodyElement sOAPBodyElement = sOAPEnvelope.getFirstBody();
            if (sOAPBodyElement instanceof SOAPFaultElement) {
                return new AxisFault(sOAPBodyElement.toString());
            }
            RPCElement rPCElement = (RPCElement)sOAPBodyElement;
            String string = null;
            Vector vector = rPCElement.getParams();
            if (vector != null && vector.size() > 0) {
                RPCParam rPCParam = (RPCParam)vector.get(0);
                string = rPCParam.getValue();
                if (vector.size() > 1) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int i = 1; i < vector.size(); ++i) {
                        RPCParam rPCParam2 = (RPCParam)vector.get(i);
                        hashMap.put(rPCParam2.getName(), rPCParam2.getValue());
                    }
                    this.setResponseMessageParameters(hashMap);
                }
            }
            return string;
        }
        catch (Exception exception) {
            Trc.exception(exception);
            throw new WSIFException(exception.getMessage());
        }
    }

    private boolean buildResponseMessages(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        boolean bl;
        if (object instanceof AxisFault) {
            bl = false;
            if (wSIFMessage2 != null) {
                AxisFault axisFault = (AxisFault)object;
                Element element = axisFault.getFaultDetails()[0];
                String string = element.getNamespaceURI();
                String string2 = element.getLocalName();
                QName qName = new QName(string, string2);
                Map map = this.portTypeOperation.getFaults();
                for (Fault fault : map.values()) {
                    javax.wsdl.Message message = fault.getMessage();
                    Map map2 = message.getParts();
                    Part part = (Part)map2.values().iterator().next();
                    if (!part.getElementName().equals(qName)) continue;
                    wSIFMessage2.setName(message.getQName().getLocalPart());
                    wSIFMessage2.setObjectPart(part.getName(), element);
                    wSIFMessage2.setMessageDefinition(message);
                    break;
                }
                if (wSIFMessage2.getName() == null) {
                    wSIFMessage2.setName("org.apache.wsif.soap.fault");
                    wSIFMessage2.setObjectPart("org.apache.wsif.soap.fault.object", (Object)axisFault);
                }
            }
        } else {
            bl = true;
            this.populateOutMsgReturnPart(object, wSIFMessage);
            this.populateOutMsgParts(wSIFMessage);
        }
        return bl;
    }

    private void populateOutMsgReturnPart(Object object, WSIFMessage wSIFMessage) throws WSIFException {
        if (wSIFMessage != null) {
            List list = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
            Part part = null;
            if (list.size() > 0) {
                part = (Part)list.get(0);
                WSIFOperation_ApacheAxis.setSOAPMessagePart(wSIFMessage, part.getName(), object);
            } else if (this.outputMIMEParts.size() > 0) {
                part = (Part)this.outputMIMEParts.get(0);
                WSIFOperation_ApacheAxis.setMIMEMessagePart(wSIFMessage, part.getName(), object, object == null ? null : object.getClass());
            }
        }
    }

    private void populateOutMsgParts(WSIFMessage wSIFMessage) throws WSIFException {
        HashMap hashMap;
        if (wSIFMessage != null && (hashMap = this.getResponseMessageParameters()) != null) {
            Object object;
            String string;
            int n;
            List list = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
            if (!this.outputMIMEParts.isEmpty()) {
                list = new ArrayList(list);
                list.removeAll(this.outputMIMEParts);
            }
            for (n = 1; n < list.size(); ++n) {
                Part part = (Part)list.get(n);
                string = part.getName();
                object = hashMap.get(string);
                WSIFOperation_ApacheAxis.setSOAPMessagePart(wSIFMessage, string, object);
            }
            n = list.size() > 0 ? 0 : 1;
            for (int i = n; i < this.outputMIMEParts.size(); ++i) {
                Object v;
                string = (Part)this.outputMIMEParts.get(i);
                WSIFOperation_ApacheAxis.setMIMEMessagePart(wSIFMessage, object, v, (v = hashMap.get(object = string.getName())) == null ? null : v.getClass());
            }
        }
    }

    private static void setSOAPMessagePart(WSIFMessage wSIFMessage, String string, Object object) throws WSIFException {
        Trc.entry(null, wSIFMessage, string, object);
        wSIFMessage.setObjectPart(string, object);
        Trc.exit();
    }

    private static void setMIMEMessagePart(WSIFMessage wSIFMessage, String string, Object object, Class clazz) throws WSIFException {
        Trc.entry(null, wSIFMessage, string, object, clazz);
        MIMEHelper.setMIMEMessagePart(wSIFMessage, string, object, clazz);
        Trc.exit();
    }

    private QName getPartType(Part part) {
        QName qName = part.getTypeName();
        if (qName == null) {
            qName = part.getElementName();
        }
        return qName;
    }

    protected boolean invokeRequestResponseOperation(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Object object;
        Trc.entry(this, wSIFMessage, wSIFMessage2, wSIFMessage3);
        boolean bl = false;
        Call call = this.wsifPort.getCall();
        call.removeAllParameters();
        call.clearHeaders();
        call.setTargetEndpointAddress(this.wsifPort.getEndPoint());
        if (this.inputSOAPParts == null) {
            this.prepare(call);
        }
        call.setSOAPActionURI(this.getSoapActionURI());
        this.operationStyle = this.getOperationStyle(wSIFMessage);
        Transport transport = this.getTransport();
        WSIFJMSDestination wSIFJMSDestination = null;
        if (transport != null) {
            call.setTransport(transport);
            if (transport instanceof WSIFJmsTransport) {
                object = (WSIFJmsTransport)transport;
                wSIFJMSDestination = ((WSIFJmsTransport)((Object)object)).getDestination();
                wSIFJMSDestination.setAsyncMode(this.isAsyncOperation());
                ((WSIFJmsTransport)((Object)object)).setSyncTimeout(null);
                ((WSIFJmsTransport)((Object)object)).setAsyncTimeout(null);
            }
        }
        if (wSIFJMSDestination != null && this.inJmsPropVals != null && !this.inJmsPropVals.isEmpty()) {
            this.checkForTimeoutProperties(this.inJmsPropVals, wSIFJMSDestination);
            wSIFJMSDestination.setProperties(this.inJmsPropVals);
        }
        this.setDestinationContext(wSIFJMSDestination);
        this.setCallContext(call);
        object = WSIFProperties.getProperty("wsif.syncrequest.timeout");
        if (object != null && ((String)object).length() > 0) {
            Integer n = new Integer(0);
            try {
                n = Integer.valueOf((String)object);
                if (n < 0) {
                    n = new Integer(0);
                }
                call.setTimeout(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        bl = "message".equals(this.operationStyle) ? this.invokeAXISMessaging(call, wSIFMessage, wSIFMessage2, wSIFMessage3) : ("rpc".equals(this.operationStyle) ? this.invokeAXISRPCStyle(call, wSIFMessage, wSIFMessage2, wSIFMessage3, wSIFJMSDestination) : this.invokeAXISDocStyle(call, wSIFMessage, wSIFMessage2, wSIFMessage3));
        this.setResponseContext(call);
        Trc.exit(bl);
        return bl;
    }

    protected String getOperationStyle(WSIFMessage wSIFMessage) {
        String string;
        block3: {
            string = this.operationStyle;
            try {
                WSIFMessage wSIFMessage2 = this.getContext();
                string = (String)wSIFMessage2.getObjectPart("org.apache.wsif.axis.operationStyle");
            }
            catch (WSIFException wSIFException) {
                Trc.ignoredException(wSIFException);
                if ("document".equals(this.operationStyle) && this.isInputMessageUnWrapped(wSIFMessage)) {
                    string = "wrapped";
                }
                if (!this.isMessaging(wSIFMessage)) break block3;
                string = "message";
            }
        }
        return string;
    }

    private boolean isInputMessageUnWrapped(WSIFMessage wSIFMessage) {
        Object object;
        boolean bl = true;
        Object object2 = null;
        try {
            object = this.getContext();
            object2 = object.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        if ("wrapped".equals(object2)) {
            bl = true;
        } else if ("unwrapped".equals(object2)) {
            bl = false;
        } else if (this.inputUnwrappedSOAPParts != null && this.inputUnwrappedSOAPParts.size() > 0) {
            bl = true;
            object = this.inputUnwrappedSOAPParts.iterator();
            while (object.hasNext() && bl) {
                Part part = (Part)object.next();
                try {
                    wSIFMessage.getObjectPart(part.getName());
                }
                catch (WSIFException wSIFException) {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isMessaging(WSIFMessage wSIFMessage) {
        boolean bl = true;
        boolean bl2 = false;
        if (wSIFMessage != null) {
            for (Part part : this.inputSOAPParts) {
                try {
                    Object object = wSIFMessage.getObjectPart(part.getName());
                    if (object instanceof Element) {
                        bl2 = true;
                        continue;
                    }
                    bl = false;
                }
                catch (WSIFException wSIFException) {
                    Trc.ignoredException(wSIFException);
                }
            }
        }
        return bl2 && bl;
    }

    private boolean invokeAXISRPCStyle(Call call, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3, WSIFJMSDestination wSIFJMSDestination) throws WSIFException {
        Object object;
        call.setOperationName(new QName(this.getInputNamespace(), this.portTypeOperation.getName()));
        this.setCallParameterNames(call);
        Object[] objectArray = this.getInputMessageValues(wSIFMessage, wSIFJMSDestination);
        this.addUnreferencedAttachments(call);
        Object object2 = null;
        boolean bl = true;
        try {
            object = this.portTypeOperation.getName();
            Trc.event(this, "Invoking operation ", object, " input namespace ", this.getInputNamespace(), " parameters ", objectArray, " call object ", call);
            object2 = call.invoke(this.getInputNamespace(), (String)object, objectArray);
        }
        catch (AxisFault axisFault) {
            Trc.exception(axisFault);
            object2 = axisFault;
            bl = false;
        }
        Trc.event(this, "Returned from operation, response ", object2);
        if (!this.isAsyncOperation()) {
            if ((this.outputSOAPParts.size() > 0 || this.outputMIMEParts.size() > 0) && (object = call.getOutputParams()) != null) {
                HashMap hashMap = new HashMap();
                for (QName qName : object.keySet()) {
                    hashMap.put(qName.getLocalPart(), object.get(qName));
                }
                this.setResponseMessageParameters(hashMap);
            }
            bl = this.buildResponseMessages(object2, wSIFMessage2, wSIFMessage3);
            this.setResponseUnreferencedAttachments(call, wSIFMessage2);
        }
        return bl;
    }

    private void setCallParameterNames(Call call) throws WSIFException {
        int n;
        QName qName;
        QName qName2;
        String string;
        boolean bl = ProviderUtils.isUnwrapable(this.getPortTypeOperation());
        String string2 = "literal".equals(this.getInputUse()) && !bl || "encoded".equals(this.getInputUse()) ? "" : this.getInputNamespace();
        String string3 = "";
        List list = "wrapped".equals(this.operationStyle) ? this.inputUnwrappedSOAPParts : this.inputSOAPParts;
        List list2 = this.inputMIMEParts.isEmpty() ? list : this.portTypeOperation.getInput().getMessage().getOrderedParts(null);
        for (Object object : list2) {
            string = object.getName();
            if ("document".equals(this.operationStyle) && (qName2 = object.getElementName()) != null) {
                string = qName2.getLocalPart();
            }
            if (this.inJmsProps.containsKey(string) || !this.inputMIMEParts.contains(object) && !list.contains(object)) continue;
            qName2 = new QName(string2, string);
            qName = this.getPartType((Part)object);
            call.addParameter(qName2, qName, ParameterMode.IN);
        }
        list = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
        Part part = null;
        if (list.size() > 0) {
            part = (Part)list.get(0);
        } else if (this.outputMIMEParts.size() > 0) {
            part = (Part)this.outputMIMEParts.get(0);
        }
        if (part == null) {
            call.setReturnType(XMLType.AXIS_VOID);
        } else {
            Object object;
            object = this.getPartType(part);
            call.setReturnType((QName)object);
        }
        for (n = 1; n < list.size(); ++n) {
            string = (Part)list.get(n);
            qName2 = new QName(string3, string.getName());
            qName = this.getPartType((Part)string);
            call.addParameter(qName2, qName, ParameterMode.OUT);
        }
        for (int i = n = list.size() > 0 ? 0 : 1; i < this.outputMIMEParts.size(); ++i) {
            qName2 = (Part)this.outputMIMEParts.get(i);
            qName = new QName(string3, qName2.getName());
            QName qName3 = this.getPartType((Part)qName2);
            call.addParameter(qName, qName3, ParameterMode.OUT);
        }
    }

    private boolean invokeAXISDocStyle(Call call, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Object object;
        boolean bl = false;
        call.setOperationName(new QName(this.wsifPort.getPortTypeNamespace(), this.portTypeOperation.getName()));
        call.setProperty("sendXsiTypes", (Object)Boolean.FALSE);
        call.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        call.setOperationStyle(this.operationStyle);
        this.setCallParameterNames(call);
        Object[] objectArray = this.getInputMessageValues(wSIFMessage, null);
        this.addUnreferencedAttachments(call);
        Trc.event(this, "Invoking AXIS call", call, objectArray);
        try {
            object = call.invoke(objectArray);
            bl = true;
        }
        catch (RemoteException remoteException) {
            Trc.exception(remoteException);
            throw new WSIFException("exception on AXIS invoke: " + remoteException.getLocalizedMessage(), remoteException);
        }
        Trc.event(this, "Returned from AXIS invoke, response: ", object);
        if (!this.isAsyncOperation()) {
            List list = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
            if (list.size() > 0 || this.outputMIMEParts.size() > 0) {
                Map map = call.getOutputParams();
                if (map != null) {
                    HashMap hashMap = new HashMap();
                    for (QName qName : map.keySet()) {
                        hashMap.put(qName.getLocalPart(), map.get(qName));
                    }
                    this.setResponseMessageParameters(hashMap);
                }
                bl = this.buildResponseMessages(object, wSIFMessage2, wSIFMessage3);
            }
            this.setResponseUnreferencedAttachments(call, wSIFMessage2);
        }
        return bl;
    }

    private boolean invokeAXISMessaging(Call call, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Object object;
        boolean bl = true;
        List list = this.addReferencedAttachments(wSIFMessage, call);
        this.addUnreferencedAttachments(call);
        Object[] objectArray = this.getInputMessageValues(wSIFMessage, null);
        ArrayList<SOAPBodyElement> arrayList = new ArrayList<SOAPBodyElement>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Element) {
                object = (Element)objectArray[i];
                if (list.size() > 0 && i == 0) {
                    this.fixAttachmentPartsCID((Element)object, list);
                }
            } else {
                throw new WSIFException("unexpected input type: " + objectArray[i]);
            }
            arrayList.add(new SOAPBodyElement((Element)object));
        }
        Object[] objectArray2 = arrayList.toArray();
        Trc.event(this, "Invoking AXIS call", call, objectArray2);
        try {
            object = call.invoke(objectArray2);
        }
        catch (RemoteException remoteException) {
            Trc.exception(remoteException);
            object = remoteException;
            bl = false;
        }
        Trc.event(this, "Returned from AXIS invoke, response: ", object);
        if (bl) {
            this.setOutputMessageValues(object, wSIFMessage2);
            this.setResponseUnreferencedAttachments(call, wSIFMessage2);
        } else {
            bl = this.buildResponseMessages(object, wSIFMessage2, wSIFMessage3);
        }
        return bl;
    }

    private void fixAttachmentPartsCID(Element element, List list) throws WSIFException {
        ArrayList arrayList = new ArrayList();
        WSIFOperation_ApacheAxis.getAttachmentElements(arrayList, element);
        if (arrayList.size() != list.size()) {
            throw new WSIFException("unexpected number of attachments," + list.size() + " AttachmentParts, " + arrayList.size() + " attachment href elements");
        }
        for (int i = 0; i < list.size(); ++i) {
            AttachmentPart attachmentPart = (AttachmentPart)list.get(i);
            Element element2 = (Element)arrayList.get(i);
            element2.setAttribute("href", "cid:" + attachmentPart.getContentId());
        }
    }

    private static void getAttachmentElements(ArrayList arrayList, Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute("href");
            if (string != null && string.toLowerCase().startsWith("cid:")) {
                arrayList.add(element2);
                continue;
            }
            WSIFOperation_ApacheAxis.getAttachmentElements(arrayList, element2);
        }
    }

    private void prepare(Call call) throws WSIFException {
        Trc.entry((Object)this, call);
        this.inputSOAPParts = new ArrayList();
        this.inputMIMEParts = new ArrayList();
        this.outputSOAPParts = new ArrayList();
        this.outputMIMEParts = new ArrayList();
        this.parseSoapOperation();
        this.parseBindingInput();
        this.parseBindingOutput();
        this.unwrapSOAPParts();
        this.addInputJmsPropertyValues(this.wsifPort.getJmsAddressPropVals());
        if (!"rpc".equals(this.operationStyle)) {
            call.setEncodingStyle(null);
            this.inputEncodingStyle = "";
            this.outputEncodingStyle = "";
        }
        if (this.inputNamespace == null || this.inputNamespace.length() < 1) {
            this.inputNamespace = this.getTargetNamespaceURI();
        }
        TypeMapping typeMapping = call.getTypeMapping();
        WSIFMessage wSIFMessage = this.getContext();
        WSIFOperation_ApacheAxis.registerDefaultTypeMappings(typeMapping, wSIFMessage);
        WSIFOperation_ApacheAxis.registerDynamicTypes(typeMapping, this.typeMap, wSIFMessage);
        this.registerMIMETypes(this.inputMIMEParts, call);
        this.registerMIMETypes(this.outputMIMEParts, call);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    static void registerDefaultTypeMappings(TypeMapping typeMapping, WSIFMessage wSIFMessage) throws WSIFException {
        Object object = null;
        try {
            object = wSIFMessage.getObjectPart("org.apache.wsif.axis.default.type.serializers");
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            throw new WSIFException("context part 'org.apache.wsif.axis.default.type.serializers' value is not an instance of java.util.List: " + object);
        }
        List list = (List)object;
        for (Object e : list) {
            if (!(e instanceof TypeSerializerInfo)) {
                throw new WSIFException("context part 'org.apache.wsif.axis.default.type.serializers' value List contains an entry that is not an instance of org.apache.wsif.util.TypeSerializer: " + object);
            }
            TypeSerializerInfo typeSerializerInfo = (TypeSerializerInfo)e;
            Class clazz = typeSerializerInfo.getJavaType();
            QName qName = typeSerializerInfo.getElementType();
            Object object2 = typeSerializerInfo.getSerializer();
            SerializerFactory serializerFactory = null;
            if (object2 instanceof SerializerFactory) {
                serializerFactory = (SerializerFactory)object2;
            }
            object2 = typeSerializerInfo.getDeserializer();
            DeserializerFactory deserializerFactory = null;
            if (object2 instanceof DeserializerFactory) {
                deserializerFactory = (DeserializerFactory)object2;
            }
            if (clazz != null && qName != null && (serializerFactory != null || deserializerFactory != null)) {
                typeMapping.register(clazz, qName, (javax.xml.rpc.encoding.SerializerFactory)serializerFactory, (javax.xml.rpc.encoding.DeserializerFactory)deserializerFactory);
                continue;
            }
            Trc.event(null, "ignoring default TypeSerializer invalid for AXIS:" + typeSerializerInfo);
        }
    }

    static void registerDynamicTypes(TypeMapping typeMapping, WSIFDynamicTypeMap wSIFDynamicTypeMap, WSIFMessage wSIFMessage) throws WSIFException {
        Iterator iterator = wSIFDynamicTypeMap.iterator();
        while (iterator.hasNext()) {
            String string;
            WSIFDynamicTypeMapping wSIFDynamicTypeMapping = (WSIFDynamicTypeMapping)iterator.next();
            Class clazz = wSIFDynamicTypeMapping.getJavaType();
            QName qName = wSIFDynamicTypeMapping.getXmlType();
            Object object = null;
            Object object2 = null;
            TypeSerializerInfo typeSerializerInfo = WSIFOperation_ApacheAxis.findContextTypeSerialzer(wSIFMessage, clazz, qName);
            if (typeSerializerInfo != null) {
                clazz = typeSerializerInfo.getJavaType();
                qName = typeSerializerInfo.getElementType();
                object = (SerializerFactory)typeSerializerInfo.getSerializer();
                object2 = (DeserializerFactory)typeSerializerInfo.getDeserializer();
            }
            if (object == null && typeMapping.getSerializer(clazz, qName) == null) {
                object = clazz.isArray() ? new ArraySerializerFactory() : (SimpleType.class.isAssignableFrom(clazz) ? new SimpleSerializerFactory(clazz, qName) : new BeanSerializerFactory(clazz, qName));
            }
            if (object2 == null && typeMapping.getDeserializer(clazz, qName) == null) {
                object2 = clazz.isArray() ? new ArrayDeserializerFactory() : (SimpleType.class.isAssignableFrom(clazz) ? new SimpleDeserializerFactory(clazz, qName) : new BeanDeserializerFactory(clazz, qName));
            }
            if (WSIFOperation_ApacheAxis.isDefaultSOAPNamespace(string = wSIFDynamicTypeMapping.getXmlType().getNamespaceURI())) continue;
            String string2 = wSIFDynamicTypeMapping.getXmlType().getLocalPart();
            QName qName2 = new QName(string, string2);
            if (object == null && object2 == null) continue;
            typeMapping.register(clazz, qName2, (javax.xml.rpc.encoding.SerializerFactory)object, (javax.xml.rpc.encoding.DeserializerFactory)object2);
        }
    }

    private static TypeSerializerInfo findContextTypeSerialzer(WSIFMessage wSIFMessage, Class clazz, QName qName) throws WSIFException {
        Object object = null;
        try {
            object = wSIFMessage.getObjectPart("org.apache.wsif.axis.type.serializers");
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        if (object == null) {
            return null;
        }
        if (!(object instanceof List)) {
            throw new WSIFException("context part 'org.apache.wsif.axis.type.serializers' value is not an instance of java.util.List: " + object);
        }
        List list = (List)object;
        for (Object e : list) {
            if (!(e instanceof TypeSerializerInfo)) {
                throw new WSIFException("context part 'org.apache.wsif.axis.type.serializers' value List contains an entry that is not an instance of org.apache.wsif.util.TypeSerializer: " + object);
            }
            TypeSerializerInfo typeSerializerInfo = (TypeSerializerInfo)e;
            Class clazz2 = typeSerializerInfo.getJavaType();
            QName qName2 = typeSerializerInfo.getElementType();
            Object object2 = typeSerializerInfo.getSerializer();
            Object object3 = typeSerializerInfo.getDeserializer();
            if (clazz2 == null || !clazz2.isAssignableFrom(clazz) || qName2 == null || !qName2.equals(qName) || object2 != null && !(object2 instanceof SerializerFactory) || object3 != null && !(object3 instanceof DeserializerFactory) || object2 == null && object3 == null) continue;
            return typeSerializerInfo;
        }
        return null;
    }

    private static boolean isDefaultSOAPNamespace(String string) {
        boolean bl = false;
        if ("http://www.w3.org/1999/XMLSchema".equals(string) || "http://www.w3.org/2000/10/XMLSchema".equals(string) || "http://www.w3.org/2001/XMLSchema".equals(string) || "http://schemas.xmlsoap.org/soap/encoding/".equals(string)) {
            bl = true;
        }
        return bl;
    }

    private Object[] getInputMessageValues(WSIFMessage wSIFMessage, WSIFJMSDestination wSIFJMSDestination) throws WSIFException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = "wrapped".equals(this.operationStyle) ? this.inputUnwrappedSOAPParts : this.inputSOAPParts;
        if (this.inputMIMEParts.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Part part = (Part)list.get(i);
                String string = part.getName();
                try {
                    object = wSIFMessage.getObjectPart(string);
                }
                catch (WSIFException wSIFException) {
                    Trc.ignoredException(wSIFException);
                    object = null;
                }
                if (this.inJmsProps.containsKey(string) && wSIFJMSDestination != null) {
                    String string2 = (String)this.inJmsProps.get(string);
                    if (this.timeoutProperty(wSIFJMSDestination, string2, object)) continue;
                    wSIFJMSDestination.setProperty(string2, object);
                    continue;
                }
                arrayList.add(object);
            }
        } else {
            List list2 = this.portTypeOperation.getInput().getMessage().getOrderedParts(null);
            for (Part part : list2) {
                Object object;
                Object object2;
                String string = part.getName();
                if (!list.contains(part) && (!this.inputMIMEParts.contains(part) || "message".equals(this.operationStyle))) continue;
                try {
                    object2 = wSIFMessage.getObjectPart(string);
                }
                catch (WSIFException wSIFException) {
                    Trc.ignoredException(wSIFException);
                    object2 = null;
                }
                if (this.inJmsProps.containsKey(string) && wSIFJMSDestination != null) {
                    object = (String)this.inJmsProps.get(string);
                    if (this.timeoutProperty(wSIFJMSDestination, (String)object, object2)) continue;
                    wSIFJMSDestination.setProperty((String)object, object2);
                    continue;
                }
                if (object2 instanceof WSIFAttachmentPart) {
                    object = (WSIFAttachmentPart)object2;
                    arrayList.add(((WSIFAttachmentPart)object).getDataHandler());
                    continue;
                }
                arrayList.add(object2);
            }
        }
        return arrayList.toArray();
    }

    private List addReferencedAttachments(WSIFMessage wSIFMessage, Call call) throws WSIFException {
        Trc.entry(this, wSIFMessage, call);
        ArrayList<AttachmentPart> arrayList = new ArrayList<AttachmentPart>();
        for (int i = 0; i < this.inputMIMEParts.size(); ++i) {
            Part part = (Part)this.inputMIMEParts.get(i);
            try {
                String string = part.getName();
                Object object = wSIFMessage.getObjectPart(string);
                AttachmentPart attachmentPart = MIMEHelper.getAttachementPart(object);
                call.addAttachmentPart((Object)attachmentPart);
                arrayList.add(attachmentPart);
                continue;
            }
            catch (WSIFException wSIFException) {
                throw new WSIFException("attachment part '" + part.getName() + "' not in input WSIFMessage");
            }
        }
        Trc.exit(arrayList);
        return arrayList;
    }

    private void addUnreferencedAttachments(Call call) throws WSIFException {
        Trc.entry((Object)this, call);
        if (WSIFProperties.areUnreferencedAttachmentsSupported()) {
            Object object;
            List list = null;
            try {
                object = this.getContext();
                if (object != null) {
                    list = (List)object.getObjectPart("org.apache.wsif.attachments.request.unreferenced_attachment_parts");
                }
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
            }
            if (list != null && !list.isEmpty()) {
                object = list.listIterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    AttachmentPart attachmentPart = MIMEHelper.getAttachementPart(e);
                    call.addAttachmentPart((Object)attachmentPart);
                }
            }
        }
        Trc.exit();
    }

    private void setResponseUnreferencedAttachments(Call call, WSIFMessage wSIFMessage) throws WSIFException {
        Trc.entry(this, call, wSIFMessage);
        if (WSIFProperties.areUnreferencedAttachmentsSupported()) {
            Object object;
            HashSet<String> hashSet = null;
            ArrayList<WSIFAttachmentPart> arrayList = new ArrayList<WSIFAttachmentPart>();
            MessageContext messageContext = call.getMessageContext();
            Message message = messageContext.getResponseMessage();
            Iterator iterator = message.getAttachments();
            while (iterator.hasNext()) {
                object = iterator.next();
                AttachmentPart attachmentPart = MIMEHelper.getAttachementPart(object);
                String string = attachmentPart.getContentId();
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    Iterator iterator2 = wSIFMessage.getPartNames();
                    while (iterator2.hasNext()) {
                        String string2 = (String)iterator2.next();
                        Object object2 = wSIFMessage.getObjectPart(string2);
                        AttachmentPart attachmentPart2 = null;
                        try {
                            attachmentPart2 = MIMEHelper.getAttachementPart(object2);
                        }
                        catch (WSIFException wSIFException) {
                            Trc.ignoredException(wSIFException);
                        }
                        if (attachmentPart2 == null) continue;
                        hashSet.add(attachmentPart2.getContentId());
                    }
                }
                if (hashSet.contains(string)) continue;
                arrayList.add(WSIFAXISUtils.axisToWsifAttachmentPart(attachmentPart));
            }
            if (!arrayList.isEmpty()) {
                object = this.getContext();
                object.setObjectPart("org.apache.wsif.attachments.response.unreferenced_attachment_parts", arrayList);
                this.setContext((WSIFMessage)object);
            }
        }
        Trc.exit();
    }

    private void setOutputMessageValues(Object object, WSIFMessage wSIFMessage) throws WSIFException {
        if (!(object instanceof Vector)) {
            throw new WSIFException("expect response type of java.util.Vector of SOAPBodyElement, found: " + object);
        }
        Vector vector = (Vector)object;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof RPCElement) {
                RPCElement rPCElement = (RPCElement)vector.elementAt(i);
                QName qName = new QName(rPCElement.getNamespaceURI(), rPCElement.getName());
                Part part = this.findPart(this.outputSOAPParts, qName);
                if (part != null) {
                    this.setSOAPPart(wSIFMessage, rPCElement, part);
                    continue;
                }
                this.setAttachmentPart(wSIFMessage, rPCElement);
                continue;
            }
            throw new WSIFException("expecting response type org.w3c.dom.Element, found: " + vector.elementAt(i));
        }
    }

    private void setSOAPPart(WSIFMessage wSIFMessage, RPCElement rPCElement, Part part) throws WSIFException {
        Element element = null;
        try {
            element = rPCElement.getAsDOM();
        }
        catch (Exception exception) {
            throw new WSIFException("exception getting soap body as DOM: " + exception.getLocalizedMessage(), exception);
        }
        String string = part.getName();
        wSIFMessage.setObjectPart(string, element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAttachmentPart(WSIFMessage wSIFMessage, RPCElement rPCElement) throws WSIFException {
        Vector vector;
        try {
            vector = rPCElement.getParams();
        }
        catch (SAXException sAXException) {
            throw new WSIFException("SAXException getting response MIME part: " + sAXException.getLocalizedMessage(), sAXException);
        }
        if (vector == null || vector.size() < 1) {
            throw new WSIFException("no attachments found in response element: " + rPCElement);
        }
        RPCParam rPCParam = (RPCParam)vector.get(0);
        QName qName = rPCParam.getQName();
        Part part = this.findPart(this.outputMIMEParts, qName);
        if (part == null) throw new WSIFException("cannot find a WSDL output MIME part for response element: " + rPCElement);
        String string = rPCParam.getValue();
        if (!(string instanceof AttachmentPart)) throw new WSIFException("expecting response AttachmentPart but found: " + string);
        try {
            DataHandler dataHandler = ((AttachmentPart)string).getDataHandler();
            String string2 = part.getName();
            wSIFMessage.setObjectPart(string2, dataHandler);
            return;
        }
        catch (SOAPException sOAPException) {
            throw new WSIFException("SOAPException getting DataHandler from AttachmentPart: " + sOAPException.getLocalizedMessage(), sOAPException);
        }
    }

    private Part findPart(List list, QName qName) {
        Part part = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && part == null) {
            Part part2 = (Part)iterator.next();
            if (qName.equals(part2.getElementName())) {
                part = part2;
                continue;
            }
            if (!qName.getLocalPart().equals(part2.getName())) continue;
            part = part2;
        }
        return part;
    }

    private void registerMIMETypes(List list, Call call) {
        if (list != null && !list.isEmpty()) {
            for (Part part : list) {
                QName qName = this.getPartType(part);
                MIMEHelper.registerAttachmentType(call, qName);
            }
        }
    }

    private void setResponseHandler(WSIFResponseHandler wSIFResponseHandler) {
        this.responseHandler = wSIFResponseHandler;
    }

    WSIFResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setDefinition(Definition definition) {
        Trc.entry((Object)this, definition);
        throw new RuntimeException("method nolonger supported");
    }

    public void setDynamicWSIFPort(WSIFPort_ApacheAxis wSIFPort_ApacheAxis) {
        Trc.entry((Object)this, wSIFPort_ApacheAxis);
        this.wsifPort = wSIFPort_ApacheAxis;
        Trc.exit();
    }

    public void setInputEncodingStyle(String string) {
        Trc.entry((Object)this, string);
        this.inputEncodingStyle = string;
        Trc.exit();
    }

    public void setInputNamespace(String string) {
        Trc.entry((Object)this, string);
        this.inputNamespace = string;
        Trc.exit();
    }

    public void setOperation(Operation operation) {
        Trc.entry((Object)this, operation);
        this.portTypeOperation = operation;
        Trc.exit();
    }

    public void setOutputEncodingStyle(String string) {
        Trc.entry((Object)this, string);
        this.outputEncodingStyle = string;
        Trc.exit();
    }

    public void setSoapActionURI(String string) {
        Trc.entry((Object)this, string);
        this.soapActionURI = string;
        Trc.exit();
    }

    private void setResponseMessageParameters(HashMap hashMap) {
        this.responseMessageParameters = hashMap;
    }

    private void setAsyncOperation(boolean bl) {
        this.asyncOperation = bl;
    }

    public String getTargetNamespaceURI() {
        Trc.entry(this);
        Definition definition = this.getDefinition();
        String string = definition == null ? "" : definition.getTargetNamespace();
        Trc.exit(string);
        return string;
    }

    private void setJMSOutPropsInContext(WSIFJMSDestination wSIFJMSDestination) throws WSIFException {
        if (wSIFJMSDestination == null) {
            return;
        }
        HashMap hashMap = wSIFJMSDestination.getProperties();
        if (hashMap != null) {
            this.getContext().setParts(hashMap);
        }
    }

    private void setDestinationContext(WSIFJMSDestination wSIFJMSDestination) throws WSIFException {
        if (wSIFJMSDestination == null) {
            return;
        }
        WSIFMessage wSIFMessage = this.getContext();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = wSIFMessage.getPartNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Object object = wSIFMessage.getObjectPart(string);
                if (this.timeoutProperty(wSIFJMSDestination, string, object) || !string.startsWith("JMSProperty.")) continue;
                String string2 = string.substring("JMSProperty.".length());
                hashMap.put(string2, object);
            }
            catch (WSIFException wSIFException) {
                Trc.ignoredException(wSIFException);
            }
        }
        if (hashMap.size() > 0) {
            wSIFJMSDestination.setProperties(hashMap);
        }
    }

    private void setCallContext(Call call) throws WSIFException {
        Object object;
        WSIFMessage wSIFMessage = this.getContext();
        String string = "org.apache.wsif.http.UserName";
        try {
            object = wSIFMessage.getObjectPart(string);
            if (object instanceof String) {
                this.addHTTPHeader(call, string, (String)object);
            }
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        string = "org.apache.wsif.http.Password";
        try {
            object = wSIFMessage.getObjectPart(string);
            if (object instanceof String) {
                this.addHTTPHeader(call, string, (String)object);
            }
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        try {
            string = "org.apache.wsif.soap.RequestHeaders";
            object = wSIFMessage.getObjectPart(string);
            if (object instanceof List) {
                this.addSOAPHeader(call, string, (List)object);
            }
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        object = null;
        try {
            string = "org.apache.wsif.http.RequestHeaders";
            object = wSIFMessage.getObjectPart(string);
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        if (object != null) {
            if (object != null && object instanceof Hashtable) {
                call.setProperty("HTTP-Request-Headers", (Object)((Hashtable)object));
            } else {
                throw new WSIFException("value type must be java.util.Hashtable for context part 'org.apache.wsif.http.RequestHeaders'");
            }
        }
        this.setProxyUserFromContext(wSIFMessage);
    }

    private void setProxyUserFromContext(WSIFMessage wSIFMessage) throws WSIFException {
        String string;
        String string2;
        block7: {
            string2 = null;
            string = null;
            try {
                Object object = wSIFMessage.getObjectPart("org.apache.wsif.http.proxy.UserName");
                if (object != null) {
                    if (object instanceof String) {
                        string2 = (String)object;
                    } else {
                        throw new WSIFException("invalid value type for context part 'org.apache.wsif.http.proxy.UserName', found value: " + object);
                    }
                }
                if ((object = wSIFMessage.getObjectPart("org.apache.wsif.http.proxy.Password")) == null) break block7;
                if (object instanceof String) {
                    string = (String)object;
                    break block7;
                }
                throw new WSIFException("invalid value type for context part 'org.apache.wsif.http.proxy.Password', found value: " + object);
            }
            catch (WSIFException wSIFException) {
                Trc.ignoredException(wSIFException);
            }
        }
        if (string2 != null) {
            AxisProperties.setProperty((String)"http.proxyUser", string2);
            AxisProperties.setProperty((String)"http.proxyPassword", string);
        }
    }

    private void setResponseContext(Call call) throws WSIFException {
        Message message = call.getResponseMessage();
        if (message != null) {
            SOAPEnvelope sOAPEnvelope;
            try {
                sOAPEnvelope = message.getSOAPEnvelope();
            }
            catch (AxisFault axisFault) {
                throw new WSIFException("AxisFault getting response SOAP envelope", axisFault);
            }
            if (sOAPEnvelope != null) {
                SOAPHeader sOAPHeader;
                try {
                    sOAPHeader = sOAPEnvelope.getHeader();
                }
                catch (SOAPException sOAPException) {
                    throw new WSIFException("SOAPException getting response headers from SOAP envelope", sOAPException);
                }
                this.addContextResponseSOAPHeaders(sOAPHeader);
            }
        }
    }

    private void addSOAPHeader(Call call, String string, List list) {
        for (Object e : list) {
            if (!(e instanceof Element)) continue;
            call.addHeader(new SOAPHeaderElement((Element)e));
        }
    }

    private void addContextResponseSOAPHeaders(SOAPHeader sOAPHeader) throws WSIFException {
        if (sOAPHeader != null) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            Object object = sOAPHeader.getChildElements();
            while (object.hasNext()) {
                Object e = object.next();
                if (e instanceof SOAPHeaderElement) {
                    SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)e;
                    try {
                        arrayList.add(sOAPHeaderElement.getAsDOM());
                        continue;
                    }
                    catch (Exception exception) {
                        throw new WSIFException("exception getting response SOAP header", exception);
                    }
                }
                Trc.event("unexpected response SOAP header type: ", e);
            }
            if (arrayList.size() > 0) {
                object = this.getContext();
                object.setObjectPart("org.apache.wsif.soap.ResponseHeaders", arrayList);
                this.setContext((WSIFMessage)object);
            }
        }
    }

    private void addHTTPHeader(Call call, String string, String string2) {
        if (string.equals("org.apache.wsif.http.UserName")) {
            call.setProperty("javax.xml.rpc.security.auth.username", (Object)string2);
        } else if (string.equals("org.apache.wsif.http.Password")) {
            call.setProperty("javax.xml.rpc.security.auth.password", (Object)string2);
        }
    }

    private void checkForTimeoutProperties(HashMap hashMap, WSIFJMSDestination wSIFJMSDestination) throws WSIFException {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            String string = (String)iterator.next();
            if (!this.timeoutProperty(wSIFJMSDestination, string, v = hashMap.get(string))) continue;
            iterator.remove();
        }
    }

    private boolean timeoutProperty(WSIFJMSDestination wSIFJMSDestination, String string, Object object) throws WSIFException {
        boolean bl = false;
        try {
            if ("wsif.syncrequest.timeout".equals(string)) {
                bl = true;
                Long l = new Long(object.toString());
                WSIFJmsTransport wSIFJmsTransport = (WSIFJmsTransport)this.getTransport();
                wSIFJmsTransport.setSyncTimeout(l);
                Trc.event(this, "overridding syncTimeout to " + l);
            } else if ("wsif.asyncrequest.timeout".equals(string)) {
                bl = true;
                Long l = new Long(object.toString());
                WSIFJmsTransport wSIFJmsTransport = (WSIFJmsTransport)this.getTransport();
                wSIFJmsTransport.setAsyncTimeout(l);
                Trc.event(this, "overridding asyncTimeout to " + l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Trc.ignoredException(numberFormatException);
        }
        return bl;
    }

    private static boolean isPrimitiveOf(Class clazz, Class clazz2) {
        return clazz2.equals(Boolean.TYPE) && Boolean.class.isAssignableFrom(clazz) || clazz2.equals(Character.TYPE) && Character.class.isAssignableFrom(clazz) || clazz2.equals(Byte.TYPE) && Byte.class.isAssignableFrom(clazz) || clazz2.equals(Short.TYPE) && Short.class.isAssignableFrom(clazz) || clazz2.equals(Integer.TYPE) && Integer.class.isAssignableFrom(clazz) || clazz2.equals(Long.TYPE) && Long.class.isAssignableFrom(clazz) || clazz2.equals(Float.TYPE) && Float.class.isAssignableFrom(clazz) || clazz2.equals(Double.TYPE) && Double.class.isAssignableFrom(clazz);
    }

    void setAsyncRequestID(WSIFCorrelationId wSIFCorrelationId) {
        Trc.entry((Object)this, wSIFCorrelationId);
        this.asyncRequestID = wSIFCorrelationId;
        Trc.exit();
    }

    public String getStyle() {
        return this.operationStyle;
    }

    public String getOperationStyle() {
        return this.operationStyle;
    }

    public void setStyle(String string) {
        this.operationStyle = string;
    }

    public void setOperationStyle(String string) {
        this.operationStyle = string;
    }

    public String deep() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(super.toString()).append(":\n");
            stringBuffer.append("wsifPort:").append(this.wsifPort);
            stringBuffer.append(" portTypeOperation:").append(Trc.brief(this.portTypeOperation));
            stringBuffer.append(" bindingOperation:").append(this.bindingOperation);
            stringBuffer.append(" soapOperation:").append(this.soapOperation);
            stringBuffer.append(" operationStyle:").append(this.operationStyle);
            stringBuffer.append(" inputSOAPParts:").append(this.inputSOAPParts);
            stringBuffer.append(" inputUnwrappedSOAPParts:").append(this.inputUnwrappedSOAPParts);
            stringBuffer.append(" inputMIMEParts:").append(this.inputMIMEParts);
            stringBuffer.append(" inputSOAPHeader:").append(this.inputSOAPHeader);
            stringBuffer.append(" inputSOAPHeaderFault:").append(this.inputSOAPHeaderFault);
            stringBuffer.append(" outputSOAPParts:").append(this.outputSOAPParts);
            stringBuffer.append(" outputUnwrappedSOAPParts:").append(this.outputUnwrappedSOAPParts);
            stringBuffer.append(" outputMIMEParts:").append(this.outputMIMEParts);
            stringBuffer.append(" outputSOAPHeader:").append(this.outputSOAPHeader);
            stringBuffer.append(" outputSOAPHeaderFault:").append(this.outputSOAPHeaderFault);
            stringBuffer.append(" inputEncodingStyle:").append(this.inputEncodingStyle);
            stringBuffer.append(" inputNamespace:").append(this.inputNamespace);
            stringBuffer.append(" actionUri:").append(this.soapActionURI);
            stringBuffer.append(" inJmsProps:").append(this.inJmsProps);
            stringBuffer.append(" outJmsProps:").append(this.outJmsProps);
            stringBuffer.append(" inJmsPropVals:").append(this.inJmsPropVals);
            stringBuffer.append(" context:").append(this.context);
            stringBuffer.append(" asyncOperation:").append(this.asyncOperation);
            stringBuffer.append(" asyncRequestID:").append(this.asyncRequestID);
            stringBuffer.append(" responseHandler:").append(this.responseHandler);
            stringBuffer.append(" responseMessageParameters:").append(this.responseMessageParameters);
            stringBuffer.append(" outputEncodingStyle:").append(this.outputEncodingStyle);
            stringBuffer.append(" typeMap:").append(this.typeMap);
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return stringBuffer.toString();
    }
}

