/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apacheaxis;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.transport.http.HTTPTransport;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.base.WSIFDefaultPort;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.soap.apacheaxis.WSIFAXISConstants;
import org.apache.wsif.providers.soap.apacheaxis.WSIFJmsTransport;
import org.apache.wsif.providers.soap.apacheaxis.WSIFOperation_ApacheAxis;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;

public class WSIFPort_ApacheAxis
extends WSIFDefaultPort {
    private static final long serialVersionUID = 2L;
    protected Definition definition;
    protected Port port;
    protected SOAPBinding soapBinding;
    protected SOAPAddress soapAddress;
    protected JMSAddress jmsAddress;
    protected String bindingStyle;
    protected URL endPointURL;
    protected List jmsAddressPropVals;
    protected WSIFDynamicTypeMap wsifdynamictypemap;
    protected Map cachedWSIFOperations;
    protected transient Transport transport;
    protected transient Call call;
    private static final String HTTP_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/http";
    private static final String JMS_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/jms";

    public WSIFPort_ApacheAxis(Definition definition, Port port, SOAPBinding sOAPBinding, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        Trc.entry(this, definition, port, sOAPBinding, wSIFDynamicTypeMap);
        this.definition = definition;
        this.port = port;
        this.soapBinding = sOAPBinding;
        this.wsifdynamictypemap = wSIFDynamicTypeMap;
        this.parseSoapBinding();
        this.parseServiceAddress();
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    private void parseSoapBinding() throws WSIFException {
        this.bindingStyle = this.soapBinding.getStyle();
        if (this.bindingStyle == null || this.bindingStyle.length() < 1) {
            this.bindingStyle = "document";
        } else if (!WSIFAXISConstants.VALID_STYLES.contains(this.bindingStyle)) {
            throw new WSIFException("unsupported style '" + this.bindingStyle + "' for binding:" + this.soapBinding);
        }
        String string = this.soapBinding.getTransportURI();
        if (!WSIFAXISConstants.VALID_TRANSPORTS.contains(string)) {
            throw new WSIFException("unsupported transport '" + string + "' for binding: " + this.soapBinding);
        }
    }

    private void parseServiceAddress() throws WSIFException {
        this.soapAddress = (SOAPAddress)this.getExtElem(this.port, SOAPAddress.class, this.port.getExtensibilityElements());
        this.jmsAddress = (JMSAddress)this.getExtElem(this.port, JMSAddress.class, this.port.getExtensibilityElements());
        if (this.soapAddress != null && this.jmsAddress != null) {
            throw new WSIFException("Both soap:address and jms:address cannot be specified for port " + this.port);
        }
        if (this.soapAddress == null && this.jmsAddress == null) {
            throw new WSIFException("Either soap:address or jms:address must be specified for port " + this.port);
        }
        if (this.isTransportHTTP() && this.soapAddress == null) {
            throw new WSIFException("binding transport http://schemas.xmlsoap.org/soap/http requires soap:address for port " + this.port);
        }
        if (this.soapAddress != null) {
            String string = this.soapAddress.getLocationURI();
            if (string == null || string.length() < 1) {
                throw new WSIFException("soap:address with location URI is required for " + this.port);
            }
            if (string.startsWith("jms:")) {
                this.jmsAddress = WSIFJMSDestination.getJMSAddressFromURL(string);
                this.soapAddress = null;
            } else {
                try {
                    this.endPointURL = new URL(string);
                    if (this.endPointURL.getPort() == -1 && "https".equals(this.endPointURL.getProtocol())) {
                        URL uRL = new URL(string);
                        this.endPointURL = new URL("https", uRL.getHost(), 443, uRL.getFile());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Trc.exception(malformedURLException);
                    throw new WSIFException("exception setting SOAP address to " + string + ": " + malformedURLException.getLocalizedMessage(), malformedURLException);
                }
            }
        }
        if (this.isTransportJMS() && this.jmsAddress == null) {
            throw new WSIFException("binding transport http://schemas.xmlsoap.org/soap/jms requires jms:address for port " + this.port);
        }
        if (this.jmsAddress != null) {
            this.jmsAddressPropVals = this.jmsAddress.getJMSPropertyValues();
        }
    }

    public WSIFOperation createOperation(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        WSIFOperation wSIFOperation = this.createOperation(string, null, null);
        Trc.exit(wSIFOperation);
        return wSIFOperation;
    }

    public WSIFOperation createOperation(String string, String string2, String string3) throws WSIFException {
        Trc.entry(this, string, string2, string3);
        WSIFOperation_ApacheAxis wSIFOperation_ApacheAxis = this.getDynamicWSIFOperation(string, string2, string3);
        if (wSIFOperation_ApacheAxis == null) {
            throw new WSIFException("Could not create operation: " + string + ":" + string2 + ":" + string3);
        }
        Trc.exit(wSIFOperation_ApacheAxis);
        return wSIFOperation_ApacheAxis;
    }

    public void close() throws WSIFException {
        Trc.entry(this);
        if (this.transport != null && this.transport instanceof WSIFJmsTransport) {
            ((WSIFJmsTransport)this.transport).close();
        }
        Trc.exit();
    }

    public Transport getAxisTransport() throws WSIFException {
        Trc.entry(this);
        Transport transport = this.getTransport();
        Trc.exit(transport);
        return transport;
    }

    public QName getBindingName() {
        Trc.entry(this);
        Binding binding = this.port.getBinding();
        QName qName = binding.getQName();
        Trc.exit(qName);
        return qName;
    }

    public String getBindingStyle() {
        Trc.entry(this);
        Trc.exit(this.bindingStyle);
        return this.bindingStyle;
    }

    public String getPortTypeNamespace() {
        Trc.entry(this);
        String string = this.port.getBinding().getPortType().getQName().getNamespaceURI();
        Trc.exit(string);
        return string;
    }

    public Call getCall() throws WSIFException {
        Trc.entry(this);
        if (this.call == null) {
            this.call = this.makeNewAXISCall();
        }
        Trc.exit(this.call);
        return this.call;
    }

    private Call makeNewAXISCall() throws WSIFException {
        Call call = null;
        URL uRL = this.getEndPoint();
        try {
            if (uRL != null) {
                call = new Call(uRL);
                Transport transport = this.getTransport();
                if (transport != null) {
                    transport.setUrl(uRL.toString());
                }
            } else {
                call = new Call(new Service());
            }
            call.setMaintainSession(true);
        }
        catch (JAXRPCException jAXRPCException) {
            Trc.exception(jAXRPCException);
            throw new WSIFException("exception creating call object: " + jAXRPCException.getLocalizedMessage(), jAXRPCException);
        }
        return call;
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.definition);
        return this.definition;
    }

    public WSIFOperation_ApacheAxis getDynamicWSIFOperation(String string, String string2, String string3) throws WSIFException {
        WSIFOperation_ApacheAxis wSIFOperation_ApacheAxis;
        Trc.entry(this, string, string2, string3);
        WSIFOperation_ApacheAxis wSIFOperation_ApacheAxis2 = null;
        if (this.cachedWSIFOperations == null) {
            this.cachedWSIFOperations = new HashMap();
        } else {
            wSIFOperation_ApacheAxis2 = (WSIFOperation_ApacheAxis)this.cachedWSIFOperations.get(this.getKey(string, string2, string3));
        }
        if (wSIFOperation_ApacheAxis2 == null) {
            BindingOperation bindingOperation = WSIFUtils.getBindingOperation(this.port.getBinding(), string, string2, string3);
            if (bindingOperation == null) {
                throw new WSIFException("no operation found named " + string + ", input:" + string2 + ", output:" + string3);
            }
            wSIFOperation_ApacheAxis2 = new WSIFOperation_ApacheAxis(this, bindingOperation.getOperation(), this.wsifdynamictypemap);
            this.cachedWSIFOperations.put(this.getKey(string, string2, string3), wSIFOperation_ApacheAxis2);
            wSIFOperation_ApacheAxis = wSIFOperation_ApacheAxis2;
        } else {
            wSIFOperation_ApacheAxis = wSIFOperation_ApacheAxis2.copy();
        }
        Trc.exit(wSIFOperation_ApacheAxis);
        return wSIFOperation_ApacheAxis;
    }

    public URL getEndPoint() {
        Trc.entry(this);
        Trc.exit(this.endPointURL);
        return this.endPointURL;
    }

    public Object getExtElem(Object object, Class clazz, List list) throws WSIFException {
        Trc.entry(this, object, clazz, list);
        Object object2 = super.getExtElem(object, clazz, list);
        Trc.exit(object2);
        return object2;
    }

    public List getExtElems(Object object, Class clazz, List list) throws WSIFException {
        Trc.entry(this, object, clazz, list);
        List list2 = super.getExtElems(object, clazz, list);
        Trc.exit(list2);
        return list2;
    }

    public List getJmsAddressPropVals() {
        Trc.entry(this);
        Trc.exit(this.jmsAddressPropVals);
        return this.jmsAddressPropVals;
    }

    public Port getPort() {
        Trc.entry(this);
        Trc.exit(this.port);
        return this.port;
    }

    public SOAPOperation getSOAPOperation(BindingOperation bindingOperation) throws WSIFException {
        Trc.entry((Object)this, bindingOperation);
        SOAPOperation sOAPOperation = (SOAPOperation)this.getExtElem(bindingOperation, SOAPOperation.class, bindingOperation.getExtensibilityElements());
        if (sOAPOperation == null) {
            throw new WSIFException("no soap:operation found in binding for: " + bindingOperation);
        }
        Trc.exit(sOAPOperation);
        return sOAPOperation;
    }

    public Transport getTransport() throws WSIFException {
        Trc.entry(this);
        if (this.transport == null) {
            String string = this.soapBinding.getTransportURI();
            if (HTTP_TRANSPORT_URI.equals(string)) {
                this.transport = new HTTPTransport();
            } else if (JMS_TRANSPORT_URI.equals(string)) {
                WSIFJMSDestination wSIFJMSDestination = new WSIFJMSDestination(WSIFJMSFinder.newFinder(this.jmsAddress, this.port.getName()), this.jmsAddress.getJmsProvDestName(), WSIFProperties.getSyncTimeout());
                this.transport = new WSIFJmsTransport(wSIFJMSDestination);
            }
        }
        Trc.exit(this.transport);
        return this.transport;
    }

    public boolean isTransportHTTP() {
        Trc.entry(this);
        String string = this.soapBinding.getTransportURI();
        boolean bl = HTTP_TRANSPORT_URI.equals(string);
        Trc.exit(bl);
        return bl;
    }

    public boolean isTransportJMS() {
        Trc.entry(this);
        String string = this.soapBinding.getTransportURI();
        boolean bl = JMS_TRANSPORT_URI.equals(string);
        Trc.exit(bl);
        return bl;
    }

    public void setDefinition(Definition definition) {
        Trc.entry((Object)this, definition);
        this.definition = definition;
        Trc.exit();
    }

    public void setDynamicWSIFOperation(String string, String string2, String string3, WSIFOperation_ApacheAxis wSIFOperation_ApacheAxis) {
        Trc.entry(this, string, string2, string3, wSIFOperation_ApacheAxis);
        if (this.cachedWSIFOperations == null) {
            this.cachedWSIFOperations = new HashMap();
        }
        this.cachedWSIFOperations.put(this.getKey(string, string2, string3), wSIFOperation_ApacheAxis);
        Trc.exit();
    }

    public void setEndPoint(URL uRL) {
        Trc.entry((Object)this, uRL);
        this.endPointURL = uRL;
        Trc.exit();
    }

    public void setPort(Port port) {
        Trc.entry((Object)this, port);
        this.port = port;
        Trc.exit();
    }

    public boolean supportsAsync() {
        Trc.entry(this);
        if (this.isTransportJMS()) {
            Trc.exit(true);
            return true;
        }
        Trc.exit(false);
        return false;
    }

    public String deep() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(new String(super.toString()));
            stringBuffer.append(":\n");
            stringBuffer.append(" port: ").append(this.port);
            stringBuffer.append(" definition: ").append(this.definition);
            stringBuffer.append(" soapbinding: ").append(this.soapBinding);
            stringBuffer.append(" bindingStyle: ").append(this.bindingStyle);
            stringBuffer.append(" soapAddress: ").append(this.soapAddress);
            stringBuffer.append(" jmsAddress: ").append(this.jmsAddress);
            stringBuffer.append(" service url: ").append(this.endPointURL);
            stringBuffer.append(" jmsAddressPropVals: ").append(this.jmsAddressPropVals);
            stringBuffer.append(" dynamicTypeMap: ").append(this.wsifdynamictypemap);
            stringBuffer.append(" transport: ").append(this.transport);
            stringBuffer.append(" call: ").append(this.call);
            stringBuffer.append("operationInstances: ").append(this.cachedWSIFOperations);
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return stringBuffer.toString();
    }
}

