/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apachesoap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import javax.mail.MessagingException;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.soap.apachesoap.WSIFOperation_ApacheSOAP;
import org.apache.wsif.util.WSIFCorrelationServiceLocator;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.jms.WSIFJMSCorrelationId;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;

public class SOAPJMSConnection
implements SOAPTransport {
    private BufferedReader responseReader = null;
    private SOAPContext responseSOAPContext = null;
    private WSIFJMSDestination destination = null;
    private boolean asyncOperation = false;
    private WSIFOperation_ApacheSOAP wsifOperation = null;
    private long syncTimeout;
    private long asyncTimeout;
    private static final String DUMMY_RESPONSE = "<?xml version='1.0' encoding='UTF-8'?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\">\n<SOAP-ENV:Body>\n<ns1:addEntryResponse xmlns:ns1=\"http://wsifservice.addressbook/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n</ns1:addEntryResponse>\n\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>";

    public SOAPJMSConnection(JMSAddress jMSAddress, String string) throws WSIFException {
        Trc.entry(this, jMSAddress, string);
        this.destination = new WSIFJMSDestination(WSIFJMSFinder.newFinder(jMSAddress, string), jMSAddress.getJmsProvDestName(), WSIFProperties.getSyncTimeout());
        Trc.exit(jMSAddress);
    }

    public Hashtable getHeaders() {
        Trc.entry(this);
        Trc.exit(null);
        return null;
    }

    public SOAPContext getResponseSOAPContext() {
        Trc.entry(this);
        Trc.exit(this.responseSOAPContext);
        return this.responseSOAPContext;
    }

    public long getSyncTimeout() {
        Trc.entry(this);
        Trc.exit(new Long(this.syncTimeout));
        return this.syncTimeout;
    }

    public long getAsyncTimeout() {
        Trc.entry(this);
        Trc.exit(new Long(this.asyncTimeout));
        return this.asyncTimeout;
    }

    public BufferedReader receive() {
        Trc.entry(this);
        Trc.exit();
        return this.responseReader;
    }

    public void send(URL uRL, String string, Hashtable hashtable, Envelope envelope, SOAPMappingRegistry sOAPMappingRegistry, SOAPContext sOAPContext) throws SOAPException {
        Trc.entry(this, uRL, string, hashtable, envelope, sOAPMappingRegistry, sOAPContext);
        try {
            if (this.isAsyncOperation()) {
                this.performAsyncSend(uRL, string, hashtable, envelope, sOAPMappingRegistry, sOAPContext);
            } else {
                StringWriter stringWriter = new StringWriter();
                envelope.marshall((Writer)stringWriter, (XMLJavaMappingRegistry)sOAPMappingRegistry, sOAPContext);
                String string2 = this.destination.send(stringWriter.toString(), null);
                String string3 = this.destination.receiveString(string2, this.syncTimeout);
                this.responseSOAPContext = new SOAPContext();
                this.responseSOAPContext.setRootPart(string3, "text/xml");
                this.responseReader = new BufferedReader(new StringReader(string3));
            }
        }
        catch (IOException iOException) {
            Trc.exception(iOException);
            throw new SOAPException("WSIF SOAPJMSConnection ", iOException.toString());
        }
        catch (MessagingException messagingException) {
            Trc.exception(messagingException);
            throw new SOAPException("WSIF SOAPJMSConnection ", messagingException.toString());
        }
        Trc.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAsyncSend(URL uRL, String string, Hashtable hashtable, Envelope envelope, SOAPMappingRegistry sOAPMappingRegistry, SOAPContext sOAPContext) throws IOException, SOAPException, MessagingException {
        String string2;
        StringWriter stringWriter = new StringWriter();
        envelope.marshall((Writer)stringWriter, (XMLJavaMappingRegistry)sOAPMappingRegistry, sOAPContext);
        WSIFOperation_ApacheSOAP wSIFOperation_ApacheSOAP = this.getWsifOperation();
        if (wSIFOperation_ApacheSOAP.getResponseHandler() == null) {
            string2 = this.destination.send(stringWriter.toString(), null);
            WSIFJMSCorrelationId wSIFJMSCorrelationId = new WSIFJMSCorrelationId(string2);
        } else {
            WSIFCorrelationService wSIFCorrelationService;
            WSIFCorrelationService wSIFCorrelationService2 = wSIFCorrelationService = WSIFCorrelationServiceLocator.getCorrelationService();
            synchronized (wSIFCorrelationService2) {
                string2 = this.destination.send(stringWriter.toString(), null);
                WSIFJMSCorrelationId wSIFJMSCorrelationId = new WSIFJMSCorrelationId(string2);
                if (wSIFCorrelationService != null) {
                    wSIFCorrelationService.put(wSIFJMSCorrelationId, this.getWsifOperation(), this.asyncTimeout);
                }
            }
        }
        wSIFOperation_ApacheSOAP.setAsyncRequestID(new WSIFJMSCorrelationId(string2));
        this.responseSOAPContext = new SOAPContext();
        this.responseSOAPContext.setRootPart(DUMMY_RESPONSE, "text/xml");
        this.responseReader = new BufferedReader(new StringReader(DUMMY_RESPONSE));
    }

    public void setAsyncOperation(boolean bl) {
        Trc.entry((Object)this, bl);
        this.asyncOperation = bl;
        Trc.exit();
    }

    public boolean isAsyncOperation() {
        Trc.entry(this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    public WSIFOperation_ApacheSOAP getWsifOperation() {
        Trc.entry(this);
        Trc.exit(this.wsifOperation);
        return this.wsifOperation;
    }

    public void setWsifOperation(WSIFOperation_ApacheSOAP wSIFOperation_ApacheSOAP) {
        Trc.entry((Object)this, wSIFOperation_ApacheSOAP);
        this.wsifOperation = wSIFOperation_ApacheSOAP;
        Trc.exit();
    }

    public void setJmsProperty(String string, Object object) throws WSIFException {
        Trc.entry(this, string, object);
        this.destination.setProperty(string, object);
        Trc.exit();
    }

    public void setJmsProperties(HashMap hashMap) {
        Trc.entry((Object)this, hashMap);
        this.destination.setProperties(hashMap);
        Trc.exit();
    }

    public HashMap getJmsProperties() throws WSIFException {
        Trc.entry(this);
        HashMap hashMap = this.destination.getProperties();
        Trc.exit(hashMap);
        return hashMap;
    }

    void close() throws WSIFException {
        Trc.entry(this);
        this.destination.close();
        Trc.exit();
    }

    public void setSyncTimeout(long l) {
        Trc.entry((Object)this, new Long(l));
        this.syncTimeout = l;
        Trc.exit();
    }

    public void setAsyncTimeout(long l) {
        Trc.entry((Object)this, new Long(l));
        this.asyncTimeout = l;
        Trc.exit();
    }
}

