/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apachesoap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64Serializer;
import org.apache.soap.encoding.soapenc.BeanSerializer;
import org.apache.soap.encoding.soapenc.DateSerializer;
import org.apache.soap.rpc.Call;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.base.WSIFDefaultPort;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.providers.soap.apachesoap.PartSerializer;
import org.apache.wsif.providers.soap.apachesoap.SOAPJMSConnection;
import org.apache.wsif.providers.soap.apachesoap.WSIFOperation_ApacheSOAP;
import org.apache.wsif.providers.soap.apachesoap.WSIFSOAPMappingRegistry;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;

public class WSIFPort_ApacheSOAP
extends WSIFDefaultPort {
    private static final long serialVersionUID = 1L;
    protected transient Map operationInstances = new HashMap();
    protected Port port;
    protected Definition definition;
    protected transient Call call;
    protected transient SOAPTransport st;
    protected URL url;
    protected String style = "document";
    protected String partSerializerName = null;
    private WSIFDynamicTypeMap wsifTypeMap = null;
    private HashMap localTypeMap;
    private List jmsAddressPropVals = null;
    private static final String LITERAL_ENCODING = "literal";

    public WSIFPort_ApacheSOAP(Definition definition, Service service, Port port, WSIFDynamicTypeMap wSIFDynamicTypeMap, String string) throws WSIFException {
        String string2;
        Trc.entry(this, definition, service, port, wSIFDynamicTypeMap, string);
        this.setPartSerializerName(string);
        this.setDefinition(definition);
        this.setPort(port);
        this.wsifTypeMap = wSIFDynamicTypeMap;
        JMSAddress jMSAddress = (JMSAddress)this.getExtElem(port, JMSAddress.class, port.getExtensibilityElements());
        SOAPAddress sOAPAddress = (SOAPAddress)this.getExtElem(port, SOAPAddress.class, port.getExtensibilityElements());
        if (sOAPAddress != null && jMSAddress != null) {
            throw new WSIFException("Both soap:address and jms:address cannot be specified for port " + port.getName());
        }
        if (sOAPAddress == null && jMSAddress == null) {
            throw new WSIFException("Either soap:address or jms:address must be specified for port " + port.getName());
        }
        if (jMSAddress != null) {
            this.jmsAddressPropVals = jMSAddress.getJMSPropertyValues();
            this.st = new SOAPJMSConnection(jMSAddress, port.getName());
        } else {
            this.st = new SOAPHTTPConnection();
            string2 = sOAPAddress.getLocationURI();
            try {
                this.url = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                Trc.exception(malformedURLException);
                throw new WSIFException("could not set SOAP address to " + string2, malformedURLException);
            }
            if (this.url == null) {
                throw new WSIFException("soap:address with location URI is required for " + port.getName());
            }
        }
        string2 = port.getBinding();
        SOAPBinding sOAPBinding = (SOAPBinding)this.getExtElem(string2, SOAPBinding.class, string2.getExtensibilityElements());
        if (sOAPBinding != null) {
            this.style = sOAPBinding.getStyle();
            if (this.style == null) {
                this.style = "document";
            }
            String string3 = sOAPBinding.getTransportURI();
            if (jMSAddress != null && !"http://schemas.xmlsoap.org/soap/jms".equals(string3) || sOAPAddress != null && !"http://schemas.xmlsoap.org/soap/http".equals(string3)) {
                throw new WSIFException("unsupported transport " + string3 + " for " + sOAPBinding);
            }
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public static SOAPMappingRegistry createSOAPMappingRegistry(Call call) {
        Trc.entry(null, call);
        SOAPMappingRegistry sOAPMappingRegistry = call.getSOAPMappingRegistry();
        DateSerializer dateSerializer = new DateSerializer();
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://www.w3.org/1999/XMLSchema", "dateTime"), Date.class, null, (Deserializer)dateSerializer);
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://www.w3.org/2000/10/XMLSchema", "dateTime"), Date.class, null, (Deserializer)dateSerializer);
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), Date.class, null, (Deserializer)dateSerializer);
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), Date.class, (Serializer)dateSerializer, null);
        Base64Serializer base64Serializer = new Base64Serializer();
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://www.w3.org/1999/XMLSchema", "base64Binary"), byte[].class, null, (Deserializer)base64Serializer);
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://www.w3.org/2000/10/XMLSchema", "base64Binary"), byte[].class, null, (Deserializer)base64Serializer);
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"), byte[].class, null, (Deserializer)base64Serializer);
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"), byte[].class, (Serializer)base64Serializer, null);
        Trc.exit(sOAPMappingRegistry);
        return sOAPMappingRegistry;
    }

    public Call getCall() {
        Trc.entry(this);
        if (this.call == null) {
            this.call = new Call();
            this.call.setSOAPMappingRegistry((SOAPMappingRegistry)new WSIFSOAPMappingRegistry(WSIFPort_ApacheSOAP.createSOAPMappingRegistry(this.call)));
            this.prepareTypeMappings();
        }
        Trc.exit(this.call);
        return this.call;
    }

    public SOAPMappingRegistry getSOAPMappingRegistry() {
        Trc.entry(this);
        SOAPMappingRegistry sOAPMappingRegistry = this.getCall().getSOAPMappingRegistry();
        Trc.exit(sOAPMappingRegistry);
        return sOAPMappingRegistry;
    }

    protected HashMap getLocalTypeMap() {
        if (this.localTypeMap == null) {
            this.localTypeMap = new HashMap();
            this.getCall();
        }
        return this.localTypeMap;
    }

    private void prepareTypeMappings() {
        if (this.localTypeMap == null) {
            this.localTypeMap = new HashMap();
        }
        WSIFPort_ApacheSOAP.prepareTypeMappings(this.getSOAPMappingRegistry(), this.wsifTypeMap, this.partSerializerName, this.localTypeMap);
    }

    static void prepareTypeMappings(SOAPMappingRegistry sOAPMappingRegistry, WSIFDynamicTypeMap wSIFDynamicTypeMap, String string, HashMap hashMap) {
        BeanSerializer beanSerializer = new BeanSerializer();
        PartSerializer partSerializer = null;
        if (string != null) {
            try {
                partSerializer = (PartSerializer)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Throwable throwable) {
                Trc.ignoredException(throwable);
            }
        }
        PartSerializer partSerializer2 = partSerializer;
        PartSerializer partSerializer3 = partSerializer;
        BeanSerializer beanSerializer2 = beanSerializer;
        BeanSerializer beanSerializer3 = beanSerializer;
        String string2 = "http://schemas.xmlsoap.org/soap/encoding/";
        Iterator iterator = wSIFDynamicTypeMap.iterator();
        while (iterator.hasNext()) {
            WSIFDynamicTypeMapping wSIFDynamicTypeMapping = (WSIFDynamicTypeMapping)iterator.next();
            Class clazz = wSIFDynamicTypeMapping.getJavaType();
            QName qName = new QName(wSIFDynamicTypeMapping.getXmlType().getNamespaceURI(), wSIFDynamicTypeMapping.getXmlType().getLocalPart());
            hashMap.put(qName, clazz);
            Serializer serializer = null;
            try {
                serializer = sOAPMappingRegistry.querySerializer(clazz, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Trc.ignoredException(illegalArgumentException);
            }
            if (serializer == null) {
                sOAPMappingRegistry.mapTypes(string2, qName, clazz, (Serializer)beanSerializer2, (Deserializer)beanSerializer3);
            }
            try {
                serializer = null;
                serializer = sOAPMappingRegistry.querySerializer(clazz, LITERAL_ENCODING);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Trc.ignoredException(illegalArgumentException);
            }
            if (serializer != null) continue;
            sOAPMappingRegistry.mapTypes(LITERAL_ENCODING, qName, clazz, (Serializer)partSerializer2, (Deserializer)partSerializer3);
        }
    }

    public URL getEndPoint() {
        Trc.entry(this);
        Trc.exit(this.url);
        return this.url;
    }

    public void setEndPoint(URL uRL) {
        Trc.entry((Object)this, uRL);
        this.url = uRL;
        Trc.exit();
    }

    public SOAPTransport getSOAPTransport() {
        Trc.entry(this);
        Trc.exit(this.st);
        return this.st;
    }

    public void setSOAPTransport(SOAPTransport sOAPTransport) {
        Trc.entry((Object)this, sOAPTransport);
        this.st = sOAPTransport;
        Trc.exit();
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.definition);
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        Trc.entry((Object)this, definition);
        this.definition = definition;
        Trc.exit();
    }

    public Port getPort() {
        Trc.entry(this);
        Trc.exit(this.port);
        return this.port;
    }

    public void setPort(Port port) {
        Trc.entry((Object)this, port);
        this.port = port;
        Trc.exit();
    }

    public void setDynamicWSIFOperation(String string, String string2, String string3, WSIFOperation_ApacheSOAP wSIFOperation_ApacheSOAP) {
        Trc.entry(this, string, string2, string3, wSIFOperation_ApacheSOAP);
        this.operationInstances.put(this.getKey(string, string2, string3), wSIFOperation_ApacheSOAP);
        Trc.exit();
    }

    public WSIFOperation createOperation(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        WSIFOperation wSIFOperation = this.createOperation(string, null, null);
        Trc.exit(wSIFOperation);
        return wSIFOperation;
    }

    public WSIFOperation createOperation(String string, String string2, String string3) throws WSIFException {
        Trc.entry(this, string, string2, string3);
        WSIFOperation_ApacheSOAP wSIFOperation_ApacheSOAP = this.getDynamicWSIFOperation(string, string2, string3);
        if (wSIFOperation_ApacheSOAP == null) {
            throw new WSIFException("Could not create operation: " + string + ":" + string2 + ":" + string3);
        }
        WSIFOperation_ApacheSOAP wSIFOperation_ApacheSOAP2 = wSIFOperation_ApacheSOAP.copy();
        Trc.exit(wSIFOperation_ApacheSOAP2);
        return wSIFOperation_ApacheSOAP2;
    }

    public WSIFOperation_ApacheSOAP getDynamicWSIFOperation(String string, String string2, String string3) throws WSIFException {
        BindingOperation bindingOperation;
        Trc.entry(this, string, string2, string3);
        WSIFOperation_ApacheSOAP wSIFOperation_ApacheSOAP = (WSIFOperation_ApacheSOAP)this.operationInstances.get(this.getKey(string, string2, string3));
        WSIFOperation_ApacheSOAP wSIFOperation_ApacheSOAP2 = null;
        if (wSIFOperation_ApacheSOAP != null) {
            wSIFOperation_ApacheSOAP2 = wSIFOperation_ApacheSOAP.copy();
        }
        if (wSIFOperation_ApacheSOAP2 == null && (bindingOperation = WSIFUtils.getBindingOperation(this.port.getBinding(), string, string2, string3)) != null) {
            List list;
            List list2;
            Object object;
            String string4;
            SOAPOperation sOAPOperation;
            wSIFOperation_ApacheSOAP2 = new WSIFOperation_ApacheSOAP(this, bindingOperation.getOperation(), this.wsifTypeMap);
            if (wSIFOperation_ApacheSOAP2 == null) {
                throw new WSIFException("Operation not found from binding operation: " + bindingOperation.getName());
            }
            wSIFOperation_ApacheSOAP2.setStyle(this.style);
            wSIFOperation_ApacheSOAP2.setPartSerializerName(this.partSerializerName);
            if (this.jmsAddressPropVals != null && this.jmsAddressPropVals.size() > 0) {
                if (this.st instanceof SOAPJMSConnection) {
                    wSIFOperation_ApacheSOAP2.addInputJmsPropertyValues(this.jmsAddressPropVals);
                } else {
                    throw new WSIFException("jms:propertyValue found in non-jms address");
                }
            }
            if ((sOAPOperation = (SOAPOperation)this.getExtElem(bindingOperation, SOAPOperation.class, bindingOperation.getExtensibilityElements())) == null) {
                throw new WSIFException("soapAction must be specified in  required by WSDL 1.1 soap:operation binding for " + bindingOperation.getName());
            }
            String string5 = sOAPOperation.getSoapActionURI();
            wSIFOperation_ApacheSOAP2.setSoapActionURI(string5);
            Trc.event(this, "setting actionURI ", string5, " for op ", wSIFOperation_ApacheSOAP2.getName());
            String string6 = sOAPOperation.getStyle();
            BindingInput bindingInput = bindingOperation.getBindingInput();
            SOAPBody sOAPBody = (SOAPBody)this.getExtElem(bindingInput, SOAPBody.class, bindingInput.getExtensibilityElements());
            if (sOAPBody != null) {
                string4 = sOAPBody.getNamespaceURI();
                Trc.event(this, "setting namespace ", string4, " for op ", wSIFOperation_ApacheSOAP2.getName());
                wSIFOperation_ApacheSOAP2.setInputNamespace(string4);
                object = sOAPBody.getUse();
                wSIFOperation_ApacheSOAP2.setInputUse((String)object);
                list2 = sOAPBody.getEncodingStyles();
                if (list2 != null) {
                    if (list2.size() == 0) {
                        // empty if block
                    }
                    wSIFOperation_ApacheSOAP2.setInputEncodingStyle((String)list2.get(0));
                }
                if ((list = sOAPBody.getParts()) != null) {
                    wSIFOperation_ApacheSOAP2.setPartNames(list);
                }
            }
            if ((string4 = (SOAPHeader)this.getExtElem(bindingInput, SOAPHeader.class, bindingInput.getExtensibilityElements())) != null) {
                throw new WSIFException("not supported input soap:header " + string4);
            }
            object = this.getExtElems(bindingInput, JMSProperty.class, bindingInput.getExtensibilityElements());
            if (object != null && object.size() > 0) {
                if (this.st instanceof SOAPJMSConnection) {
                    wSIFOperation_ApacheSOAP2.setInputJmsProperties((List)object);
                } else {
                    throw new WSIFException("jms:properties found in non-jms binding");
                }
            }
            if ((list2 = this.getExtElems(bindingInput, JMSPropertyValue.class, bindingInput.getExtensibilityElements())) != null && list2.size() > 0) {
                if (this.st instanceof SOAPJMSConnection) {
                    wSIFOperation_ApacheSOAP2.addInputJmsPropertyValues(list2);
                } else {
                    throw new WSIFException("jms:propertyValue found in non-jms binding");
                }
            }
            if ((list = bindingOperation.getBindingOutput()) != null) {
                Object object2;
                SOAPBody sOAPBody2 = (SOAPBody)this.getExtElem(list, SOAPBody.class, list.getExtensibilityElements());
                if (sOAPBody2 != null) {
                    object2 = sOAPBody2.getUse();
                    wSIFOperation_ApacheSOAP2.setOutputUse((String)object2);
                    List list3 = sOAPBody2.getParts();
                    if (list3 != null && list3.size() > 0) {
                        wSIFOperation_ApacheSOAP2.setReturnName((String)list3.get(0));
                    }
                }
                if ((string4 = (SOAPHeader)this.getExtElem(list, SOAPHeader.class, list.getExtensibilityElements())) != null) {
                    throw new WSIFException("not supported output soap:header " + string4);
                }
                object2 = this.getExtElems(list, JMSProperty.class, list.getExtensibilityElements());
                if (object2 != null && object2.size() > 0) {
                    if (this.st instanceof SOAPJMSConnection) {
                        wSIFOperation_ApacheSOAP2.setOutputJmsProperties((List)object2);
                    } else {
                        throw new WSIFException("jms:properties found in non-jms binding");
                    }
                }
            }
            this.setDynamicWSIFOperation(string, string2, string3, wSIFOperation_ApacheSOAP2);
        }
        Trc.exit(wSIFOperation_ApacheSOAP2);
        return wSIFOperation_ApacheSOAP2;
    }

    public String getPartSerializerName() {
        Trc.entry(this);
        Trc.exit(this.partSerializerName);
        return this.partSerializerName;
    }

    public void setPartSerializerName(String string) {
        Trc.entry((Object)this, string);
        this.partSerializerName = string;
        Trc.exit();
    }

    public void close() throws WSIFException {
        Trc.entry(this);
        if (this.st != null && this.st instanceof SOAPJMSConnection) {
            ((SOAPJMSConnection)this.st).close();
        }
        Trc.exit();
    }

    public boolean supportsAsync() {
        return this.st instanceof SOAPJMSConnection;
    }

    public String deep() {
        String string = "";
        try {
            string = new String(super.toString() + ":\n");
            if (this.operationInstances == null) {
                string = string + " operationInstances: null";
            } else {
                string = string + " operationInstances: size:" + this.operationInstances.size();
                Iterator iterator = this.operationInstances.keySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    WSIFOperation_ApacheSOAP wSIFOperation_ApacheSOAP = (WSIFOperation_ApacheSOAP)this.operationInstances.get(string2);
                    string = string + "\noperationInstances[" + n + "]:" + string2 + " " + wSIFOperation_ApacheSOAP.getName() + " ";
                    ++n;
                }
            }
            string = string + "\nport:" + Trc.brief(this.port);
            string = string + " definition:" + Trc.brief(this.definition);
            string = string + " call:" + this.call;
            string = string + " soapTransport:" + this.st;
            string = string + " url:" + this.url;
            string = string + " style:" + this.style;
            string = string + " partSerializerName:" + this.partSerializerName;
            string = string + " wsifTypeMap:" + this.wsifTypeMap;
            string = string + " jmsAddressPropVals:" + this.jmsAddressPropVals;
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.operationInstances = new HashMap();
        JMSAddress jMSAddress = (JMSAddress)this.getExtElem(this.port, JMSAddress.class, this.port.getExtensibilityElements());
        SOAPAddress sOAPAddress = (SOAPAddress)this.getExtElem(this.port, SOAPAddress.class, this.port.getExtensibilityElements());
        if (sOAPAddress != null && jMSAddress != null) {
            throw new WSIFException("Both soap:address and jms:address cannot be specified for port " + this.port.getName());
        }
        if (sOAPAddress == null && jMSAddress == null) {
            throw new WSIFException("Either soap:address or jms:address must be specified for port " + this.port.getName());
        }
        if (jMSAddress != null) {
            this.jmsAddressPropVals = jMSAddress.getJMSPropertyValues();
            this.st = new SOAPJMSConnection(jMSAddress, this.port.getName());
        } else {
            this.st = new SOAPHTTPConnection();
        }
    }
}

