/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.soap.apachesoap;

import java.math.BigDecimal;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.wsif.logging.Trc;

public class WSIFSOAPMappingRegistry
extends SOAPMappingRegistry {
    public WSIFSOAPMappingRegistry() {
        Trc.entry((Object)this);
        Trc.exit();
    }

    public WSIFSOAPMappingRegistry(SOAPMappingRegistry sOAPMappingRegistry) {
        super(sOAPMappingRegistry);
        Trc.entry((Object)this, sOAPMappingRegistry);
        Trc.exit();
    }

    public WSIFSOAPMappingRegistry(SOAPMappingRegistry sOAPMappingRegistry, String string) {
        super(sOAPMappingRegistry, string);
        Trc.entry((Object)this, sOAPMappingRegistry, string);
        Trc.exit();
    }

    protected Serializer querySerializer_(Class clazz, String string) {
        Trc.entry((Object)this, clazz, string);
        Serializer serializer = super.querySerializer_(clazz, string);
        Trc.exit(serializer);
        return serializer;
    }

    protected Deserializer queryDeserializer_(QName qName, String string) {
        QName qName2;
        Trc.entry((Object)this, qName, string);
        Deserializer deserializer = null;
        if (qName != null && qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/") && (qName2 = this.getEquivalentXSDSimpleType(qName)) != null) {
            deserializer = super.queryDeserializer_(qName2, string);
        }
        if (deserializer == null) {
            deserializer = super.queryDeserializer_(qName, string);
        }
        Trc.exit(deserializer);
        return deserializer;
    }

    protected QName queryElementType_(Class clazz, String string) {
        return super.queryElementType_(clazz, string);
    }

    protected Class queryJavaType_(QName qName, String string) {
        Class clazz = null;
        if (qName != null && qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            clazz = this.resolveSOAPENCSimpleType(qName);
        }
        if (clazz == null) {
            return super.queryJavaType_(qName, string);
        }
        return clazz;
    }

    private QName getEquivalentXSDSimpleType(QName qName) {
        if (qName == null || !qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return null;
        }
        String string = qName.getLocalPart();
        if (string == null) {
            return null;
        }
        if (string.equals("string")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "string");
        }
        if (string.equals("boolean")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "boolean");
        }
        if (string.equals("float")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "float");
        }
        if (string.equals("double")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "double");
        }
        if (string.equals("decimal")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "decimal");
        }
        if (string.equals("int")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "int");
        }
        if (string.equals("short")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "short");
        }
        if (string.equals("byte")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "byte");
        }
        if (string.equals("base64")) {
            return new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
        }
        return null;
    }

    private Class resolveSOAPENCSimpleType(QName qName) {
        if (qName == null || !qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return null;
        }
        String string = qName.getLocalPart();
        if (string == null) {
            return null;
        }
        if (string.equals("string")) {
            return String.class;
        }
        if (string.equals("boolean")) {
            return Boolean.class;
        }
        if (string.equals("float")) {
            return Float.class;
        }
        if (string.equals("double")) {
            return Double.class;
        }
        if (string.equals("decimal")) {
            return BigDecimal.class;
        }
        if (string.equals("int")) {
            return Integer.class;
        }
        if (string.equals("short")) {
            return Short.class;
        }
        if (string.equals("byte")) {
            return Byte.class;
        }
        if (string.equals("base64")) {
            return byte[].class;
        }
        return null;
    }
}

