/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.wsif.schema.Attribute;
import org.apache.wsif.schema.ComplexContent;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.Extension;
import org.apache.wsif.schema.Restriction;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.schema.SequenceElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexType
extends SchemaType
implements Serializable {
    static final long serialVersionUID = 1L;
    private boolean isAnArray = false;
    private String name = "";
    private QName typeName = null;
    private QName arrayType = null;
    private int arrayDim = 0;
    private ComplexContent complexContent = null;
    private static final QName soapEncArray = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    private static final QName soapEncArrayType = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    private static final QName wsdlArrayType = new QName("http://schemas.xmlsoap.org/wsdl/", "arrayType");
    private ArrayList sequenceElements = new ArrayList();
    private ArrayList childElements = new ArrayList();
    private String isAbstract = "false";

    ComplexType(Element element, String string) {
        this.typeName = ComplexType.getAttributeQName(element, "name", string);
        QName qName = ComplexType.getAttributeQName(element, "abstract", string);
        if (qName != null) {
            this.isAbstract = qName.getLocalPart();
        }
        if (this.typeName != null) {
            this.name = this.typeName.getLocalPart();
        }
        this.process(element, string);
        if (this.name.startsWith("ArrayOf") && this.complexContent != null) {
            QName qName2;
            Restriction restriction = this.complexContent.getRestriction();
            if (restriction != null && soapEncArray.equals(qName2 = restriction.getBase())) {
                Attribute[] attributeArray = restriction.getAttributes();
                if (attributeArray != null && attributeArray.length > 0) {
                    for (int i = 0; i < attributeArray.length; ++i) {
                        QName qName3;
                        Attribute attribute = attributeArray[i];
                        if (attribute == null || !soapEncArrayType.equals(qName3 = attribute.getXMLAttribute("ref"))) continue;
                        QName qName4 = attribute.getXMLAttribute(wsdlArrayType);
                        if (qName4 != null) {
                            String string2 = qName4.getNamespaceURI();
                            String string3 = qName4.getLocalPart();
                            int n = string3.lastIndexOf("[]");
                            while (n != -1) {
                                string3 = string3.substring(0, n);
                                ++this.arrayDim;
                                n = string3.lastIndexOf("[]");
                            }
                            this.arrayType = new QName(string2, string3);
                        }
                        break;
                    }
                } else {
                    SequenceElement sequenceElement;
                    QName qName5;
                    SequenceElement[] sequenceElementArray = restriction.getSequenceElements();
                    if (sequenceElementArray != null && sequenceElementArray.length == 1 && (qName5 = (sequenceElement = sequenceElementArray[0]).getXMLAttribute("type")) != null) {
                        String string4 = qName5.getNamespaceURI();
                        String string5 = qName5.getLocalPart();
                        this.arrayType = new QName(string4, string5);
                    }
                }
            }
            this.isAnArray = true;
        }
    }

    public boolean isComplex() {
        return true;
    }

    public boolean isArray() {
        return this.isAnArray;
    }

    public QName getArrayType() {
        return this.arrayType;
    }

    public int getArrayDimension() {
        return this.arrayDim;
    }

    public QName getTypeName() {
        return this.typeName;
    }

    public ArrayList getChildElements() {
        return this.childElements;
    }

    public String getAbstractAttribute() {
        return this.isAbstract;
    }

    public SequenceElement[] getSequenceElements() {
        return this.sequenceElements.toArray(new SequenceElement[this.sequenceElements.size()]);
    }

    public ComplexContent getComplexContent() {
        return this.complexContent;
    }

    private void process(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string2 = element2.getLocalName();
            if (string2.equals("complexContent")) {
                this.complexContent = new ComplexContent(element2, string);
                continue;
            }
            if (string2.equals("sequence")) {
                this.parseSequenceElements(element2, string);
                continue;
            }
            if (string2.equals("all")) {
                this.parseChildElements(element2, string);
                continue;
            }
            if (!string2.equals("simpleContent")) continue;
            this.parseChildElements(element2, string);
        }
    }

    private void parseChildElements(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string2 = element2.getLocalName();
            if (string2.equals("element")) {
                this.childElements.add(new ElementType(element2, string));
                continue;
            }
            if (string2.equals("extension")) {
                this.childElements.add(new Extension(element2));
                continue;
            }
            if (!string2.equals("restriction")) continue;
            this.childElements.add(new Restriction(element2, string));
        }
    }

    private void parseSequenceElements(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(string2 = (element2 = (Element)node).getLocalName()).equals("element")) continue;
            this.sequenceElements.add(new SequenceElement(element2, string));
        }
    }
}

