/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.ibm.wsdl.util.xml.QNameUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.Schema;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Parser {
    private static final QName schema1999 = new QName("http://www.w3.org/1999/XMLSchema", "schema");
    private static final QName schema2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "schema");
    private static final QName schema2001 = new QName("http://www.w3.org/2001/XMLSchema", "schema");

    public static void getTypeMappings(Definition definition, Map map) throws WSIFException {
        Parser.getTypeMappings(definition, map, true, null);
    }

    public static void getTypeMappings(Definition definition, Map map, ClassLoader classLoader) throws WSIFException {
        WSIFWSDLLocatorImpl wSIFWSDLLocatorImpl = new WSIFWSDLLocatorImpl((String)null, (String)null, classLoader);
        Parser.getTypeMappings(definition, map, true, wSIFWSDLLocatorImpl);
    }

    public static void getTypeMappings(Definition definition, Map map, ClassLoader classLoader, boolean bl) throws WSIFException {
        WSIFWSDLLocatorImpl wSIFWSDLLocatorImpl = new WSIFWSDLLocatorImpl((String)null, (String)null, classLoader);
        Parser.getTypeMappings(definition, map, bl, wSIFWSDLLocatorImpl);
    }

    public static void getTypeMappings(Definition definition, Map map, WSDLLocator wSDLLocator) throws WSIFException {
        Parser.getTypeMappings(definition, map, true, wSDLLocator);
    }

    public static void getTypeMappings(Definition definition, Map map, boolean bl) throws WSIFException {
        Parser.getTypeMappings(definition, map, bl, null);
    }

    public static void getTypeMappings(Definition definition, Map map, boolean bl, WSDLLocator wSDLLocator) throws WSIFException {
        Object object;
        Object object2;
        Object object3;
        Object object422;
        Serializable serializable222;
        Trc.entry(null, definition, map, new Boolean(bl), wSDLLocator);
        if (wSDLLocator == null) {
            wSDLLocator = new WSIFWSDLLocatorImpl((String)null, (String)null, null);
        }
        ArrayList arrayList = new ArrayList();
        Parser.getTypesSchemas(definition, arrayList, wSDLLocator);
        Hashtable hashtable = null;
        if (bl) {
            Parser.populateWithStandardMappings(map, "http://www.w3.org/1999/XMLSchema", true);
            Parser.populateWithStandardMappings(map, "http://www.w3.org/2000/10/XMLSchema", false);
            Parser.populateWithStandardMappings(map, "http://www.w3.org/2001/XMLSchema", false);
        } else {
            hashtable = new Hashtable();
            Parser.populateWithStandardMappings(hashtable, "http://www.w3.org/1999/XMLSchema", true);
            Parser.populateWithStandardMappings(hashtable, "http://www.w3.org/2000/10/XMLSchema", false);
            Parser.populateWithStandardMappings(hashtable, "http://www.w3.org/2001/XMLSchema", false);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (Serializable serializable222 : arrayList) {
            if (serializable222 == null) continue;
            List list = ((Schema)serializable222).getTypes();
            object422 = list.iterator();
            while (object422.hasNext()) {
                QName serializable3;
                object3 = (SchemaType)object422.next();
                if (object3 == null || (serializable3 = ((SchemaType)object3).getTypeName()) == null) continue;
                if (((SchemaType)object3).isArray()) {
                    arrayList2.add(object3);
                    continue;
                }
                if (object3 instanceof ElementType) {
                    object2 = ((ElementType)object3).getElementType();
                    if (object2 != null) {
                        if (((ElementType)object3).isNillable() && (object = Parser.getWrapperClassName((QName)object2)) != null) {
                            map.put(serializable3, object);
                            continue;
                        }
                        object = (String)map.get(object2);
                        if (object == null && !bl) {
                            object = (String)hashtable.get(object2);
                        }
                        if (object != null) {
                            map.put(serializable3, object);
                            continue;
                        }
                        arrayList3.add(object3);
                        continue;
                    }
                    object = Parser.resolveClassName(serializable3);
                    if ((object = (String)object + "Element") == null) continue;
                    map.put(serializable3, object);
                    continue;
                }
                object2 = Parser.resolveClassName(serializable3);
                if (object2 == null) continue;
                map.put(serializable3, object2);
            }
        }
        serializable222 = new ArrayList();
        for (Object object422 : arrayList2) {
            QName qName;
            object3 = ((SchemaType)object422).getTypeName();
            if (object3 == null || (qName = ((SchemaType)object422).getArrayType()) == null || object3 == null) continue;
            object2 = (String)map.get(qName);
            if (object2 == null && hashtable != null) {
                object2 = (String)hashtable.get(qName);
            }
            if (object2 == null) {
                object = qName.getLocalPart();
                if (object == null || !((String)object).startsWith("ArrayOf")) continue;
                ((ArrayList)serializable222).add(object422);
                continue;
            }
            object = "";
            for (int i = 1; i < ((SchemaType)object422).getArrayDimension(); ++i) {
                object = (String)object + "[";
            }
            if (object2 == null) continue;
            if (((String)object2).equals("int")) {
                map.put(object3, (String)object + "[I");
                continue;
            }
            if (((String)object2).equals("float")) {
                map.put(object3, (String)object + "[F");
                continue;
            }
            if (((String)object2).equals("long")) {
                map.put(object3, (String)object + "[J");
                continue;
            }
            if (((String)object2).equals("double")) {
                map.put(object3, (String)object + "[D");
                continue;
            }
            if (((String)object2).equals("boolean")) {
                map.put(object3, (String)object + "[Z");
                continue;
            }
            if (((String)object2).equals("byte")) {
                map.put(object3, (String)object + "[B");
                continue;
            }
            if (((String)object2).equals("short")) {
                map.put(object3, (String)object + "[S");
                continue;
            }
            if (((String)object2).startsWith("[")) {
                String string = "[" + (String)object2;
                map.put(object3, string);
                continue;
            }
            String string = (String)object + "[L" + (String)object2 + ";";
            map.put(object3, string);
        }
        object422 = ((ArrayList)serializable222).iterator();
        while (object422.hasNext()) {
            object3 = (SchemaType)object422.next();
            QName qName = ((SchemaType)object3).getTypeName();
            if (qName == null || (object2 = ((SchemaType)object3).getArrayType()) == null || qName == null) continue;
            object = "";
            for (int i = 1; i < ((SchemaType)object3).getArrayDimension(); ++i) {
                object = (String)object + "[";
            }
            String string = (String)map.get(object2);
            if (string == null || !string.startsWith("[")) continue;
            String string2 = "[" + string;
            map.put(qName, string2);
        }
        for (SchemaType schemaType : arrayList3) {
            String string;
            object2 = schemaType.getTypeName();
            if (object2 == null) continue;
            object = null;
            if (schemaType instanceof ElementType) {
                object = ((ElementType)schemaType).getElementType();
            }
            if (object == null || (string = (String)map.get(object)) == null) continue;
            map.put(object2, string);
        }
        Trc.exit();
    }

    public static void getAllSchemaTypes(Definition definition, List list, WSDLLocator wSDLLocator) throws WSIFException {
        try {
            ArrayList arrayList = new ArrayList();
            if (wSDLLocator == null) {
                wSDLLocator = new WSIFWSDLLocatorImpl((String)null, (String)null, null);
            }
            Parser.getTypesSchemas(definition, arrayList, wSDLLocator);
            for (Schema schema : arrayList) {
                if (schema == null) continue;
                List list2 = schema.getTypes();
                for (SchemaType schemaType : list2) {
                    if (schemaType == null) continue;
                    list.add(schemaType);
                }
            }
        }
        catch (WSIFException wSIFException) {
            // empty catch block
        }
    }

    private static void populateWithStandardMappings(Map map, String string, boolean bl) {
        map.put(new QName(string, "string"), "java.lang.String");
        map.put(new QName(string, "integer"), "java.math.BigInteger");
        map.put(new QName(string, "boolean"), "boolean");
        map.put(new QName(string, "float"), "float");
        map.put(new QName(string, "double"), "double");
        map.put(new QName(string, "base64Binary"), "[B");
        map.put(new QName(string, "hexBinary"), "[B");
        map.put(new QName(string, "long"), "long");
        map.put(new QName(string, "int"), "int");
        map.put(new QName(string, "short"), "short");
        map.put(new QName(string, "decimal"), "java.math.BigDecimal");
        map.put(new QName(string, "byte"), "byte");
        map.put(new QName(string, "QName"), "javax.xml.namespace.QName");
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            map.put(new QName(string, "dateTime"), "java.util.Calendar");
        } else {
            map.put(new QName(string, "timeInstant"), "java.util.Calendar");
        }
        if (bl) {
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "string"), "java.lang.String");
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "boolean"), "java.lang.Boolean");
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "float"), "java.lang.Float");
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "double"), "java.lang.Double");
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "decimal"), "java.math.BigDecimal");
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "int"), "java.lang.Integer");
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "short"), "java.lang.Short");
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "byte"), "java.lang.Byte");
            map.put(new QName("http://schemas.xmlsoap.org/soap/encoding/", "base64"), "[B");
            map.put(new QName("http://xml.apache.org/xml-soap", "Map"), "java.util.Map");
            map.put(new QName("http://xml.apache.org/xml-soap", "Vector"), "java.util.Vector");
            map.put(new QName("http://xml.apache.org/xml-soap", "Hashtable"), "java.util.Hashtable");
        }
    }

    private static void getTypesSchemas(Definition definition, List list, WSDLLocator wSDLLocator) throws WSIFException {
        Object object;
        Object object2;
        Types types = definition.getTypes();
        if (types != null) {
            object2 = types.getExtensibilityElements().iterator();
            while (object2.hasNext()) {
                Object object3;
                Iterator<Object> iterator = object2.next();
                if (iterator instanceof UnknownExtensibilityElement) {
                    object3 = (UnknownExtensibilityElement)iterator;
                    object = object3.getElement();
                    Parser.importSchemas((Element)object, definition, list, wSDLLocator);
                    continue;
                }
                if (!(iterator instanceof SchemaImpl)) continue;
                object3 = (SchemaImpl)iterator;
                object = object3.getElement();
                Parser.importSchemas((Element)object, definition, list, wSDLLocator);
            }
        }
        if ((object2 = definition.getImports()) != null) {
            for (Object object3 : object2.values()) {
                if (object3 == null) continue;
                object = object3.iterator();
                while (object.hasNext()) {
                    Import import_ = (Import)object.next();
                    if (import_ == null) continue;
                    Definition definition2 = import_.getDefinition();
                    if (definition2 != null) {
                        Parser.getTypesSchemas(definition2, list, wSDLLocator);
                        continue;
                    }
                    String string = definition.getDocumentBaseURI();
                    String string2 = import_.getLocationURI();
                    if (string == null || string2 == null || wSDLLocator == null) continue;
                    Parser.getImportedSchemas(string, string2, wSDLLocator, list);
                }
            }
        }
    }

    private static void importSchemas(Element element, Definition definition, List list, WSDLLocator wSDLLocator) throws WSIFException {
        if (QNameUtils.matches((QName)schema2001, (Node)element) || QNameUtils.matches((QName)schema2000, (Node)element) || QNameUtils.matches((QName)schema1999, (Node)element)) {
            Schema schema = new Schema(element);
            list.add(schema);
            String string = definition.getDocumentBaseURI();
            if (string != null && wSDLLocator != null) {
                String[] stringArray = schema.getImportsAndIncludes();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    Parser.getImportedSchemas(string, string2, wSDLLocator, list);
                }
            }
        }
    }

    private static void getImportedSchemas(String string, String string2, WSDLLocator wSDLLocator, List list) throws WSIFException {
        try {
            InputSource inputSource = wSDLLocator.getImportInputSource(string, string2);
            if (inputSource == null) {
                throw new WSIFException("Unable to read schema file " + string2 + " relative to " + string);
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            if (inputSource.getCharacterStream() != null) {
                inputSource.getCharacterStream().close();
            } else if (inputSource.getByteStream() != null) {
                inputSource.getByteStream().close();
            }
            Element element = document.getDocumentElement();
            if (element != null && (QNameUtils.matches((QName)schema2001, (Node)element) || QNameUtils.matches((QName)schema2000, (Node)element) || QNameUtils.matches((QName)schema1999, (Node)element))) {
                Schema schema = new Schema(element);
                list.add(schema);
                String[] stringArray = schema.getImportsAndIncludes();
                String string3 = wSDLLocator.getLatestImportURI();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    Parser.getImportedSchemas(string3, string4, wSDLLocator, list);
                }
            }
        }
        catch (Exception exception) {
            Trc.exception(exception);
            if (exception instanceof WSIFException) {
                throw (WSIFException)exception;
            }
            throw new WSIFException("Error when getting imported schemas", exception);
        }
    }

    private static String resolveClassName(QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        String string3 = WSIFUtils.getPackageNameFromNamespaceURI(string);
        String string4 = WSIFUtils.getJavaClassNameFromXMLName(string2);
        if (string3 != null && !string3.equals("") && string4 != null && !string4.equals("")) {
            return string3 + "." + string4;
        }
        return null;
    }

    private static String getWrapperClassName(QName qName) {
        if (qName == null) {
            return null;
        }
        String string = qName.getNamespaceURI();
        if ("http://www.w3.org/1999/XMLSchema".equals(string) || "http://www.w3.org/2000/10/XMLSchema".equals(string) || "http://www.w3.org/2001/XMLSchema".equals(string)) {
            String string2 = qName.getLocalPart();
            if (string2 == null) {
                return null;
            }
            if (string2.equals("int")) {
                return "java.lang.Integer";
            }
            if (string2.equals("long")) {
                return "java.lang.Long";
            }
            if (string2.equals("float")) {
                return "java.lang.Float";
            }
            if (string2.equals("short")) {
                return "java.lang.Short";
            }
            if (string2.equals("double")) {
                return "java.lang.Double";
            }
            if (string2.equals("boolean")) {
                return "java.lang.Boolean";
            }
            if (string2.equals("byte")) {
                return "java.lang.Byte";
            }
        }
        return null;
    }
}

