/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.wsif.schema.Attribute;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.schema.SequenceElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Restriction
implements Serializable {
    static final long serialVersionUID = 1L;
    QName base = null;
    ArrayList attributes = new ArrayList();
    ArrayList sequenceElements = new ArrayList();
    Map restrictionElements = new HashMap();

    Restriction(Element element, String string) {
        this.base = SchemaType.getAttributeQName(element, "base");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string2 = element2.getLocalName();
            if (string2.equals("attribute")) {
                this.attributes.add(new Attribute(element2, string));
                continue;
            }
            if (string2.equals("sequence")) {
                this.parseSequenceElements(element2, string);
                continue;
            }
            this.parseRestrictionElement(element2, string);
        }
    }

    public QName getBase() {
        return this.base;
    }

    public Attribute[] getAttributes() {
        return this.attributes.toArray(new Attribute[this.attributes.size()]);
    }

    public SequenceElement[] getSequenceElements() {
        return this.sequenceElements.toArray(new SequenceElement[this.sequenceElements.size()]);
    }

    public Map getRestrictionElements() {
        return this.restrictionElements;
    }

    private void parseSequenceElements(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(string2 = (element2 = (Element)node).getLocalName()).equals("element")) continue;
            this.sequenceElements.add(new SequenceElement(element2, string));
        }
    }

    private void parseRestrictionElement(Element element, String string) {
        if (element.getNodeType() == 1) {
            String string2 = element.getLocalName();
            String string3 = element.getAttribute("value");
            if (string2.compareToIgnoreCase("enumeration") == 0) {
                ArrayList<String> arrayList = (ArrayList<String>)this.restrictionElements.get("enumeration");
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string3);
                this.restrictionElements.put("enumeration", arrayList);
            } else {
                this.restrictionElements.put(string2, string3);
            }
        }
    }
}

