/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wsif.schema.ComplexType;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.SimpleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Schema
implements Serializable {
    static final long serialVersionUID = 1L;
    private String targetNamespace = "";
    private ArrayList types = new ArrayList();
    private ArrayList iai = new ArrayList();

    Schema(Element element) {
        this.targetNamespace = element.getAttribute("targetNamespace");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string2 = element2.getLocalName();
            if (string2.equals("complexType")) {
                this.types.add(new ComplexType(element2, this.targetNamespace));
                continue;
            }
            if (string2.equals("simpleType")) {
                this.types.add(new SimpleType(element2, this.targetNamespace));
                continue;
            }
            if (string2.equals("element")) {
                this.types.add(new ElementType(element2, this.targetNamespace));
                continue;
            }
            if (!string2.equals("import") && !string2.equals("include") || (string = element2.getAttribute("schemaLocation")) == null || string.equals("")) continue;
            this.iai.add(string);
        }
    }

    List getTypes() {
        return this.types;
    }

    String getTargetNamespace() {
        return this.targetNamespace;
    }

    String[] getImportsAndIncludes() {
        return this.iai.toArray(new String[this.iai.size()]);
    }
}

