/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.CLOptionDescriptor;
import org.apache.axis.utils.CLUtil;
import org.apache.wsif.WSIFException;
import org.apache.wsif.tools.wsdl.BindingGenerator;
import org.apache.wsif.tools.wsdl.EJBBindingGenerator;
import org.apache.wsif.tools.wsdl.JavaBindingGenerator;
import org.apache.wsif.tools.wsdl.SOAPJMSBindingGenerator;
import org.apache.wsif.util.WSIFUtils;

public class WSDL2WSDL {
    protected String wsdlURI;
    protected String outputWSDLName;
    protected String outputDirectory;
    protected ArrayList requestedBindings;
    protected ArrayList availableGenerators;
    protected static final int HELP_OPT = 104;
    protected static final int BINDINGS_OPT = 98;
    protected static final int OUTPUT_DIR_OPT = 111;
    protected static final int OUTPUT_WSDL_OPT = 110;
    protected CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print usage information"), new CLOptionDescriptor("outputWSDL", 2, 110, "the name of the new WSDL file"), new CLOptionDescriptor("bindings", 2, 98, "comma seperated list of binding types to add to the WSDL"), new CLOptionDescriptor("output", 2, 111, "output directory for the updated WSDL")};

    public WSDL2WSDL() {
        this.requestedBindings = new ArrayList();
        this.availableGenerators = new ArrayList();
        this.addGenerators();
    }

    protected void addGenerators() {
        this.availableGenerators.add(new JavaBindingGenerator());
        this.availableGenerators.add(new EJBBindingGenerator());
        this.availableGenerators.add(new SOAPJMSBindingGenerator());
    }

    protected void addBindings(Definition definition) {
        for (BindingGenerator bindingGenerator : this.availableGenerators) {
            if (!this.requestedBindings.contains(bindingGenerator)) continue;
            bindingGenerator.addBindings(definition);
        }
    }

    protected boolean parseOption(CLOption cLOption) {
        boolean bl = true;
        switch (cLOption.getId()) {
            case 0: {
                if (this.wsdlURI != null) {
                    System.out.println("duplicate WSDL specified:" + cLOption.getArgument());
                    this.printUsage();
                    bl = false;
                }
                this.wsdlURI = cLOption.getArgument();
                break;
            }
            case 104: {
                this.printUsage();
                bl = false;
                break;
            }
            case 110: {
                this.outputWSDLName = cLOption.getArgument();
                break;
            }
            case 111: {
                this.outputDirectory = cLOption.getArgument();
                break;
            }
            case 98: {
                if (this.parseBindingOptions(cLOption)) break;
                this.printUsage();
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected boolean parseBindingOptions(CLOption cLOption) {
        boolean bl = true;
        String string = cLOption.getArgument();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            BindingGenerator bindingGenerator = this.getGenerator(string2);
            if (bindingGenerator == null) {
                System.err.println("invalid binding: " + string2);
                bl = false;
                continue;
            }
            if (this.requestedBindings.contains(bindingGenerator)) {
                System.err.println("duplicate binding: " + string2);
                bl = false;
                continue;
            }
            this.requestedBindings.add(bindingGenerator);
        }
        return bl;
    }

    protected BindingGenerator getGenerator(String string) {
        BindingGenerator bindingGenerator = null;
        Iterator iterator = this.availableGenerators.iterator();
        while (bindingGenerator == null && iterator.hasNext()) {
            BindingGenerator bindingGenerator2 = (BindingGenerator)iterator.next();
            if (!bindingGenerator2.getBindingTypeName().equalsIgnoreCase(string)) continue;
            bindingGenerator = bindingGenerator2;
        }
        return bindingGenerator;
    }

    protected boolean validateOptions() {
        boolean bl = true;
        if (this.wsdlURI == null || this.wsdlURI.length() < 1) {
            System.err.println("must specify a WSDL URI");
            bl = false;
        }
        if (this.requestedBindings.size() < 1) {
            System.err.println("must specify atleast one binding to add");
            bl = false;
        }
        if (bl && (this.outputWSDLName == null || this.outputWSDLName.length() < 1)) {
            int n = this.wsdlURI.lastIndexOf(File.separatorChar);
            this.outputWSDLName = n > -1 ? this.wsdlURI.substring(n + 1) : this.wsdlURI;
        }
        return bl;
    }

    protected int run(String[] stringArray) {
        CLArgsParser cLArgsParser = new CLArgsParser(stringArray, this.options);
        if (null != cLArgsParser.getErrorString()) {
            System.err.println(cLArgsParser.getErrorString());
            this.printUsage();
            return 1;
        }
        Vector vector = cLArgsParser.getArguments();
        for (int i = 0; i < vector.size(); ++i) {
            if (this.parseOption((CLOption)vector.get(i))) continue;
            this.printUsage();
            return 1;
        }
        if (!this.validateOptions()) {
            this.printUsage();
            return 1;
        }
        Definition definition = null;
        try {
            definition = this.readWSDL(this.wsdlURI);
        }
        catch (WSIFException wSIFException) {
            System.err.println("Exception reading WSDL file: " + wSIFException);
            wSIFException.printStackTrace();
            System.exit(1);
        }
        this.addBindings(definition);
        try {
            this.writeWSDL(definition, this.outputDirectory, this.outputWSDLName);
        }
        catch (WSIFException wSIFException) {
            System.err.println("Exception writing WSDL file: " + wSIFException);
            wSIFException.printStackTrace();
            System.exit(1);
        }
        return 0;
    }

    protected Definition readWSDL(String string) throws WSIFException {
        System.out.println("reading WSDL: " + string);
        Definition definition = null;
        try {
            definition = WSIFUtils.readWSDL(null, string);
        }
        catch (WSDLException wSDLException) {
            throw new WSIFException("exception reading WSDL '" + string + "'", wSDLException);
        }
        return definition;
    }

    private void writeWSDL(Definition definition, String string, String string2) throws WSIFException {
        try {
            File file;
            WSDLFactory wSDLFactory = WSDLFactory.newInstance();
            WSDLWriter wSDLWriter = wSDLFactory.newWSDLWriter();
            if (string != null && string.length() > 0) {
                file = new File(string.replace('.', '/'));
                file.mkdirs();
                file = new File(file, string2);
            } else {
                file = new File(string2);
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("writing WSDL: " + file);
            FileWriter fileWriter = new FileWriter(file);
            wSDLWriter.writeWSDL(definition, (Writer)fileWriter);
            fileWriter.close();
        }
        catch (Exception exception) {
            throw new WSIFException("exception writing WSDL", exception);
        }
    }

    private void printUsage() {
        String string = new FindThisClassName().getName();
        System.err.println("Usage: java " + string + " <options>" + " inputWSDLURI");
        System.err.println("where posible options include:");
        System.err.println(CLUtil.describeOptions((CLOptionDescriptor[])this.options).toString());
        System.err.print("available binding types to add are: ");
        Iterator iterator = this.availableGenerators.iterator();
        while (iterator.hasNext()) {
            BindingGenerator bindingGenerator = (BindingGenerator)iterator.next();
            System.err.print(bindingGenerator.getBindingTypeName());
            if (!iterator.hasNext()) continue;
            System.err.print(", ");
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        WSDL2WSDL wSDL2WSDL = new WSDL2WSDL();
        System.exit(wSDL2WSDL.run(stringArray));
    }

    protected static class FindThisClassName
    extends SecurityManager {
        protected FindThisClassName() {
        }

        public String getName() {
            return this.getClassContext()[1].getName();
        }
    }
}

