/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.tools.tojava;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.wsif.WSIFException;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.tools.tojava.WSIFEmitter;
import org.apache.wsif.util.WSIFUtils;

public class WSIFJavaTestCaseWriter
extends JavaClassWriter {
    protected ServiceEntry sEntry;
    protected SymbolTable symbolTable;
    protected String indent;
    protected static final String TAB = "    ";

    protected WSIFJavaTestCaseWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry.getName() + "TestCase", "testCase");
        this.sEntry = serviceEntry;
        this.symbolTable = symbolTable;
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        BindingEntry bindingEntry;
        Binding binding;
        this.indent = TAB;
        this.writeTestConstructor(printWriter);
        this.skipLines(printWriter, 1);
        this.writeTestSuite(printWriter);
        ArrayList<PortType> arrayList = new ArrayList<PortType>();
        Service service = this.sEntry.getService();
        Map map = service.getPorts();
        HashMap<PortType, String> hashMap = new HashMap<PortType, String>();
        HashMap<PortType, String> hashMap2 = new HashMap<PortType, String>();
        for (Port port : map.values()) {
            String string;
            binding = port.getBinding();
            bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            PortType portType = binding.getPortType();
            if (arrayList.contains(portType)) continue;
            arrayList.add(portType);
            String string2 = port.getName();
            if (!JavaUtils.isJavaId((String)string2)) {
                string2 = Utils.xmlNameToJavaClass((String)string2);
            }
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
            if (((WSIFEmitter)this.emitter).isTestcaseGenDII()) {
                this.writeComment(printWriter, port.getDocumentationElement());
                string = this.writeDIITestPortType(printWriter, service, string2, portType, portTypeEntry);
                hashMap.put(portType, string);
            }
            if (!((WSIFEmitter)this.emitter).isTestcaseGenStubs()) continue;
            this.writeComment(printWriter, port.getDocumentationElement());
            string = this.writeStubTestPortType(printWriter, service, string2, portType, portTypeEntry);
            hashMap2.put(portType, string);
        }
        for (Port port : map.values()) {
            binding = port.getBinding();
            bindingEntry = binding.getPortType();
            if (((WSIFEmitter)this.emitter).isTestcaseGenDII()) {
                this.writeTestMethod(printWriter, (String)hashMap.get(bindingEntry), port.getName());
            }
            if (!((WSIFEmitter)this.emitter).isTestcaseGenStubs()) continue;
            this.writeTestMethod(printWriter, (String)hashMap2.get(bindingEntry), port.getName());
        }
        this.writeMainMethod(printWriter);
    }

    protected void writeHeaderComments(PrintWriter printWriter) throws IOException {
        String string = this.getFileName();
        int n = string.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        printWriter.println("/**");
        printWriter.println(" * " + string);
        printWriter.println(" *");
        printWriter.println(" * This file was auto-generated from WSDL");
        printWriter.println(" * by the Apache WSIF WSDL2Java emitter.");
        printWriter.println(" *");
        printWriter.println(" * Search for TODO: for code requiring completing");
        printWriter.println(" */");
        printWriter.println();
    }

    protected void writePackage(PrintWriter printWriter) throws IOException {
        if (this.getPackage() != null) {
            printWriter.println("package " + this.getPackage() + ";");
            printWriter.println();
        }
        this.writeImports(printWriter);
        this.skipLines(printWriter, 1);
    }

    protected void writeImports(PrintWriter printWriter) throws IOException {
        if (((WSIFEmitter)this.emitter).isTestcaseGenStubs()) {
            printWriter.println("import java.rmi.RemoteException;");
        }
        if (((WSIFEmitter)this.emitter).isTestcaseGenDII()) {
            printWriter.println("import java.util.Iterator;");
        }
        this.skipLines(printWriter, 1);
        printWriter.println("import junit.framework.Test;");
        printWriter.println("import junit.framework.TestCase;");
        printWriter.println("import junit.framework.TestSuite;");
        printWriter.println("import junit.textui.TestRunner;");
        this.skipLines(printWriter, 1);
        if (((WSIFEmitter)this.emitter).isTestcaseGenDII()) {
            printWriter.println("import org.apache.wsif.WSIFConstants;");
            printWriter.println("import org.apache.wsif.WSIFException;");
            printWriter.println("import org.apache.wsif.WSIFMessage;");
            printWriter.println("import org.apache.wsif.WSIFOperation;");
            printWriter.println("import org.apache.wsif.WSIFPort;");
        }
        printWriter.println("import org.apache.wsif.WSIFService;");
        printWriter.println("import org.apache.wsif.WSIFServiceFactory;");
    }

    protected String getExtendsText() {
        return "extends TestCase ";
    }

    protected void writeTestConstructor(PrintWriter printWriter) throws IOException {
        this.addNewCodeLine(printWriter, "public " + this.getClassName() + "(String name) {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "super(name);");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
    }

    protected void writeTestSuite(PrintWriter printWriter) throws IOException {
        this.addNewCodeLine(printWriter, "public static Test suite() {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "return new TestSuite(" + this.getClassName() + ".class);");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
    }

    protected String writeStubTestPortType(PrintWriter printWriter, Service service, String string, PortType portType, PortTypeEntry portTypeEntry) throws IOException {
        QName qName = service.getQName();
        QName qName2 = portType.getQName();
        String string2 = "doitStub" + qName2.getLocalPart();
        this.addNewCodeLine(printWriter, "protected void " + string2 + "(String portName) {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "try {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "WSIFServiceFactory factory = WSIFServiceFactory.newInstance();");
        this.skipLines(printWriter, 1);
        this.addNewCodeLine(printWriter, "WSIFService service =");
        this.tabIn();
        this.addNewCodeLine(printWriter, "factory.getService(");
        this.tabIn();
        this.addNewCodeLine(printWriter, "\"" + this.emitter.getWSDLURI().replace('\\', '/') + "\",");
        this.addNewCodeLine(printWriter, "\"" + qName.getNamespaceURI() + "\",");
        this.addNewCodeLine(printWriter, "\"" + qName.getLocalPart() + "\",");
        this.addNewCodeLine(printWriter, "\"" + qName2.getNamespaceURI() + "\",");
        this.addNewCodeLine(printWriter, "\"" + qName2.getLocalPart() + "\");");
        this.tabOut();
        this.tabOut();
        this.skipLines(printWriter, 1);
        this.writeMapPackages(printWriter);
        String string3 = this.getSEIName(portType);
        this.addNewCodeLine(printWriter, string3);
        this.addCode(printWriter, " stub =");
        this.tabIn();
        this.addNewCodeLine(printWriter, "(");
        this.addCode(printWriter, string3);
        this.addCode(printWriter, ") service.getStub(portName, ");
        this.addCode(printWriter, string3);
        this.addCode(printWriter, ".class);");
        this.tabOut();
        this.skipLines(printWriter, 1);
        for (Operation operation : portType.getOperations()) {
            String string4 = this.makeExecuteOpMethodName(portType, operation);
            this.addNewCodeLine(printWriter, string4 + "(portName, stub);");
        }
        this.skipLines(printWriter, 1);
        this.tabOut();
        this.addNewCodeLine(printWriter, "} catch (Exception ex) {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "ex.printStackTrace();");
        this.addNewCodeLine(printWriter, "assertTrue(\"");
        this.addCode(printWriter, string2);
        this.addCode(printWriter, " got exception: \" + ex.getLocalizedMessage(), false);");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.skipLines(printWriter, 1);
        for (Operation operation : portType.getOperations()) {
            this.writeStubOperationMethod(printWriter, string3, portType, operation);
        }
        return string2;
    }

    protected void writeStubOperationMethod(PrintWriter printWriter, String string, PortType portType, Operation operation) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.addNewCodeLine(printWriter, "protected void ");
        String string2 = this.makeExecuteOpMethodName(portType, operation);
        this.addCode(printWriter, string2);
        this.addCode(printWriter, "(String portName, ");
        this.addCode(printWriter, string);
        this.addCode(printWriter, " stub) throws RemoteException {");
        this.skipLines(printWriter, 1);
        this.tabIn();
        ArrayList<String> arrayList = new ArrayList<String>();
        Input input = operation.getInput();
        if (input != null && input.getMessage() != null) {
            object5 = input.getMessage().getOrderedParts(null);
            this.unwrapIfWrapped(this.emitter.getCurrentDefinition(), (List)object5, operation.getName());
            if (object5.size() > 0) {
                this.addNewCodeLine(printWriter, "// TODO: initialize these parameters with required values");
            }
            int n = 0;
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (Part)object4.next();
                object2 = ProviderUtils.getPartType((Part)object3);
                object = Utils.getJavaLocalName((String)this.getClassName((QName)object2));
                String string3 = "p" + n++;
                arrayList.add(string3);
                this.addNewCodeLine(printWriter, (String)object + " " + string3 + " = " + this.getTypeInitialiser((QName)object2) + ";");
            }
            this.skipLines(printWriter, 1);
        }
        object5 = null;
        String string4 = "";
        object4 = operation.getOutput();
        if (object4 != null && object4.getMessage() != null && object4.getMessage().getParts().size() > 0) {
            object3 = object4.getMessage().getOrderedParts(null);
            this.unwrapIfWrapped(this.emitter.getCurrentDefinition(), (List)object3, operation.getName() + "Response");
            object2 = (Part)object3.get(0);
            object5 = object2.getName();
            if (JavaUtils.isJavaKeyword((String)object5)) {
                object5 = "_" + (String)object5;
            }
            object = ProviderUtils.getPartType((Part)object2);
            string4 = Utils.getJavaLocalName((String)this.getClassName((QName)object));
            this.addNewCodeLine(printWriter, string4);
            this.addCode(printWriter, " ");
            this.addCode(printWriter, (String)object5);
            this.addCode(printWriter, " = stub.");
            this.addCode(printWriter, ProviderUtils.lowercaseFirst(operation.getName()));
            this.addCode(printWriter, "(");
        } else {
            this.addNewCodeLine(printWriter, "stub.");
            this.addCode(printWriter, ProviderUtils.lowercaseFirst(operation.getName()));
            this.addCode(printWriter, "(");
        }
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            this.addCode(printWriter, (String)object2);
            if (!object3.hasNext()) continue;
            this.addCode(printWriter, ", ");
        }
        this.addCode(printWriter, ");");
        this.skipLines(printWriter, 1);
        if (object5 != null) {
            this.addNewCodeLine(printWriter, "System.out.println(\" port \" + portName + \" operation '");
            this.addCode(printWriter, operation.getName());
            this.addCode(printWriter, "' returned: \" + ");
            this.addCode(printWriter, (String)object5);
            this.addCode(printWriter, ");");
            this.skipLines(printWriter, 1);
            this.addNewCodeLine(printWriter, "// TODO: validate response parts here");
            if (Character.isLowerCase(string4.charAt(0))) {
                this.addNewCodeLine(printWriter, "// assertTrue(\"operation ");
            } else {
                this.addNewCodeLine(printWriter, "assertTrue(\"operation ");
            }
            this.addCode(printWriter, operation.getName());
            this.addCode(printWriter, " returned null!!\", ");
            this.addCode(printWriter, (String)object5);
            this.addCode(printWriter, " != null);");
        }
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.skipLines(printWriter, 1);
    }

    protected String writeDIITestPortType(PrintWriter printWriter, Service service, String string, PortType portType, PortTypeEntry portTypeEntry) throws IOException {
        QName qName = service.getQName();
        QName qName2 = portType.getQName();
        String string2 = "doitDII" + qName2.getLocalPart();
        this.skipLines(printWriter, 1);
        this.addNewCodeLine(printWriter, "protected void ");
        this.addCode(printWriter, string2);
        this.addCode(printWriter, "(String portName) {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "try {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "WSIFServiceFactory factory = WSIFServiceFactory.newInstance();");
        this.addNewCodeLine(printWriter, "factory.setFeature(");
        this.tabIn();
        this.addNewCodeLine(printWriter, "WSIFConstants.WSIF_FEATURE_AUTO_MAP_TYPES,");
        this.addNewCodeLine(printWriter, "new Boolean(true));");
        this.tabOut();
        this.skipLines(printWriter, 1);
        this.addNewCodeLine(printWriter, "WSIFService service =");
        this.tabIn();
        this.addNewCodeLine(printWriter, "factory.getService(");
        this.tabIn();
        this.addNewCodeLine(printWriter, "\"" + this.emitter.getWSDLURI().replace('\\', '/') + "\",");
        this.addNewCodeLine(printWriter, "\"" + qName.getNamespaceURI() + "\",");
        this.addNewCodeLine(printWriter, "\"" + qName.getLocalPart() + "\",");
        this.addNewCodeLine(printWriter, "\"" + qName2.getNamespaceURI() + "\",");
        this.addNewCodeLine(printWriter, "\"" + qName2.getLocalPart() + "\");");
        this.tabOut();
        this.tabOut();
        this.skipLines(printWriter, 1);
        this.writeMapPackages(printWriter);
        this.addNewCodeLine(printWriter, "WSIFPort port = service.getPort(portName);");
        this.skipLines(printWriter, 1);
        for (Operation operation : portType.getOperations()) {
            String string3 = this.makeExecuteOpMethodName(portType, operation);
            this.addNewCodeLine(printWriter, string3 + "(port);");
        }
        this.skipLines(printWriter, 1);
        this.tabOut();
        this.addNewCodeLine(printWriter, "} catch (Exception ex) {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "ex.printStackTrace();");
        this.addNewCodeLine(printWriter, "assertTrue(\"");
        this.addCode(printWriter, string2);
        this.addCode(printWriter, " got exception: \" + ex.getLocalizedMessage(), false);");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.skipLines(printWriter, 1);
        for (Operation operation : portType.getOperations()) {
            this.writeDIIOperationMethod(printWriter, portType, operation);
        }
        return string2;
    }

    protected void writeMapPackages(PrintWriter printWriter) {
        SymbolTable symbolTable = this.emitter.getSymbolTable();
        String string = this.emitter.getPackageName();
        if (string != null) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            Map map = symbolTable.getElementIndex();
            for (QName object : map.keySet()) {
                string2 = object.getNamespaceURI();
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            map = symbolTable.getTypeIndex();
            for (QName qName : map.keySet()) {
                string2 = qName.getNamespaceURI();
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            for (String string3 : arrayList) {
                if (string3.equals("http://schemas.xmlsoap.org/soap/encoding/") || string3.equals("http://www.w3.org/1999/XMLSchema") || string3.equals("http://www.w3.org/2000/10/XMLSchema") || string3.equals("http://www.w3.org/2001/XMLSchema")) continue;
                this.addNewCodeLine(printWriter, "service.mapPackage(\"" + string3 + "\", \"" + string + "\");");
            }
            this.skipLines(printWriter, 1);
        }
    }

    protected void writeDIIOperationMethod(PrintWriter printWriter, PortType portType, Operation operation) {
        String string;
        String string2;
        String string3;
        QName qName;
        int n;
        List list;
        this.addNewCodeLine(printWriter, "protected void ");
        String string4 = this.makeExecuteOpMethodName(portType, operation);
        this.addCode(printWriter, string4);
        this.addCode(printWriter, "(WSIFPort wsifPort) throws WSIFException {");
        this.skipLines(printWriter, 1);
        this.tabIn();
        this.addNewCodeLine(printWriter, "WSIFOperation op = wsifPort.createOperation(");
        if (this.isOverloaded(portType, operation)) {
            this.tabIn();
            this.addNewCodeLine(printWriter, "\"");
            this.addCode(printWriter, operation.getName());
            this.addCode(printWriter, "\",");
            this.addNewCodeLine(printWriter, "\"");
            this.addCode(printWriter, this.getInMsgName(operation));
            this.addCode(printWriter, "\",");
            this.addNewCodeLine(printWriter, "null);");
            this.tabOut();
        } else {
            this.addCode(printWriter, "\"");
            this.addCode(printWriter, operation.getName());
            this.addCode(printWriter, "\");");
        }
        this.skipLines(printWriter, 1);
        this.addNewCodeLine(printWriter, "WSIFMessage inMsg = op.createInputMessage();");
        this.addNewCodeLine(printWriter, "WSIFMessage outMsg = op.createOutputMessage();");
        this.addNewCodeLine(printWriter, "WSIFMessage faultMsg = op.createFaultMessage();");
        this.skipLines(printWriter, 1);
        boolean bl = true;
        Input input = operation.getInput();
        if (input != null && input.getMessage() != null) {
            list = input.getMessage().getOrderedParts(null);
            boolean bl2 = this.unwrapIfWrapped(this.emitter.getCurrentDefinition(), list, operation.getName());
            if (bl2) {
                if (list.size() > 1) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (list.size() > 0) {
                this.addNewCodeLine(printWriter, "// TODO: initialize these parameters with required values");
            }
            n = 0;
            for (Part part : list) {
                qName = ProviderUtils.getPartType(part);
                string3 = Utils.getJavaLocalName((String)this.getClassName(qName));
                string2 = "p" + n++;
                this.addNewCodeLine(printWriter, string3 + " " + string2 + " = " + this.getTypeInitialiser(qName) + ";");
                string = Character.isLowerCase(string3.charAt(0)) ? ProviderUtils.capitalizeFirst(string3) : "Object";
                this.addNewCodeLine(printWriter, "inMsg.set");
                this.addCode(printWriter, string);
                this.addCode(printWriter, "Part(\"");
                this.addCode(printWriter, part.getName());
                this.addCode(printWriter, "\", " + string2 + ");");
                this.skipLines(printWriter, 1);
            }
        }
        if (bl) {
            this.addNewCodeLine(printWriter, "WSIFMessage ctx = op.getContext();");
            this.addNewCodeLine(printWriter, "ctx.setObjectPart(");
            this.tabIn();
            this.addNewCodeLine(printWriter, "WSIFConstants.CONTEXT_OPERATION_STYLE,");
            this.addNewCodeLine(printWriter, "WSIFConstants.CONTEXT_OPERATION_STYLE_WRAPPED);");
            this.tabOut();
            this.addNewCodeLine(printWriter, "op.setContext(ctx);");
            this.skipLines(printWriter, 1);
        }
        this.addNewCodeLine(printWriter, "boolean success =");
        this.tabIn();
        this.addNewCodeLine(printWriter, "op.executeRequestResponseOperation(inMsg, outMsg, faultMsg);");
        this.tabOut();
        this.skipLines(printWriter, 1);
        this.addNewCodeLine(printWriter, "if (success) {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "System.out.println(\"operation '" + operation.getName() + "' successfull:\");");
        list = operation.getOutput();
        if (list != null && list.getMessage() != null) {
            List list2 = list.getMessage().getOrderedParts(null);
            this.unwrapIfWrapped(this.emitter.getCurrentDefinition(), list2, operation.getName() + "Response");
            n = 0;
            for (Part part : list2) {
                String string5;
                qName = ProviderUtils.getPartType(part);
                string3 = Utils.getJavaLocalName((String)this.getClassName(qName));
                string2 = "r" + n++;
                if (Character.isLowerCase(string3.charAt(0))) {
                    string = ProviderUtils.capitalizeFirst(string3);
                    string5 = "";
                } else {
                    string = "Object";
                    string5 = "(" + string3 + ")";
                }
                this.addNewCodeLine(printWriter, string3 + " " + string2 + " = " + string5 + " outMsg.get" + string + "Part(\"" + part.getName() + "\");");
                this.addNewCodeLine(printWriter, "System.out.println(\"" + part.getName() + ": \" + " + string2 + ");");
            }
            if (list2.size() > 0) {
                this.skipLines(printWriter, 1);
                this.addNewCodeLine(printWriter, "// TODO: validate response parts here");
                this.skipLines(printWriter, 1);
            }
        }
        this.tabOut();
        this.addNewCodeLine(printWriter, "} else {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "System.err.println(\"operation '" + operation.getName() + "' returned a fault:\");");
        this.addNewCodeLine(printWriter, "for (Iterator i = faultMsg.getPartNames(); i.hasNext();) {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "System.err.println(faultMsg.getObjectPart((String) i.next()));");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.addNewCodeLine(printWriter, "assertTrue(\"");
        this.addCode(printWriter, string4);
        this.addCode(printWriter, " returned a fault!!\", false);");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.skipLines(printWriter, 1);
    }

    protected void writeTestMethod(PrintWriter printWriter, String string, String string2) throws IOException {
        String string3 = "test" + ProviderUtils.capitalizeFirst(string) + string2;
        this.addNewCodeLine(printWriter, "public void " + string3 + "() {");
        this.tabIn();
        this.addNewCodeLine(printWriter, string + "(\"" + string2 + "\");");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.skipLines(printWriter, 1);
    }

    protected void writeMainMethod(PrintWriter printWriter) throws IOException {
        this.addNewCodeLine(printWriter, "public static void main(String[] args) {");
        this.tabIn();
        this.addNewCodeLine(printWriter, "TestRunner.run(suite());");
        this.tabOut();
        this.addNewCodeLine(printWriter, "}");
        this.skipLines(printWriter, 1);
    }

    protected String makeExecuteOpMethodName(PortType portType, Operation operation) {
        String string = Utils.xmlNameToJavaClass((String)operation.getName());
        String string2 = "executeOp" + string;
        if (this.isOverloaded(portType, operation)) {
            string2 = string2 + ProviderUtils.capitalizeFirst(this.getInMsgName(operation));
        }
        return string2;
    }

    protected boolean unwrapIfWrapped(Definition definition, List list, String string) {
        Part part;
        boolean bl = false;
        if (!this.emitter.isNowrap() && (part = ProviderUtils.getWrapperPart(list, string)) != null) {
            List list2;
            try {
                list2 = ProviderUtils.unWrapPart(part, definition);
            }
            catch (WSIFException wSIFException) {
                throw new RuntimeException("exception unwrapping operation " + string + ": " + wSIFException.getLocalizedMessage());
            }
            int n = list.indexOf(part);
            list.remove(n);
            list.addAll(n, list2);
            bl = true;
        }
        return bl;
    }

    protected String getInMsgName(Operation operation) {
        String string = "";
        Input input = operation.getInput();
        if (input != null) {
            string = input.getName();
        }
        return string;
    }

    protected boolean isOverloaded(PortType portType, Operation operation) {
        boolean bl = false;
        String string = operation.getName();
        Iterator iterator = portType.getOperations().iterator();
        while (!bl && iterator.hasNext()) {
            Operation operation2 = (Operation)iterator.next();
            if (operation.equals(operation2) || !string.equals(operation2.getName())) continue;
            bl = true;
        }
        return bl;
    }

    protected String getClassName(QName qName) {
        String string;
        Map map;
        Object v;
        String string2 = "";
        SymbolTable symbolTable = this.emitter.getSymbolTable();
        Type type = symbolTable.getType(qName);
        string2 = type != null ? type.getName() : ((v = (map = WSIFUtils.getSimpleTypesMap()).get(qName)) != null ? ((string = (String)v).indexOf(91) < 0 ? string : WSIFJavaTestCaseWriter.getArrayType(string)) : Utils.makePackageName((String)qName.getNamespaceURI()) + "." + Utils.xmlNameToJavaClass((String)qName.getLocalPart()));
        return string2;
    }

    protected static String getArrayType(String string) {
        String string2 = "";
        int n = 0;
        while (string.charAt(n) == '[') {
            string2 = string2 + "[]";
            ++n;
        }
        String string3 = "";
        switch (string.charAt(string.lastIndexOf(91) + 1)) {
            case 'I': {
                string3 = "int";
                break;
            }
            case 'F': {
                string3 = "float";
                break;
            }
            case 'J': {
                string3 = "long";
                break;
            }
            case 'D': {
                string3 = "double";
                break;
            }
            case 'Z': {
                string3 = "boolean";
                break;
            }
            case 'B': {
                string3 = "byte";
                break;
            }
            case 'S': {
                string3 = "short";
                break;
            }
            case 'L': {
                string3 = string.substring(string.lastIndexOf(91) + 2);
            }
        }
        return string3 + string2;
    }

    protected String getTypeInitialiser(QName qName) {
        String string = "";
        String string2 = Utils.getJavaLocalName((String)this.getClassName(qName));
        String string3 = Utils.getJavaLocalName((String)string2);
        if ("int".equals(string3)) {
            string = "0";
        } else if ("short".equals(string3)) {
            string = "0";
        } else if ("boolean".equals(string3)) {
            string = "false";
        } else if ("byte".equals(string3)) {
            string = "0";
        } else if ("long".equals(string3)) {
            string = "0";
        } else if ("double".equals(string3)) {
            string = "0";
        } else if ("float".equals(string3)) {
            string = "0";
        } else if ("char".equals(string3)) {
            string = "''";
        } else if ("String".equals(string3)) {
            string = "\"\"";
        } else {
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (string2.indexOf(91) < 0) {
                stringBuffer.append("()");
            } else {
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    if (stringBuffer.charAt(i) != '[') continue;
                    stringBuffer.insert(i + 1, '0');
                }
            }
            string = "new " + stringBuffer.toString();
        }
        return string;
    }

    protected String getSEIName(PortType portType) {
        return ProviderUtils.capitalizeFirst(Utils.getJavaLocalName((String)this.getClassName(portType.getQName())));
    }

    protected void addNewCodeLine(PrintWriter printWriter, String string) {
        printWriter.println();
        printWriter.print(this.indent);
        printWriter.print(string);
    }

    protected void addCode(PrintWriter printWriter, String string) {
        printWriter.print(string);
    }

    protected void skipLines(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.println();
        }
    }

    protected void tabIn() {
        this.indent = this.indent + TAB;
    }

    protected void tabOut() {
        if (this.indent.length() >= TAB.length()) {
            this.indent = this.indent.substring(0, this.indent.length() - TAB.length());
        }
    }
}

