/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.tools.wsdl;

import com.ibm.wsdl.BindingInputImpl;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.BindingOutputImpl;
import com.ibm.wsdl.PortImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.tools.wsdl.BindingGenerator;

public abstract class ModelBindingGenerator
implements BindingGenerator {
    protected String bindingTypeName;

    public ModelBindingGenerator(String string) {
        this.bindingTypeName = string;
    }

    public String getBindingTypeName() {
        return this.bindingTypeName;
    }

    public void addBindings(Definition definition) {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        ArrayList<PortType> arrayList2 = new ArrayList<PortType>();
        Map map = definition.getServices();
        for (QName qName : map.keySet()) {
            Service service = (Service)map.get(qName);
            Map map2 = service.getPorts();
            for (String string : map2.keySet()) {
                Port port = (Port)map2.get(string);
                PortType portType = port.getBinding().getPortType();
                if (arrayList2.contains(portType) || !this.isNewBindingRequired(port)) continue;
                Binding binding = this.createBinding(definition, port);
                definition.addBinding(binding);
                Port port2 = this.createServicePort(service, port, binding);
                arrayList.add(port2);
                arrayList2.add(portType);
            }
            Iterator<Object> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                service.addPort((Port)iterator.next());
            }
        }
        if (arrayList2.size() > 0) {
            this.doAddNamespace(definition);
        }
    }

    protected boolean isNewBindingRequired(Port port) {
        boolean bl = true;
        Binding binding = port.getBinding();
        Class clazz = this.getImplementedBinding();
        List list = binding.getExtensibilityElements();
        Iterator iterator = list.iterator();
        while (bl && iterator.hasNext()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            if (!clazz.isAssignableFrom(extensibilityElement.getClass())) continue;
            bl = false;
        }
        return bl;
    }

    public abstract Class getImplementedBinding();

    protected void doAddNamespace(Definition definition) {
    }

    protected Binding createBinding(Definition definition, Port port) {
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        Binding binding2 = definition.createBinding();
        binding2.setPortType(portType);
        QName qName = binding.getQName();
        QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart() + ProviderUtils.capitalizeFirst(this.getBindingTypeName()));
        binding2.setQName(qName2);
        this.doCreateBinding(portType, binding2);
        this.addOperations(portType, binding2);
        binding2.setUndefined(false);
        return binding2;
    }

    protected void doCreateBinding(PortType portType, Binding binding) {
    }

    protected void addOperations(PortType portType, Binding binding) {
        for (Operation operation : portType.getOperations()) {
            Output output;
            BindingOperationImpl bindingOperationImpl = new BindingOperationImpl();
            bindingOperationImpl.setName(operation.getName());
            this.doCreateBindingOperation(operation, (BindingOperation)bindingOperationImpl);
            Input input = operation.getInput();
            if (input != null) {
                output = new BindingInputImpl();
                output.setName(input.getName());
                this.doCreateBindingInput(operation, (BindingOperation)bindingOperationImpl, (BindingInput)output);
                bindingOperationImpl.setBindingInput((BindingInput)output);
            }
            if ((output = operation.getOutput()) != null) {
                BindingOutputImpl bindingOutputImpl = new BindingOutputImpl();
                bindingOutputImpl.setName(output.getName());
                this.doCreateBindingOutput(operation, (BindingOperation)bindingOperationImpl, (BindingOutput)bindingOutputImpl);
                bindingOperationImpl.setBindingOutput((BindingOutput)bindingOutputImpl);
            }
            binding.addBindingOperation((BindingOperation)bindingOperationImpl);
        }
    }

    protected void doCreateBindingOperation(Operation operation, BindingOperation bindingOperation) {
    }

    protected void doCreateBindingInput(Operation operation, BindingOperation bindingOperation, BindingInput bindingInput) {
    }

    protected void doCreateBindingOutput(Operation operation, BindingOperation bindingOperation, BindingOutput bindingOutput) {
    }

    protected Port createServicePort(Service service, Port port, Binding binding) {
        PortImpl portImpl = new PortImpl();
        portImpl.setName(port.getName() + ProviderUtils.capitalizeFirst(this.getBindingTypeName()));
        portImpl.setBinding(binding);
        this.doCreateServicePort((Port)portImpl);
        return portImpl;
    }

    protected void doCreateServicePort(Port port) {
    }
}

