/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.util.WSIFProperties;

public class WSIFPluggableProviders {
    private static boolean autoLoadProviders = true;
    private static ArrayList providersFromSPIFiles;
    private static HashMap defaultNSProviders;
    private static final String PLUGABLE_PROVIDER_FILENAME = "META-INF/services/org.apache.wsif.spi.WSIFProvider";

    public static WSIFProvider getProvider(String string) {
        WSIFProvider wSIFProvider;
        Trc.entry(null, string);
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (defaultNSProviders == null) {
            defaultNSProviders = new HashMap();
        } else {
            wSIFProvider = (WSIFProvider)defaultNSProviders.get(string);
            if (wSIFProvider != null) {
                return wSIFProvider;
            }
        }
        ArrayList arrayList = WSIFPluggableProviders.getSupportingProviders(string, true);
        if (arrayList.size() == 0) {
            return null;
        }
        wSIFProvider = arrayList.size() == 1 ? (WSIFProvider)arrayList.get(0) : WSIFPluggableProviders.chooseProvider(arrayList, string);
        defaultNSProviders.put(string, wSIFProvider);
        Trc.exit(wSIFProvider);
        return wSIFProvider;
    }

    public static void overrideDefaultProvider(String string, WSIFProvider wSIFProvider) {
        Trc.entry(null, string, wSIFProvider);
        if (defaultNSProviders == null) {
            defaultNSProviders = new HashMap();
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (wSIFProvider == null) {
            WSIFProvider wSIFProvider2 = (WSIFProvider)defaultNSProviders.get(string);
            if (defaultNSProviders != null) {
                defaultNSProviders.remove(string);
            }
        } else {
            defaultNSProviders.put(string, wSIFProvider);
            WSIFPluggableProviders.issueChosenProviderMsg(string, wSIFProvider);
        }
        Trc.exit();
    }

    public static boolean isProviderAvailable(String string) {
        return WSIFPluggableProviders.isProviderAvailable(string, string);
    }

    public static boolean isProviderAvailable(String string, String string2) {
        boolean bl = false;
        ArrayList arrayList = WSIFPluggableProviders.getSupportingProviders(string, false);
        if (arrayList.size() > 0) {
            if (string2 == null || string2.length() < 1 || string2.equals(string)) {
                bl = true;
            } else {
                for (int i = 0; i < arrayList.size() && !bl; ++i) {
                    String[] stringArray = ((WSIFProvider)arrayList.get(i)).getAddressNamespaceURIs();
                    for (int j = 0; j < stringArray.length && !bl; ++j) {
                        if (!string2.equals(stringArray[j])) continue;
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public static void setAutoLoadProviders(boolean bl) {
        Trc.entry(null, bl);
        if (autoLoadProviders != bl) {
            providersFromSPIFiles = null;
            defaultNSProviders = null;
            autoLoadProviders = bl;
        }
        Trc.exit();
    }

    public static boolean isAutoLoadProviders() {
        Trc.entry(null);
        Trc.exit(autoLoadProviders);
        return autoLoadProviders;
    }

    private static ArrayList getSupportingProviders(String string, boolean bl) {
        Trc.entry(null, string, new Boolean(bl));
        if (providersFromSPIFiles == null) {
            providersFromSPIFiles = WSIFPluggableProviders.getAllDynamicWSIFProviders();
        }
        ArrayList<WSIFProvider> arrayList = new ArrayList<WSIFProvider>();
        for (WSIFProvider wSIFProvider : providersFromSPIFiles) {
            String[] stringArray = wSIFProvider.getBindingNamespaceURIs();
            for (int i = 0; i < stringArray.length; ++i) {
                if (string == null || !string.equals(stringArray[i])) continue;
                Trc.event(null, "Adding provider " + wSIFProvider + " for namespace " + stringArray[i]);
                arrayList.add(wSIFProvider);
            }
        }
        if (defaultNSProviders != null && defaultNSProviders.get(string) != null) {
            Trc.event(null, "Adding default provider " + defaultNSProviders.get(string) + " for namespace " + string);
            arrayList.add((WSIFProvider)defaultNSProviders.get(string));
        }
        if (arrayList.size() > 1 && bl) {
            WSIFPluggableProviders.issueMultipleProvidersMsg(string, arrayList);
        }
        Trc.exit(arrayList);
        return arrayList;
    }

    private static ArrayList getAllDynamicWSIFProviders() {
        Trc.entry(null);
        if (!autoLoadProviders) {
            return new ArrayList();
        }
        ArrayList arrayList = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return WSIFPluggableProviders.findPlugableProviders();
            }
        });
        Trc.exit(arrayList);
        return arrayList;
    }

    private static ArrayList findPlugableProviders() {
        Object object;
        ArrayList arrayList = new ArrayList();
        ArrayList<WSIFProvider> arrayList2 = new ArrayList<WSIFProvider>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            object = classLoader.getResources(PLUGABLE_PROVIDER_FILENAME);
            while (object.hasMoreElements()) {
                WSIFPluggableProviders.readMETAINFClassNames(object.nextElement(), arrayList);
            }
        }
        catch (Exception exception) {
            Trc.exception(exception);
            MessageLogger.log("WSIF.0003W", exception.getMessage());
            return arrayList2;
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                Object obj = Class.forName((String)object.next(), true, classLoader).newInstance();
                if (obj instanceof WSIFProvider) {
                    WSIFProvider wSIFProvider = (WSIFProvider)obj;
                    if (wSIFProvider.getBindingNamespaceURIs().length > 0) {
                        Trc.event(null, "Registering provider: " + wSIFProvider);
                        arrayList2.add(wSIFProvider);
                        continue;
                    }
                    WSIFException wSIFException = new WSIFException("Disabled WSIFProvider found:" + wSIFProvider.getClass().getName());
                    Trc.ignoredException(wSIFException);
                    continue;
                }
                MessageLogger.log("WSIF.0003W", "The provider class specified," + (obj == null ? null : obj.getClass().getName()) + ", does not implement org.apache.wsif.spi.WSIFProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trc.exception(classNotFoundException);
                MessageLogger.log("WSIF.0003W", classNotFoundException.getMessage());
            }
            catch (Throwable throwable) {
                Trc.exception(throwable);
                MessageLogger.log("WSIF.0003W", throwable.getMessage());
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMETAINFClassNames(URL uRL, ArrayList arrayList) {
        Trc.entry(null, uRL);
        Trc.event(null, "Reading provider class names from URL: " + uRL.toString());
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(35);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((string = string.trim()).length() <= 0) continue;
                Trc.event(null, "Found provider class name: " + string);
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        catch (IOException iOException) {
            Trc.exception(iOException);
            MessageLogger.log("WSIF.0003W", iOException.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Trc.exception(iOException);
                    MessageLogger.log("WSIF.0003W", iOException.getMessage());
                }
            }
        }
        Trc.exit();
    }

    private static WSIFProvider chooseProvider(ArrayList arrayList, String string) {
        int n;
        if (arrayList == null || arrayList.size() < 1) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (WSIFProvider)arrayList.get(0);
        }
        for (n = arrayList.size() - 1; n > 0 && !WSIFPluggableProviders.isDefaultProvider((WSIFProvider)arrayList.get(n), string); --n) {
        }
        WSIFProvider wSIFProvider = (WSIFProvider)arrayList.get(n);
        WSIFPluggableProviders.issueChosenProviderMsg(string, wSIFProvider);
        return wSIFProvider;
    }

    private static boolean isDefaultProvider(WSIFProvider wSIFProvider, String string) {
        String string2 = wSIFProvider.getClass().getName();
        try {
            String string3 = "wsif.provider.default." + string2;
            int n = Integer.parseInt(WSIFProperties.getProperty(string3));
            for (int i = 1; i <= n; ++i) {
                string3 = "wsif.provider.uri." + i + "." + string2;
                String string4 = WSIFProperties.getProperty(string3);
                if (string == null || !string.equals(string4)) continue;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Trc.ignoredException(numberFormatException);
        }
        return false;
    }

    private static void issueMultipleProvidersMsg(String string, ArrayList arrayList) {
        String string2 = arrayList.get(0).getClass().getName();
        for (int i = 1; i < arrayList.size(); ++i) {
            string2 = string2 + ", " + arrayList.get(i).getClass().getName();
        }
        Trc.event(null, "- Multiple WSIFProvider found supporting the same namespace URI '" + string + "'. Found ('" + string2 + "')");
    }

    private static void issueChosenProviderMsg(String string, WSIFProvider wSIFProvider) {
        String string2 = wSIFProvider == null ? "null" : wSIFProvider.getClass().getName();
        Trc.event(null, "- Using WSIFProvider '" + string2 + "' for namespaceURI '" + string + "'");
    }
}

