/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.wsif.logging.Trc;

public class WSIFProperties {
    private static Properties properties;

    public static String getProperty(String string) {
        Trc.entry(null, string);
        if (properties == null) {
            properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wsif.properties");
                    Properties properties = new Properties();
                    try {
                        properties.load(inputStream);
                    }
                    catch (Exception exception) {
                        Trc.exception(exception);
                        return null;
                    }
                    return properties;
                }
            });
        }
        if (properties == null) {
            Trc.exit(null);
            return null;
        }
        String string2 = properties.getProperty(string);
        Trc.exit(string2);
        return string2;
    }

    public static long getAsyncTimeout() {
        long l;
        Trc.entry(null);
        try {
            l = Long.parseLong(WSIFProperties.getProperty("wsif.asyncrequest.timeout"));
            l = l < 0L ? 0L : (l *= 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            Trc.exception(numberFormatException);
            l = 0L;
        }
        Trc.exit(new Long(l));
        return l;
    }

    public static long getSyncTimeout() {
        long l;
        Trc.entry(null);
        try {
            l = Long.parseLong(WSIFProperties.getProperty("wsif.syncrequest.timeout"));
            if (l < 0L) {
                l = 0L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Trc.exception(numberFormatException);
            l = 0L;
        }
        Trc.exit(new Long(l));
        return l;
    }

    public static boolean areUnreferencedAttachmentsSupported() {
        Trc.entry(null);
        boolean bl = false;
        String string = WSIFProperties.getProperty("wsif.unreferencedattachments");
        if ("on".equals(string)) {
            bl = true;
        }
        Trc.exit(bl);
        return bl;
    }
}

