/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.format.WSIFFormatHandler;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.MappingHelper;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.util.WSIFPluggableProviders;
import org.apache.wsif.wsdl.AuthenticatingProxyWSDLLocatorImpl;
import org.apache.wsif.wsdl.ClosableLocator;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSIFUtils {
    private static Class initContextClass;
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String FORMAT_HANDLER = "FormatHandler";
    private static final String ELEMENT_FORMAT_HANDLER = "ElementFormatHandler";
    private static final String PHYSICALREP = "physicalrep/";
    private static final String FORMATBINDING = "formatbinding/";
    private static final String XMLSEPARATORS = "-.:\u00b7\u0387\u06dd\u06de\u30fb";
    private static final String XMLSEPARATORS_NODOT = "-:\u00b7\u0387\u06dd\u06de";
    private static final String UNDERSCORE = "_";
    private static final String WWW = "www";
    private static final String lookupPrefix = "java:comp/env/";
    private static final String emptyString = "";
    private static Boolean providersInitialized;
    private static boolean simpleTypesMapCreated;
    private static HashMap simpleTypesMap;
    private static HashMap keywordMap;

    public static boolean isJNDIAvailable() {
        Trc.entry(null);
        initContextClass = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName("javax.naming.InitialContext", true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable throwable) {
                    Trc.ignoredException(throwable);
                    return null;
                }
            }
        });
        boolean bl = true;
        if (initContextClass == null) {
            bl = false;
        }
        Trc.exit(bl);
        return bl;
    }

    public static Service selectService(Definition definition, String string, String string2) throws WSIFException {
        Trc.entry(null, definition, string, string2);
        Map map = WSIFUtils.getAllItems(definition, "Service");
        QName qName = string != null && string2 != null ? new QName(string, string2) : null;
        Service service = (Service)WSIFUtils.getNamedItem(map, qName, "Service");
        Trc.exit(service);
        return service;
    }

    public static PortType selectPortType(Definition definition, String string, String string2) throws WSIFException {
        Trc.entry(null, definition, string, string2);
        Map map = WSIFUtils.getAllItems(definition, "PortType");
        QName qName = string != null && string2 != null ? new QName(string, string2) : null;
        PortType portType = (PortType)WSIFUtils.getNamedItem(map, qName, "PortType");
        Trc.exit(portType);
        return portType;
    }

    public static void addDefinedItems(Map map, String string, Map map2) {
        Trc.entry(null, map, string, map2);
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            if (string.equals("Message")) {
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Message message = (Message)entry.getValue();
                    if (message.isUndefined()) continue;
                    map2.put(entry.getKey(), message);
                }
            } else if (string.equals("Operation")) {
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Operation operation = (Operation)entry.getValue();
                    if (operation.isUndefined()) continue;
                    map2.put(entry.getKey(), operation);
                }
            } else if (string.equals("PortType")) {
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    PortType portType = (PortType)entry.getValue();
                    if (portType.isUndefined()) continue;
                    map2.put(entry.getKey(), portType);
                }
            } else if (string.equals("Binding")) {
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Binding binding = (Binding)entry.getValue();
                    if (binding.isUndefined()) continue;
                    map2.put(entry.getKey(), binding);
                }
            } else if (string.equals("Service")) {
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Service service = (Service)entry.getValue();
                    map2.put(entry.getKey(), service);
                }
            }
        }
        Trc.exit();
    }

    private static void getAllItems(Definition definition, String string, Map map) {
        Trc.entry(null, definition, string, map);
        Map map2 = null;
        if (string.equals("PortType")) {
            map2 = definition.getPortTypes();
        } else if (string.equals("Service")) {
            map2 = definition.getServices();
        } else {
            throw new IllegalArgumentException("Don't know how to find all " + string + "s.");
        }
        WSIFUtils.addDefinedItems(map2, string, map);
        Map map3 = definition.getImports();
        if (map3 != null) {
            for (List list : map3.values()) {
                if (list == null) continue;
                for (Import import_ : list) {
                    Definition definition2;
                    if (import_ == null || (definition2 = import_.getDefinition()) == null) continue;
                    WSIFUtils.getAllItems(definition2, string, map);
                }
            }
        }
        Trc.exit();
    }

    public static Map getAllItems(Definition definition, String string) {
        Trc.entry(null, definition, string);
        HashMap hashMap = new HashMap();
        WSIFUtils.getAllItems(definition, string, hashMap);
        Trc.exit(hashMap);
        return hashMap;
    }

    public static Object getNamedItem(Map map, QName qName, String string) throws WSIFException {
        Trc.entry(null, map, qName, string);
        if (qName != null) {
            Object v = map.get(qName);
            if (v != null) {
                Trc.exit(v);
                return v;
            }
            throw new WSIFException(string + " '" + qName + "' not found. Choices are: " + WSIFUtils.getCommaListFromQNameMap(map));
        }
        int n = map.size();
        if (n == 1) {
            Iterator iterator = map.values().iterator();
            Object v = iterator.next();
            Trc.exit(v);
            return v;
        }
        if (n == 0) {
            throw new WSIFException("WSDL document contains no " + string + "s.");
        }
        throw new WSIFException("Please specify a " + string + ". Choices are: " + WSIFUtils.getCommaListFromQNameMap(map));
    }

    private static String getCommaListFromQNameMap(Map map) {
        StringBuffer stringBuffer = new StringBuffer("{");
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            stringBuffer.append((n > 0 ? ", " : emptyString) + qName);
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static Definition readWSDL(String string, String string2) throws WSDLException {
        Trc.entry(null, string, string2);
        WSIFUtils.initializeProviders();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        try {
            Definition definition = wSDLReader.readWSDL(string, string2);
            Trc.exitExpandWsdl(definition);
            return definition;
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            MessageLogger.log("WSIF.0002E", string2);
            throw wSDLException;
        }
    }

    public static Definition readWSDLThroughAuthProxy(String string, PasswordAuthentication passwordAuthentication) throws WSDLException {
        Trc.entry(null, string, passwordAuthentication);
        WSIFUtils.initializeProviders();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        AuthenticatingProxyWSDLLocatorImpl authenticatingProxyWSDLLocatorImpl = null;
        try {
            authenticatingProxyWSDLLocatorImpl = new AuthenticatingProxyWSDLLocatorImpl(string, passwordAuthentication);
            Definition definition = wSDLReader.readWSDL((WSDLLocator)authenticatingProxyWSDLLocatorImpl);
            Trc.exitExpandWsdl(definition);
            Definition definition2 = definition;
            return definition2;
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            MessageLogger.log("WSIF.0002E", string);
            throw wSDLException;
        }
        finally {
            try {
                if (authenticatingProxyWSDLLocatorImpl != null && authenticatingProxyWSDLLocatorImpl instanceof ClosableLocator) {
                    ((ClosableLocator)authenticatingProxyWSDLLocatorImpl).close();
                }
            }
            catch (IOException iOException) {
                Trc.ignoredException(iOException);
            }
        }
    }

    public static Definition readWSDL(WSDLLocator wSDLLocator) throws WSDLException {
        Trc.entry(null, wSDLLocator);
        if (wSDLLocator == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "Cannot use null WSDLLocator for reading wsdl");
        }
        WSIFUtils.initializeProviders();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        try {
            Definition definition = wSDLReader.readWSDL(wSDLLocator);
            Trc.exitExpandWsdl(definition);
            return definition;
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            MessageLogger.log("WSIF.0002E", wSDLLocator.getBaseURI());
            throw wSDLException;
        }
    }

    public static Definition readWSDL(URL uRL, Reader reader, ClassLoader classLoader) throws WSDLException {
        String string = uRL == null ? null : uRL.toString();
        return WSIFUtils.readWSDL(string, reader, classLoader);
    }

    public static Definition readWSDL(String string, Reader reader, ClassLoader classLoader) throws WSDLException {
        Trc.entry(null, string, reader, classLoader);
        WSIFUtils.initializeProviders();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        WSIFWSDLLocatorImpl wSIFWSDLLocatorImpl = null;
        try {
            wSIFWSDLLocatorImpl = new WSIFWSDLLocatorImpl(string, reader, classLoader);
            Definition definition = wSDLReader.readWSDL((WSDLLocator)wSIFWSDLLocatorImpl);
            Trc.exitExpandWsdl(definition);
            Definition definition2 = definition;
            return definition2;
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            MessageLogger.log("WSIF.0002E", string);
            throw wSDLException;
        }
        finally {
            try {
                if (wSIFWSDLLocatorImpl != null) {
                    wSIFWSDLLocatorImpl.close();
                }
            }
            catch (IOException iOException) {
                Trc.ignoredException(iOException);
            }
        }
    }

    public static Definition readWSDL(URL uRL, String string, ClassLoader classLoader) throws WSDLException {
        Trc.entry(null, uRL, string, classLoader);
        WSIFUtils.initializeProviders();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        WSIFWSDLLocatorImpl wSIFWSDLLocatorImpl = null;
        try {
            String string2 = uRL == null ? null : uRL.toString();
            wSIFWSDLLocatorImpl = new WSIFWSDLLocatorImpl(string2, string, classLoader);
            Definition definition = wSDLReader.readWSDL((WSDLLocator)wSIFWSDLLocatorImpl);
            Trc.exitExpandWsdl(definition);
            Definition definition2 = definition;
            return definition2;
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            MessageLogger.log("WSIF.0002E", string);
            throw wSDLException;
        }
        finally {
            try {
                if (wSIFWSDLLocatorImpl != null) {
                    wSIFWSDLLocatorImpl.close();
                }
            }
            catch (IOException iOException) {
                Trc.ignoredException(iOException);
            }
        }
    }

    public static Definition readWSDL(String string, Reader reader) throws WSDLException {
        Trc.entry(null, string, reader);
        WSIFUtils.initializeProviders();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        Definition definition = wSDLReader.readWSDL(string, new InputSource(reader));
        Trc.exitExpandWsdl(definition);
        return definition;
    }

    public static Definition readWSDL(String string, Document document) throws WSDLException {
        Trc.entry(null, string, document);
        WSIFUtils.initializeProviders();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        Definition definition = wSDLReader.readWSDL(string, document);
        Trc.exitExpandWsdl(definition);
        return definition;
    }

    public static Definition readWSDL(String string, Element element) throws WSDLException {
        Trc.entry(null, string, element);
        WSIFUtils.initializeProviders();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        Definition definition = wSDLReader.readWSDL(string, element);
        Trc.exitExpandWsdl(definition);
        return definition;
    }

    public static void writeWSDL(Definition definition, Writer writer) throws WSDLException {
        Trc.entry(null, definition, writer);
        WSDLFactory wSDLFactory = WSDLFactory.newInstance((String)"org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLWriter wSDLWriter = wSDLFactory.newWSDLWriter();
        wSDLWriter.writeWSDL(definition, writer);
        Trc.exit();
    }

    public static Definition getDefinitionFromLocation(String string, String string2) throws WSIFException {
        Trc.entry(null, string, string2);
        if (string2 == null) {
            throw new WSIFException("WSDL location must not be null.");
        }
        Definition definition = null;
        try {
            definition = WSIFUtils.readWSDL(string, string2);
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            throw new WSIFException("Problem reading WSDL document.", wSDLException);
        }
        Trc.exitExpandWsdl(definition);
        return definition;
    }

    public static Definition getDefinitionFromContent(String string, String string2) throws WSIFException {
        Trc.entry(null, string, string2);
        if (string2 == null) {
            throw new WSIFException("WSDL content must not be null.");
        }
        Definition definition = null;
        try {
            definition = WSIFUtils.readWSDL(string, new StringReader(string2));
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            throw new WSIFException("Problem reading WSDL document.", wSDLException);
        }
        Trc.exitExpandWsdl(definition);
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeProviders() {
        Boolean bl = providersInitialized;
        synchronized (bl) {
            if (!providersInitialized.booleanValue()) {
                WSIFPluggableProviders.getProvider(SLASH);
                providersInitialized = new Boolean(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSimpleTypesMap() {
        HashMap hashMap = simpleTypesMap;
        synchronized (hashMap) {
            if (!simpleTypesMapCreated) {
                MappingHelper.populateWithStandardXMLJavaMappings(simpleTypesMap, "http://www.w3.org/1999/XMLSchema", true);
                MappingHelper.populateWithStandardXMLJavaMappings(simpleTypesMap, "http://www.w3.org/2000/10/XMLSchema", false);
                MappingHelper.populateWithStandardXMLJavaMappings(simpleTypesMap, "http://www.w3.org/2001/XMLSchema", false);
                simpleTypesMapCreated = true;
            }
        }
    }

    public static Map getSimpleTypesMap() {
        if (!simpleTypesMapCreated) {
            WSIFUtils.createSimpleTypesMap();
        }
        return simpleTypesMap;
    }

    public static WSIFFormatHandler getFormatHandler(Part part, Definition definition, Binding binding) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string;
        Trc.entry(null, part, definition, binding);
        WSIFFormatHandler wSIFFormatHandler = null;
        QName qName = part.getTypeName();
        if (qName == null) {
            qName = part.getElementName();
        }
        if (qName == null) {
            throw new ClassNotFoundException(part.getName());
        }
        String string2 = string = WSIFUtils.getPackageNameFromNamespaceURI(qName.getNamespaceURI());
        String string3 = WSIFUtils.getPackageNameFromXMLName(definition.getPrefix(WSIFUtils.getBindingNamespace(binding)));
        if (string3 != null) {
            string2 = string2 + DOT + string3;
        }
        if (WSIFUtils.getFormatStylePackage(binding) != null) {
            string2 = string2 + DOT + WSIFUtils.getFormatStylePackage(binding);
        }
        String string4 = string2 + DOT + WSIFUtils.getJavaClassNameFromXMLName(qName.getLocalPart());
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            wSIFFormatHandler = (WSIFFormatHandler)classLoader.loadClass(string4 + FORMAT_HANDLER).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trc.ignoredException(classNotFoundException);
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                wSIFFormatHandler = (WSIFFormatHandler)classLoader.loadClass(string4 + ELEMENT_FORMAT_HANDLER).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                Trc.ignoredException(classNotFoundException2);
                try {
                    wSIFFormatHandler = (WSIFFormatHandler)Class.forName(string4 + FORMAT_HANDLER).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    Trc.ignoredException(classNotFoundException3);
                    wSIFFormatHandler = (WSIFFormatHandler)Class.forName(string4 + ELEMENT_FORMAT_HANDLER).newInstance();
                }
            }
        }
        if (wSIFFormatHandler == null) {
            throw new ClassNotFoundException(string2);
        }
        Trc.exit(wSIFFormatHandler);
        return wSIFFormatHandler;
    }

    public static String getPackageNameFromNamespaceURI(String string) {
        Trc.entry(null, string);
        List list = WSIFUtils.getNamespaceURISegments(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String string2;
            if (i == 0) {
                CharSequence charSequence;
                string2 = WSIFUtils.getPackageNameFromXMLName((String)list.get(i));
                StringTokenizer stringTokenizer = new StringTokenizer(string2, DOT);
                ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
                while (stringTokenizer.hasMoreTokens()) {
                    charSequence = stringTokenizer.nextToken();
                    arrayList.add(0, charSequence);
                }
                charSequence = new StringBuffer();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    if (((StringBuffer)charSequence).length() != 0) {
                        ((StringBuffer)charSequence).append('.');
                    }
                    if (!Character.isJavaIdentifierStart((string3 = (String)iterator.next()).toCharArray()[0])) {
                        string3 = UNDERSCORE + string3;
                    }
                    if (WSIFUtils.isJavaKeyword(string3)) {
                        string3 = UNDERSCORE + string3;
                    }
                    ((StringBuffer)charSequence).append(string3);
                }
                string2 = ((StringBuffer)charSequence).toString();
            } else {
                string2 = WSIFUtils.getJavaNameFromXMLName((String)list.get(i));
            }
            if (string2.length() == 0) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string2);
        }
        Trc.exit(stringBuffer.toString());
        return stringBuffer.toString();
    }

    public static String getJavaNameFromXMLName(String string, String string2) {
        Trc.entry(null, string, string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        String string3 = stringBuffer.toString();
        if (!Character.isJavaIdentifierStart(string3.toCharArray()[0])) {
            string3 = UNDERSCORE + string3;
        }
        if (WSIFUtils.isJavaKeyword(string3)) {
            string3 = UNDERSCORE + string3;
        }
        Trc.exit(string3);
        return string3;
    }

    public static String getJavaNameFromXMLName(String string) {
        Trc.entry(null, string);
        String string2 = WSIFUtils.getJavaNameFromXMLName(string, XMLSEPARATORS);
        Trc.exit(string2);
        return string2;
    }

    public static String getPackageNameFromXMLName(String string) {
        Trc.entry(null, string);
        String string2 = WSIFUtils.getJavaNameFromXMLName(string, XMLSEPARATORS_NODOT);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, DOT);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            if (!Character.isJavaIdentifierStart((string3 = stringTokenizer.nextToken()).toCharArray()[0])) {
                string3 = UNDERSCORE + string3;
            }
            if (WSIFUtils.isJavaKeyword(string3)) {
                string3 = UNDERSCORE + string3;
            }
            stringBuffer.append(string3);
        }
        Trc.exit(stringBuffer.toString());
        return stringBuffer.toString();
    }

    private static List getNamespaceURISegments(String string) {
        Trc.entry(null, string);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (!arrayList.isEmpty()) {
            try {
                URL uRL = new URL(string);
                if (arrayList.get(0).equals(uRL.getProtocol())) {
                    arrayList.remove(0);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Trc.ignoredException(malformedURLException);
            }
        }
        Trc.exit(arrayList);
        return arrayList;
    }

    private static String getBindingNamespace(Binding binding) {
        Trc.entry(null, binding);
        Iterator iterator = binding.getExtensibilityElements().iterator();
        String string = null;
        while (iterator.hasNext()) {
            String string2;
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            if (string != null || (string2 = extensibilityElement.getElementType().getNamespaceURI()).endsWith(PHYSICALREP) || string2.endsWith(FORMATBINDING)) continue;
            string = string2;
        }
        Trc.exit(string);
        return string;
    }

    public static String getFormatStylePackage(Binding binding) {
        Object object;
        Trc.entry(null, binding);
        Iterator iterator = binding.getExtensibilityElements().iterator();
        String string = null;
        while (iterator.hasNext()) {
            object = (ExtensibilityElement)iterator.next();
            if (object instanceof TypeMapping) {
                TypeMapping typeMapping = (TypeMapping)object;
                string = typeMapping.getEncoding();
                if (typeMapping.getStyle() != null) {
                    string = string + typeMapping.getStyle();
                }
            }
            if (string == null) continue;
            break;
        }
        object = null;
        object = string != null ? WSIFUtils.getPackageNameFromXMLName(string) : string;
        Trc.exit(object);
        return object;
    }

    public static String getFormatHandlerName(Part part, Definition definition, Binding binding) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string;
        Trc.entry(null, part, definition, binding);
        QName qName = part.getTypeName();
        if (qName == null) {
            qName = part.getElementName();
        }
        if (qName == null) {
            throw new ClassNotFoundException(part.getName());
        }
        String string2 = string = WSIFUtils.getPackageNameFromNamespaceURI(qName.getNamespaceURI());
        String string3 = WSIFUtils.getPackageNameFromXMLName(definition.getPrefix(WSIFUtils.getBindingNamespace(binding)));
        if (string3 != null) {
            string2 = string2 + DOT + string3;
        }
        if (WSIFUtils.getFormatStylePackage(binding) != null) {
            string2 = string2 + DOT + WSIFUtils.getFormatStylePackage(binding);
        }
        string2 = string2 + DOT + WSIFUtils.getJavaClassNameFromXMLName(qName.getLocalPart()) + FORMAT_HANDLER;
        Trc.exit(string2);
        return string2;
    }

    public static String getJavaClassNameFromXMLName(String string) {
        Trc.entry(null, string);
        String string2 = WSIFUtils.getJavaClassNameFromXMLName(string, XMLSEPARATORS);
        Trc.exit(string2);
        return string2;
    }

    public static String getJavaClassNameFromXMLName(String string, String string2) {
        String string3;
        Trc.entry(null, string, string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.length() > 0) {
                string3 = Character.toUpperCase(string3.toCharArray()[0]) + string3.substring(1);
            }
            stringBuffer.append(string3);
        }
        string3 = stringBuffer.toString();
        if (!Character.isJavaIdentifierStart(string3.toCharArray()[0])) {
            string3 = UNDERSCORE + string3;
        }
        Trc.exit(string3);
        if (WSIFUtils.isJavaKeyword(string3)) {
            return UNDERSCORE + string3;
        }
        return string3;
    }

    public static String getXSDNamespaceFromPackageName(String string) {
        String string2 = emptyString;
        StringTokenizer stringTokenizer = new StringTokenizer(string, DOT);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = WSIFUtils.removeUnderscores(string3) + DOT + string2;
        }
        if (string2.endsWith(DOT)) {
            return "http://" + string2.substring(0, string2.length() - 1) + SLASH;
        }
        return "http://" + string2 + SLASH;
    }

    private static String removeUnderscores(String string) {
        String string2 = emptyString;
        StringTokenizer stringTokenizer = new StringTokenizer(string, UNDERSCORE);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 + string3;
        }
        return string2;
    }

    public static BindingOperation getBindingOperation(Binding binding, Operation operation) throws WSIFException {
        Trc.entry(null, binding, operation);
        BindingOperation bindingOperation = operation == null ? null : WSIFUtils.getBindingOperation(binding, operation.getName(), operation.getInput() == null ? null : operation.getInput().getName(), operation.getOutput() == null ? null : operation.getOutput().getName());
        Trc.exit(bindingOperation);
        return bindingOperation;
    }

    public static BindingOperation getBindingOperation(Binding binding, String string, String string2, String string3) throws WSIFException {
        Trc.entry(null, binding, string, string2, string3);
        BindingOperation bindingOperation = null;
        if (binding != null && string != null) {
            ArrayList<BindingOperation> arrayList = new ArrayList<BindingOperation>();
            List list = binding.getBindingOperations();
            if (list != null) {
                for (BindingOperation bindingOperation2 : list) {
                    if (!string.equalsIgnoreCase(bindingOperation2.getName())) continue;
                    arrayList.add(bindingOperation2);
                }
                if (arrayList.size() == 1) {
                    bindingOperation = (BindingOperation)arrayList.get(0);
                } else if (arrayList.size() > 1) {
                    bindingOperation = WSIFUtils.chooseBindingOperation(arrayList, string2, string3);
                }
            }
        }
        Trc.exit(bindingOperation);
        return bindingOperation;
    }

    private static BindingOperation chooseBindingOperation(ArrayList arrayList, String string, String string2) throws WSIFException {
        BindingOperation bindingOperation = null;
        for (BindingOperation bindingOperation2 : arrayList) {
            String string3;
            String string4 = bindingOperation2.getBindingInput() == null ? null : bindingOperation2.getBindingInput().getName();
            String string5 = string3 = bindingOperation2.getBindingOutput() == null ? null : bindingOperation2.getBindingOutput().getName();
            if (!(string == null ? string4 == null : string.equalsIgnoreCase(string4))) continue;
            boolean bl = true;
            bl = string2 == null || string2.length() < 1 ? string3 == null || string3.length() < 1 : string2.equalsIgnoreCase(string3);
            if (!bl) continue;
            if (bindingOperation == null) {
                bindingOperation = bindingOperation2;
                continue;
            }
            throw new WSIFException("duplicate operation in binding: " + bindingOperation2.getName() + ":" + string + ":" + string2);
        }
        return bindingOperation;
    }

    private static boolean isJavaKeyword(String string) {
        if (keywordMap == null) {
            Object object = new Object();
            keywordMap = new HashMap();
            keywordMap.put("abstract", object);
            keywordMap.put("default", object);
            keywordMap.put("if", object);
            keywordMap.put("private", object);
            keywordMap.put("this", object);
            keywordMap.put("boolean", object);
            keywordMap.put("do", object);
            keywordMap.put("implements", object);
            keywordMap.put("protected", object);
            keywordMap.put("throw", object);
            keywordMap.put("break", object);
            keywordMap.put("double", object);
            keywordMap.put("import", object);
            keywordMap.put("public", object);
            keywordMap.put("throws", object);
            keywordMap.put("byte", object);
            keywordMap.put("else", object);
            keywordMap.put("instanceof", object);
            keywordMap.put("return", object);
            keywordMap.put("transient", object);
            keywordMap.put("case", object);
            keywordMap.put("extends", object);
            keywordMap.put("int", object);
            keywordMap.put("short", object);
            keywordMap.put("try", object);
            keywordMap.put("catch", object);
            keywordMap.put("final", object);
            keywordMap.put("interface", object);
            keywordMap.put("static", object);
            keywordMap.put("void", object);
            keywordMap.put("char", object);
            keywordMap.put("finally", object);
            keywordMap.put("long", object);
            keywordMap.put("strictfp", object);
            keywordMap.put("volatile", object);
            keywordMap.put("class", object);
            keywordMap.put("float", object);
            keywordMap.put("native", object);
            keywordMap.put("super", object);
            keywordMap.put("while", object);
            keywordMap.put("const", object);
            keywordMap.put("for", object);
            keywordMap.put("new", object);
            keywordMap.put("switch", object);
            keywordMap.put("continue", object);
            keywordMap.put("goto", object);
            keywordMap.put("package", object);
            keywordMap.put("synchronized", object);
            keywordMap.put("null", object);
            keywordMap.put("true", object);
            keywordMap.put("false", object);
            keywordMap.put("assert", object);
        }
        return keywordMap.containsKey(string);
    }

    public static boolean wildcardCompare(String string, String string2, char c) {
        if (string == null) {
            return false;
        }
        String string3 = c + emptyString;
        return WSIFUtils.cmp(new StringTokenizer(string, string3, true), string2, string3);
    }

    private static boolean cmp(StringTokenizer stringTokenizer, String string, String string2) {
        if (string == null || string.equals(emptyString)) {
            return !stringTokenizer.hasMoreTokens();
        }
        if (stringTokenizer.hasMoreTokens()) {
            int n;
            String string3 = stringTokenizer.nextToken();
            if (string2.equals(string3)) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return true;
                }
                string3 = stringTokenizer.nextToken();
                if (string.equals(string3)) {
                    return false;
                }
            }
            if ((n = string.indexOf(string3)) < 0) {
                return false;
            }
            if ((n += string3.length()) < string.length()) {
                return WSIFUtils.cmp(stringTokenizer, string.substring(n), string2);
            }
            return WSIFUtils.cmp(stringTokenizer, emptyString, string2);
        }
        return false;
    }

    public static boolean isWrappedDocLiteral(List list, String string) {
        return ProviderUtils.getWrapperPart(list, string) != null;
    }

    public static Part getWrappedDocLiteralPart(List list, String string) {
        return ProviderUtils.getWrapperPart(list, string);
    }

    public static List unWrapPart(Part part, Definition definition) throws WSIFException {
        return ProviderUtils.unWrapPart(part, definition);
    }

    public static ExtensionRegistry getExtensionRegistry() {
        Trc.entry(null);
        WSIFUtils.initializeProviders();
        ExtensionRegistry extensionRegistry = WSIFServiceImpl.getCompositeExtensionRegistry();
        Trc.exit(extensionRegistry);
        return extensionRegistry;
    }

    static {
        providersInitialized = new Boolean(false);
        simpleTypesMapCreated = false;
        simpleTypesMap = new HashMap();
        keywordMap = null;
    }
}

