/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.soap.transport.TransportMessage;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.JMS2HTTPBridgeDestination;
import org.apache.wsif.util.jms.WSIFJMSFinderForJndi;
import org.apache.wsif.util.jms.WSIFJMSListener;
import org.apache.wsif.util.jms.WSIFJMSProperties;

public class JMS2HTTPBridge {
    private String httpURL = null;
    private JMS2HTTPBridgeDestination destination = null;
    private static final ArrayList outGoingHeaders = new ArrayList<String>(Arrays.asList("SOAPAction", "WSIFContentType"));
    private static final ArrayList interestingProperties = new ArrayList<String>(Arrays.asList("JMSPriority", "JMSDeliveryMode"));
    private HashMap strProp = new HashMap();
    private boolean maintainSession = false;
    private boolean http10 = true;
    private Message original = null;
    private Integer statusCode = null;
    private String statusMessage = null;
    private boolean verbose = false;
    private boolean veryVerbose = false;
    private int syncTimeout = 10000;
    private WSIFJMSListener list = new WSIFJMSListener(){

        public void onException(JMSException jMSException) {
            Trc.entry((Object)this, (Object)jMSException);
            System.err.println("Caught an exception!");
            jMSException.printStackTrace();
            Trc.exit();
        }

        public void onMessage(Message message) {
            Trc.entry((Object)this, message);
            JMS2HTTPBridge.this.receiveMessage(message);
            Trc.exit();
        }
    };

    public JMS2HTTPBridge(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl) throws Exception {
        Trc.entry(this, string, string2, string3, string4, string5, string6, new Integer(n), new Boolean(bl));
        if (bl) {
            System.out.println("Starting the JMS2HTTPBridge with\nInitial Context Factory = " + string + "\n" + "JNDI URL = " + string2 + "\n" + "Queue Connection Factory  = " + string3 + "\n" + "JNDI Read Queue = " + string4 + "\n" + "HTTP URL = " + string5 + "\n" + "Start Type = " + string6 + "\n" + "Synchronous Timeout = " + n + "\n" + "Verbose = " + bl);
        }
        this.destination = new JMS2HTTPBridgeDestination(new WSIFJMSFinderForJndi(null, string, string2, "queue", string3, string4, null), null, 0L, string6, bl);
        this.httpURL = string5;
        this.syncTimeout = n;
        this.verbose = bl;
        Trc.exit();
    }

    public static void main(String[] stringArray) throws Exception {
        Trc.entry(null, stringArray);
        String string = "Usage: java " + JMS2HTTPBridge.class.getName() + " [-cold|-warm] " + "-icf <initialContextFactory> " + "-jndi <jndiUrl> " + "-s <sampleName> " + "-qcf <queueConnectionFactory> " + "-q <readQueue> " + "-http <httpURL> " + "-t <syncTimeout> " + "-v";
        String string2 = "warm";
        String string3 = "com.sun.jndi.fscontext.RefFSContextFactory";
        String string4 = "file:///JNDI-Directory";
        String string5 = null;
        String string6 = "WSIFSampleQCF";
        String string7 = null;
        String string8 = "http://localhost:8080/soap/servlet/rpcrouter";
        int n = 10000;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-")) {
                throw new Exception("Bad parameter\n" + string);
            }
            if (stringArray[i].equals("-cold")) {
                string2 = "cold";
                continue;
            }
            if (stringArray[i].equals("-warm")) {
                string2 = "warm";
                continue;
            }
            if (stringArray[i].equals("-icf")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-jndi")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-s")) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-qcf")) {
                string6 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-q")) {
                string7 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-http")) {
                string8 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-t")) {
                n = new Integer(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-v")) {
                bl = true;
                continue;
            }
            throw new Exception("Bad parameter\n" + string);
        }
        if (string7 == null && string5 != null) {
            string7 = "SoapJms" + string5 + "Queue";
        }
        if (string2 == null || string3 == null || string4 == null || string6 == null || string7 == null || string8 == null) {
            throw new Exception("Missing parameter\n" + string);
        }
        JMS2HTTPBridge jMS2HTTPBridge = new JMS2HTTPBridge(string3, string4, string6, string7, string8, string2, n, bl);
        jMS2HTTPBridge.listen();
        Trc.exit();
    }

    public void listen() throws WSIFException {
        Trc.entry(this);
        this.destination.listen(this.list);
        Trc.exit();
    }

    void receiveMessage(Message message) {
        block13: {
            Trc.entry((Object)this, message);
            Object var2_2 = null;
            this.original = message;
            try {
                if (this.verbose) {
                    System.out.println("JMS2HTTPBridge Caught a message!");
                }
                if (message instanceof TextMessage) {
                    String string = ((TextMessage)message).getText();
                    if (string == null) break block13;
                    if (this.verbose) {
                        System.out.println("JMS2HTTPBridge Message contained '" + string + "'");
                    }
                    String string2 = this.getServiceURL(message);
                    URL uRL = new URL(string2);
                    String string3 = uRL.getHost();
                    int n = uRL.getPort();
                    this.statusCode = null;
                    this.statusMessage = null;
                    BooleanHolder booleanHolder = new BooleanHolder(false);
                    StringBuffer stringBuffer = new StringBuffer();
                    DefaultSocketFactory defaultSocketFactory = new DefaultSocketFactory(new Hashtable());
                    Socket socket = defaultSocketFactory.create(string3, n, stringBuffer, booleanHolder);
                    String string4 = "text/xml; charset=utf-8";
                    if (message.propertyExists("WSIFContentType")) {
                        try {
                            string4 = message.getStringProperty("WSIFContentType");
                        }
                        catch (JMSException jMSException) {
                            Trc.ignoredException(jMSException);
                        }
                    }
                    String string5 = " ";
                    if (message.propertyExists("SOAPAction")) {
                        try {
                            string5 = message.getStringProperty("SOAPAction");
                        }
                        catch (JMSException jMSException) {
                            Trc.ignoredException(jMSException);
                        }
                    }
                    InputStream inputStream = this.writeToSocket(socket, string, string2, stringBuffer, string3, n, booleanHolder, string4, string.length(), string5);
                    this.readFromSocket(socket, inputStream, null);
                    break block13;
                }
                System.err.println("JMS2HTTPBridge ignoring message because it was not a TextMessage");
                Trc.exit();
                return;
            }
            catch (Exception exception) {
                Trc.exception(exception);
                exception.printStackTrace();
                String string = "<?xml version='1.0' encoding='UTF-8'?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\">\n<SOAP-ENV:Body>\n<SOAP-ENV:Fault>\n<faultcode>SOAP-ENV:Server</faultcode>\n<faultstring>JMS2HTTPBridge caught " + exception + "</faultstring>\n" + "<faultactor>org.apache.wsif.util.jms.JMS2HTTPBridge</faultactor>\n" + "</SOAP-ENV:Fault>\n\n" + "</SOAP-ENV:Body>\n" + "</SOAP-ENV:Envelope>";
                try {
                    this.destination.setReplyToQueue((Queue)this.original.getJMSReplyTo());
                    this.destination.send(string, this.original.getJMSMessageID());
                }
                catch (Exception exception2) {
                    Trc.exception(exception2);
                    System.err.println("JMS2HTTPBridge unable to send exception information back to the WSIF client. Exception " + exception2);
                }
            }
        }
        Trc.exit();
    }

    private InputStream writeToSocket(Socket socket, String string, String string2, StringBuffer stringBuffer, String string3, int n, BooleanHolder booleanHolder, String string4, long l, String string5) throws Exception {
        Map.Entry entry2;
        Hashtable hashtable;
        CharSequence charSequence;
        Trc.entry(this, socket, string, string2, stringBuffer, string3, new Integer(n), booleanHolder, string4, new Long(l), string5);
        String string6 = null;
        Object var13_12 = null;
        Object var14_13 = null;
        InputStream inputStream = null;
        if (string5 == null) {
            string5 = "";
        }
        if (string6 != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string6).append(":").append(var13_12 == null ? "" : var13_12);
            stringBuffer.append("Authorization").append(": Basic ").append(Base64.encode((byte[])((StringBuffer)charSequence).toString().getBytes())).append("\r\n");
        }
        if (this.maintainSession) {
            charSequence = (String)this.strProp.get("Cookie");
            String string7 = (String)this.strProp.get("Cookie2");
            if (charSequence != null) {
                stringBuffer.append("Cookie").append(": ").append((String)charSequence).append("\r\n");
            }
            if (string7 != null) {
                stringBuffer.append("Cookie2").append(": ").append(string7).append("\r\n");
            }
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("POST").append(" ").append(new URL(string2).getFile());
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        String string8 = null;
        String string9 = (String)this.strProp.get("axis.transport.version");
        if (null == string9) {
            string9 = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((string9 = string9.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            bl = false;
        }
        if ((hashtable = null) != null) {
            if (null == stringBuffer) {
                stringBuffer = new StringBuffer(1024);
            }
            for (Map.Entry entry2 : hashtable.entrySet()) {
                String string10;
                Object k = entry2.getKey();
                if (null == k) continue;
                String string11 = k.toString().trim();
                if (string11.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (bl || null == (string10 = entry2.getValue().toString()) || !string10.trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    bl2 = true;
                    continue;
                }
                if (string11.equalsIgnoreCase("Host") || string11.equalsIgnoreCase("Content-Type") || string11.equalsIgnoreCase("SOAPAction") || string11.equalsIgnoreCase("Content-Length") || string11.equalsIgnoreCase("Cookie") || string11.equalsIgnoreCase("Cookie2") || string11.equalsIgnoreCase("Authorization") || string11.equalsIgnoreCase("Proxy-Authorization")) continue;
                if (string11.equalsIgnoreCase("Connection")) {
                    if (bl || !(string10 = entry2.getValue().toString()).trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    string8 = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                if (!bl && string11.equalsIgnoreCase("Expect") && null != (string10 = entry2.getValue().toString()) && string10.trim().equalsIgnoreCase("100-continue")) {
                    bl3 = true;
                }
                stringBuffer.append(string11).append(": ").append(entry2.getValue()).append("\r\n");
            }
        }
        if (!bl) {
            string8 = HTTPConstants.HEADER_CONNECTION_CLOSE;
        }
        ((StringBuffer)charSequence).append(" ");
        ((StringBuffer)charSequence).append(bl ? "HTTP/1.0" : "HTTP/1.1").append("\r\n").append("Content-Type").append(": ").append(string4).append("\r\n").append("Accept").append(": ").append("application/soap+xml").append(", ").append("application/dime").append(", ").append("multipart/related").append(", ").append("text/*").append("\r\n").append("User-Agent").append(": ").append("WSIF").append("\r\n").append("Host").append(": ").append(string3).append(n == -1 ? "" : ":" + n).append("\r\n").append("Cache-Control").append(": ").append("no-cache").append("\r\n").append("Pragma").append(": ").append("no-cache").append("\r\n").append("SOAPAction").append(": \"").append(string5).append("\"\r\n");
        if (!bl2) {
            ((StringBuffer)charSequence).append("Content-Length").append(": ").append(l).append("\r\n");
        } else {
            ((StringBuffer)charSequence).append(HTTPConstants.HEADER_TRANSFER_ENCODING).append(": ").append(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED).append("\r\n");
        }
        if (null != string8) {
            ((StringBuffer)charSequence).append("Connection");
            ((StringBuffer)charSequence).append(": ");
            ((StringBuffer)charSequence).append(string8);
            ((StringBuffer)charSequence).append("\r\n");
        }
        if (null != stringBuffer) {
            ((StringBuffer)charSequence).append(stringBuffer);
        }
        ((StringBuffer)charSequence).append("\r\n");
        Object object = socket.getOutputStream();
        if (bl2) {
            throw new WSIFException("Chunking not supported by the JMS2HTTPBridge");
        }
        if (bl3) {
            throw new WSIFException("Continue expected is not supported by the JMS2HTTPBridge");
        }
        object = new BufferedOutputStream((OutputStream)object, 8192);
        entry2 = new ByteArrayOutputStream();
        ((OutputStream)((Object)entry2)).write(((StringBuffer)charSequence).toString().getBytes("iso-8859-1"));
        ((OutputStream)((Object)entry2)).write(string.getBytes());
        if (this.verbose) {
            System.out.println("JMS2HTTPBridge writeToSocket " + ((ByteArrayOutputStream)((Object)entry2)).toString());
        }
        ((OutputStream)object).write(((ByteArrayOutputStream)((Object)entry2)).toByteArray());
        ((OutputStream)object).flush();
        Trc.exit(inputStream);
        return inputStream;
    }

    private InputStream readFromSocket(Socket socket, InputStream inputStream, Hashtable hashtable) throws Exception {
        String string;
        Object object;
        Trc.entry(this, socket, inputStream, hashtable);
        Object var4_4 = null;
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        if (null != hashtable) {
            bl = true;
        } else {
            hashtable = new Hashtable<String, String>();
        }
        this.statusMessage = "";
        int n3 = 0;
        if (null == inputStream) {
            inputStream = new BufferedInputStream(socket.getInputStream());
        }
        boolean bl2 = false;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Object object2 = new ByteArrayOutputStream(4097);
        while (true) {
            String string2;
            String string3;
            if (!bl2) {
                n4 = (byte)inputStream.read();
                if (this.veryVerbose) {
                    System.out.println("read1 " + n4 + " " + (char)n4);
                }
                stringBuffer.append((char)n4);
            }
            if (n4 == -1) break;
            bl2 = false;
            if (n4 != 13 && n4 != 10) {
                if (n4 == 58 && n2 == -1) {
                    n2 = n;
                }
                ++n;
                ((ByteArrayOutputStream)object2).write(n4);
                continue;
            }
            if (n4 == 13) continue;
            if (n == 0) break;
            n4 = (byte)inputStream.read();
            if (this.veryVerbose) {
                System.out.println("read2 " + n4 + " " + (char)n4);
            }
            stringBuffer.append((char)n4);
            bl2 = true;
            if (n4 == 32 || n4 == 9) continue;
            ((ByteArrayOutputStream)object2).close();
            object = ((ByteArrayOutputStream)object2).toByteArray();
            ((ByteArrayOutputStream)object2).reset();
            if (n2 != -1) {
                string3 = new String((byte[])object, 0, n2, "iso-8859-1");
                string2 = new String((byte[])object, n2 + 1, n - 1 - n2, "iso-8859-1");
                n2 = -1;
            } else {
                string3 = new String((byte[])object, 0, n, "iso-8859-1");
                string2 = "";
            }
            Trc.event("name=", string3, " value=", string2);
            if (this.verbose) {
                System.out.println("JMS2HTTPBridge name=" + string3 + " value=" + string2);
            }
            if (this.statusCode == null) {
                int n5 = string3.indexOf(32) + 1;
                string = string3.substring(n5).trim();
                int n6 = string.indexOf(32);
                if (n6 != -1) {
                    string = string.substring(0, n6);
                }
                n3 = Integer.parseInt(string);
                this.statusCode = new Integer(n3);
                this.statusMessage = string3.substring(n5 + n6 + 1);
                if (this.veryVerbose) {
                    System.out.println("returncode/statuscode " + n3 + "/" + this.statusCode);
                }
            } else {
                hashtable.put(string3.toLowerCase(), string2);
            }
            n = 0;
        }
        if (this.verbose) {
            System.out.println("JMS2HTTPBridge readFromSocket " + stringBuffer);
        }
        if (bl) {
            Trc.exit(inputStream);
            return inputStream;
        }
        object2 = (String)hashtable.get("Content-Type".toLowerCase());
        Object object3 = object2 = null == object2 ? null : ((String)object2).trim();
        if (!(n3 > 199 && n3 < 300 || object2 != null && !((String)object2).startsWith("text/html") && n3 > 499 && n3 < 600)) {
            object = new ByteArrayOutputStream(4097);
            while (true) {
                byte by = (byte)inputStream.read();
                n4 = by;
                if (-1 == by) break;
                ((ByteArrayOutputStream)object).write(n4);
            }
            AxisFault axisFault = new AxisFault("HTTP", "(" + n3 + ")" + this.statusMessage, null, null);
            axisFault.setFaultDetailString(Messages.getMessage((String)"return01", (String)("" + n3), (String)((ByteArrayOutputStream)object).toString()));
            throw axisFault;
        }
        if (n4 != -1) {
            object = (String)hashtable.get("Content-Location".toLowerCase());
            object = null == object ? null : ((String)object).trim();
            String string4 = (String)hashtable.get("Content-Length".toLowerCase());
            string4 = null == string4 ? null : string4.trim();
            string = (String)hashtable.get(HTTPConstants.HEADER_TRANSFER_ENCODING.toLowerCase());
            if (null != string && string.trim().equals(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
                inputStream = new ChunkedInputStream(inputStream);
            }
            this.sendJmsReply(inputStream, (String)object2, (String)object, string4);
        }
        if (this.maintainSession) {
            this.handleCookie("Cookie", "Set-Cookie", hashtable);
            this.handleCookie("Cookie2", "Set-Cookie2", hashtable);
        }
        Trc.exit(inputStream);
        return inputStream;
    }

    private void sendJmsReply(InputStream inputStream, String string, String string2, String string3) throws Exception {
        int n;
        Trc.entry(this, inputStream, string, string2);
        int n2 = 0;
        if (string3 != null) {
            try {
                n2 = new Integer(string3);
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
            }
        }
        byte[] byArray = null;
        if (n2 != 0) {
            byArray = new byte[n2];
        }
        int n3 = 0;
        int n4 = 0;
        do {
            n = inputStream.available();
            while (n == 0 && (this.syncTimeout == 0 || n4 * 100 < this.syncTimeout)) {
                if (this.verbose) {
                    System.out.println("wait " + n4);
                }
                ++n4;
                Thread.sleep(100L);
                n = inputStream.available();
            }
            if (this.syncTimeout != 0 && n4 * 100 >= this.syncTimeout) {
                String string4 = "JMS2HTTPBridge timeout before reading complete message from socket. Bytes read=" + n3;
                System.err.println(string4);
                throw new WSIFException(string4);
            }
            if (this.veryVerbose) {
                System.out.println("JMS2HTTPBridge sendJmsReply avail=" + n + " bytesRead=" + n3);
            }
            if (n2 == 0) {
                byArray = new byte[n];
            }
            inputStream.read(byArray, n3, n);
        } while ((n3 += n) < n2);
        String string5 = new String(byArray);
        if (this.verbose) {
            System.out.println("JMS2HTTPBridge sendJmsReply len=" + string5.length() + " buff=" + string5);
        }
        WSIFJMSProperties wSIFJMSProperties = new WSIFJMSProperties("out");
        wSIFJMSProperties.getPropertiesFromMessage(this.original);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = interestingProperties.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    if (!wSIFJMSProperties.containsKey(string6)) continue;
                    hashMap.put(string6, wSIFJMSProperties.get(string6));
                }
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
                exception.printStackTrace();
                continue;
            }
            break;
        }
        if (string != null) {
            hashMap.put("WSIFContentType", string);
        }
        if (string2 != null) {
            hashMap.put("WSIFContentLocation", string2);
        }
        this.destination.setProperties(hashMap);
        this.destination.setReplyToQueue((Queue)this.original.getJMSReplyTo());
        this.destination.send(string5, this.original.getJMSMessageID());
        Trc.exit();
    }

    public void handleCookie(String string, String string2, Hashtable hashtable) {
        Trc.entry(this, string, string2, hashtable);
        if (hashtable.containsKey(string2.toLowerCase())) {
            String string3 = (String)hashtable.get(string2.toLowerCase());
            int n = (string3 = string3.trim()).indexOf(59);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
            this.strProp.put(string, string3);
        }
        Trc.exit();
    }

    private void setOutGoingHeaders(Message message, TransportMessage transportMessage) {
        Trc.entry(this, message, transportMessage);
        Iterator iterator = outGoingHeaders.iterator();
        while (iterator.hasNext()) {
            try {
                String string;
                String string2 = (String)iterator.next();
                if (!message.propertyExists(string2) || (string = message.getStringProperty(string2)) == null || string.length() <= 0) continue;
                if ("WSIFContentType".equals(string2)) {
                    transportMessage.setContentType(string);
                    continue;
                }
                transportMessage.setHeader(string2, "\"" + string + "\"");
            }
            catch (JMSException jMSException) {
                Trc.ignoredException(jMSException);
                jMSException.printStackTrace();
            }
        }
        Trc.exit();
    }

    private String getServiceURL(Message message) {
        Trc.entry((Object)this, message);
        String string = null;
        try {
            if (message.propertyExists("WSIFServiceURL")) {
                string = message.getStringProperty("WSIFServiceURL");
                if (this.verbose) {
                    System.out.println("JMS2HTTPBridge WSIFServiceURL=" + string);
                }
            }
        }
        catch (Exception exception) {
            Trc.ignoredException(exception);
        }
        if (string == null) {
            string = this.httpURL;
        }
        Trc.exit(string);
        return string;
    }
}

