/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSConstants;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.util.jms.WSIFJMSListener;

public class JMS2HTTPBridgeDestination
extends WSIFJMSDestination {
    public static final String COLDSTART = "cold";
    public static final String WARMSTART = "warm";
    private boolean verbose;
    private static final ArrayList allStarts = new ArrayList<Object>(Arrays.asList("cold", "warm"));

    public JMS2HTTPBridgeDestination(WSIFJMSFinder wSIFJMSFinder, String string, long l, String string2, boolean bl) throws WSIFException {
        super(wSIFJMSFinder, string, l);
        Trc.entry(this, wSIFJMSFinder, string, new Long(l), string2, new Boolean(bl));
        this.verbose = bl;
        this.readQ = this.writeQ;
        this.writeQ = null;
        if (!allStarts.contains(string2)) {
            throw new WSIFException("StartType must either be warm or cold");
        }
        if (COLDSTART.equals(string2)) {
            if (bl) {
                System.out.println("Wiping messages off the read queue");
            }
            Message message = null;
            try {
                QueueReceiver queueReceiver = this.session.createReceiver(this.readQ);
                while ((message = queueReceiver.receive(100L)) != null) {
                    if (!bl) continue;
                    System.out.println("Removing an input message");
                }
            }
            catch (Exception exception) {
                Trc.exception(exception);
            }
        }
        Trc.exit();
    }

    public void listen(WSIFJMSListener wSIFJMSListener) throws WSIFException {
        Trc.entry((Object)this, wSIFJMSListener);
        this.listen(wSIFJMSListener, this.readQ);
        Trc.exit();
    }

    public void listen(WSIFJMSListener wSIFJMSListener, Queue queue) throws WSIFException {
        Trc.entry(this, wSIFJMSListener, queue);
        this.areWeClosed();
        try {
            QueueReceiver queueReceiver = this.session.createReceiver(queue);
            queueReceiver.setMessageListener((MessageListener)wSIFJMSListener);
            this.connection.setExceptionListener((ExceptionListener)wSIFJMSListener);
            this.connection.start();
            int n = 1;
            while (!Thread.interrupted()) {
                Thread.yield();
                Thread.sleep(5000L);
                if (this.verbose) {
                    System.out.println("Waiting... " + n);
                }
                ++n;
            }
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
        catch (InterruptedException interruptedException) {
            Trc.exception(interruptedException);
            System.out.println("Exitting");
        }
        Trc.exit();
    }

    public void setReplyToQueue() throws WSIFException {
        Trc.entry(this);
        Trc.exit();
    }

    public void setReplyToQueue(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        Trc.exit();
    }

    public void setReplyToQueue(Queue queue) throws WSIFException {
        Trc.entry((Object)this, queue);
        this.areWeClosed();
        if (this.writeQ == null) {
            this.writeQ = queue;
        } else if (!this.writeQ.equals(queue)) {
            if (this.sender != null) {
                try {
                    this.sender.close();
                }
                catch (Exception exception) {
                    Trc.exception(exception);
                }
                this.sender = null;
            }
            this.writeQ = queue;
        }
        Trc.exit();
    }
}

