/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSConstants;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.util.jms.WSIFJMSProperties;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;

public class WSIFJMSDestination {
    protected WSIFJMSFinder finder;
    protected QueueConnection connection = null;
    protected QueueSession session = null;
    protected Queue readQ = null;
    protected Queue writeQ = null;
    protected QueueSender sender = null;
    protected boolean asyncMode = false;
    protected Queue syncTempQueue = null;
    protected WSIFJMSProperties inProps;
    protected WSIFJMSProperties outProps;
    protected Message lastMessage = null;
    protected long timeout;
    protected String replyToName = null;

    public WSIFJMSDestination(WSIFJMSFinder wSIFJMSFinder) throws WSIFException {
        this(wSIFJMSFinder, 0L);
        Trc.entry((Object)this, wSIFJMSFinder);
        Trc.exit();
    }

    public WSIFJMSDestination(WSIFJMSFinder wSIFJMSFinder, long l) throws WSIFException {
        this(wSIFJMSFinder, null, l);
        Trc.entry(this, wSIFJMSFinder, new Long(l));
        Trc.exit();
    }

    public WSIFJMSDestination(WSIFJMSFinder wSIFJMSFinder, String string, long l) throws WSIFException {
        Trc.entry(this, wSIFJMSFinder, string, new Long(l));
        this.inProps = new WSIFJMSProperties("in");
        this.outProps = new WSIFJMSProperties("out");
        this.timeout = l;
        this.finder = wSIFJMSFinder;
        try {
            this.connection = wSIFJMSFinder.getFactory().createQueueConnection();
            this.session = this.connection.createQueueSession(false, 1);
            Destination destination = wSIFJMSFinder.getInitialDestination();
            if (destination != null && string != null) {
                throw new WSIFException("Both jndiDestinationName and jmsproviderDestinationName cannot be specified");
            }
            if (destination == null && string == null) {
                throw new WSIFException("Either jndiDestinationName or jmsproviderDestinationName must be specified");
            }
            if (string != null) {
                destination = this.session.createQueue(string);
            }
            this.writeQ = (Queue)destination;
            this.readQ = null;
            this.connection.start();
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public void close() throws WSIFException {
        Trc.entry(this);
        try {
            QueueSender queueSender = this.sender;
            QueueSession queueSession = this.session;
            QueueConnection queueConnection = this.connection;
            this.sender = null;
            this.session = null;
            this.connection = null;
            if (queueSender != null) {
                queueSender.close();
            }
            if (queueSession != null) {
                queueSession.close();
            }
            if (queueConnection != null) {
                queueConnection.close();
            }
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
        Trc.exit();
    }

    public void finalize() throws WSIFException {
        Trc.entry(this);
        this.close();
        Trc.exit();
    }

    public String send(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        String string2 = this.send(string, null);
        Trc.exit(string2);
        return string2;
    }

    public String send(String string, String string2) throws WSIFException {
        Trc.entry(this, string, string2);
        this.areWeClosed();
        try {
            TextMessage textMessage = this.session.createTextMessage();
            textMessage.setText(string);
            String string3 = this.send((Message)textMessage, string2, true);
            Trc.exit(string3);
            return string3;
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
    }

    public String send(Serializable serializable) throws WSIFException {
        Trc.entry((Object)this, serializable);
        String string = this.send(serializable, null);
        Trc.exit(string);
        return string;
    }

    public String send(Serializable serializable, String string) throws WSIFException {
        Trc.entry(this, serializable, string);
        this.areWeClosed();
        try {
            ObjectMessage objectMessage = this.session.createObjectMessage();
            objectMessage.setObject(serializable);
            String string2 = this.send((Message)objectMessage, string, true);
            Trc.exit(string2);
            return string2;
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
    }

    public String send(Message message, String string, boolean bl) throws WSIFException {
        Trc.entry(this, message, string);
        this.areWeClosed();
        String string2 = null;
        boolean bl2 = true;
        try {
            if (this.sender == null) {
                this.sender = this.session.createSender(this.writeQ);
                this.sender.setTimeToLive(this.timeout);
            }
            if (this.inProps.containsKey("JMSReplyTo")) {
                String string3 = (String)this.inProps.get("JMSReplyTo");
                this.setReplyToQueue(string3);
                this.inProps.remove("JMSReplyTo");
                message.setJMSReplyTo((Destination)this.readQ);
            } else if (bl) {
                this.setReplyToQueue();
                message.setJMSReplyTo((Destination)this.readQ);
            }
            if (string != null) {
                message.setJMSCorrelationID(string);
            }
            this.inProps.set((MessageProducer)this.sender, message);
            this.sender.send(message);
            string2 = message.getJMSMessageID();
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
        finally {
            if (bl2) {
                try {
                    if (this.sender != null) {
                        this.sender.close();
                    }
                }
                catch (JMSException jMSException) {
                    throw new WSIFException("JMSException closing sender: " + jMSException.getLinkedException(), jMSException);
                }
                this.sender = null;
            }
            this.inProps.clear();
        }
        Trc.exit(string2);
        return string2;
    }

    public String receive() throws WSIFException {
        Trc.entry(this);
        String string = this.receiveString(null);
        Trc.exit(string);
        return string;
    }

    public String receiveString(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        String string2 = this.receiveString(string, this.timeout);
        Trc.exit(string2);
        return string2;
    }

    public String receiveString(String string, long l) throws WSIFException {
        Trc.entry((Object)this, string);
        Message message = this.receive(string, l);
        String string2 = null;
        try {
            if (!(message instanceof TextMessage)) {
                throw new WSIFException("Reply message was not a TextMessage:msg=" + (message == null ? "null" : message.toString()));
            }
            string2 = ((TextMessage)message).getText();
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
        Trc.exit(string2);
        return string2;
    }

    public Message receive(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        Message message = this.receive(string, this.timeout);
        Trc.exit(message);
        return message;
    }

    public Message receive(String string, long l) throws WSIFException {
        Trc.entry((Object)this, string);
        this.areWeClosed();
        QueueReceiver queueReceiver = null;
        Message message = null;
        try {
            queueReceiver = string != null ? this.session.createReceiver(this.readQ, "JMSCorrelationID='" + string + "'") : this.session.createReceiver(this.readQ);
            message = queueReceiver.receive(l);
            this.setLastMessage(message);
            if (message == null) {
                throw new WSIFException("Receive timed out on JMS queue " + this.readQ.getQueueName() + ", timeout " + l);
            }
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
        finally {
            try {
                if (queueReceiver != null) {
                    queueReceiver.close();
                }
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
            }
        }
        Trc.exit(message);
        return message;
    }

    public void setReplyToQueue() throws WSIFException {
        Trc.entry(this);
        this.areWeClosed();
        try {
            if (this.syncTempQueue == null) {
                this.syncTempQueue = this.session.createTemporaryQueue();
            }
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
        this.readQ = this.syncTempQueue;
        this.replyToName = null;
        Trc.exit();
    }

    public void setReplyToQueue(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        this.areWeClosed();
        if (string == null || string.length() == 0) {
            this.setReplyToQueue();
            Trc.exit();
            return;
        }
        if (string.equals(this.replyToName)) {
            Trc.exit();
            return;
        }
        this.readQ = this.finder.findQueue(string);
        this.replyToName = string;
        Trc.exit();
    }

    public void setAsyncMode(boolean bl) throws WSIFException {
        Trc.entry((Object)this, bl);
        this.areWeClosed();
        if (this.asyncMode != bl) {
            this.asyncMode = bl;
        }
        Trc.exit();
    }

    public void setProperty(String string, Object object) throws WSIFException {
        Trc.entry(this, string, object);
        if (string != null && object != null) {
            this.inProps.put(string, object);
        }
        Trc.exit();
    }

    public void setProperties(HashMap hashMap) {
        Trc.entry((Object)this, hashMap);
        if (hashMap != null && !hashMap.isEmpty()) {
            this.inProps.putAll(hashMap);
        }
        Trc.exit();
    }

    public Object getProperty(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.lastMessage == null) {
            Trc.exit(null);
            return null;
        }
        if (this.outProps.isEmpty()) {
            this.outProps.getPropertiesFromMessage(this.lastMessage);
        }
        Object object = null;
        if (string != null) {
            object = this.outProps.get(string);
        }
        Trc.exit(object);
        return object;
    }

    public HashMap getProperties() throws WSIFException {
        Trc.entry(this);
        if (this.lastMessage == null) {
            Trc.exit(null);
            return null;
        }
        if (this.outProps.isEmpty()) {
            this.outProps.getPropertiesFromMessage(this.lastMessage);
        }
        if (!this.outProps.isEmpty()) {
            Trc.exit(this.outProps);
            return this.outProps;
        }
        Trc.exit(null);
        return null;
    }

    protected void areWeClosed() throws WSIFException {
        if (this.session == null) {
            throw new WSIFException("Cannot use a closed destination");
        }
    }

    public static Message createMessage(Session session, int n) throws WSIFException {
        ObjectMessage objectMessage;
        block4: {
            Trc.entry(null, session, new Integer(n));
            objectMessage = null;
            try {
                if (n == 30) {
                    objectMessage = session.createObjectMessage();
                    break block4;
                }
                if (n == 50) {
                    objectMessage = session.createTextMessage();
                    break block4;
                }
                throw new WSIFException("Unable to support message type");
            }
            catch (JMSException jMSException) {
                Trc.exception(jMSException);
                throw WSIFJMSConstants.ToWsifException(jMSException);
            }
        }
        Trc.exit(objectMessage);
        return objectMessage;
    }

    public Message createMessage(int n) throws WSIFException {
        Trc.entry((Object)this, n);
        Message message = WSIFJMSDestination.createMessage((Session)this.session, n);
        Trc.exit(message);
        return message;
    }

    public void setLastMessage(Message message) {
        Trc.entry((Object)this, message);
        this.lastMessage = message;
        Trc.exit();
    }

    public String deep() {
        String string = "";
        try {
            string = new String(this.toString() + "\n");
            string = string + "finder: " + this.finder;
            string = string + " connection: " + this.connection;
            string = string + " session: " + this.session;
            string = string + " readQ: " + this.readQ;
            string = string + " writeQ: " + this.writeQ;
            string = string + " sender: " + this.sender;
            string = string + " asyncMode: " + this.asyncMode;
            string = string + " syncTempQueue: " + this.syncTempQueue;
            string = string + " inProps: " + this.inProps;
            string = string + " outProps: " + this.outProps;
            string = string + " lastMessage: " + this.lastMessage;
            string = string + " timeout: " + this.timeout;
            string = string + " replyToName: " + this.replyToName;
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }

    public static JMSAddress getJMSAddressFromURL(String string) throws WSIFException {
        String string2;
        JMSAddress jMSAddress = new JMSAddress();
        if (!string.startsWith("jms:")) {
            throw new WSIFException("protocol must be 'jms:', url: " + string);
        }
        int n = string.indexOf(63);
        if (n < 1) {
            throw new WSIFException("URL must be a query, url: " + string);
        }
        String string3 = string.substring("jms:".length(), n);
        if (!"/queue".equals(string3) && !"/topic".equals(string3)) {
            throw new WSIFException("style must be /queue or /topic. found: " + string3);
        }
        jMSAddress.setDestStyle(string3.substring(1));
        if (n >= string.length()) {
            throw new WSIFException("empty query string: " + string);
        }
        String string4 = string.substring(n + 1);
        if (string4.indexOf((string2 = "&").charAt(0)) < 0) {
            string2 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, string2);
        while (stringTokenizer.hasMoreTokens()) {
            JMSPropertyValue jMSPropertyValue;
            String string5 = stringTokenizer.nextToken();
            int n2 = string5.indexOf(61);
            if (n2 < 1 || n2 >= string5.length()) {
                throw new WSIFException("property must be '=' seperated name value pair: " + string5);
            }
            String string6 = string5.substring(0, n2);
            String string7 = string5.substring(n2 + 1);
            if (string6.equals("destination")) {
                jMSAddress.setJndiDestName(string7);
                continue;
            }
            if (string6.equals("connectionFactory")) {
                jMSAddress.setJndiConnFactName(string7);
                continue;
            }
            if (string6.equals("initialContextFactory")) {
                jMSAddress.setInitCxtFact(string7);
                continue;
            }
            if (string6.equals("jndiProviderURL")) {
                jMSAddress.setJndiProvURL(string7);
                continue;
            }
            if (string6.equals("deliveryMode")) {
                jMSPropertyValue = new JMSPropertyValue();
                jMSPropertyValue.setName("JMSDeliveryMode");
                jMSPropertyValue.setValue(string7);
                jMSPropertyValue.setType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
                jMSAddress.addJMSPropertyValue(jMSPropertyValue);
                continue;
            }
            if (string6.equals("timeToLive")) {
                jMSPropertyValue = new JMSPropertyValue();
                jMSPropertyValue.setName("JMSTimeToLive");
                jMSPropertyValue.setValue(string7);
                jMSPropertyValue.setType(new QName("http://www.w3.org/2001/XMLSchema", "long"));
                jMSAddress.addJMSPropertyValue(jMSPropertyValue);
                continue;
            }
            if (string6.equals("priority")) {
                jMSPropertyValue = new JMSPropertyValue();
                jMSPropertyValue.setName("JMSPriority");
                jMSPropertyValue.setValue(string7);
                jMSPropertyValue.setType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
                jMSAddress.addJMSPropertyValue(jMSPropertyValue);
                continue;
            }
            if (string6.equals("userid")) {
                jMSPropertyValue = new JMSPropertyValue();
                jMSPropertyValue.setName("JMSUserid");
                jMSPropertyValue.setValue(string7);
                jMSPropertyValue.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
                jMSAddress.addJMSPropertyValue(jMSPropertyValue);
                continue;
            }
            if (string6.equals("password")) {
                jMSPropertyValue = new JMSPropertyValue();
                jMSPropertyValue.setName("JMSPassword");
                jMSPropertyValue.setValue(string7);
                jMSPropertyValue.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
                jMSAddress.addJMSPropertyValue(jMSPropertyValue);
                continue;
            }
            jMSPropertyValue = new JMSPropertyValue();
            jMSPropertyValue.setName(string6);
            jMSPropertyValue.setValue(string7);
            jMSPropertyValue.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            jMSAddress.addJMSPropertyValue(jMSPropertyValue);
        }
        return jMSAddress;
    }
}

