/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSFinderForJndi;
import org.apache.wsif.util.jms.WSIFJMSFinderForMq;
import org.apache.wsif.wsdl.extensions.jms.JMSAddress;

public abstract class WSIFJMSFinder {
    public static final String STYLE_QUEUE = "queue";
    public static final String STYLE_TOPIC = "topic";
    protected static final ArrayList allStyles = new ArrayList<Object>(Arrays.asList("queue", "topic"));
    private static final String MQ_URL_PREFIX = "mq://";

    public abstract QueueConnectionFactory getFactory();

    public abstract Destination getInitialDestination();

    abstract Queue findQueue(String var1) throws WSIFException;

    abstract String getStyle();

    public static WSIFJMSFinder newFinder(JMSAddress jMSAddress, String string) throws WSIFException {
        WSIFJMSFinder wSIFJMSFinder;
        Trc.entry(null, jMSAddress);
        boolean bl = jMSAddress.getInitCxtFact() != null || jMSAddress.getJndiProvURL() != null || jMSAddress.getDestStyle() != null || jMSAddress.getJndiConnFactName() != null || jMSAddress.getJndiDestName() != null || jMSAddress.getJmsProvDestName() != null;
        String string2 = jMSAddress.getJmsImplSpecURI();
        if (bl && string2 != null) {
            throw new WSIFException("Cannot specify both JNDI attributes and jmsImplementationSpecificURL in the jms:address in port " + string);
        }
        if (!bl && string2 == null) {
            throw new WSIFException("Must specify either JNDI attributes or jmsImplementationSpecificURL in the jms:address in port " + string);
        }
        if (bl) {
            wSIFJMSFinder = new WSIFJMSFinderForJndi(jMSAddress.getJmsVendorURI(), jMSAddress.getInitCxtFact(), jMSAddress.getJndiProvURL(), jMSAddress.getDestStyle(), jMSAddress.getJndiConnFactName(), jMSAddress.getJndiDestName(), string);
        } else if (string2.startsWith(MQ_URL_PREFIX)) {
            wSIFJMSFinder = new WSIFJMSFinderForMq(jMSAddress.getJmsVendorURI(), string2);
        } else {
            throw new WSIFException("No jms implementation found for jmsImplementationSpecificURI '" + string2 + "' for port " + string);
        }
        Trc.exit(wSIFJMSFinder);
        return wSIFJMSFinder;
    }
}

