/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSFinder;

public class WSIFJMSFinderForJndi
extends WSIFJMSFinder {
    private InitialDirContext namedJndiContext;
    private InitialDirContext containersJndiContext;
    private QueueConnectionFactory factory;
    private Destination initialDestination;
    private String style;
    private String portName;

    public WSIFJMSFinderForJndi(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws WSIFException {
        block21: {
            this.namedJndiContext = null;
            this.containersJndiContext = null;
            this.initialDestination = null;
            Trc.entry(this, string, string2, string3, string4, string5, string6, string7);
            if (!allStyles.contains(string4)) {
                throw new WSIFException("Style must either be queue or topic");
            }
            this.style = string4;
            if (string7 == null) {
                string7 = "<null>";
            }
            this.portName = string7;
            if (string2 == null && string3 != null || string2 != null && string3 == null) {
                throw new WSIFException("Either both initialContextFactory and jndiProviderURL must be specified or neither of them must be specified. Port=" + string7);
            }
            if (string2 != null && string3 != null) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("java.naming.factory.initial", string2);
                hashtable.put("java.naming.provider.url", string3);
                try {
                    this.namedJndiContext = new InitialDirContext(hashtable);
                }
                catch (NamingException namingException) {
                    Trc.exception(namingException);
                    throw new WSIFException("WSIFJMSFinderForJndi caught '" + namingException + "'. InitialContextFactory was '" + string2 + "' ProviderUrl was '" + string3 + "'. Port=" + string7);
                }
            }
            try {
                this.containersJndiContext = new InitialDirContext();
            }
            catch (NamingException namingException) {
                Trc.exception(namingException);
                if (string2 != null || string3 != null) break block21;
                throw new WSIFException("WSIFJMSFinderForJndi caught '" + namingException + "' using the default JNDI repository. Port=" + string7);
            }
        }
        if ("topic".equals(string4)) {
            throw new WSIFException("Topics not implemented. Port=" + string7);
        }
        if (!"queue".equals(string4)) {
            throw new WSIFException("jms:address must either be a queue or a topic not a '" + (string4 == null ? "null" : string4) + "'. Port=" + string7);
        }
        if (string5 == null) {
            throw new WSIFException("jndiConnectionFactory must be specified in port " + string7);
        }
        try {
            this.factory = (QueueConnectionFactory)this.lookup(string5);
            if (this.factory == null) {
                throw new WSIFException("WSIFJMSFinderForJndi was not able to lookup the ConnectionFactory " + string5 + " in JNDI. Port=" + string7);
            }
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            throw new WSIFException("WSIFJMSFinderForJndi caught ClassCastException. The ConnectionFactory " + string5 + " in JNDI was not defined to be a connection factory. Port=" + string7 + " " + classCastException);
        }
        catch (NamingException namingException) {
            Trc.exception(namingException);
            throw new WSIFException("WSIFJMSFinderForJndi caught NamingException. The ConnectionFactory " + string5 + " in JNDI was not defined to be a connection factory. Port=" + string7 + " " + namingException);
        }
        if (string6 != null) {
            try {
                this.initialDestination = (Destination)this.lookup(string6);
                if (this.initialDestination == null) {
                    throw new WSIFException("WSIFJMSFinderForJndi was not able to lookup the Destination " + string6 + " in JNDI. Port=" + string7);
                }
            }
            catch (ClassCastException classCastException) {
                Trc.exception(classCastException);
                throw new WSIFException("WSIFJMSFinderForJndi caught ClassCastException. The Destination " + string6 + " in JNDI was not defined to be a destination. Port=" + string7 + " " + classCastException);
            }
            catch (NamingException namingException) {
                Trc.exception(namingException);
                throw new WSIFException("WSIFJMSFinderForJndi caught NamingException. The Destination " + string6 + " in JNDI was not defined to be a destination. Port=" + string7 + " " + namingException);
            }
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public QueueConnectionFactory getFactory() {
        Trc.entry(this);
        Trc.exit(this.factory);
        return this.factory;
    }

    public Destination getInitialDestination() {
        Trc.entry(this);
        Trc.exit(this.initialDestination);
        return this.initialDestination;
    }

    String getStyle() {
        Trc.entry(this);
        Trc.exit(this.style);
        return this.style;
    }

    Queue findQueue(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        Queue queue = null;
        try {
            queue = (Queue)this.lookup(string);
            if (queue == null) {
                throw new WSIFException("WSIFJMSFinderForJndi was not able to lookup the Destination " + string + " in JNDI.Port=" + this.portName);
            }
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            throw new WSIFException("WSIFJMSFinderForJndi caught ClassCastException. The Queue " + string + " in JNDI was not defined to be a queue. Port=" + this.portName + " " + classCastException);
        }
        catch (NamingException namingException) {
            Trc.exception(namingException);
            throw new WSIFException("WSIFJMSFinderForJndi caught NamingException. The Queue " + string + " in JNDI was not defined to be a queue. Port=" + this.portName + " " + namingException);
        }
        Trc.exit(queue);
        return queue;
    }

    private Object lookupJNDIName(String string) throws NamingException {
        Trc.entry(string);
        Object object = null;
        if (this.containersJndiContext != null) {
            try {
                object = this.containersJndiContext.lookup(string);
            }
            catch (NamingException namingException) {
                Trc.exception(namingException);
                if (this.namedJndiContext != null) {
                    object = this.namedJndiContext.lookup(string);
                }
                throw namingException;
            }
        } else {
            object = this.namedJndiContext.lookup(string);
        }
        Trc.exit(object);
        return object;
    }

    private Object lookup(String string) throws NamingException {
        Trc.entry(string);
        Object object = null;
        try {
            object = this.lookupJNDIName("java:comp/env/" + string);
        }
        catch (NamingException namingException) {
            Trc.exception(namingException);
            object = this.lookupJNDIName(string);
        }
        Trc.exit(object);
        return object;
    }

    public String deep() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.toString() + "\n");
            stringBuffer.append("containersJndiContext: " + this.containersJndiContext);
            stringBuffer.append(" namedJndiContext: " + this.namedJndiContext);
            stringBuffer.append(" factory: " + this.factory);
            stringBuffer.append(" initialDestination: " + this.initialDestination);
            stringBuffer.append(" style: " + this.style);
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return stringBuffer.toString();
    }
}

