/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSConstants;

public class WSIFJMSProperties
extends HashMap {
    private static final long serialVersionUID = 1L;
    public static final String IN = "in";
    public static final String OUT = "out";
    private static final ArrayList allDirections = new ArrayList<Object>(Arrays.asList("in", "out"));
    public static final String CORRELATIONID = "JMSCorrelationID";
    public static final String DELIVERYMODE = "JMSDeliveryMode";
    public static final String DESTINATION = "JMSDestination";
    public static final String EXPIRATION = "JMSExpiration";
    public static final String MESSAGEID = "JMSMessageID";
    public static final String PRIORITY = "JMSPriority";
    public static final String REDELIVERED = "JMSRedelivered";
    public static final String REPLYTO = "JMSReplyTo";
    public static final String TIMESTAMP = "JMSTimestamp";
    public static final String TIMETOLIVE = "JMSTimeToLive";
    public static final String TYPE = "JMSType";
    public static final String QCF_USERID = "JMSUserid";
    public static final String QCF_PASSWORD = "JMSPassword";
    private static final ArrayList predefinedProps = new ArrayList<Object>(Arrays.asList("JMSCorrelationID", "JMSDeliveryMode", "JMSDestination", "JMSExpiration", "JMSPriority", "JMSRedelivered", "JMSReplyTo", "JMSTimestamp", "JMSTimeToLive", "JMSType"));
    private String direction;

    public WSIFJMSProperties(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (!allDirections.contains(string)) {
            throw new WSIFException("Invalid direction " + string);
        }
        this.direction = string;
        Trc.exit(this.deep());
    }

    public WSIFJMSProperties(WSIFJMSProperties wSIFJMSProperties) {
        super(wSIFJMSProperties);
        Trc.entry((Object)this, wSIFJMSProperties);
        this.direction = wSIFJMSProperties.direction;
        Trc.exit(this.deep());
    }

    public boolean set(MessageProducer messageProducer, Message message) throws WSIFException {
        Trc.entry(this, messageProducer, message);
        if (messageProducer != null && this.direction != IN) {
            throw new WSIFException("Only input properties can be set on a MessageProducer");
        }
        if (this.isEmpty()) {
            Trc.exit(false);
            return false;
        }
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                Object object = this.get(string);
                Class<?> clazz = object.getClass();
                if (predefinedProps.contains(string)) {
                    try {
                        if (string.equals(CORRELATIONID)) {
                            message.setJMSCorrelationID((String)object);
                            continue;
                        }
                        if (string.equals(DELIVERYMODE)) {
                            message.setJMSDeliveryMode(((Integer)object).intValue());
                            if (messageProducer == null) continue;
                            messageProducer.setDeliveryMode(((Integer)object).intValue());
                            continue;
                        }
                        if (string.equals(DESTINATION)) {
                            message.setJMSDestination((Destination)object);
                            continue;
                        }
                        if (string.equals(EXPIRATION)) {
                            message.setJMSExpiration(((Long)object).longValue());
                            continue;
                        }
                        if (string.equals(PRIORITY)) {
                            message.setJMSPriority(((Integer)object).intValue());
                            if (messageProducer == null) continue;
                            messageProducer.setPriority(((Integer)object).intValue());
                            continue;
                        }
                        if (string.equals(REDELIVERED)) {
                            message.setJMSRedelivered(((Boolean)object).booleanValue());
                            continue;
                        }
                        if (string.equals(REPLYTO)) {
                            message.setJMSReplyTo((Destination)object);
                            continue;
                        }
                        if (string.equals(TIMESTAMP)) {
                            message.setJMSTimestamp(((Long)object).longValue());
                            continue;
                        }
                        if (string.equals(TIMETOLIVE)) {
                            if (messageProducer == null) continue;
                            messageProducer.setTimeToLive(((Long)object).longValue());
                            continue;
                        }
                        if (!string.equals(TYPE)) continue;
                        message.setJMSType((String)object);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        Trc.exception(classCastException);
                        throw new WSIFException("Unexpected type " + clazz + " for JMS property " + string + ".");
                    }
                }
                if (clazz.equals(String.class)) {
                    message.setStringProperty(string, object.toString());
                    continue;
                }
                if (clazz.equals(Integer.class)) {
                    message.setIntProperty(string, ((Integer)object).intValue());
                    continue;
                }
                if (clazz.equals(Boolean.class)) {
                    message.setBooleanProperty(string, ((Boolean)object).booleanValue());
                    continue;
                }
                if (clazz.equals(Byte.class)) {
                    message.setByteProperty(string, ((Byte)object).byteValue());
                    continue;
                }
                if (clazz.equals(Double.class)) {
                    message.setDoubleProperty(string, ((Double)object).doubleValue());
                    continue;
                }
                if (clazz.equals(Float.class)) {
                    message.setFloatProperty(string, ((Float)object).floatValue());
                    continue;
                }
                if (clazz.equals(Long.class)) {
                    message.setLongProperty(string, ((Long)object).longValue());
                    continue;
                }
                if (clazz.equals(Short.class)) {
                    message.setShortProperty(string, ((Short)object).shortValue());
                    continue;
                }
                message.setObjectProperty(string, object);
            }
            catch (JMSException jMSException) {
                Trc.exception(jMSException);
                throw WSIFJMSConstants.ToWsifException(jMSException);
            }
        }
        Trc.exit(true);
        return true;
    }

    public void getPropertiesFromMessage(Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (this.direction != OUT) {
            throw new WSIFException("Only output properties can be got from a message");
        }
        this.clear();
        try {
            this.put(CORRELATIONID, message.getJMSCorrelationID());
            this.put(DELIVERYMODE, new Integer(message.getJMSDeliveryMode()));
            this.put(DESTINATION, message.getJMSDestination());
            this.put(EXPIRATION, new Long(message.getJMSExpiration()));
            this.put(MESSAGEID, message.getJMSMessageID());
            this.put(PRIORITY, new Integer(message.getJMSPriority()));
            this.put(REDELIVERED, new Boolean(message.getJMSRedelivered()));
            this.put(REPLYTO, message.getJMSReplyTo());
            this.put(TIMESTAMP, new Long(message.getJMSTimestamp()));
            this.put(TYPE, message.getJMSType());
            Enumeration enumeration = message.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.put(string, message.getObjectProperty(string));
            }
        }
        catch (JMSException jMSException) {
            Trc.exception(jMSException);
            throw WSIFJMSConstants.ToWsifException(jMSException);
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public void clear() {
        Trc.entry(this);
        super.clear();
        Trc.exit();
    }

    public Object get(Object object) {
        Trc.entry((Object)this, object);
        Object v = super.get(object);
        Trc.exit(v);
        return v;
    }

    public Object put(Object object, Object object2) {
        Trc.entry(this, object, object2);
        Object object3 = super.put(object, object2);
        Trc.exit(object3);
        return object3;
    }

    public void putAll(HashMap hashMap) {
        Trc.entry((Object)this, hashMap);
        super.putAll(hashMap);
        Trc.exit();
    }

    public String toString() {
        return "WSIFJMSProperties(" + this.size() + "," + this.hashCode() + ")";
    }

    public String deep() {
        String string = "";
        try {
            string = new String(super.toString() + "\n");
            string = string + "direction:" + (this.direction.equals(IN) ? IN : (this.direction.equals(OUT) ? OUT : "unknown"));
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }
}

