/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl;

import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.ClosableLocator;
import org.xml.sax.InputSource;

public class AuthenticatingProxyWSDLLocatorImpl
implements WSDLLocator,
ClosableLocator {
    private static final String PROXY_AUTH = "Proxy-Authorization";
    private static final char[] BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char BASE64_PAD_CHAR = '=';
    Reader baseReader = null;
    InputStream baseInputStream = null;
    InputStream importInputStream = null;
    String documentBase = "";
    String importBase = "";
    String wsdlLocation = "";
    PasswordAuthentication passwdAuth = null;
    String authString = null;

    public AuthenticatingProxyWSDLLocatorImpl(String string, String string2, String string3) throws WSDLException {
        this.wsdlLocation = string;
        if (string3 != null) {
            this.passwdAuth = new PasswordAuthentication(string2, string3.toCharArray());
        }
    }

    public AuthenticatingProxyWSDLLocatorImpl(String string, PasswordAuthentication passwordAuthentication) throws WSDLException {
        this.wsdlLocation = string;
        this.passwdAuth = passwordAuthentication;
    }

    public AuthenticatingProxyWSDLLocatorImpl(String string, Reader reader, PasswordAuthentication passwordAuthentication) throws WSDLException {
        this.documentBase = string;
        this.baseReader = reader;
        this.passwdAuth = passwordAuthentication;
    }

    public InputSource getBaseInputSource() {
        Trc.entry(this);
        if (this.baseReader != null) {
            return new InputSource(this.baseReader);
        }
        if (this.baseInputStream == null) {
            try {
                URL uRL = StringUtils.getURL(null, (String)this.wsdlLocation);
                if ("file".equals(uRL.getProtocol())) {
                    this.baseInputStream = StringUtils.getContentAsInputStream((URL)uRL);
                } else {
                    URLConnection uRLConnection = uRL.openConnection();
                    this.createAuthString();
                    if (this.authString != null) {
                        uRLConnection.setRequestProperty(PROXY_AUTH, this.authString);
                    }
                    this.baseInputStream = uRLConnection.getInputStream();
                }
                if (uRL != null) {
                    this.documentBase = uRL.toString();
                }
            }
            catch (Exception exception) {
                this.documentBase = this.wsdlLocation;
            }
        }
        Trc.exit();
        if (this.baseInputStream == null) {
            return null;
        }
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String string, String string2) {
        Trc.entry(this, string, string2);
        this.importInputStream = null;
        try {
            URL uRL = string != null ? StringUtils.getURL(null, (String)string) : null;
            URL uRL2 = StringUtils.getURL((URL)uRL, (String)string2);
            if ("file".equals(uRL2.getProtocol())) {
                this.importInputStream = StringUtils.getContentAsInputStream((URL)uRL2);
            } else {
                URLConnection uRLConnection = uRL2.openConnection();
                this.createAuthString();
                if (this.authString != null) {
                    uRLConnection.setRequestProperty(PROXY_AUTH, this.authString);
                }
                this.importInputStream = uRLConnection.getInputStream();
            }
            this.importBase = uRL2 == null ? string2 : uRL2.toString();
        }
        catch (Exception exception) {
            this.importBase = "unknownImportURI";
        }
        Trc.exit();
        if (this.importInputStream == null) {
            return null;
        }
        return new InputSource(this.importInputStream);
    }

    public Reader getBaseReader() {
        InputSource inputSource = this.getBaseInputSource();
        if (inputSource == null) {
            return null;
        }
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return new InputStreamReader(inputSource.getByteStream());
        }
        return null;
    }

    public Reader getImportReader(String string, String string2) {
        InputSource inputSource = this.getImportInputSource(string, string2);
        if (inputSource == null) {
            return null;
        }
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return new InputStreamReader(inputSource.getByteStream());
        }
        return null;
    }

    public String getBaseURI() {
        return this.documentBase;
    }

    public String getLatestImportURI() {
        return this.importBase;
    }

    private void createAuthString() {
        int n;
        int n2;
        if (this.authString != null) {
            return;
        }
        if (this.passwdAuth == null) {
            return;
        }
        String string = this.passwdAuth.getUserName();
        char[] cArray = this.passwdAuth.getPassword();
        if (string == null || cArray == null) {
            return;
        }
        byte[] byArray = null;
        try {
            String string2 = new String(cArray);
            byArray = (string + ":" + string2).getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        int n3 = byArray.length;
        char[] cArray2 = new char[n3 / 3 * 4 + 4];
        int n4 = 0;
        int n5 = 0;
        for (n2 = n3; n2 >= 3; n2 -= 3) {
            n = ((byArray[n4] & 0xFF) << 16) + ((byArray[n4 + 1] & 0xFF) << 8) + (byArray[n4 + 2] & 0xFF);
            cArray2[n5++] = BASE64_CHARS[n >> 18];
            cArray2[n5++] = BASE64_CHARS[n >> 12 & 0x3F];
            cArray2[n5++] = BASE64_CHARS[n >> 6 & 0x3F];
            cArray2[n5++] = BASE64_CHARS[n & 0x3F];
            n4 += 3;
        }
        if (n2 == 1) {
            n = byArray[n4] & 0xFF;
            cArray2[n5++] = BASE64_CHARS[n >> 2];
            cArray2[n5++] = BASE64_CHARS[n << 4 & 0x3F];
            cArray2[n5++] = 61;
            cArray2[n5++] = 61;
        } else if (n2 == 2) {
            n = ((byArray[n4] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
            cArray2[n5++] = BASE64_CHARS[n >> 10];
            cArray2[n5++] = BASE64_CHARS[n >> 4 & 0x3F];
            cArray2[n5++] = BASE64_CHARS[n << 2 & 0x3F];
            cArray2[n5++] = 61;
        }
        String string3 = new String(cArray2, 0, n5);
        this.authString = "Basic " + string3;
    }

    public void close() throws IOException {
        if (this.baseReader != null) {
            this.baseReader.close();
        }
        if (this.importInputStream != null) {
            this.importInputStream.close();
        }
        if (this.baseInputStream != null) {
            this.baseInputStream.close();
        }
    }
}

