/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl;

import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.ClosableLocator;
import org.xml.sax.InputSource;

public class WSIFWSDLLocatorImpl
implements WSDLLocator,
ClosableLocator {
    Reader baseReader = null;
    InputStream baseInputStream = null;
    InputStream importInputStream = null;
    String contextURI = null;
    String wsdlLocation = null;
    String documentBase = null;
    String importBase = null;
    ClassLoader loader = null;

    public WSIFWSDLLocatorImpl(String string, String string2, ClassLoader classLoader) {
        Trc.entry(this, string, string2, classLoader);
        this.contextURI = string;
        this.wsdlLocation = string2;
        this.loader = classLoader;
        Trc.exit();
    }

    public WSIFWSDLLocatorImpl(String string, Reader reader, ClassLoader classLoader) {
        Trc.entry(this, string, classLoader);
        this.documentBase = string;
        this.baseReader = reader;
        this.loader = classLoader;
        Trc.exit();
    }

    public InputSource getBaseInputSource() {
        Trc.entry(this);
        if (this.baseReader != null) {
            return new InputSource(this.baseReader);
        }
        if (this.baseInputStream == null) {
            try {
                URL uRL;
                URL uRL2 = null;
                URL uRL3 = uRL = this.contextURI != null ? StringUtils.getURL(null, (String)this.contextURI) : null;
                if (this.loader != null) {
                    try {
                        uRL2 = uRL != null ? new URL(uRL, this.wsdlLocation) : (this.wsdlLocation.indexOf(":") == -1 ? new URL("file", null, this.wsdlLocation) : new URL(this.wsdlLocation));
                        String string = uRL2.getPath();
                        if (string.startsWith("/")) {
                            string = string.substring(1);
                        }
                        this.baseInputStream = this.loader.getResourceAsStream(string);
                    }
                    catch (Exception exception) {
                        Trc.ignoredException(exception);
                    }
                }
                if (this.baseInputStream == null) {
                    uRL2 = StringUtils.getURL((URL)uRL, (String)this.wsdlLocation);
                    this.baseInputStream = StringUtils.getContentAsInputStream((URL)uRL2);
                }
                if (uRL2 != null) {
                    this.documentBase = uRL2.toString();
                } else if (this.baseInputStream == null) {
                    this.documentBase = this.wsdlLocation;
                }
            }
            catch (Exception exception) {
                Trc.exception(exception);
                this.documentBase = this.wsdlLocation;
            }
        }
        Trc.exit();
        if (this.baseInputStream == null) {
            return null;
        }
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String string, String string2) {
        Trc.entry(this, string, string2);
        this.importInputStream = null;
        boolean bl = false;
        try {
            Object object;
            URL uRL = null;
            if (this.loader != null) {
                if (string2.startsWith("/") || string2.startsWith("\\")) {
                    string2 = string2.substring(1, string2.length());
                    this.importInputStream = this.loader.getResourceAsStream(string2);
                } else if (string2.indexOf("://") != -1) {
                    bl = true;
                    uRL = StringUtils.getURL(null, (String)string2);
                    this.importInputStream = StringUtils.getContentAsInputStream((URL)uRL);
                } else if (string != null) {
                    int n = string.lastIndexOf("/");
                    if (n == -1) {
                        n = string.lastIndexOf("\\");
                    }
                    if (n != -1) {
                        object = string.substring(0, n + 1);
                        String string3 = (String)object + string2;
                        if (string2.startsWith("..")) {
                            string3 = this.resolvePath((String)object, string2);
                        }
                        if (string3 == null) {
                            throw new Exception("Invalid Path");
                        }
                        uRL = string3.startsWith("file:") ? new URL(null, string3) : new URL(null, "file:" + string3);
                    } else {
                        uRL = new URL(null, "file:" + string2);
                    }
                    this.importInputStream = this.loader.getResourceAsStream(uRL.getPath());
                } else {
                    uRL = new URL(null, "file:" + string2);
                    this.importInputStream = this.loader.getResourceAsStream(uRL.getPath());
                }
            } else {
                bl = true;
                URL uRL2 = string != null ? StringUtils.getURL(null, (String)string) : null;
                uRL = StringUtils.getURL((URL)uRL2, (String)string2);
                this.importInputStream = StringUtils.getContentAsInputStream((URL)uRL);
            }
            if (this.importInputStream == null) {
                if (!bl) {
                    try {
                        URL uRL3 = string != null ? StringUtils.getURL(null, (String)string) : null;
                        object = StringUtils.getURL((URL)uRL3, (String)string2);
                        this.importInputStream = StringUtils.getContentAsInputStream((URL)object);
                        this.importBase = object == null ? string2 : ((URL)object).toString();
                    }
                    catch (Exception exception) {
                        Trc.exception(exception);
                        this.importBase = "unknownImportURI";
                    }
                } else {
                    this.importBase = "unknownImportURI";
                }
            } else {
                this.importBase = uRL == null ? string2 : uRL.toString();
            }
        }
        catch (Exception exception) {
            Trc.exception(exception);
            if (!bl) {
                try {
                    URL uRL = string != null ? StringUtils.getURL(null, (String)string) : null;
                    URL uRL4 = StringUtils.getURL((URL)uRL, (String)string2);
                    this.importInputStream = StringUtils.getContentAsInputStream((URL)uRL4);
                    this.importBase = uRL4 == null ? string2 : uRL4.toString();
                }
                catch (Exception exception2) {
                    Trc.exception(exception2);
                    this.importBase = "unknownImportURI";
                }
            }
            this.importBase = "unknownImportURI";
        }
        Trc.exit();
        if (this.importInputStream == null) {
            return null;
        }
        return new InputSource(this.importInputStream);
    }

    public Reader getBaseReader() {
        InputSource inputSource = this.getBaseInputSource();
        if (inputSource == null) {
            return null;
        }
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return new InputStreamReader(inputSource.getByteStream());
        }
        return null;
    }

    public Reader getImportReader(String string, String string2) {
        InputSource inputSource = this.getImportInputSource(string, string2);
        if (inputSource == null) {
            return null;
        }
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return new InputStreamReader(inputSource.getByteStream());
        }
        return null;
    }

    public String getBaseURI() {
        Trc.entry(this);
        Trc.exit(this.documentBase);
        return this.documentBase;
    }

    public String getLatestImportURI() {
        Trc.entry(this);
        Trc.exit(this.importBase);
        return this.importBase;
    }

    private String resolvePath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = 0;
        while (stringBuffer.length() > 0 && stringBuffer.length() > 3 && stringBuffer.charAt(0) == '.' && stringBuffer.charAt(1) == '.' && (stringBuffer.charAt(2) == '/' || stringBuffer.charAt(2) == '\\')) {
            ++n;
            stringBuffer.delete(0, 3);
        }
        StringBuffer stringBuffer2 = new StringBuffer(string);
        int n2 = stringBuffer2.length() - 1;
        int n3 = 0;
        for (int i = n2; i >= 0; --i) {
            if (i != n2 && (stringBuffer2.charAt(i) == '/' || stringBuffer2.charAt(i) == '\\')) {
                ++n3;
            }
            if (n3 >= n) break;
            stringBuffer2.deleteCharAt(i);
        }
        if (n3 + 1 < n) {
            return null;
        }
        return stringBuffer2.toString() + stringBuffer.toString();
    }

    public void close() throws IOException {
        if (this.baseReader != null) {
            this.baseReader.close();
        }
        if (this.importInputStream != null) {
            this.importInputStream.close();
        }
        if (this.baseInputStream != null) {
            this.baseInputStream.close();
        }
    }
}

