/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl.extensions.java;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.extensions.java.JavaAddress;
import org.apache.wsif.wsdl.extensions.java.JavaBinding;
import org.apache.wsif.wsdl.extensions.java.JavaBindingConstants;
import org.apache.wsif.wsdl.extensions.java.JavaOperation;
import org.w3c.dom.Element;

public class JavaBindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        Trc.entry(this, clazz, qName, extensibilityElement, printWriter, definition, extensionRegistry);
        if (extensibilityElement == null) {
            Trc.exit();
            return;
        }
        if (extensibilityElement instanceof JavaBinding) {
            JavaBinding javaBinding = (JavaBinding)extensibilityElement;
            printWriter.print("      <java:binding");
            Boolean bl = extensibilityElement.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute((QName)Constants.Q_ATTR_REQUIRED, (String)bl.toString(), (Definition)definition, (PrintWriter)printWriter);
            }
            printWriter.println("/>");
        } else if (extensibilityElement instanceof JavaOperation) {
            Boolean bl;
            JavaOperation javaOperation = (JavaOperation)extensibilityElement;
            printWriter.print("      <java:operation");
            if (javaOperation.getMethodName() != null) {
                DOMUtils.printAttribute((String)"methodName", (String)javaOperation.getMethodName(), (PrintWriter)printWriter);
            }
            if (javaOperation.getMethodType() != null) {
                DOMUtils.printAttribute((String)"methodType", (String)javaOperation.getMethodType(), (PrintWriter)printWriter);
            }
            if (javaOperation.getParameterOrder() != null) {
                DOMUtils.printAttribute((String)"parameterOrder", (String)StringUtils.getNMTokens((List)javaOperation.getParameterOrder()), (PrintWriter)printWriter);
            }
            if (javaOperation.getReturnPart() != null) {
                DOMUtils.printAttribute((String)"returnPart", (String)javaOperation.getReturnPart(), (PrintWriter)printWriter);
            }
            if ((bl = extensibilityElement.getRequired()) != null) {
                DOMUtils.printQualifiedAttribute((QName)Constants.Q_ATTR_REQUIRED, (String)bl.toString(), (Definition)definition, (PrintWriter)printWriter);
            }
            printWriter.println("/>");
        } else if (extensibilityElement instanceof JavaAddress) {
            Boolean bl;
            JavaAddress javaAddress = (JavaAddress)extensibilityElement;
            printWriter.print("      <java:address");
            if (javaAddress.getClassName() != null) {
                DOMUtils.printAttribute((String)"className", (String)javaAddress.getClassName(), (PrintWriter)printWriter);
            }
            if (javaAddress.getClassPath() != null) {
                DOMUtils.printAttribute((String)"classPath", (String)javaAddress.getClassPath(), (PrintWriter)printWriter);
            }
            if (javaAddress.getClassLoader() != null) {
                DOMUtils.printAttribute((String)"classLoader", (String)javaAddress.getClassLoader(), (PrintWriter)printWriter);
            }
            if ((bl = extensibilityElement.getRequired()) != null) {
                DOMUtils.printQualifiedAttribute((QName)Constants.Q_ATTR_REQUIRED, (String)bl.toString(), (Definition)definition, (PrintWriter)printWriter);
            }
            printWriter.println("/>");
        }
        Trc.exit();
    }

    public void registerSerializer(ExtensionRegistry extensionRegistry) {
        Trc.entry((Object)this, extensionRegistry);
        extensionRegistry.registerSerializer(Binding.class, JavaBindingConstants.Q_ELEM_JAVA_BINDING, (ExtensionSerializer)this);
        extensionRegistry.registerDeserializer(Binding.class, JavaBindingConstants.Q_ELEM_JAVA_BINDING, (ExtensionDeserializer)this);
        extensionRegistry.mapExtensionTypes(Binding.class, JavaBindingConstants.Q_ELEM_JAVA_BINDING, JavaBinding.class);
        extensionRegistry.registerSerializer(BindingOperation.class, JavaBindingConstants.Q_ELEM_JAVA_OPERATION, (ExtensionSerializer)this);
        extensionRegistry.registerDeserializer(BindingOperation.class, JavaBindingConstants.Q_ELEM_JAVA_OPERATION, (ExtensionDeserializer)this);
        extensionRegistry.mapExtensionTypes(BindingOperation.class, JavaBindingConstants.Q_ELEM_JAVA_OPERATION, JavaOperation.class);
        extensionRegistry.registerSerializer(Port.class, JavaBindingConstants.Q_ELEM_JAVA_ADDRESS, (ExtensionSerializer)this);
        extensionRegistry.registerDeserializer(Port.class, JavaBindingConstants.Q_ELEM_JAVA_ADDRESS, (ExtensionDeserializer)this);
        extensionRegistry.mapExtensionTypes(Port.class, JavaBindingConstants.Q_ELEM_JAVA_ADDRESS, JavaAddress.class);
        Trc.exit();
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        Trc.entry(this, clazz, qName, element, definition, extensionRegistry);
        ExtensibilityElement extensibilityElement = null;
        if (JavaBindingConstants.Q_ELEM_JAVA_BINDING.equals(qName)) {
            JavaBinding javaBinding = new JavaBinding();
            Trc.exit(javaBinding);
            return javaBinding;
        }
        if (JavaBindingConstants.Q_ELEM_JAVA_OPERATION.equals(qName)) {
            String string;
            String string2;
            String string3;
            JavaOperation javaOperation = new JavaOperation();
            String string4 = DOMUtils.getAttribute((Element)element, (String)"methodName");
            if (string4 != null) {
                javaOperation.setMethodName(string4);
            }
            if ((string3 = DOMUtils.getAttribute((Element)element, (String)"methodType")) != null) {
                javaOperation.setMethodType(string3);
            }
            if ((string2 = DOMUtils.getAttribute((Element)element, (String)"parameterOrder")) != null) {
                javaOperation.setParameterOrder(string2);
            }
            if ((string = DOMUtils.getAttribute((Element)element, (String)"returnPart")) != null) {
                javaOperation.setReturnPart(string);
            }
            Trc.exit(javaOperation);
            return javaOperation;
        }
        if (JavaBindingConstants.Q_ELEM_JAVA_ADDRESS.equals(qName)) {
            String string;
            String string5;
            JavaAddress javaAddress = new JavaAddress();
            String string6 = DOMUtils.getAttribute((Element)element, (String)"className");
            if (string6 != null) {
                javaAddress.setClassName(string6);
            }
            if ((string5 = DOMUtils.getAttribute((Element)element, (String)"classPath")) != null) {
                javaAddress.setClassPath(string5);
            }
            if ((string = DOMUtils.getAttribute((Element)element, (String)"classLoader")) != null) {
                javaAddress.setClassLoader(string);
            }
            Trc.exit(javaAddress);
            return javaAddress;
        }
        Trc.exit(extensibilityElement);
        return extensibilityElement;
    }
}

