/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.wsdl.extensions.jms;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.wsdl.extensions.jms.JMSBinding;
import org.apache.wsif.wsdl.extensions.jms.JMSConstants;
import org.w3c.dom.Element;

public class JMSBindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        Boolean bl;
        Trc.entry(this, clazz, qName, extensibilityElement, printWriter, definition, extensionRegistry);
        if (extensibilityElement == null) {
            Trc.exit();
            return;
        }
        JMSBinding jMSBinding = (JMSBinding)extensibilityElement;
        String string = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/wsdl/jms/", (String)"binding", (Definition)definition);
        printWriter.print("      <" + string);
        if (jMSBinding.getJmsMessageType() != 0) {
            DOMUtils.printAttribute((String)"type", (String)JMSBinding.JmsMessageTypeAsString(jMSBinding.getJmsMessageType()), (PrintWriter)printWriter);
        }
        if ((bl = extensibilityElement.getRequired()) != null) {
            DOMUtils.printQualifiedAttribute((QName)Constants.Q_ATTR_REQUIRED, (String)bl.toString(), (Definition)definition, (PrintWriter)printWriter);
        }
        printWriter.println("/>");
        Trc.exit();
    }

    public void registerSerializer(ExtensionRegistry extensionRegistry) {
        Trc.entry((Object)this, extensionRegistry);
        extensionRegistry.registerSerializer(Binding.class, JMSConstants.Q_ELEM_JMS_BINDING, (ExtensionSerializer)this);
        extensionRegistry.registerDeserializer(Binding.class, JMSConstants.Q_ELEM_JMS_BINDING, (ExtensionDeserializer)this);
        extensionRegistry.mapExtensionTypes(Binding.class, JMSConstants.Q_ELEM_JMS_BINDING, JMSBinding.class);
        Trc.exit();
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        Trc.entry(this, clazz, qName, element, definition, extensionRegistry);
        JMSBinding jMSBinding = (JMSBinding)extensionRegistry.createExtension(clazz, qName);
        String string = DOMUtils.getAttribute((Element)element, (String)"type");
        if ("ByteMessage".equals(string)) {
            jMSBinding.setJmsMessageType(10);
        } else if ("MapMessage".equals(string)) {
            jMSBinding.setJmsMessageType(20);
        } else if ("ObjectMessage".equals(string)) {
            jMSBinding.setJmsMessageType(30);
        } else if ("StreamMessage".equals(string)) {
            jMSBinding.setJmsMessageType(40);
        } else if ("TextMessage".equals(string)) {
            jMSBinding.setJmsMessageType(50);
        } else {
            jMSBinding.setJmsMessageType(0);
        }
        Trc.exit(jMSBinding);
        return jMSBinding;
    }
}

