/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xindice.client.xmldb.ResourceIteratorImpl;
import org.apache.xindice.client.xmldb.XindiceCollection;
import org.apache.xindice.client.xmldb.resources.XMLResourceImpl;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.TextWriter;
import org.apache.xindice.xml.dom.DOMCompressor;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class ResourceSetImpl
implements ResourceSet {
    public static final String RESOURCE_SET_NS = "http://www.xmldb.org/xapi/ResourceSet";
    protected List resources;
    protected Collection collection;
    private SymbolTable symbols;
    private byte[] bytes;

    public ResourceSetImpl(Collection collection, Document doc) throws XMLDBException {
        this.collection = collection;
        if (doc != null) {
            this.initResources(doc);
        } else {
            this.resources = Collections.synchronizedList(new ArrayList());
        }
    }

    public ResourceSetImpl(Collection collection, SymbolTable symbols, byte[] bytes) throws XMLDBException {
        this.collection = collection;
        this.symbols = symbols;
        this.bytes = bytes;
        this.initResources(new DocumentImpl(bytes, symbols, null));
    }

    protected void initResources(Document document) throws XMLDBException {
        NodeList nodes = document.getDocumentElement().getChildNodes();
        this.resources = Collections.synchronizedList(new ArrayList(nodes.getLength()));
        for (int i = 0; i < nodes.getLength(); ++i) {
            XMLResourceImpl resource;
            Node n = nodes.item(i);
            String documentId = null;
            if (n instanceof Element) {
                documentId = ((Element)n).getAttributeNS("http://xml.apache.org/xindice/Query", "key");
            }
            if (this.bytes != null) {
                DocumentImpl doc = new DocumentImpl();
                doc.setSymbols(this.symbols);
                doc.importNode(n, true);
                doc.appendChild(n);
                byte[] b = DOMCompressor.compress(doc, this.symbols);
                resource = new XMLResourceImpl(null, documentId, this.collection, this.symbols, b);
            } else {
                resource = new XMLResourceImpl(null, documentId, this.collection, TextWriter.toString(n));
            }
            this.resources.add(resource);
        }
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new ResourceIteratorImpl(this.resources);
    }

    public Resource getResource(long index) throws XMLDBException {
        return (XMLResource)this.resources.get((int)index);
    }

    public long getSize() throws XMLDBException {
        return this.resources.size();
    }

    public void addResource(Resource res) throws XMLDBException {
        this.resources.add(res);
    }

    public void clear() throws XMLDBException {
        this.resources.clear();
    }

    public void removeResource(long index) throws XMLDBException {
        this.resources.remove((int)index);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        DocumentImpl doc = new DocumentImpl();
        Element set = doc.createElementNS(RESOURCE_SET_NS, "xapi:resourceSet");
        set.setAttributeNS(RESOURCE_SET_NS, "xapi:collectionURI", "xmldb:xindice://" + ((XindiceCollection)this.collection).getCanonicalName());
        set.setAttribute("xmlns:xapi", RESOURCE_SET_NS);
        doc.appendChild(set);
        for (int i = 0; i < this.resources.size(); ++i) {
            XMLResource res = (XMLResource)this.resources.get(i);
            Element resource = doc.createElementNS(RESOURCE_SET_NS, "xapi:resource");
            resource.setAttributeNS(RESOURCE_SET_NS, "xapi:documentID", res.getDocumentId());
            resource.appendChild(doc.importNode(((Document)res.getContentAsDOM()).getDocumentElement(), true));
            set.appendChild(resource);
        }
        return new XMLResourceImpl(null, null, this.collection, TextWriter.toString(doc));
    }
}

